/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.acceleo.AcceleoPackage;
import org.eclipse.acceleo.Module;
import org.eclipse.acceleo.ModuleElement;
import org.eclipse.acceleo.Template;
import org.eclipse.acceleo.Variable;
import org.eclipse.acceleo.aql.IAcceleoEnvironment;
import org.eclipse.acceleo.aql.evaluation.AcceleoEvaluator;
import org.eclipse.acceleo.query.ast.TypeLiteral;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameQueryEnvironment;
import org.eclipse.acceleo.query.services.EObjectServices;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public final class AcceleoUtil {
    private static final String SELF = "self";

    private AcceleoUtil() {
    }

    public static String getTemplateImplicitVariableName() {
        return SELF;
    }

    public static Template getMainTemplate(Module module) {
        Template res = null;
        for (ModuleElement moduleElement : module.getModuleElements()) {
            if (!(moduleElement instanceof Template) || !((Template)moduleElement).isMain()) continue;
            res = (Template)moduleElement;
            break;
        }
        return res;
    }

    public static void generate(AcceleoEvaluator evaluator, IAcceleoEnvironment acceleoEnvironment, Module module, Resource model) {
        AcceleoUtil.generate(evaluator, acceleoEnvironment, module, Collections.singletonList(model));
    }

    public static void generate(AcceleoEvaluator evaluator, IAcceleoEnvironment acceleoEnvironment, Module module, ResourceSet resourceSet) {
        AcceleoUtil.generate(evaluator, acceleoEnvironment, module, (List<Resource>)resourceSet.getResources());
    }

    private static void generate(AcceleoEvaluator evaluator, IAcceleoEnvironment acceleoEnvironment, Module module, List<Resource> resources) {
        IQualifiedNameQueryEnvironment queryEnvironment = acceleoEnvironment.getQueryEnvironment();
        EObjectServices services = new EObjectServices((IReadOnlyQueryEnvironment)queryEnvironment, null, null);
        Template main = AcceleoUtil.getMainTemplate(module);
        String parameterName = ((Variable)main.getParameters().get(0)).getName();
        EClass parameterType = (EClass)((TypeLiteral)((Variable)main.getParameters().get(0)).getType().getAst()).getValue();
        ArrayList<EObject> values = new ArrayList<EObject>();
        for (Resource model : resources) {
            for (EObject root : model.getContents()) {
                if (parameterType.isInstance((Object)root)) {
                    values.add(root);
                }
                values.addAll(services.eAllContents(root, parameterType));
            }
        }
        HashMap<String, Object> variables = new HashMap<String, Object>();
        for (EObject value : values) {
            variables.put(parameterName, value);
            evaluator.generate(module, variables);
        }
    }

    public static List<EClass> getConcreteAcceleoTypesInheriting(EClass superType) {
        if (!superType.getEPackage().equals(AcceleoPackage.eINSTANCE)) {
            throw new IllegalArgumentException("This can only be used for EClasses from the Acceleo EPackage. " + superType + " is from EPackage " + superType.getEPackage() + ".");
        }
        ArrayList<EClass> eClasses = new ArrayList<EClass>();
        if (!superType.isAbstract() && !superType.isInterface()) {
            eClasses.add(superType);
        }
        List allAcceleoConcreteEClasses = AcceleoPackage.eINSTANCE.getEClassifiers().stream().filter(EClass.class::isInstance).map(EClass.class::cast).filter(eClass -> !eClass.isInterface() && !eClass.isAbstract()).collect(Collectors.toList());
        List acceleoConcreteSubTypes = allAcceleoConcreteEClasses.stream().filter(eClass2 -> eClass2.getESuperTypes().contains((Object)superType)).collect(Collectors.toList());
        eClasses.addAll(acceleoConcreteSubTypes);
        return eClasses;
    }
}

