/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.Deque;
import org.eclipse.acceleo.OpenModeKind;
import org.eclipse.acceleo.aql.IAcceleoEnvironment;
import org.eclipse.acceleo.aql.evaluation.GenerationResult;
import org.eclipse.acceleo.aql.evaluation.writer.IAcceleoGenerationStrategy;
import org.eclipse.acceleo.aql.evaluation.writer.IAcceleoWriter;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.Query;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameQueryEnvironment;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameResolver;
import org.eclipse.emf.common.util.URI;

public class AcceleoEnvironment
implements IAcceleoEnvironment {
    private IQualifiedNameQueryEnvironment aqlEnvironment;
    private final Deque<IAcceleoWriter> writers = new ArrayDeque<IAcceleoWriter>();
    private final IAcceleoGenerationStrategy generationStrategy;
    private final URI destination;
    private final GenerationResult generationResult = new GenerationResult();

    public AcceleoEnvironment(IQualifiedNameResolver resolver, IQualifiedNameQueryEnvironment aqlEnvironment, IAcceleoGenerationStrategy generationStrategy, URI destination) {
        this.generationStrategy = generationStrategy;
        this.destination = destination;
        this.aqlEnvironment = aqlEnvironment;
        Query.configureEnvironment((IQueryEnvironment)aqlEnvironment, null, null);
    }

    @Override
    public IQualifiedNameQueryEnvironment getQueryEnvironment() {
        return this.aqlEnvironment;
    }

    @Override
    public void openWriter(URI uri, OpenModeKind openMode, Charset charset, String lineDelimiter) throws IOException {
        IAcceleoWriter writer = this.generationStrategy.createWriterFor(uri, openMode, charset, lineDelimiter);
        this.writers.addLast(writer);
        this.generationResult.getGeneratedFiles().add(uri);
    }

    @Override
    public void closeWriter() throws IOException {
        IAcceleoWriter writer = this.writers.removeLast();
        writer.close();
    }

    @Override
    public void write(String text) throws IOException {
        IAcceleoWriter writer = this.writers.peekLast();
        writer.append(text);
    }

    @Override
    public URI getDestination() {
        return this.destination;
    }

    @Override
    public GenerationResult getGenerationResult() {
        return this.generationResult;
    }
}

