/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.parser;

import java.util.List;
import org.eclipse.acceleo.ASTNode;
import org.eclipse.acceleo.Error;
import org.eclipse.acceleo.Module;
import org.eclipse.acceleo.query.ast.Expression;
import org.eclipse.acceleo.query.ast.VariableDeclaration;
import org.eclipse.acceleo.query.parser.Positions;
import org.eclipse.emf.ecore.EObject;

public class AcceleoAstResult {
    private final Module module;
    private Positions positions;
    private final List<Error> errors;

    public AcceleoAstResult(Module module, Positions positions, List<Error> errors) {
        this.module = module;
        this.module.setAst(this);
        this.positions = positions;
        this.errors = errors;
    }

    public int getStartPosition(ASTNode node) {
        return this.getInternalStartPosition(node);
    }

    public int getStartPosition(Expression expression) {
        return this.getInternalStartPosition((EObject)expression);
    }

    public int getStartPosition(VariableDeclaration declaration) {
        return this.getInternalStartPosition((EObject)declaration);
    }

    private int getInternalStartPosition(EObject object) {
        Integer position = this.positions.getStartPositions(object);
        int res = position != null ? position : -1;
        return res;
    }

    public int getStartLine(ASTNode node) {
        return this.getInternalStartLine(node);
    }

    public int getStartLine(Expression expression) {
        return this.getInternalStartLine((EObject)expression);
    }

    public int getStartLine(VariableDeclaration declaration) {
        return this.getInternalStartLine((EObject)declaration);
    }

    private int getInternalStartLine(EObject object) {
        Integer line = this.positions.getStartLines(object);
        int res = line != null ? line : -1;
        return res;
    }

    public int getStartColumn(ASTNode node) {
        return this.getInternalStartColumn(node);
    }

    public int getStartColumn(Expression expression) {
        return this.getInternalStartColumn((EObject)expression);
    }

    public int getStartColumn(VariableDeclaration declaration) {
        return this.getInternalStartColumn((EObject)declaration);
    }

    private int getInternalStartColumn(EObject object) {
        Integer column = this.positions.getStartColumns(object);
        int res = column != null ? column : -1;
        return res;
    }

    public int getEndPosition(ASTNode node) {
        return this.getInternalEndPosition(node);
    }

    public int getEndPosition(Expression expression) {
        return this.getInternalEndPosition((EObject)expression);
    }

    public int getEndPosition(VariableDeclaration declaration) {
        return this.getInternalEndPosition((EObject)declaration);
    }

    private int getInternalEndPosition(EObject object) {
        Integer position = this.positions.getEndPositions(object);
        int res = position != null ? position : -1;
        return res;
    }

    public int getEndLine(ASTNode node) {
        return this.getInternalEndLine(node);
    }

    public int getEndLine(Expression expression) {
        return this.getInternalEndLine((EObject)expression);
    }

    public int getEndLine(VariableDeclaration declaration) {
        return this.getInternalEndLine((EObject)declaration);
    }

    private int getInternalEndLine(EObject object) {
        Integer line = this.positions.getEndLines(object);
        int res = line != null ? line : -1;
        return res;
    }

    public int getEndColumn(ASTNode node) {
        return this.getInternalEndColumn(node);
    }

    public int getEndColumn(Expression expression) {
        return this.getInternalEndColumn((EObject)expression);
    }

    public int getEndColumn(VariableDeclaration declaration) {
        return this.getInternalEndColumn((EObject)declaration);
    }

    private int getInternalEndColumn(EObject object) {
        Integer column = this.positions.getEndColumns(object);
        int res = column != null ? column : -1;
        return res;
    }

    public EObject getAstNode(int position) {
        return this.positions.getNodeAt((EObject)this.module, position);
    }

    public EObject getAstNode(int line, int column) {
        return this.positions.getNodeAt((EObject)this.module, line, column);
    }

    public Module getModule() {
        return this.module;
    }

    public List<Error> getErrors() {
        return this.errors;
    }
}

