/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.evaluation;

import java.util.List;
import java.util.Optional;
import org.eclipse.acceleo.Module;
import org.eclipse.acceleo.ModuleElement;
import org.eclipse.acceleo.VisibilityKind;
import org.eclipse.acceleo.aql.AcceleoEnvironment;
import org.eclipse.acceleo.query.runtime.AcceleoQueryEvaluationException;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.impl.AbstractService;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public abstract class AbstractModuleElementService<O extends ModuleElement>
extends AbstractService<O> {
    private final AcceleoEnvironment env;

    public AbstractModuleElementService(O moduleElement, AcceleoEnvironment env) {
        super(moduleElement);
        this.env = env;
    }

    public abstract VisibilityKind getVisibility();

    protected AcceleoEnvironment getEnv() {
        return this.env;
    }

    public String getModuleQualifiedName() {
        return this.env.getModuleQualifiedName((Module)((ModuleElement)this.getOrigin()).eContainer());
    }

    public String getShortSignature() {
        List parameterTypes = this.getParameterTypes((IReadOnlyQueryEnvironment)this.getEnv().getQueryEnvironment());
        Object[] argumentTypes = parameterTypes.toArray(new IType[parameterTypes.size()]);
        return this.serviceShortSignature(argumentTypes);
    }

    public String getLongSignature() {
        String namespace = this.getNamespace();
        if (namespace != null) {
            return String.valueOf(namespace) + "::" + this.getShortSignature();
        }
        return this.getShortSignature();
    }

    private String getNamespace() {
        String result = null;
        Resource res = ((ModuleElement)this.getOrigin()).eResource();
        if (res != null) {
            result = res.getURI().toString();
        } else {
            EObject container = ((ModuleElement)this.getOrigin()).eContainer();
            while (!(container instanceof Module)) {
                container = container.eContainer();
            }
            if (container instanceof Module) {
                result = ((Module)container).getName();
            }
        }
        return result;
    }

    public int getPriority() {
        return 0;
    }

    public boolean equals(Object obj) {
        return obj instanceof AbstractModuleElementService && this.getOrigin() == ((AbstractModuleElementService)((Object)obj)).getOrigin();
    }

    public int hashCode() {
        return ((ModuleElement)this.getOrigin()).hashCode();
    }

    public Object invoke(Object ... arguments) throws AcceleoQueryEvaluationException {
        this.startInvoke();
        Object result = super.invoke(arguments);
        this.endInvoke();
        return result;
    }

    private void startInvoke() {
        String newQualifiedName;
        Module newModule = (Module)((ModuleElement)this.getOrigin()).eContainer();
        String currentQualifiedName = this.getEnv().getCurrentStack().getStartingModuleQualifiedName();
        if (currentQualifiedName != (newQualifiedName = this.getEnv().getModuleQualifiedName(newModule))) {
            if (this.isInExtends(currentQualifiedName, newQualifiedName)) {
                this.getEnv().push((ModuleElement)this.getOrigin());
            } else {
                Optional<String> importedModule = this.getEnv().getImports(currentQualifiedName).stream().filter(imported -> this.isInExtends((String)imported, newQualifiedName)).findFirst();
                if (importedModule.isPresent()) {
                    this.getEnv().pushImport(importedModule.get(), (ModuleElement)this.getOrigin());
                }
            }
        } else {
            this.getEnv().push((ModuleElement)this.getOrigin());
        }
    }

    private boolean isInExtends(String start, String calleeQualifiedName) {
        String currentQualifiedName = start;
        while (currentQualifiedName != null) {
            if (currentQualifiedName.equals(calleeQualifiedName)) {
                return true;
            }
            currentQualifiedName = this.getEnv().getExtend(currentQualifiedName);
        }
        return false;
    }

    private void endInvoke() {
        this.getEnv().popStack((ModuleElement)this.getOrigin());
    }
}

