/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.completion;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.acceleo.Error;
import org.eclipse.acceleo.Module;
import org.eclipse.acceleo.ModuleElement;
import org.eclipse.acceleo.aql.IAcceleoEnvironment;
import org.eclipse.acceleo.aql.completion.AcceleoAstCompletor;
import org.eclipse.acceleo.aql.completion.proposals.AcceleoCompletionProposal;
import org.eclipse.acceleo.aql.parser.AcceleoAstResult;
import org.eclipse.acceleo.aql.parser.AcceleoParser;
import org.eclipse.acceleo.aql.validation.AcceleoValidator;
import org.eclipse.acceleo.aql.validation.IAcceleoValidationResult;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.emf.ecore.EObject;

public class AcceleoCompletor {
    private static final String TO_COMPLETION_NAMESPACE = "_reserved_::to::completion";

    public List<AcceleoCompletionProposal> getProposals(IAcceleoEnvironment acceleoEnvironment, String moduleFileName, String source, int position) {
        List<AcceleoCompletionProposal> proposals;
        String moduleQualifiedNameForCompletion = "_reserved_::to::completion::" + moduleFileName;
        AcceleoParser acceleoParser = new AcceleoParser((IReadOnlyQueryEnvironment)acceleoEnvironment.getQueryEnvironment());
        String partialAcceleoSource = source.substring(0, position);
        AcceleoAstResult partialAcceleoAstResult = acceleoParser.parse(partialAcceleoSource, moduleQualifiedNameForCompletion);
        AcceleoAstResult acceleoAstResult = acceleoParser.parse(source, moduleQualifiedNameForCompletion);
        acceleoEnvironment.registerModule(moduleQualifiedNameForCompletion, acceleoAstResult.getModule());
        AcceleoValidator acceleoValidator = new AcceleoValidator(acceleoEnvironment);
        IAcceleoValidationResult acceleoValidationResult = acceleoValidator.validate(partialAcceleoAstResult, moduleQualifiedNameForCompletion);
        EObject acceleoElementToComplete = this.getElementToComplete(partialAcceleoAstResult);
        ModuleElement containingModuleElement = this.getContainingModuleElement(acceleoElementToComplete);
        if (containingModuleElement != null) {
            acceleoEnvironment.pushImport(moduleQualifiedNameForCompletion, containingModuleElement);
        }
        try {
            proposals = this.getProposals(acceleoEnvironment, partialAcceleoSource, acceleoValidationResult, acceleoElementToComplete);
        }
        finally {
            if (containingModuleElement != null) {
                acceleoEnvironment.popStack(containingModuleElement);
            }
        }
        return proposals;
    }

    private ModuleElement getContainingModuleElement(EObject eObj) {
        ModuleElement res = null;
        EObject current = eObj;
        while (current != null) {
            if (current instanceof ModuleElement) {
                res = (ModuleElement)current;
                break;
            }
            current = current.eContainer();
        }
        return res;
    }

    protected List<AcceleoCompletionProposal> getProposals(IAcceleoEnvironment acceleoEnvironment, String sourceFragment, IAcceleoValidationResult acceleoValidationResult, EObject acceleoElementToComplete) {
        ArrayList<AcceleoCompletionProposal> completionProposals = new ArrayList<AcceleoCompletionProposal>();
        AcceleoAstCompletor acceleoSyntaxCompletor = new AcceleoAstCompletor(acceleoEnvironment, acceleoValidationResult);
        completionProposals.addAll(acceleoSyntaxCompletor.getCompletion(sourceFragment, acceleoElementToComplete));
        return completionProposals;
    }

    private EObject getElementToComplete(AcceleoAstResult acceleoAstResult) {
        Error errorToComplete = this.getErrorToComplete(acceleoAstResult);
        if (errorToComplete == null) {
            Module moduleToComplete = acceleoAstResult.getModule();
            return moduleToComplete;
        }
        return errorToComplete;
    }

    private Error getErrorToComplete(AcceleoAstResult acceleoAstResultToComplete) {
        Objects.requireNonNull(acceleoAstResultToComplete);
        List<Error> errors = acceleoAstResultToComplete.getErrors();
        if (errors.isEmpty()) {
            return null;
        }
        Error currentError = errors.get(0);
        int currentErrorEndPosition = acceleoAstResultToComplete.getEndPosition(currentError);
        int i = 1;
        while (i < errors.size()) {
            Error candidateError = errors.get(i);
            int candidateErrorEnd = acceleoAstResultToComplete.getEndPosition(candidateError);
            if (candidateErrorEnd > currentErrorEndPosition) {
                currentError = candidateError;
                currentErrorEndPosition = candidateErrorEnd;
            }
            ++i;
        }
        return currentError;
    }
}

