/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql;

import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.acceleo.ErrorMetamodel;
import org.eclipse.acceleo.Import;
import org.eclipse.acceleo.Metamodel;
import org.eclipse.acceleo.Module;
import org.eclipse.acceleo.ModuleElement;
import org.eclipse.acceleo.ModuleReference;
import org.eclipse.acceleo.OpenModeKind;
import org.eclipse.acceleo.Query;
import org.eclipse.acceleo.Template;
import org.eclipse.acceleo.aql.IAcceleoEnvironment;
import org.eclipse.acceleo.aql.evaluation.AcceleoCallStack;
import org.eclipse.acceleo.aql.evaluation.AcceleoEvaluator;
import org.eclipse.acceleo.aql.evaluation.AcceleoQueryEnvironment;
import org.eclipse.acceleo.aql.evaluation.GenerationResult;
import org.eclipse.acceleo.aql.evaluation.QueryService;
import org.eclipse.acceleo.aql.evaluation.TemplateService;
import org.eclipse.acceleo.aql.evaluation.writer.IAcceleoGenerationStrategy;
import org.eclipse.acceleo.aql.evaluation.writer.IAcceleoWriter;
import org.eclipse.acceleo.aql.resolver.IQualifiedNameResolver;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.ServiceUtils;
import org.eclipse.acceleo.query.runtime.impl.EPackageProvider;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;

public class AcceleoEnvironment
implements IAcceleoEnvironment {
    private Map<String, Module> qualifiedNameToModule;
    private final Map<Module, String> moduleToQualifiedName;
    private final Map<String, String> moduleExtends;
    private final Map<String, LinkedList<String>> moduleImports;
    private Map<String, Map<String, Set<IService<?>>>> qualifiedNameServices;
    private IQueryEnvironment aqlEnvironment;
    private final Deque<IAcceleoWriter> writers = new ArrayDeque<IAcceleoWriter>();
    private final IAcceleoGenerationStrategy generationStrategy;
    private final URI destination;
    private final Deque<AcceleoCallStack> callStacks;
    private final GenerationResult generationResult = new GenerationResult();
    private IQualifiedNameResolver resolver;
    private AcceleoEvaluator evaluator;

    public AcceleoEnvironment(IAcceleoGenerationStrategy generationStrategy, URI destination) {
        this.generationStrategy = generationStrategy;
        this.destination = destination;
        this.qualifiedNameToModule = new LinkedHashMap<String, Module>();
        this.moduleToQualifiedName = new LinkedHashMap<Module, String>();
        this.moduleExtends = new LinkedHashMap<String, String>();
        this.moduleImports = new LinkedHashMap<String, LinkedList<String>>();
        this.qualifiedNameServices = new LinkedHashMap();
        this.callStacks = new ArrayDeque<AcceleoCallStack>();
        this.aqlEnvironment = new AcceleoQueryEnvironment(new EPackageProvider(), this);
        org.eclipse.acceleo.query.runtime.Query.configureEnvironment((IQueryEnvironment)this.aqlEnvironment, null, null);
    }

    @Override
    public void pushImport(String importModuleQualifiedName, ModuleElement moduleElement) {
        AcceleoCallStack currentStack = new AcceleoCallStack(importModuleQualifiedName);
        this.callStacks.addLast(currentStack);
        currentStack.push(moduleElement);
    }

    @Override
    public void push(ModuleElement moduleElement) {
        AcceleoCallStack currentStack = this.callStacks.peekLast();
        currentStack.push(moduleElement);
    }

    @Override
    public void popStack(ModuleElement moduleElement) {
        AcceleoCallStack currentStack = this.callStacks.peekLast();
        if (currentStack != null && !currentStack.pop().equals(moduleElement)) {
            currentStack.isEmpty();
        }
        if (currentStack.isEmpty()) {
            this.callStacks.pollLast();
        }
    }

    public AcceleoCallStack getCurrentStack() {
        return this.callStacks.peekLast();
    }

    private Module resolveModule(String qualifiedName) {
        Module module;
        if (this.resolver == null) {
            return this.qualifiedNameToModule.get(qualifiedName);
        }
        try {
            module = this.resolver.resolveModule(qualifiedName);
        }
        catch (IOException e) {
            e.printStackTrace();
            module = null;
        }
        if (module != null) {
            this.registerModule(qualifiedName, module);
        }
        return module;
    }

    @Override
    public String getModuleQualifiedName(Module module) {
        return this.moduleToQualifiedName.get(module);
    }

    @Override
    public URL getModuleURL(Module module) {
        return this.resolver.getModuleURL(this.getModuleQualifiedName(module));
    }

    @Override
    public URL getModuleSourceURL(Module module) {
        return this.resolver.getModuleSourceURL(this.getModuleQualifiedName(module));
    }

    @Override
    public String getExtend(String qualifiedName) {
        String extended = this.moduleExtends.get(qualifiedName);
        if (extended != null) {
            this.hasQualifiedName(extended);
        }
        return extended;
    }

    @Override
    public Collection<String> getImports(String qualifiedName) {
        Collection imported = this.moduleImports.getOrDefault(qualifiedName, new LinkedList());
        for (String importedName : imported) {
            this.hasQualifiedName(importedName);
        }
        return imported;
    }

    public Set<IService<?>> getServicesWithName(String qualifiedName, String serviceName) {
        Module module = this.getModule(qualifiedName);
        if (module == null && !this.qualifiedNameServices.containsKey(qualifiedName)) {
            this.resolveClass(qualifiedName);
        }
        return ((Map)this.qualifiedNameServices.getOrDefault(qualifiedName, new LinkedHashMap())).getOrDefault(serviceName, new LinkedHashSet());
    }

    public Set<IService<?>> getServices(String qualifiedName, Set<IType> receiverTypes) {
        LinkedHashSet result = new LinkedHashSet();
        Module module = this.getModule(qualifiedName);
        if (module == null && !this.qualifiedNameServices.containsKey(qualifiedName)) {
            this.resolveClass(qualifiedName);
        }
        LinkedHashSet storedServices = new LinkedHashSet();
        for (Map.Entry entry : ((Map)this.qualifiedNameServices.getOrDefault(qualifiedName, new LinkedHashMap())).entrySet()) {
            storedServices.addAll((Collection)entry.getValue());
        }
        for (IType type : receiverTypes) {
            if (type == null) continue;
            for (IService service : storedServices) {
                if (!((IType)service.getParameterTypes((IReadOnlyQueryEnvironment)this.aqlEnvironment).get(0)).isAssignableFrom(type)) continue;
                result.add(service);
            }
        }
        return result;
    }

    private Class<?> resolveClass(String qualifiedName) {
        Class<?> res = null;
        if (this.resolver != null) {
            try {
                res = this.resolver.resolveClass(qualifiedName);
                LinkedHashMap<String, Set> servicesMap = new LinkedHashMap<String, Set>();
                this.qualifiedNameServices.put(qualifiedName, servicesMap);
                for (IService service : ServiceUtils.getServices((IReadOnlyQueryEnvironment)this.aqlEnvironment, res)) {
                    Set services = servicesMap.computeIfAbsent(service.getName(), key -> new LinkedHashSet());
                    services.add(service);
                }
            }
            catch (ClassNotFoundException e) {
                res = null;
            }
        }
        return res;
    }

    @Override
    public void registerModule(String qualifiedName, Module module) {
        if (this.qualifiedNameToModule.containsKey(qualifiedName)) {
            this.unregisterModule(qualifiedName);
        }
        this.qualifiedNameToModule.put(qualifiedName, module);
        this.moduleToQualifiedName.put(module, qualifiedName);
        if (module.getExtends() != null && module.getExtends().getQualifiedName() != null) {
            this.moduleExtends.put(qualifiedName, module.getExtends().getQualifiedName());
        }
        for (Import imp : module.getImports()) {
            ModuleReference moduleRef = imp.getModule();
            if (moduleRef == null || moduleRef.getQualifiedName() == null) continue;
            this.moduleImports.computeIfAbsent(qualifiedName, key -> new LinkedList()).add(moduleRef.getQualifiedName());
        }
        for (Metamodel metamodel : module.getMetamodels()) {
            if (metamodel instanceof ErrorMetamodel) continue;
            EPackage referredPackage = metamodel.getReferencedPackage();
            this.aqlEnvironment.registerEPackage(referredPackage);
            ServiceUtils.registerServices((IQueryEnvironment)this.aqlEnvironment, (Set)ServiceUtils.getServices((EPackage)referredPackage));
        }
        LinkedHashMap<String, Set> servicesMap = new LinkedHashMap<String, Set>();
        this.qualifiedNameServices.put(qualifiedName, servicesMap);
        for (ModuleElement element : module.getModuleElements()) {
            String name;
            if (element instanceof Template) {
                name = ((Template)element).getName();
                servicesMap.computeIfAbsent(name, key -> new LinkedHashSet()).add(new TemplateService(this, (Template)element));
                continue;
            }
            if (!(element instanceof Query)) continue;
            name = ((Query)element).getName();
            servicesMap.computeIfAbsent(name, key -> new LinkedHashSet()).add(new QueryService(this, (Query)element));
        }
    }

    @Override
    public void unregisterModule(String qualifiedName) {
        Objects.requireNonNull(qualifiedName);
        Module moduleToUnregister = this.qualifiedNameToModule.get(qualifiedName);
        this.qualifiedNameToModule.remove(qualifiedName);
        this.moduleToQualifiedName.remove(moduleToUnregister);
        this.moduleExtends.remove(qualifiedName);
        this.moduleImports.remove(qualifiedName);
        this.qualifiedNameServices.remove(qualifiedName);
        if (moduleToUnregister != null) {
            for (Metamodel metamodel : moduleToUnregister.getMetamodels()) {
                EPackage ePackage = metamodel.getReferencedPackage();
                if (!this.moduleToQualifiedName.keySet().stream().noneMatch(otherModule -> !moduleToUnregister.equals(otherModule) && otherModule.getMetamodels().stream().map(Metamodel::getReferencedPackage).anyMatch(otherEPackage -> otherEPackage == ePackage))) continue;
                this.aqlEnvironment.removeEPackage(ePackage);
            }
        }
    }

    @Override
    public IQueryEnvironment getQueryEnvironment() {
        return this.aqlEnvironment;
    }

    @Override
    public boolean hasQualifiedName(String qualifiedName) {
        return this.qualifiedNameServices.containsKey(qualifiedName) || this.resolveModule(qualifiedName) != null || this.resolveClass(qualifiedName) != null;
    }

    @Override
    public Module getModule(String qualifiedName) {
        Module cachedModule = this.qualifiedNameToModule.get(qualifiedName);
        Module res = cachedModule != null ? cachedModule : this.resolveModule(qualifiedName);
        return res;
    }

    @Override
    public Module getModule(URL url) {
        String qualifiedName = this.resolver.getQualifierName(url);
        Module res = qualifiedName != null ? this.getModule(qualifiedName) : null;
        return res;
    }

    @Override
    public Set<String> getAvailableQualifiedNames() {
        return this.resolver.getAvailableQualifiedNames();
    }

    @Override
    public void openWriter(URI uri, OpenModeKind openMode, Charset charset, String lineDelimiter) throws IOException {
        IAcceleoWriter writer = this.generationStrategy.createWriterFor(uri, openMode, charset, lineDelimiter);
        this.writers.addLast(writer);
        this.generationResult.getGeneratedFiles().add(uri);
    }

    @Override
    public void closeWriter() throws IOException {
        IAcceleoWriter writer = this.writers.removeLast();
        writer.close();
    }

    @Override
    public void write(String text) throws IOException {
        IAcceleoWriter writer = this.writers.peekLast();
        writer.append(text);
    }

    @Override
    public URI getDestination() {
        return this.destination;
    }

    @Override
    public GenerationResult getGenerationResult() {
        return this.generationResult;
    }

    @Override
    public IQualifiedNameResolver getModuleResolver() {
        return this.resolver;
    }

    @Override
    public void setModuleResolver(IQualifiedNameResolver nameResolver) {
        this.resolver = nameResolver;
    }

    @Override
    public void setEvaluator(AcceleoEvaluator evaluator) {
        this.evaluator = evaluator;
    }

    @Override
    public AcceleoEvaluator getEvaluator() {
        return this.evaluator;
    }
}

