/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.ide.ui;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import org.eclipse.acceleo.aql.ide.ui.EclipseAcceleoLanguageServerContext;
import org.eclipse.acceleo.aql.ls.AcceleoLanguageServerContext;
import org.eclipse.acceleo.aql.ls.AcceleoSocketServer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.lsp4e.server.StreamConnectionProvider;

public class AcceleoConnectionProvider
implements StreamConnectionProvider {
    private static final String HOST = "127.0.0.1";
    private final AcceleoSocketServer acceleoSocketServer;
    private Socket socketClient;

    public AcceleoConnectionProvider() {
        EclipseAcceleoLanguageServerContext acceleoContext = new EclipseAcceleoLanguageServerContext(ResourcesPlugin.getWorkspace());
        this.acceleoSocketServer = new AcceleoSocketServer((AcceleoLanguageServerContext)acceleoContext);
    }

    public synchronized void start() throws IOException {
        this.acceleoSocketServer.start(HOST);
        int serverPort = this.acceleoSocketServer.getPort();
        this.socketClient = new Socket(InetAddress.getByName(HOST), serverPort);
    }

    public synchronized void stop() {
        try {
            this.socketClient.close();
            this.acceleoSocketServer.stop();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public InputStream getInputStream() {
        if (this.socketClient != null) {
            try {
                return this.socketClient.getInputStream();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public OutputStream getOutputStream() {
        if (this.socketClient != null) {
            try {
                return this.socketClient.getOutputStream();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public InputStream getErrorStream() {
        return null;
    }
}

