/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.impl;

import java.util.regex.Pattern;
import org.eclipse.acceleo.query.runtime.ICompletionProposal;
import org.eclipse.acceleo.query.runtime.ICompletionResult;
import org.eclipse.acceleo.query.runtime.IProposalFilter;
import org.eclipse.acceleo.query.runtime.impl.completion.EClassifierCompletionProposal;

public class BasicFilter
implements IProposalFilter {
    private static final Pattern CAMEL_CASE_PATTERN = Pattern.compile("([a-z]+|[A-Z][a-z]*)");
    private final ICompletionResult completionResult;

    public BasicFilter(ICompletionResult result) {
        this.completionResult = result;
    }

    @Override
    public boolean keepProposal(ICompletionProposal proposal) {
        String prefix = this.completionResult.getPrefix();
        if (prefix == null) {
            return true;
        }
        String candidateName = proposal.getProposal();
        if (proposal instanceof EClassifierCompletionProposal) {
            candidateName = ((EClassifierCompletionProposal)proposal).getObject().getName();
        }
        return BasicFilter.startsWithOrMatchCamelCase(candidateName, prefix);
    }

    public static boolean startsWithOrMatchCamelCase(String candidate, String query) {
        boolean result = false;
        if (BasicFilter.startsWithIgnoreCase(candidate, query)) {
            result = true;
        } else if (candidate != null) {
            String regex = String.valueOf(CAMEL_CASE_PATTERN.matcher(query).replaceAll("$1[^A-Z]*")) + ".*";
            result = candidate.matches(regex);
        }
        return result;
    }

    private static boolean startsWithIgnoreCase(String candidate, String prefix) {
        return candidate != null && candidate.regionMatches(true, 0, prefix, 0, prefix.length());
    }
}

