/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.impl;

import com.google.common.collect.Sets;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.query.ast.Call;
import org.eclipse.acceleo.query.ast.Error;
import org.eclipse.acceleo.query.parser.CombineIterator;
import org.eclipse.acceleo.query.runtime.AcceleoQueryValidationException;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.runtime.impl.AbstractLanguageServices;
import org.eclipse.acceleo.query.runtime.impl.ServicesValidationResult;
import org.eclipse.acceleo.query.validation.type.ClassType;
import org.eclipse.acceleo.query.validation.type.EClassifierLiteralType;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.ICollectionType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.query.validation.type.NothingType;
import org.eclipse.acceleo.query.validation.type.SequenceType;
import org.eclipse.acceleo.query.validation.type.SetType;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EcorePackage;

public class ValidationServices
extends AbstractLanguageServices {
    public static final String INTERNAL_ERROR_MSG = "An internal error occured during validation of a query";
    private static final String VARIABLE_HAS_NO_TYPES = "The %s variable has no types";

    public ValidationServices(IReadOnlyQueryEnvironment queryEnv) {
        super(queryEnv);
    }

    public NothingType nothing(String message, Object ... msgArgs) {
        String formatedMessage = String.format(message, msgArgs);
        return new NothingType(formatedMessage);
    }

    public Set<IType> getVariableTypes(Map<String, Set<IType>> variableTypes, String variableName) {
        try {
            LinkedHashSet<IType> res = new LinkedHashSet<IType>();
            Set<IType> types = variableTypes.get(variableName);
            if (types != null) {
                if (types.size() > 0) {
                    res.addAll(types);
                } else {
                    res.add(this.nothing(VARIABLE_HAS_NO_TYPES, variableName));
                }
            } else {
                res.add(this.nothing("Couldn't find the %s variable", variableName));
            }
            return res;
        }
        catch (NullPointerException e) {
            throw new AcceleoQueryValidationException(INTERNAL_ERROR_MSG, e);
        }
    }

    public ServicesValidationResult callType(Call call, IValidationResult validationResult, String serviceName, List<Set<IType>> argTypes) {
        if (argTypes.size() == 0) {
            throw new AcceleoQueryValidationException("An internal error occured during validation of a query : at least one argument must be specified for service " + serviceName + ".");
        }
        try {
            ServicesValidationResult result = new ServicesValidationResult(this.queryEnvironment, this);
            CombineIterator it = new CombineIterator(argTypes);
            LinkedHashMap typesPerService = new LinkedHashMap();
            boolean serviceFound = false;
            boolean emptyCombination = !it.hasNext();
            ArrayList<String> notFoundSignatures = new ArrayList<String>();
            while (it.hasNext()) {
                Object currentArgTypes = it.next();
                IService service = this.queryEnvironment.getLookupEngine().lookup(serviceName, currentArgTypes.toArray(new IType[currentArgTypes.size()]));
                if (service != null) {
                    LinkedHashMap<Object, Set<IType>> typeMapping = (LinkedHashMap<Object, Set<IType>>)typesPerService.get(service);
                    if (typeMapping == null) {
                        typeMapping = new LinkedHashMap<Object, Set<IType>>();
                        typesPerService.put(service, typeMapping);
                    }
                    Set<IType> serviceTypes = service.getType(call, this, validationResult, this.queryEnvironment, (List<IType>)currentArgTypes);
                    typeMapping.put(currentArgTypes, serviceTypes);
                    serviceFound = true;
                    continue;
                }
                notFoundSignatures.add(this.serviceSignature(serviceName, (List<IType>)currentArgTypes));
            }
            if (!emptyCombination) {
                if (serviceFound) {
                    for (Map.Entry entry : typesPerService.entrySet()) {
                        IService service = (IService)entry.getKey();
                        Map types = (Map)entry.getValue();
                        result.addServiceTypes(service, types);
                    }
                } else {
                    StringBuilder builder = new StringBuilder();
                    for (String signature : notFoundSignatures) {
                        builder.append(String.valueOf(String.format("Couldn't find the %s service", signature)) + "\n");
                    }
                    result.addServiceNotFound(this.nothing(builder.substring(0, builder.length() - 1), new Object[0]));
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new AcceleoQueryValidationException(INTERNAL_ERROR_MSG, e);
        }
    }

    public ServicesValidationResult callOrApplyTypes(Call call, IValidationResult validationResult, String serviceName, List<Set<IType>> argTypes) {
        try {
            ServicesValidationResult result = new ServicesValidationResult(this.queryEnvironment, this);
            ArrayList<Set<IType>> argTypesNoReceiver = new ArrayList<Set<IType>>(argTypes);
            Set receiverTypes = (Set)argTypesNoReceiver.remove(0);
            for (IType receiverType : receiverTypes) {
                if (receiverType instanceof SequenceType) {
                    result.merge(this.validateCallOnSequence(call, validationResult, serviceName, (SequenceType)receiverType, argTypesNoReceiver));
                    continue;
                }
                if (receiverType instanceof SetType) {
                    result.merge(this.validateCallOnSet(call, validationResult, serviceName, (SetType)receiverType, argTypesNoReceiver));
                    continue;
                }
                ArrayList<Set<IType>> newArgTypes = new ArrayList<Set<IType>>(argTypesNoReceiver);
                LinkedHashSet<IType> newReceiverTypes = new LinkedHashSet<IType>();
                newReceiverTypes.add(receiverType);
                newArgTypes.add(0, newReceiverTypes);
                result.merge(this.callType(call, validationResult, serviceName, newArgTypes));
            }
            return result;
        }
        catch (Exception e) {
            throw new AcceleoQueryValidationException(INTERNAL_ERROR_MSG, e);
        }
    }

    private ServicesValidationResult validateCallOnSequence(Call call, IValidationResult validationResult, String serviceName, SequenceType receiverType, List<Set<IType>> argTypesNoReceiver) {
        try {
            ArrayList<Set<IType>> newArgTypes = new ArrayList<Set<IType>>(argTypesNoReceiver);
            LinkedHashSet<IType> newReceiverTypes = new LinkedHashSet<IType>();
            newReceiverTypes.add(receiverType.getCollectionType());
            newArgTypes.add(0, newReceiverTypes);
            ServicesValidationResult result = this.callOrApplyTypes(call, validationResult, serviceName, newArgTypes);
            result.flattenSequence();
            return result;
        }
        catch (Exception e) {
            throw new AcceleoQueryValidationException("empty argument array passed to callOrApply " + serviceName, e);
        }
    }

    private ServicesValidationResult validateCallOnSet(Call call, IValidationResult validationResult, String serviceName, SetType receiverType, List<Set<IType>> argTypesNoReceiver) {
        try {
            ArrayList<Set<IType>> newArgTypes = new ArrayList<Set<IType>>(argTypesNoReceiver);
            LinkedHashSet<IType> newReceiverTypes = new LinkedHashSet<IType>();
            newReceiverTypes.add(receiverType.getCollectionType());
            newArgTypes.add(0, newReceiverTypes);
            ServicesValidationResult result = this.callOrApplyTypes(call, validationResult, serviceName, newArgTypes);
            result.flattenSet();
            return result;
        }
        catch (Exception e) {
            throw new AcceleoQueryValidationException("empty argument array passed to callOrApply " + serviceName, e);
        }
    }

    public ServicesValidationResult collectionServiceCallTypes(Call call, IValidationResult validationResult, String serviceName, List<Set<IType>> argTypes) {
        ArrayList<Set<IType>> newArguments = new ArrayList<Set<IType>>(argTypes);
        try {
            Set receiverTypes = (Set)newArguments.remove(0);
            LinkedHashSet<IType> newReceiverTypes = new LinkedHashSet<IType>();
            for (IType receiverType : receiverTypes) {
                if (receiverType instanceof ClassType && receiverType.getType() == null) {
                    newReceiverTypes.add(new SetType(this.queryEnvironment, this.nothing("The Collection was empty due to a null value being wrapped as a Collection.", new Object[0])));
                    continue;
                }
                if (!(receiverType instanceof ICollectionType) && !(receiverType instanceof NothingType)) {
                    newReceiverTypes.add(new SetType(this.queryEnvironment, receiverType));
                    continue;
                }
                newReceiverTypes.add(receiverType);
            }
            newArguments.add(0, newReceiverTypes);
            return this.callType(call, validationResult, serviceName, newArguments);
        }
        catch (Exception e) {
            throw new AcceleoQueryValidationException(INTERNAL_ERROR_MSG, e);
        }
    }

    protected String serviceSignature(String serviceName, List<IType> argumentTypes) {
        StringBuilder builder = new StringBuilder();
        builder.append(serviceName).append('(');
        boolean first = true;
        for (IType argType : argumentTypes) {
            if (!first) {
                builder.append(',');
            } else {
                first = false;
            }
            builder.append(argType.toString());
        }
        return builder.append(')').toString();
    }

    public Set<IType> getIType(Type type) {
        LinkedHashSet<IType> result = new LinkedHashSet<IType>();
        if (type instanceof ParameterizedType) {
            Class cls = (Class)((ParameterizedType)type).getRawType();
            if (List.class.isAssignableFrom(cls)) {
                for (IType t : this.getIType(((ParameterizedType)type).getActualTypeArguments()[0])) {
                    result.add(new SequenceType(this.queryEnvironment, t));
                }
            } else if (Set.class.isAssignableFrom(cls)) {
                for (IType t : this.getIType(((ParameterizedType)type).getActualTypeArguments()[0])) {
                    result.add(new SetType(this.queryEnvironment, t));
                }
            } else {
                result.add(new ClassType(this.queryEnvironment, cls));
            }
        } else if (type instanceof Class) {
            Class cls = (Class)type;
            result.addAll(this.getIType(cls));
        } else {
            result.add(new ClassType(this.queryEnvironment, Object.class));
        }
        return result;
    }

    private Set<IType> getIType(Class<?> cls) {
        LinkedHashSet<IType> result = new LinkedHashSet<IType>();
        Set<EClassifier> classifiers = this.queryEnvironment.getEPackageProvider().getEClassifiers(cls);
        if (List.class.isAssignableFrom(cls)) {
            result.add(new SequenceType(this.queryEnvironment, new ClassType(this.queryEnvironment, Object.class)));
        } else if (Set.class.isAssignableFrom(cls)) {
            result.add(new SetType(this.queryEnvironment, new ClassType(this.queryEnvironment, Object.class)));
        } else if (classifiers != null) {
            for (EClassifier eCls : classifiers) {
                result.add(new EClassifierType(this.queryEnvironment, eCls));
            }
        } else {
            result.add(new ClassType(this.queryEnvironment, cls));
        }
        return result;
    }

    public Set<IType> getErrorTypes(IValidationResult validationResult, Error error) {
        LinkedHashSet<IType> result = new LinkedHashSet<IType>();
        for (Diagnostic diagnostic : validationResult.getAstResult().getDiagnostic().getChildren()) {
            if (!diagnostic.getData().contains(error)) continue;
            result.add(this.nothing(diagnostic.getMessage(), new Object[0]));
        }
        return result;
    }

    public IType lower(IType type1, IType type2) {
        IType result = type1 == null || type2 == null ? null : (type1.isAssignableFrom(type2) || type1.getType() == EcorePackage.eINSTANCE.getEObject() ? (type2 instanceof EClassifierLiteralType ? new EClassifierType(this.queryEnvironment, ((EClassifierLiteralType)type2).getType()) : type2) : (type2.isAssignableFrom(type1) || type2.getType() == EcorePackage.eINSTANCE.getEObject() ? (type1 instanceof EClassifierLiteralType ? new EClassifierType(this.queryEnvironment, ((EClassifierLiteralType)type1).getType()) : type1) : null));
        return result;
    }

    public Set<EClass> getSubTypesTopIntersection(EClass eCls1, EClass eCls2) {
        LinkedHashSet<EClass> result = new LinkedHashSet<EClass>();
        Set<EClass> subTypes1 = this.queryEnvironment.getEPackageProvider().getAllSubTypes(eCls1);
        Set<EClass> subTypes2 = this.queryEnvironment.getEPackageProvider().getAllSubTypes(eCls2);
        Sets.SetView intersection = Sets.intersection(subTypes1, subTypes2);
        for (EClass eCls : intersection) {
            boolean isTopEClass = Collections.disjoint(eCls.getEAllSuperTypes(), intersection);
            if (!isTopEClass) continue;
            result.add(eCls);
        }
        return result;
    }

    public Set<IType> intersection(IType type1, IType type2) {
        LinkedHashSet<IType> result = new LinkedHashSet<IType>();
        IType lowerType = this.lower(type1, type2);
        if (lowerType != null) {
            result.add(lowerType);
        } else if (type1.getType() instanceof EClass && type2.getType() instanceof EClass) {
            for (EClass eCls : this.getSubTypesTopIntersection((EClass)type1.getType(), (EClass)type2.getType())) {
                result.add(new EClassifierType(this.getQueryEnvironment(), (EClassifier)eCls));
            }
        }
        return result;
    }
}

