/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.validation.type;

import com.google.common.collect.ImmutableMap;
import org.eclipse.acceleo.query.validation.type.IType;

public abstract class AbstractType
implements IType {
    private static final ImmutableMap<Class<?>, Class<?>> PRIMITIVE_WRAPPERS = ImmutableMap.builder().put(Byte.TYPE, Byte.class).put(Short.TYPE, Short.class).put(Character.TYPE, Character.class).put(Integer.TYPE, Integer.class).put(Long.TYPE, Long.class).put(Float.TYPE, Float.class).put(Double.TYPE, Double.class).put(Boolean.TYPE, Boolean.class).build();

    protected Class<?> wrapPrimitive(Class<?> source) {
        Class wrapper = (Class)PRIMITIVE_WRAPPERS.get(source);
        if (wrapper != null) {
            return wrapper;
        }
        return source;
    }

    protected boolean isAssignableFrom(Class<?> toType, Class<?> fromType) {
        Class<?> wrappedToType = this.wrapPrimitive(toType);
        Class<?> wrappedFromType = this.wrapPrimitive(fromType);
        boolean result = false;
        if (toType == null || fromType == null) {
            result = false;
        } else if (wrappedToType.isAssignableFrom(wrappedFromType)) {
            result = true;
        } else if (wrappedFromType == Byte.class) {
            result = wrappedToType == Short.class || wrappedToType == Integer.class || wrappedToType == Long.class || wrappedToType == Float.class || wrappedToType == Double.class;
        } else if (wrappedFromType == Short.class) {
            result = wrappedToType == Integer.class || wrappedToType == Long.class || wrappedToType == Float.class || wrappedToType == Double.class;
        } else if (wrappedFromType == Character.class) {
            result = wrappedToType == Integer.class || wrappedToType == Long.class || wrappedToType == Float.class || wrappedToType == Double.class;
        } else if (wrappedFromType == Integer.class) {
            result = wrappedToType == Long.class || wrappedToType == Float.class || wrappedToType == Double.class;
        } else if (wrappedFromType == Long.class) {
            result = wrappedToType == Float.class || wrappedToType == Double.class;
        } else if (wrappedFromType == Float.class) {
            result = wrappedToType == Double.class;
        }
        return result;
    }

    public int hashCode() {
        return this.getType().hashCode();
    }

    public boolean equals(Object obj) {
        return this.getClass() == obj.getClass() && ((AbstractType)obj).getType().equals(this.getType());
    }
}

