/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.misc.NotNull;
import org.antlr.v4.runtime.misc.Nullable;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.eclipse.acceleo.query.ast.Binding;
import org.eclipse.acceleo.query.ast.BooleanLiteral;
import org.eclipse.acceleo.query.ast.Call;
import org.eclipse.acceleo.query.ast.CallType;
import org.eclipse.acceleo.query.ast.CollectionTypeLiteral;
import org.eclipse.acceleo.query.ast.Error;
import org.eclipse.acceleo.query.ast.ErrorCollectionCall;
import org.eclipse.acceleo.query.ast.ErrorExpression;
import org.eclipse.acceleo.query.ast.ErrorFeatureAccessOrCall;
import org.eclipse.acceleo.query.ast.ErrorTypeLiteral;
import org.eclipse.acceleo.query.ast.ErrorVariableDeclaration;
import org.eclipse.acceleo.query.ast.Expression;
import org.eclipse.acceleo.query.ast.FeatureAccess;
import org.eclipse.acceleo.query.ast.IntegerLiteral;
import org.eclipse.acceleo.query.ast.Lambda;
import org.eclipse.acceleo.query.ast.Literal;
import org.eclipse.acceleo.query.ast.NullLiteral;
import org.eclipse.acceleo.query.ast.RealLiteral;
import org.eclipse.acceleo.query.ast.SequenceInExtensionLiteral;
import org.eclipse.acceleo.query.ast.SetInExtensionLiteral;
import org.eclipse.acceleo.query.ast.StringLiteral;
import org.eclipse.acceleo.query.ast.TypeLiteral;
import org.eclipse.acceleo.query.ast.VarRef;
import org.eclipse.acceleo.query.ast.VariableDeclaration;
import org.eclipse.acceleo.query.parser.AstBuilder;
import org.eclipse.acceleo.query.parser.QueryBaseListener;
import org.eclipse.acceleo.query.parser.QueryParser;
import org.eclipse.acceleo.query.runtime.AcceleoQueryEvaluationException;
import org.eclipse.acceleo.query.runtime.IQueryBuilderEngine;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.impl.EvaluationServices;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;

public class AstBuilderListener
extends QueryBaseListener {
    public static final String CONDITIONAL_OPERATOR = "if";
    public static final String NOT_SERVICE_NAME = "not";
    public static final String NOT_OPERATOR = "not";
    public static final String LET_OPERATOR = "let";
    public static final String DIFFERS_SERVICE_NAME = "differs";
    public static final String DIFFERS_OPERATOR = "<>";
    public static final String EQUALS_SERVICE_NAME = "equals";
    public static final String EQUALS_OPERATOR = "=";
    public static final String GREATER_THAN_EQUAL_SERVICE_NAME = "greaterThanEqual";
    public static final String GREATER_THAN_EQUAL_OPERATOR = ">=";
    public static final String GREATER_THAN_SERVICE_NAME = "greaterThan";
    public static final String GREATER_THAN_OPERATOR = ">";
    public static final String LESS_THAN_EQUAL_SERVICE_NAME = "lessThanEqual";
    public static final String LESS_THAN_EQUAL_OPERATOR = "<=";
    public static final String LESS_THAN_SERVICE_NAME = "lessThan";
    public static final String LESS_THAN_OPERATOR = "<";
    public static final String DIV_SERVICE_NAME = "divOp";
    public static final String DIV_OPERATOR = "/";
    public static final String MULT_SERVICE_NAME = "mult";
    public static final String MULT_OPERATOR = "*";
    public static final String SUB_SERVICE_NAME = "sub";
    public static final String SUB_OPERATOR = "-";
    public static final String ADD_SERVICE_NAME = "add";
    public static final String ADD_OPERATOR = "+";
    public static final String UNARY_MIN_SERVICE_NAME = "unaryMin";
    public static final String UNARY_MIN_OPERATOR = "-";
    public static final String AND_SERVICE_NAME = "and";
    public static final String AND_OPERATOR = "and";
    public static final String OR_SERVICE_NAME = "or";
    public static final String OR_OPERATOR = "or";
    public static final String XOR_SERVICE_NAME = "xor";
    public static final String XOR_OPERATOR = "xor";
    public static final String IMPLIES_SERVICE_NAME = "implies";
    public static final String IMPLIES_OPERATOR = "implies";
    public static final Set<String> OPERATOR_SERVICE_NAMES = AstBuilderListener.initOperatorServiceNames();
    private static final String THIS_SHOULDN_T_HAPPEN = "This shouldn't happen.";
    private static final int NO_ERROR = -1;
    private static final int FULLY_QUALIFIED_NAME = 3;
    private static final String INTERNAL_ERROR_MSG = "Internal exception occured while evaluating an expression";
    private Stack<Object> stack = new Stack();
    private int errorRule = -1;
    private final Map<Object, Integer> startPositions = new HashMap<Object, Integer>();
    private final Map<Object, Integer> endPositions = new HashMap<Object, Integer>();
    private final List<Error> errors = new ArrayList<Error>();
    private final ANTLRErrorListener errorListener = new QueryErrorListener();
    private AstBuilder builder = new AstBuilder();
    private IQueryEnvironment environment;

    public AstBuilderListener(IQueryEnvironment environment) {
        this.environment = environment;
    }

    private static Set<String> initOperatorServiceNames() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        result.add(ADD_SERVICE_NAME);
        result.add("and");
        result.add(DIFFERS_SERVICE_NAME);
        result.add(DIV_SERVICE_NAME);
        result.add(EQUALS_SERVICE_NAME);
        result.add(GREATER_THAN_EQUAL_SERVICE_NAME);
        result.add(GREATER_THAN_SERVICE_NAME);
        result.add("implies");
        result.add(LESS_THAN_EQUAL_SERVICE_NAME);
        result.add(LESS_THAN_SERVICE_NAME);
        result.add(MULT_SERVICE_NAME);
        result.add("not");
        result.add("or");
        result.add(SUB_SERVICE_NAME);
        result.add(UNARY_MIN_SERVICE_NAME);
        result.add("xor");
        return result;
    }

    public IQueryBuilderEngine.AstResult getAstResult() {
        return new IQueryBuilderEngine.AstResult(this.pop(), this.startPositions, this.endPositions, this.errors);
    }

    private Expression pop() {
        try {
            return (Expression)this.stack.pop();
        }
        catch (EmptyStackException e) {
            throw new AcceleoQueryEvaluationException(INTERNAL_ERROR_MSG, e);
        }
        catch (ClassCastException cce) {
            throw new AcceleoQueryEvaluationException(INTERNAL_ERROR_MSG, cce);
        }
    }

    private String popString() {
        try {
            return (String)this.stack.pop();
        }
        catch (EmptyStackException e) {
            throw new AcceleoQueryEvaluationException(INTERNAL_ERROR_MSG, e);
        }
        catch (ClassCastException e2) {
            throw new AcceleoQueryEvaluationException(INTERNAL_ERROR_MSG, e2);
        }
    }

    private Binding popBinding() {
        try {
            return (Binding)this.stack.pop();
        }
        catch (EmptyStackException e) {
            throw new AcceleoQueryEvaluationException(INTERNAL_ERROR_MSG, e);
        }
        catch (ClassCastException e2) {
            throw new AcceleoQueryEvaluationException(INTERNAL_ERROR_MSG, e2);
        }
    }

    private VariableDeclaration popVariableDeclaration() {
        try {
            return (VariableDeclaration)this.stack.pop();
        }
        catch (EmptyStackException e) {
            throw new AcceleoQueryEvaluationException(INTERNAL_ERROR_MSG, e);
        }
        catch (ClassCastException e2) {
            throw new AcceleoQueryEvaluationException(INTERNAL_ERROR_MSG, e2);
        }
    }

    private TypeLiteral popTypeLiteral() {
        try {
            return (TypeLiteral)this.stack.pop();
        }
        catch (EmptyStackException e) {
            throw new AcceleoQueryEvaluationException(INTERNAL_ERROR_MSG, e);
        }
        catch (ClassCastException e2) {
            throw new AcceleoQueryEvaluationException(INTERNAL_ERROR_MSG, e2);
        }
    }

    private Expression[] popArgs() {
        try {
            return (Expression[])this.stack.pop();
        }
        catch (EmptyStackException e) {
            throw new AcceleoQueryEvaluationException(INTERNAL_ERROR_MSG, e);
        }
        catch (ClassCastException e2) {
            throw new AcceleoQueryEvaluationException(INTERNAL_ERROR_MSG, e2);
        }
    }

    private void push(Object obj) {
        this.stack.push(obj);
    }

    private void pushError(Error error) {
        this.errors.add(error);
        this.stack.push(error);
    }

    @Override
    public void exitIntType(QueryParser.IntTypeContext ctx) {
        TypeLiteral typeLiteral = this.builder.typeLiteral(Boolean.class);
        this.startPositions.put(typeLiteral, ctx.start.getStartIndex());
        this.endPositions.put(typeLiteral, ctx.stop.getStopIndex() + 1);
        this.push(typeLiteral);
    }

    @Override
    public void exitFalseLit(QueryParser.FalseLitContext ctx) {
        BooleanLiteral booleanLiteral = this.builder.booleanLiteral(false);
        this.startPositions.put(booleanLiteral, ctx.start.getStartIndex());
        this.endPositions.put(booleanLiteral, ctx.stop.getStopIndex() + 1);
        this.push(booleanLiteral);
    }

    @Override
    public void exitRealType(QueryParser.RealTypeContext ctx) {
        RealLiteral realLiteral = this.builder.realLiteral(Double.parseDouble(ctx.getText()));
        this.startPositions.put(realLiteral, ctx.start.getStartIndex());
        this.endPositions.put(realLiteral, ctx.stop.getStopIndex() + 1);
        this.push(realLiteral);
    }

    @Override
    public void exitTrueLit(QueryParser.TrueLitContext ctx) {
        BooleanLiteral booleanLiteral = this.builder.booleanLiteral(true);
        this.startPositions.put(booleanLiteral, ctx.start.getStartIndex());
        this.endPositions.put(booleanLiteral, ctx.stop.getStopIndex() + 1);
        this.push(booleanLiteral);
    }

    @Override
    public void exitSeqType(QueryParser.SeqTypeContext ctx) {
        TypeLiteral elementType = this.popTypeLiteral();
        CollectionTypeLiteral collectionTypeLiteral = this.builder.collectionTypeLiteral(List.class, elementType);
        this.startPositions.put(collectionTypeLiteral, ctx.start.getStartIndex());
        this.endPositions.put(collectionTypeLiteral, ctx.stop.getStopIndex() + 1);
        this.push(collectionTypeLiteral);
    }

    @Override
    public void exitSetType(QueryParser.SetTypeContext ctx) {
        TypeLiteral elementType = this.popTypeLiteral();
        CollectionTypeLiteral collectionTypeLiteral = this.builder.collectionTypeLiteral(Set.class, elementType);
        this.startPositions.put(collectionTypeLiteral, ctx.start.getStartIndex());
        this.endPositions.put(collectionTypeLiteral, ctx.stop.getStopIndex() + 1);
        this.push(collectionTypeLiteral);
    }

    @Override
    public void exitNot(QueryParser.NotContext ctx) {
        Call callService = this.builder.callService(CallType.CALLSERVICE, "not", this.pop());
        this.startPositions.put(callService, ctx.start.getStartIndex());
        this.endPositions.put(callService, ctx.stop.getStopIndex() + 1);
        this.push(callService);
    }

    @Override
    public void exitStringLit(QueryParser.StringLitContext ctx) {
        String text = ctx.getText();
        StringLiteral stringLiteral = this.builder.stringLiteral(text.substring(1, text.length() - 1));
        this.startPositions.put(stringLiteral, ctx.start.getStartIndex());
        this.endPositions.put(stringLiteral, ctx.stop.getStopIndex() + 1);
        this.push(stringLiteral);
    }

    @Override
    public void exitRealLit(QueryParser.RealLitContext ctx) {
        RealLiteral realLiteral = this.builder.realLiteral(Double.valueOf(ctx.getText()));
        this.startPositions.put(realLiteral, ctx.start.getStartIndex());
        this.endPositions.put(realLiteral, ctx.stop.getStopIndex() + 1);
        this.push(realLiteral);
    }

    @Override
    public void exitStrType(QueryParser.StrTypeContext ctx) {
        TypeLiteral typeLiteral = this.builder.typeLiteral(String.class);
        this.startPositions.put(typeLiteral, ctx.start.getStartIndex());
        this.endPositions.put(typeLiteral, ctx.stop.getStopIndex() + 1);
        this.push(typeLiteral);
    }

    @Override
    public void exitOr(QueryParser.OrContext ctx) {
        this.pushBinary("or", ctx);
    }

    @Override
    public void exitXor(QueryParser.XorContext ctx) {
        this.pushBinary("xor", ctx);
    }

    @Override
    public void exitImplies(QueryParser.ImpliesContext ctx) {
        this.pushBinary("implies", ctx);
    }

    @Override
    public void exitBooleanType(QueryParser.BooleanTypeContext ctx) {
        TypeLiteral typeLiteral = this.builder.typeLiteral(Boolean.class);
        this.startPositions.put(typeLiteral, ctx.start.getStartIndex());
        this.endPositions.put(typeLiteral, ctx.stop.getStopIndex() + 1);
        this.push(typeLiteral);
    }

    @Override
    public void exitIntegerLit(QueryParser.IntegerLitContext ctx) {
        IntegerLiteral integerLiteral = this.builder.integerLiteral(Integer.valueOf(ctx.getText()));
        this.startPositions.put(integerLiteral, ctx.start.getStartIndex());
        this.endPositions.put(integerLiteral, ctx.stop.getStopIndex() + 1);
        this.push(integerLiteral);
    }

    @Override
    public void exitAnd(QueryParser.AndContext ctx) {
        this.pushBinary("and", ctx);
    }

    @Override
    public void exitVarRef(QueryParser.VarRefContext ctx) {
        VarRef varRef = this.builder.varRef(ctx.getText());
        this.startPositions.put(varRef, ctx.start.getStartIndex());
        this.endPositions.put(varRef, ctx.stop.getStopIndex() + 1);
        this.push(varRef);
    }

    @Override
    public void exitFeature(QueryParser.FeatureContext ctx) {
        Expression receiver = this.pop();
        FeatureAccess featureAccess = this.builder.featureAccess(receiver, ctx.getChild(1).getText());
        this.startPositions.put(featureAccess, this.startPositions.get(receiver));
        this.endPositions.put(featureAccess, ctx.stop.getStopIndex() + 1);
        this.push(featureAccess);
    }

    private void pushBinary(String service, ParserRuleContext ctx) {
        Expression op2 = this.pop();
        Expression op1 = this.pop();
        Call callService = this.builder.callService(CallType.CALLSERVICE, service, op1, op2);
        this.startPositions.put(callService, this.startPositions.get(op1));
        this.endPositions.put(callService, this.endPositions.get(op2));
        this.push(callService);
    }

    @Override
    public void exitServiceCall(QueryParser.ServiceCallContext ctx) {
        int childCount = ctx.getChild(2).getChildCount();
        int argc = 1 + (childCount == 0 ? 0 : 1 + childCount / 2);
        Expression[] args = new Expression[argc];
        int i = argc - 1;
        while (i >= 1) {
            args[i] = this.pop();
            --i;
        }
        String serviceName = ctx.getChild(0).getText().replace("::", ".");
        args[0] = this.pop();
        this.push(serviceName);
        this.push(args);
    }

    @Override
    public void exitMin(QueryParser.MinContext ctx) {
        Call callService = this.builder.callService(CallType.CALLSERVICE, UNARY_MIN_SERVICE_NAME, this.pop());
        this.startPositions.put(callService, ctx.start.getStartIndex());
        this.endPositions.put(callService, ctx.stop.getStopIndex() + 1);
        this.push(callService);
    }

    @Override
    public void exitAdd(QueryParser.AddContext ctx) {
        String op = ctx.getChild(1).getText();
        if (ADD_OPERATOR.equals(op)) {
            this.pushBinary(ADD_SERVICE_NAME, ctx);
        } else if ("-".equals(op)) {
            this.pushBinary(SUB_SERVICE_NAME, ctx);
        } else {
            throw new AcceleoQueryEvaluationException(THIS_SHOULDN_T_HAPPEN);
        }
    }

    @Override
    public void exitMult(QueryParser.MultContext ctx) {
        String op = ctx.getChild(1).getText();
        if (MULT_OPERATOR.equals(op)) {
            this.pushBinary(MULT_SERVICE_NAME, ctx);
        } else if (DIV_OPERATOR.equals(op)) {
            this.pushBinary(DIV_SERVICE_NAME, ctx);
        } else {
            throw new AcceleoQueryEvaluationException(THIS_SHOULDN_T_HAPPEN);
        }
    }

    @Override
    public void exitComp(QueryParser.CompContext ctx) {
        String op = ctx.getChild(1).getText();
        if (LESS_THAN_OPERATOR.equals(op)) {
            this.pushBinary(LESS_THAN_SERVICE_NAME, ctx);
        } else if (LESS_THAN_EQUAL_OPERATOR.equals(op)) {
            this.pushBinary(LESS_THAN_EQUAL_SERVICE_NAME, ctx);
        } else if (GREATER_THAN_OPERATOR.equals(op)) {
            this.pushBinary(GREATER_THAN_SERVICE_NAME, ctx);
        } else if (GREATER_THAN_EQUAL_OPERATOR.equals(op)) {
            this.pushBinary(GREATER_THAN_EQUAL_SERVICE_NAME, ctx);
        } else if (EQUALS_OPERATOR.equals(op)) {
            this.pushBinary(EQUALS_SERVICE_NAME, ctx);
        } else if (DIFFERS_OPERATOR.equals(op)) {
            this.pushBinary(DIFFERS_SERVICE_NAME, ctx);
        } else {
            throw new AcceleoQueryEvaluationException(THIS_SHOULDN_T_HAPPEN);
        }
    }

    private TypeLiteral createModelType(QueryParser.ModelObjectTypeContext ctx) {
        TypeLiteral result;
        EClassifier type;
        String nsPrefix = null;
        String name = null;
        if (ctx.getChild(0).getChildCount() == 3) {
            nsPrefix = ctx.getChild(0).getChild(0).getText();
            name = ctx.getChild(0).getChild(2).getText();
            type = this.environment.getEPackageProvider().getType(nsPrefix, name);
        } else {
            name = ctx.getChild(0).getChild(0).getText();
            type = this.environment.getEPackageProvider().getType(name);
        }
        if (type == null) {
            ArrayList<String> segments = new ArrayList<String>(2);
            if (nsPrefix != null) {
                segments.add(nsPrefix);
            }
            if (name != null) {
                segments.add(name);
            }
            result = this.builder.errorTypeLiteral(segments.toArray(new String[segments.size()]));
            this.errors.add((ErrorTypeLiteral)result);
        } else {
            result = this.builder.typeLiteral(type);
        }
        this.startPositions.put(result, ctx.start.getStartIndex());
        this.endPositions.put(result, ctx.stop.getStopIndex() + 1);
        return result;
    }

    private void callFilteredService(String serviceName, ParserRuleContext ctx) {
        if (this.errorRule == -1) {
            if (ctx.getChildCount() == 3) {
                Expression type = ctx.getChild(1) instanceof QueryParser.ModelObjectTypeContext ? this.createModelType((QueryParser.ModelObjectTypeContext)ctx.getChild(1)) : this.pop();
                Expression receiver = this.pop();
                this.push(serviceName);
                this.push(new Expression[]{receiver, type});
            } else {
                Expression receiver = this.pop();
                this.push(serviceName);
                this.push(new Expression[]{receiver});
            }
        } else {
            TypeLiteral type = this.popTypeLiteral();
            Expression receiver = this.pop();
            this.push(serviceName);
            this.push(new Expression[]{receiver, type});
        }
    }

    @Override
    public void exitEContent(QueryParser.EContentContext ctx) {
        this.callFilteredService("eContents", ctx);
    }

    @Override
    public void exitPrecSiblings(QueryParser.PrecSiblingsContext ctx) {
        this.callFilteredService("precedingSiblings", ctx);
    }

    @Override
    public void exitEAContent(QueryParser.EAContentContext ctx) {
        this.callFilteredService("eAllContents", ctx);
    }

    @Override
    public void exitEContainer(QueryParser.EContainerContext ctx) {
        this.callFilteredService("eContainer", ctx);
    }

    @Override
    public void exitEContainerOrSelf(QueryParser.EContainerOrSelfContext ctx) {
        this.callFilteredService("eContainerOrSelf", ctx);
    }

    @Override
    public void exitEInverse(QueryParser.EInverseContext ctx) {
        this.callFilteredService("eInverse", ctx);
    }

    @Override
    public void exitFilter(QueryParser.FilterContext ctx) {
        this.callFilteredService("filter", ctx);
    }

    @Override
    public void exitAs(QueryParser.AsContext ctx) {
        this.callFilteredService("oclAsType", ctx);
    }

    @Override
    public void exitAsType(QueryParser.AsTypeContext ctx) {
        this.callFilteredService("oclAsType", ctx);
    }

    @Override
    public void exitCallService(QueryParser.CallServiceContext ctx) {
        if (this.errorRule != 6) {
            Expression[] args = this.popArgs();
            String serviceName = this.popString();
            Call callService = this.builder.callService(CallType.COLLECTIONCALL, serviceName, args);
            this.startPositions.put(callService, this.startPositions.get(args[0]));
            this.endPositions.put(callService, ctx.stop.getStopIndex() + 1);
            this.push(callService);
        }
    }

    @Override
    public void exitApply(QueryParser.ApplyContext ctx) {
        Expression[] args = this.popArgs();
        String serviceName = this.popString();
        Call callService = this.builder.callService(CallType.CALLORAPPLY, serviceName, args);
        this.startPositions.put(callService, this.startPositions.get(args[0]));
        this.endPositions.put(callService, ctx.stop.getStopIndex() + 1);
        this.push(callService);
    }

    @Override
    public void exitIsType(QueryParser.IsTypeContext ctx) {
        this.callFilteredService("oclIsTypeOf", ctx);
    }

    @Override
    public void exitIsKind(QueryParser.IsKindContext ctx) {
        this.callFilteredService("oclIsKindOf", ctx);
    }

    @Override
    public void exitVariableDefinition(QueryParser.VariableDefinitionContext ctx) {
        if (this.errorRule == -1) {
            VariableDeclaration variableDeclaration;
            Expression variableExpression = this.pop();
            if (ctx.getChildCount() == 4) {
                variableDeclaration = this.builder.variableDeclaration(ctx.getChild(0).getText(), this.createModelType((QueryParser.ModelObjectTypeContext)ctx.getChild(2)), variableExpression);
                this.endPositions.put(variableDeclaration, ((ParserRuleContext)ctx.getChild((int)2)).stop.getStopIndex() + 1);
            } else {
                variableDeclaration = this.builder.variableDeclaration(ctx.getChild(0).getText(), variableExpression);
                this.endPositions.put(variableDeclaration, ((TerminalNode)ctx.getChild(0)).getSymbol().getStopIndex() + 1);
            }
            this.startPositions.put(variableDeclaration, ctx.start.getStartIndex());
            this.stack.push(variableDeclaration);
        }
    }

    @Override
    public void exitIterationCall(QueryParser.IterationCallContext ctx) {
        String serviceName = ctx.getChild(0).getText();
        Expression ast = this.pop();
        new EvaluationServices(this.environment);
        VariableDeclaration iterator = this.popVariableDeclaration();
        Lambda lambda = this.builder.lambda(ast, iterator);
        this.startPositions.put(lambda, this.startPositions.get(ast));
        this.endPositions.put(lambda, (int)this.endPositions.get(ast));
        this.push(serviceName);
        this.push(new Expression[]{iterator.getExpression(), lambda});
    }

    @Override
    public void exitEnumOrClassifierLit(QueryParser.EnumOrClassifierLitContext ctx) {
        if (this.errorRule == -1) {
            String literalName = ctx.getChild(2).getText();
            Literal toPush = ctx.getChild(0).getChildCount() == 1 ? this.twoSegmentEnumOrClassifierLiteral(ctx, literalName) : this.threeSegmentEnumLiteral(ctx, literalName);
            this.push(toPush);
        }
    }

    private Literal twoSegmentEnumOrClassifierLiteral(QueryParser.EnumOrClassifierLitContext ctx, String literalName) {
        EClassifier classifier;
        String enumName = ctx.getChild(0).getChild(0).getText();
        EEnumLiteral literal = this.environment.getEPackageProvider().getEnumLiteral(enumName, literalName);
        Literal toPush = literal != null ? this.builder.enumLiteral(literal) : ((classifier = this.environment.getEPackageProvider().getType(enumName, literalName)) != null ? this.builder.typeLiteral(classifier) : this.builder.errorTypeLiteral(enumName, literalName));
        this.startPositions.put(toPush, ctx.start.getStartIndex());
        this.endPositions.put(toPush, ctx.stop.getStopIndex() + 1);
        return toPush;
    }

    private Literal threeSegmentEnumLiteral(QueryParser.EnumOrClassifierLitContext ctx, String literalName) {
        String nsPrefix = ctx.getChild(0).getChild(0).getText();
        String enumName = ctx.getChild(0).getChild(2).getText();
        EEnumLiteral literal = this.environment.getEPackageProvider().getEnumLiteral(nsPrefix, enumName, literalName);
        Literal toPush = literal != null ? this.builder.enumLiteral(literal) : this.builder.errorTypeLiteral(nsPrefix, enumName, literalName);
        this.startPositions.put(toPush, ctx.start.getStartIndex());
        this.endPositions.put(toPush, ctx.stop.getStopIndex() + 1);
        return toPush;
    }

    public ANTLRErrorListener getErrorListener() {
        return this.errorListener;
    }

    @Override
    public void exitNullLit(QueryParser.NullLitContext ctx) {
        NullLiteral nullLiteral = this.builder.nullLiteral();
        this.startPositions.put(nullLiteral, ctx.start.getStartIndex());
        this.endPositions.put(nullLiteral, ctx.stop.getStopIndex() + 1);
        this.push(nullLiteral);
    }

    @Override
    public void exitSetLit(QueryParser.SetLitContext ctx) {
        SetInExtensionLiteral setInExtension = this.builder.setInExtension(this.getExpressions(ctx));
        this.startPositions.put(setInExtension, ctx.start.getStartIndex());
        this.endPositions.put(setInExtension, ctx.stop.getStopIndex() + 1);
        this.push(setInExtension);
    }

    @Override
    public void exitExplicitSetLit(QueryParser.ExplicitSetLitContext ctx) {
        SetInExtensionLiteral setInExtension = this.builder.setInExtension(this.getExpressions(ctx));
        this.startPositions.put(setInExtension, ctx.start.getStartIndex());
        this.endPositions.put(setInExtension, ctx.stop.getStopIndex() + 1);
        this.push(setInExtension);
    }

    private List<Expression> getExpressions(QueryParser.LiteralContext ctx) {
        int nbExpressions = (ctx.getChild(1).getChildCount() + 1) / 2;
        Expression[] expressions = new Expression[nbExpressions];
        int i = nbExpressions - 1;
        while (i >= 0) {
            expressions[i] = this.pop();
            --i;
        }
        return Arrays.asList(expressions);
    }

    @Override
    public void exitSeqLit(QueryParser.SeqLitContext ctx) {
        SequenceInExtensionLiteral sequenceInExtension = this.builder.sequenceInExtension(this.getExpressions(ctx));
        this.startPositions.put(sequenceInExtension, ctx.start.getStartIndex());
        this.endPositions.put(sequenceInExtension, ctx.stop.getStopIndex() + 1);
        this.push(sequenceInExtension);
    }

    @Override
    public void exitExplicitSeqLit(QueryParser.ExplicitSeqLitContext ctx) {
        SequenceInExtensionLiteral sequenceInExtension = this.builder.sequenceInExtension(this.getExpressions(ctx));
        this.startPositions.put(sequenceInExtension, ctx.start.getStartIndex());
        this.endPositions.put(sequenceInExtension, ctx.stop.getStopIndex() + 1);
        this.push(sequenceInExtension);
    }

    @Override
    public void exitConditional(QueryParser.ConditionalContext ctx) {
        Expression falseBranch;
        Expression trueBranch;
        Expression predicate;
        int count = ctx.getChildCount();
        if (count <= 3) {
            predicate = this.pop();
            trueBranch = this.builder.errorExpression();
            falseBranch = this.builder.errorExpression();
        } else if (count <= 5) {
            trueBranch = this.pop();
            predicate = this.pop();
            falseBranch = this.builder.errorExpression();
        } else {
            falseBranch = this.pop();
            trueBranch = this.pop();
            predicate = this.pop();
        }
        this.push(this.builder.conditional(predicate, trueBranch, falseBranch));
    }

    @Override
    public void exitBinding(QueryParser.BindingContext ctx) {
        String variable = ctx.getChild(0).getText();
        Expression expression = this.pop();
        this.push(this.builder.binding(variable, expression));
    }

    @Override
    public void exitLetExpr(QueryParser.LetExprContext ctx) {
        Expression body = !(ctx.getChild(ctx.getChildCount() - 1) instanceof QueryParser.ExpressionContext) ? this.builder.errorExpression() : this.pop();
        int bindingNumber = 1 + (ctx.getChildCount() - 3) / 2;
        Binding[] bindings = new Binding[bindingNumber];
        int i = 0;
        while (i < bindingNumber) {
            bindings[i] = this.popBinding();
            ++i;
        }
        this.push(this.builder.let(body, bindings));
    }

    private final class QueryErrorListener
    extends BaseErrorListener {
        private QueryErrorListener() {
        }

        public void syntaxError(@NotNull Recognizer<?, ?> recognizer, @Nullable Object offendingSymbol, int line, int charPositionInLine, @NotNull String msg, @Nullable RecognitionException e) {
            if (e != null) {
                if (e.getCtx() instanceof QueryParser.IterationCallContext) {
                    this.iterationCallContextError(e);
                } else if (e.getCtx() instanceof QueryParser.TypeLiteralContext) {
                    this.typeLiteralContextError(offendingSymbol, e);
                } else if (e.getCtx() instanceof QueryParser.VariableDefinitionContext) {
                    this.variableDefinitionContextError(offendingSymbol, e);
                } else if (e.getCtx() instanceof QueryParser.CallExpContext) {
                    this.callExpContextError(offendingSymbol);
                } else if (e.getCtx() instanceof QueryParser.NavigationSegmentContext) {
                    this.navigationSegmentContextError(offendingSymbol);
                } else {
                    this.defaultError(offendingSymbol, e);
                }
            } else if (recognizer instanceof QueryParser) {
                this.noRecognitionException(recognizer, offendingSymbol);
            }
        }

        private void iterationCallContextError(RecognitionException e) {
            AstBuilderListener.this.errorRule = 1;
            ErrorExpression errorExpression = AstBuilderListener.this.builder.errorExpression();
            AstBuilderListener.this.pushError(errorExpression);
            Integer position = ((QueryParser.IterationCallContext)e.getCtx()).start.getStartIndex();
            AstBuilderListener.this.startPositions.put(errorExpression, position);
            AstBuilderListener.this.endPositions.put(errorExpression, position);
        }

        private void typeLiteralContextError(Object offendingSymbol, RecognitionException e) {
            Integer startPosition = ((QueryParser.TypeLiteralContext)e.getCtx()).start.getStartIndex();
            Integer endPosition = ((Token)offendingSymbol).getStopIndex() + 1;
            if (e.getCtx().getParent() instanceof QueryParser.VariableDefinitionContext) {
                AstBuilderListener.this.errorRule = 1;
                String variableName = e.getCtx().getParent().getChild(0).getText();
                ErrorTypeLiteral type = AstBuilderListener.this.builder.errorTypeLiteral(new String[0]);
                AstBuilderListener.this.startPositions.put(type, startPosition);
                AstBuilderListener.this.endPositions.put(type, endPosition);
                AstBuilderListener.this.errors.add(type);
                Expression variableExpression = AstBuilderListener.this.pop();
                VariableDeclaration variableDeclaration = AstBuilderListener.this.builder.variableDeclaration(variableName, type, variableExpression);
                AstBuilderListener.this.startPositions.put(variableDeclaration, startPosition);
                AstBuilderListener.this.endPositions.put(variableDeclaration, endPosition);
                AstBuilderListener.this.push(variableDeclaration);
                ErrorExpression errorExpression = AstBuilderListener.this.builder.errorExpression();
                AstBuilderListener.this.pushError(errorExpression);
                AstBuilderListener.this.startPositions.put(errorExpression, startPosition);
                AstBuilderListener.this.endPositions.put(errorExpression, endPosition);
            } else if (!(AstBuilderListener.this.stack.peek() instanceof TypeLiteral)) {
                AstBuilderListener.this.errorRule = 13;
                ErrorTypeLiteral errorTypeLiteral = AstBuilderListener.this.builder.errorTypeLiteral(new String[0]);
                AstBuilderListener.this.startPositions.put(errorTypeLiteral, startPosition);
                AstBuilderListener.this.endPositions.put(errorTypeLiteral, endPosition);
                AstBuilderListener.this.pushError(errorTypeLiteral);
            }
        }

        private void variableDefinitionContextError(Object offendingSymbol, RecognitionException e) {
            Integer startPosition = ((QueryParser.VariableDefinitionContext)e.getCtx()).start.getStartIndex();
            Integer endPosition = ((Token)offendingSymbol).getStopIndex() + 1;
            if (e.getCtx().getChildCount() > 0) {
                AstBuilderListener.this.errorRule = 1;
                String variableName = e.getCtx().getChild(0).getText();
                TypeLiteral type = AstBuilderListener.this.createModelType((QueryParser.ModelObjectTypeContext)e.getCtx().getChild(2));
                AstBuilderListener.this.endPositions.put(type, endPosition);
                Expression variableExpression = AstBuilderListener.this.pop();
                VariableDeclaration variableDeclaration = AstBuilderListener.this.builder.variableDeclaration(variableName, type, variableExpression);
                AstBuilderListener.this.startPositions.put(variableDeclaration, startPosition);
                AstBuilderListener.this.endPositions.put(variableDeclaration, endPosition);
                AstBuilderListener.this.push(variableDeclaration);
            } else {
                Expression variableExpression = AstBuilderListener.this.pop();
                AstBuilderListener.this.errorRule = 11;
                ErrorVariableDeclaration errorVariableDeclaration = AstBuilderListener.this.builder.errorVariableDeclaration(variableExpression);
                AstBuilderListener.this.startPositions.put(errorVariableDeclaration, startPosition);
                AstBuilderListener.this.endPositions.put(errorVariableDeclaration, endPosition);
                AstBuilderListener.this.pushError(errorVariableDeclaration);
            }
            ErrorExpression errorExpression = AstBuilderListener.this.builder.errorExpression();
            AstBuilderListener.this.startPositions.put(errorExpression, endPosition);
            AstBuilderListener.this.endPositions.put(errorExpression, endPosition);
            AstBuilderListener.this.pushError(errorExpression);
        }

        private void callExpContextError(Object offendingSymbol) {
            AstBuilderListener.this.errorRule = 6;
            Expression receiver = AstBuilderListener.this.pop();
            ErrorCollectionCall errorCollectionCall = AstBuilderListener.this.builder.errorCollectionCall(receiver);
            AstBuilderListener.this.startPositions.put(errorCollectionCall, (Integer)AstBuilderListener.this.startPositions.get(receiver));
            AstBuilderListener.this.endPositions.put(errorCollectionCall, ((Token)offendingSymbol).getStopIndex() + 1);
            AstBuilderListener.this.pushError(errorCollectionCall);
        }

        private void navigationSegmentContextError(Object offendingSymbol) {
            AstBuilderListener.this.errorRule = 6;
            Expression receiver = AstBuilderListener.this.pop();
            ErrorFeatureAccessOrCall errorFeatureAccessOrCall = AstBuilderListener.this.builder.errorFeatureAccessOrCall(receiver);
            AstBuilderListener.this.startPositions.put(errorFeatureAccessOrCall, (Integer)AstBuilderListener.this.startPositions.get(receiver));
            AstBuilderListener.this.endPositions.put(errorFeatureAccessOrCall, ((Token)offendingSymbol).getStopIndex() + 1);
            AstBuilderListener.this.pushError(errorFeatureAccessOrCall);
        }

        private void defaultError(Object offendingSymbol, RecognitionException e) {
            AstBuilderListener.this.errorRule = e.getCtx().getRuleIndex();
            switch (e.getCtx().getRuleIndex()) {
                case 1: {
                    ErrorExpression errorExpression = AstBuilderListener.this.builder.errorExpression();
                    Integer position = ((ParserRuleContext)e.getCtx()).start.getStartIndex();
                    AstBuilderListener.this.startPositions.put(errorExpression, position);
                    AstBuilderListener.this.endPositions.put(errorExpression, ((Token)offendingSymbol).getStopIndex() + 1);
                    AstBuilderListener.this.pushError(errorExpression);
                    break;
                }
            }
        }

        private void noRecognitionException(Recognizer<?, ?> recognizer, Object offendingSymbol) {
            QueryParser parser = (QueryParser)recognizer;
            if (parser.getContext() instanceof QueryParser.EnumOrClassifierLitContext) {
                Integer startPosition = ((QueryParser.EnumOrClassifierLitContext)parser.getContext()).start.getStartIndex();
                Integer endPosition = ((Token)offendingSymbol).getStopIndex() + 1;
                AstBuilderListener.this.errorRule = 13;
                ParseTree firstChild = parser.getContext().getChild(0);
                if (firstChild.getChildCount() == 1) {
                    ErrorTypeLiteral errorTypeLiteral = AstBuilderListener.this.builder.errorTypeLiteral(firstChild.getChild(0).getText());
                    AstBuilderListener.this.startPositions.put(errorTypeLiteral, startPosition);
                    AstBuilderListener.this.endPositions.put(errorTypeLiteral, endPosition);
                    AstBuilderListener.this.pushError(errorTypeLiteral);
                } else if (firstChild.getChildCount() == 3) {
                    ErrorTypeLiteral errorTypeLiteral = AstBuilderListener.this.builder.errorTypeLiteral(firstChild.getChild(0).getText(), firstChild.getChild(2).getText());
                    AstBuilderListener.this.startPositions.put(errorTypeLiteral, startPosition);
                    AstBuilderListener.this.endPositions.put(errorTypeLiteral, endPosition);
                    AstBuilderListener.this.pushError(errorTypeLiteral);
                } else {
                    throw new UnsupportedOperationException("there is no error then...");
                }
            }
        }
    }
}

