/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.compatibility.parser.ast.ocl.environment;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.common.utils.CompactHashSet;
import org.eclipse.acceleo.internal.parser.ast.ocl.environment.AcceleoEnvironment;
import org.eclipse.acceleo.internal.parser.ast.ocl.environment.AcceleoTypeResolver;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.AbstractTypeChecker;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.TypeChecker;
import org.eclipse.ocl.TypeResolver;
import org.eclipse.ocl.ecore.AnyType;
import org.eclipse.ocl.ecore.BagType;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.CollectionType;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.EcoreFactory;
import org.eclipse.ocl.ecore.OrderedSetType;
import org.eclipse.ocl.ecore.PrimitiveType;
import org.eclipse.ocl.ecore.SendSignalAction;
import org.eclipse.ocl.ecore.SequenceType;
import org.eclipse.ocl.ecore.SetType;
import org.eclipse.ocl.ecore.StringLiteralExp;
import org.eclipse.ocl.ecore.TypeExp;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.options.Option;
import org.eclipse.ocl.options.ParsingOptions;
import org.eclipse.ocl.types.OCLStandardLibrary;
import org.eclipse.ocl.types.TupleType;
import org.eclipse.ocl.types.TypeType;
import org.eclipse.ocl.utilities.PredefinedType;
import org.eclipse.ocl.utilities.TypedElement;
import org.eclipse.ocl.utilities.UMLReflection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoEnvironmentGalileo
extends AcceleoEnvironment {
    private static final Set<String> RELATIONAL_OPERATORS = new HashSet<String>();
    private AcceleoTypeChecker typeChecker;

    static {
        RELATIONAL_OPERATORS.add("<");
        RELATIONAL_OPERATORS.add("<=");
        RELATIONAL_OPERATORS.add(">");
        RELATIONAL_OPERATORS.add(">=");
    }

    public AcceleoEnvironmentGalileo(Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> parent) {
        super(parent);
        this.setOption(ParsingOptions.USE_BACKSLASH_ESCAPE_PROCESSING, Boolean.TRUE);
    }

    public AcceleoEnvironmentGalileo(Resource oclEnvironmentResource) {
        super(oclEnvironmentResource);
        this.setOption(ParsingOptions.USE_BACKSLASH_ESCAPE_PROCESSING, Boolean.TRUE);
    }

    public TypeChecker<EClassifier, EOperation, EStructuralFeature> createTypeChecker() {
        if (this.typeChecker == null) {
            this.typeChecker = new AcceleoTypeChecker((Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject>)this);
        }
        return this.typeChecker;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.typeChecker.dispose();
    }

    protected TypeResolver<EClassifier, EOperation, EStructuralFeature> createTypeResolver() {
        return new AcceleoTypeResolver(null);
    }

    protected TypeResolver<EClassifier, EOperation, EStructuralFeature> createTypeResolver(Resource resource) {
        return new AcceleoTypeResolver(this, resource);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AcceleoTypeChecker
    extends AbstractTypeChecker<EClassifier, EOperation, EStructuralFeature, EParameter> {
        private final Map<EClassifier, Set<EClassifier>> alteredTypes;
        private final Map<EOperationSignatureElement, EOperation> eOperationCache;
        private final Map<Long, EStructuralFeature> hierarchyFeatureCache;
        private final Map<EClassifier, Set<EClassifier>> subTypes;

        public AcceleoTypeChecker(Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> environment) {
            super(environment);
            this.alteredTypes = new HashMap<EClassifier, Set<EClassifier>>();
            this.eOperationCache = new HashMap<EOperationSignatureElement, EOperation>();
            this.hierarchyFeatureCache = new HashMap<Long, EStructuralFeature>();
            this.subTypes = new HashMap<EClassifier, Set<EClassifier>>();
        }

        public EClassifier commonSuperType(Object problemObject, EClassifier type1, EClassifier type2) {
            EClassifier oclType1 = null;
            EClassifier oclType2 = null;
            if (type1 != null) {
                oclType1 = (EClassifier)this.getEnvironment().getUMLReflection().getOCLType((Object)type1);
            }
            if (type2 != null) {
                oclType2 = (EClassifier)this.getEnvironment().getUMLReflection().getOCLType((Object)type2);
            }
            EClassifier commonSuperType = oclType1 == this.getEnvironment().getOCLStandardLibrary().getOclAny() ? oclType1 : (oclType2 == this.getEnvironment().getOCLStandardLibrary().getOclAny() ? oclType2 : (oclType1 instanceof org.eclipse.ocl.types.CollectionType && !(oclType2 instanceof org.eclipse.ocl.types.CollectionType) ? (EClassifier)this.getEnvironment().getOCLStandardLibrary().getOclAny() : (oclType2 instanceof org.eclipse.ocl.types.CollectionType && !(oclType1 instanceof org.eclipse.ocl.types.CollectionType) ? (EClassifier)this.getEnvironment().getOCLStandardLibrary().getOclAny() : (EClassifier)super.commonSuperType(problemObject, (Object)type1, (Object)type2))));
            return commonSuperType;
        }

        public boolean exactTypeMatch(EClassifier type1, EClassifier type2) {
            boolean match = false;
            Set<EClassifier> alteredType1 = this.alteredTypes.get(type1);
            Set<EClassifier> alteredType2 = this.alteredTypes.get(type2);
            if (alteredType1 != null) {
                for (EClassifier alteredType : alteredType1) {
                    if (alteredType != type2) continue;
                    match = true;
                    break;
                }
            }
            if (!match && alteredType2 != null) {
                for (EClassifier alteredType : alteredType2) {
                    if (alteredType != type1) continue;
                    match = true;
                    break;
                }
            }
            if (!match) {
                return super.exactTypeMatch((Object)type1, (Object)type2);
            }
            return true;
        }

        public EOperation findOperationMatching(EClassifier owner, String name, List<? extends TypedElement<EClassifier>> args) {
            EOperationSignatureElement operationSignatureElement = new EOperationSignatureElement(owner, name, args);
            EOperation operation = this.eOperationCache.get(operationSignatureElement);
            if (operation == null) {
                OCLStandardLibrary lib;
                List<Object> arguments = args;
                if (arguments == null) {
                    arguments = Collections.emptyList();
                }
                UMLReflection uml = this.getEnvironment().getUMLReflection();
                List<EOperation> operations = this.getOperations(owner, name);
                ArrayList<EOperation> matches = null;
                ArrayList<EOperation> perfectMatches = new ArrayList<EOperation>();
                for (EOperation oper : operations) {
                    if (!name.equals(uml.getName((Object)oper)) || !this.matchArgs(owner, uml.getParameters((Object)oper), arguments)) continue;
                    if (uml.getOwningClassifier((Object)oper) == owner) {
                        perfectMatches.add(oper);
                    }
                    if (matches == null) {
                        matches = new ArrayList<EOperation>(3);
                    }
                    matches.add(oper);
                }
                for (EOperation eOperation : perfectMatches) {
                    if (eOperation.getEAnnotation("MTL non-standard") == null) continue;
                    this.eOperationCache.put(operationSignatureElement, eOperation);
                    return eOperation;
                }
                if (perfectMatches.size() > 0) {
                    operation = (EOperation)perfectMatches.get(0);
                } else if (matches != null) {
                    if (matches.size() == 1) {
                        operation = (EOperation)matches.get(0);
                    } else if (!matches.isEmpty()) {
                        operation = (EOperation)this.mostSpecificRedefinition(matches, uml);
                    }
                }
                if (operation == null && (owner == (lib = this.getEnvironment().getOCLStandardLibrary()).getOclVoid() || owner == lib.getOclInvalid())) {
                    operation = this.findOperationForVoidOrInvalid(owner, name, arguments);
                }
                this.eOperationCache.put(operationSignatureElement, operation);
            }
            return operation;
        }

        public List<EOperation> getOperations(EClassifier owner) {
            ArrayList<EOperation> result = new ArrayList<EOperation>(super.getOperations((Object)owner));
            if (!(owner instanceof PrimitiveType)) {
                result.addAll(this.getUMLReflection().getOperations((Object)EcorePackage.eINSTANCE.getEObject()));
            }
            return result;
        }

        public int getRelationship(EClassifier type1, EClassifier type2) {
            int relationship;
            EClassifier oclType1 = null;
            EClassifier oclType2 = null;
            if (type1 != null) {
                oclType1 = (EClassifier)this.getEnvironment().getUMLReflection().getOCLType((Object)type1);
            }
            if (type2 != null) {
                oclType2 = (EClassifier)this.getEnvironment().getUMLReflection().getOCLType((Object)type2);
            }
            if ((relationship = oclType1 == oclType2 ? 1 : (oclType1 != null && AnyType.class.isAssignableFrom(oclType1.getClass()) ? 4 : (oclType2 != null && AnyType.class.isAssignableFrom(oclType2.getClass()) ? 2 : super.getRelationship((Object)type1, (Object)type2)))) == 8 && oclType1 != null && oclType2 != null) {
                URI uri1 = EcoreUtil.getURI((EObject)oclType1);
                URI uri2 = EcoreUtil.getURI((EObject)oclType2);
                if (uri1 != null && uri1.equals(uri2)) {
                    relationship = 1;
                }
            }
            return relationship;
        }

        public EClassifier getResultType(Object problemObject, EClassifier owner, EOperation operation, List<? extends TypedElement<EClassifier>> args) {
            EClassifier type = (EClassifier)super.getResultType(problemObject, (Object)owner, (Object)operation, args);
            if (operation.getEAnnotation("MTL non-standard") == null) {
                return type;
            }
            String operationName = operation.getName();
            if (args.size() > 0 && args.get(0) instanceof TypeExp) {
                boolean isParameterizedCollection = "eAllContents".equals(operationName);
                isParameterizedCollection = isParameterizedCollection || "eContents".equals(operationName);
                isParameterizedCollection = isParameterizedCollection || "filter".equals(operationName);
                isParameterizedCollection = isParameterizedCollection || "ancestors".equals(operationName);
                isParameterizedCollection = isParameterizedCollection || "siblings".equals(operationName);
                isParameterizedCollection = isParameterizedCollection || "eInverse".equals(operationName);
                isParameterizedCollection = isParameterizedCollection || "precedingSiblings".equals(operationName);
                boolean bl = isParameterizedCollection = isParameterizedCollection || "followingSiblings".equals(operationName);
                if (isParameterizedCollection) {
                    CollectionType alteredSequence = type instanceof SequenceType || type instanceof OrderedSetType || type instanceof BagType || type instanceof SetType ? (CollectionType)EcoreUtil.copy((EObject)type) : (owner instanceof CollectionType ? (CollectionType)EcoreUtil.copy((EObject)owner) : (CollectionType)EcoreUtil.copy((EObject)type));
                    alteredSequence.setElementType((Object)((EClassifier)((TypeExp)args.get(0)).getReferredType()));
                    CompactHashSet altered = this.alteredTypes.get(type);
                    if (altered == null) {
                        altered = new CompactHashSet();
                        this.alteredTypes.put(type, (Set<EClassifier>)altered);
                    }
                    altered.add((EClassifier)alteredSequence);
                    type = alteredSequence;
                } else if ("current".equals(operationName) || "eContainer".equals(operationName)) {
                    type = (EClassifier)((TypeExp)args.get(0)).getReferredType();
                }
            } else if (args.size() > 0 && args.get(0) instanceof StringLiteralExp && "eGet".equals(operationName)) {
                String featureName = ((StringLiteralExp)args.get(0)).getStringSymbol();
                EStructuralFeature feature = null;
                if (owner instanceof EClass) {
                    for (EStructuralFeature childFeature : ((EClass)owner).getEAllStructuralFeatures()) {
                        if (!childFeature.getName().equals(featureName)) continue;
                        feature = childFeature;
                        break;
                    }
                }
                if (feature == null) {
                    this.createSubTypesHierarchy(owner);
                    feature = this.findFeatureInSubTypesHierarchy(owner, featureName);
                }
                if (feature != null) {
                    type = this.inferTypeFromFeature(feature);
                    Long key = owner.hashCode() + featureName.hashCode();
                    if (!this.hierarchyFeatureCache.containsKey(key)) {
                        this.hierarchyFeatureCache.put(key, feature);
                    }
                }
            } else if ("reverse".equals(operationName)) {
                if (type instanceof SequenceType || type instanceof OrderedSetType) {
                    CollectionType alteredSequence = (CollectionType)EcoreUtil.copy((EObject)owner);
                    CompactHashSet altered = this.alteredTypes.get(type);
                    if (altered == null) {
                        altered = new CompactHashSet();
                        this.alteredTypes.put(type, (Set<EClassifier>)altered);
                    }
                    altered.add((EClassifier)alteredSequence);
                    type = alteredSequence;
                }
            } else if (args.size() > 0) {
                boolean shouldBeConsidered;
                boolean bl = shouldBeConsidered = "removeAll".equals(operationName) || "addAll".equals(operationName) || "drop".equals(operationName) || "dropRight".equals(operationName);
                if (shouldBeConsidered) {
                    CollectionType alteredSequence = (CollectionType)EcoreUtil.copy((EObject)owner);
                    CompactHashSet altered = this.alteredTypes.get(type);
                    if (altered == null) {
                        altered = new CompactHashSet();
                        this.alteredTypes.put(type, (Set<EClassifier>)altered);
                    }
                    altered.add((EClassifier)alteredSequence);
                    type = alteredSequence;
                }
            }
            return type;
        }

        protected void dispose() {
            for (Set<EClassifier> alteredTypesValuesSet : this.alteredTypes.values()) {
                alteredTypesValuesSet.clear();
            }
            for (Set<EClassifier> subTypesValuesSet : this.subTypes.values()) {
                subTypesValuesSet.clear();
            }
            this.alteredTypes.clear();
            this.subTypes.clear();
            this.hierarchyFeatureCache.clear();
        }

        protected EClassifier resolve(EClassifier type) {
            return (EClassifier)this.getEnvironment().getTypeResolver().resolve((Object)type);
        }

        protected org.eclipse.ocl.types.CollectionType<EClassifier, EOperation> resolveCollectionType(CollectionKind kind, EClassifier elementType) {
            return this.getEnvironment().getTypeResolver().resolveCollectionType(kind, (Object)elementType);
        }

        protected TupleType<EOperation, EStructuralFeature> resolveTupleType(EList<? extends TypedElement<EClassifier>> parts) {
            return this.getEnvironment().getTypeResolver().resolveTupleType(parts);
        }

        private void createSubTypesHierarchy(EClassifier classifier) {
            if (this.subTypes.get(classifier) == null) {
                CompactHashSet hierarchy = new CompactHashSet();
                ECrossReferenceAdapter referencer = this.getCrossReferencer((EObject)classifier);
                for (EStructuralFeature.Setting setting : referencer.getInverseReferences((EObject)classifier, false)) {
                    if (setting.getEStructuralFeature() != EcorePackage.eINSTANCE.getEClass_ESuperTypes()) continue;
                    EClassifier subType = (EClassifier)setting.getEObject();
                    hierarchy.add(subType);
                    this.createSubTypesHierarchy(subType);
                }
                this.subTypes.put(classifier, (Set<EClassifier>)hierarchy);
            }
        }

        private EStructuralFeature findFeatureInSubTypesHierarchy(EClassifier base, String featureName) {
            EStructuralFeature feature = null;
            for (EClassifier subType : this.subTypes.get(base)) {
                feature = this.findFeatureInType(subType, featureName);
                if (feature == null) {
                    feature = this.findFeatureInSubTypesHierarchy(subType, featureName);
                }
                if (feature != null) break;
            }
            return feature;
        }

        private EStructuralFeature findFeatureInType(EClassifier type, String featureName) {
            Long key = type.hashCode() + featureName.hashCode();
            if (this.hierarchyFeatureCache.containsKey(key)) {
                return this.hierarchyFeatureCache.get(key);
            }
            EStructuralFeature feature = null;
            for (EObject child : type.eContents()) {
                if (!(child instanceof EStructuralFeature) || !((EStructuralFeature)child).getName().equals(featureName)) continue;
                feature = (EStructuralFeature)child;
                this.hierarchyFeatureCache.put(key, feature);
                break;
            }
            return feature;
        }

        private EOperation findOperationForVoidOrInvalid(EClassifier owner, String name, List<? extends TypedElement<EClassifier>> args) {
            EClassifier argType;
            EOperation result = null;
            if (args.size() == 1 && (argType = (EClassifier)args.get(0).getType()) != owner) {
                result = this.findOperationMatching(argType, name, args);
            }
            return result;
        }

        private ECrossReferenceAdapter getCrossReferencer(EObject scope) {
            ECrossReferenceAdapter referencer = null;
            for (Adapter adapter : scope.eResource().eAdapters()) {
                if (!(adapter instanceof ECrossReferenceAdapter)) continue;
                referencer = (ECrossReferenceAdapter)adapter;
                break;
            }
            if (referencer == null) {
                referencer = new ECrossReferenceAdapter();
                scope.eResource().eAdapters().add((Object)referencer);
            }
            return referencer;
        }

        private EClassifier getImplicitRootClass() {
            EClassifier result = null;
            Object value = ParsingOptions.getValue((Environment)this.getEnvironment(), (Option)ParsingOptions.implicitRootClass((Environment)this.getEnvironment()));
            if (value instanceof EClassifier) {
                result = (EClassifier)value;
            }
            if (result != null && !this.getEnvironment().getUMLReflection().isClass((Object)result)) {
                result = null;
            }
            return result;
        }

        private List<EOperation> getOperations(EClassifier owner, String name) {
            List<EOperation> additionalOperations;
            List<EOperation> result;
            if (owner instanceof TypeType) {
                TypeType source = (TypeType)owner;
                return this.getTypeTypeOperations((TypeType<EClassifier, EOperation>)source, name);
            }
            if (owner instanceof PredefinedType) {
                PredefinedType source = (PredefinedType)owner;
                result = this.getPredefinedTypeOperations((PredefinedType<EOperation>)source, name);
            } else {
                EClassifier oclTypeOwner = (EClassifier)this.getUMLReflection().asOCLType((Object)owner);
                if (oclTypeOwner instanceof PredefinedType) {
                    PredefinedType source = (PredefinedType)oclTypeOwner;
                    result = this.getPredefinedTypeOperations((PredefinedType<EOperation>)source, name);
                } else {
                    result = this.getUserTypeOperations(oclTypeOwner, name);
                }
            }
            if (this.getEnvironment() instanceof AcceleoEnvironment) {
                additionalOperations = ((AcceleoEnvironment)this.getEnvironment()).getAdditionalOperations(owner, name);
                result.addAll(additionalOperations);
            } else {
                additionalOperations = this.getEnvironment().getAdditionalOperations((Object)owner);
                if (additionalOperations != null) {
                    for (EOperation candidate : additionalOperations) {
                        if (!name.equals(candidate.getName())) continue;
                        result.add(candidate);
                    }
                }
            }
            return result;
        }

        private List<EOperation> getPredefinedTypeOperations(PredefinedType<EOperation> owner, String name) {
            ArrayList<EOperation> result = new ArrayList<EOperation>();
            if (owner instanceof org.eclipse.ocl.types.AnyType && RELATIONAL_OPERATORS.contains(name)) {
                return result;
            }
            EList candidates = owner.oclOperations();
            for (EOperation candidate : candidates) {
                if (!name.equals(candidate.getName())) continue;
                result.add(candidate);
            }
            return result;
        }

        private List<EOperation> getTypeTypeOperations(TypeType<EClassifier, EOperation> owner, String name) {
            ArrayList<EOperation> result = new ArrayList<EOperation>();
            EList candidates = owner.oclOperations();
            for (EOperation candidate : candidates) {
                if (!name.equals(candidate.getName())) continue;
                result.add(candidate);
            }
            for (EOperation operation : this.getOperations((EClassifier)owner.getReferredType(), name)) {
                if (!this.getUMLReflection().isStatic((Object)operation)) continue;
                result.add(operation);
            }
            return result;
        }

        private List<EOperation> getUserTypeOperations(EClassifier owner, String name) {
            Iterable candidates;
            ArrayList<EOperation> result = new ArrayList<EOperation>();
            List userTypeCandidates = this.getUMLReflection().getOperations((Object)owner);
            List<EOperation> oclAnyCandidates = this.getOperations((EClassifier)AcceleoEnvironmentGalileo.this.getOCLStandardLibrary().getOclAny(), name);
            EClassifier implictBaseClassifier = this.getImplicitRootClass();
            if (implictBaseClassifier != null && implictBaseClassifier != owner) {
                List implicitRootCandidates = this.getUMLReflection().getOperations((Object)implictBaseClassifier);
                candidates = Iterables.concat((Iterable)userTypeCandidates, oclAnyCandidates, (Iterable)implicitRootCandidates);
            } else {
                candidates = Iterables.concat((Iterable)userTypeCandidates, oclAnyCandidates);
            }
            for (EOperation candidate : candidates) {
                if (!name.equals(candidate.getName())) continue;
                result.add(candidate);
            }
            return result;
        }

        private EClassifier inferTypeFromFeature(EStructuralFeature feature) {
            Object type = feature.getEType();
            if (feature.isMany()) {
                type = feature.isOrdered() && feature.isUnique() ? EcoreFactory.eINSTANCE.createOrderedSetType() : (feature.isOrdered() && !feature.isUnique() ? EcoreFactory.eINSTANCE.createSequenceType() : (!feature.isOrdered() && feature.isUnique() ? EcoreFactory.eINSTANCE.createSetType() : EcoreFactory.eINSTANCE.createBagType()));
                ((org.eclipse.ocl.types.CollectionType)type).setElementType((Object)feature.getEType());
            }
            return type;
        }

        private <F> F mostSpecificRedefinition(List<? extends F> features, UMLReflection<?, EClassifier, ?, ?, ?, ?, ?, ?, ?, ?> uml) {
            HashMap<EClassifier, F> redefinitions = new HashMap<EClassifier, F>();
            for (F next : features) {
                redefinitions.put((EClassifier)uml.getOwningClassifier(next), next);
            }
            ArrayList classifiers = new ArrayList(redefinitions.keySet());
            while (true) {
                for (EClassifier next : classifiers) {
                    if (classifiers.removeAll(uml.getAllSupertypes((Object)next))) continue;
                }
                break;
            }
            return (F)redefinitions.get(classifiers.get(0));
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class EOperationSignatureElement {
            private List<? extends TypedElement<EClassifier>> arguments;
            private EClassifier classifier;
            private String name;

            public EOperationSignatureElement(EClassifier classifier, String name, List<? extends TypedElement<EClassifier>> arguments) {
                this.classifier = classifier;
                this.name = name;
                this.arguments = arguments;
            }

            public boolean equals(Object arg0) {
                if (arg0 instanceof EOperationSignatureElement) {
                    EOperationSignatureElement operationSignatureElement = (EOperationSignatureElement)arg0;
                    boolean result = operationSignatureElement.getArguments().equals(this.arguments);
                    result = result && operationSignatureElement.getName().equals(this.name);
                    result = result && operationSignatureElement.getClassifier().equals(this.classifier);
                    return result;
                }
                return false;
            }

            public List<? extends TypedElement<EClassifier>> getArguments() {
                return this.arguments;
            }

            public EClassifier getClassifier() {
                return this.classifier;
            }

            public String getName() {
                return this.name;
            }

            public int hashCode() {
                int hashcode = this.name.hashCode() * 9;
                hashcode += this.classifier.hashCode() * 13;
                return hashcode += this.arguments.hashCode() * 17;
            }
        }
    }
}

