/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.ui.nat;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.model.ui.nat.TypeNode;
import org.eclipse.jface.viewers.ITreeContentProvider;

public abstract class TypeSelectionTreeContentProvider
implements ITreeContentProvider {
    protected TypeSelectionTreeContentProvider() {
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof TypeLibrary) {
            TypeLibrary typeLibrary = (TypeLibrary)inputElement;
            return this.createTree(typeLibrary).toArray();
        }
        return new Object[0];
    }

    protected abstract List<TypeNode> createTree(TypeLibrary var1);

    protected static void addPackageSubtree(TypeNode node, Collection<? extends TypeEntry> entries) {
        entries.stream().collect(Collectors.groupingBy(TypeEntry::getPackageName)).forEach((packageName, subEntries) -> {
            if (packageName.isEmpty()) {
                subEntries.stream().map(TypeNode::new).forEachOrdered(node::addChild);
            } else {
                TypeNode subNode = new TypeNode((String)packageName);
                subEntries.stream().map(TypeNode::new).forEachOrdered(subNode::addChild);
                node.addChild(subNode);
            }
        });
    }

    public String getTitle() {
        return "";
    }

    protected static void addPathSubtree(TypeNode node, Stream<? extends TypeEntry> entries) {
        TypeSelectionTreeContentProvider.addPathSubtree(node, entries, 1);
    }

    private static void addPathSubtree(TypeNode node, Stream<? extends TypeEntry> entries, int level) {
        entries.collect(Collectors.groupingBy(entry -> {
            IPath path = entry.getFile().getFullPath();
            return path.segmentCount() > level + 1 ? path.segment(level) : "";
        })).forEach((segment, subEntries) -> {
            if (segment.isEmpty()) {
                subEntries.stream().map(TypeNode::new).forEachOrdered(node::addChild);
            } else {
                TypeNode subNode = new TypeNode((String)segment);
                TypeSelectionTreeContentProvider.addPathSubtree(subNode, subEntries.stream(), level + 1);
                node.addChild(subNode);
            }
        });
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof TypeNode) {
            TypeNode typeNode = (TypeNode)parentElement;
            return typeNode.getChildren().toArray();
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element instanceof TypeNode) {
            TypeNode typeNode = (TypeNode)element;
            return typeNode.getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof TypeNode) {
            TypeNode typeNode = (TypeNode)element;
            return !typeNode.getChildren().isEmpty();
        }
        return false;
    }
}

