/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.ui.editors;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.model.ui.Messages;
import org.eclipse.fordiac.ide.model.ui.annotation.FordiacMarkerGraphicalAnnotationModel;
import org.eclipse.fordiac.ide.model.ui.annotation.GraphicalAnnotationModel;
import org.eclipse.fordiac.ide.model.ui.editors.AbstractLibraryElementProvider;
import org.eclipse.fordiac.ide.model.ui.validation.ValidationJob;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.part.FileEditorInput;

public class FileLibraryElementProvider
extends AbstractLibraryElementProvider<FileLibraryElementInfo> {
    private final LibraryElementSynchronizer resourceChangeListener = new LibraryElementSynchronizer();

    protected FileLibraryElementProvider() {
        this.resourceChangeListener.install();
    }

    @Override
    protected void doResetLibraryElement(FileLibraryElementInfo info, IProgressMonitor monitor) throws CoreException {
        this.fireLibraryElementStateChange(listener -> listener.elementContentAboutToBeReplaced((IEditorInput)info.getEditorInput()));
        info.getEditorInput().getFile().refreshLocal(2, monitor);
        info.setLibraryElement(FileLibraryElementProvider.copyLibraryElement(info.getEditorInput().getFile()));
        info.setSynchronizationStamp(info.getEditorInput().getFile().getModificationStamp());
        info.markSaveLocation();
        info.setDirty(false);
        info.getValidationJob().reload();
        this.fireLibraryElementStateChange(listener -> listener.elementContentReplaced((IEditorInput)info.getEditorInput()));
    }

    @Override
    protected void doSaveLibraryElement(FileLibraryElementInfo info, IProgressMonitor monitor) throws CoreException {
        info.getLibraryElement().getTypeEntry().save(info.getLibraryElement(), monitor);
        info.setSynchronizationStamp(info.getEditorInput().getFile().getModificationStamp());
        info.markSaveLocation();
        info.setDirty(false);
        info.getValidationJob().reset();
    }

    @Override
    protected void doSynchronize(FileLibraryElementInfo info, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        info.getEditorInput().getFile().refreshLocal(2, (IProgressMonitor)subMonitor.split(2));
        this.doResetLibraryElement(info, (IProgressMonitor)subMonitor.split(8));
    }

    @Override
    protected boolean doIsSynchronized(FileLibraryElementInfo info) {
        return info.getEditorInput().getFile().isSynchronized(0) && info.getSynchronizationStamp() == info.getEditorInput().getFile().getModificationStamp();
    }

    @Override
    protected long doGetModificationStamp(FileLibraryElementInfo info) {
        return info.getEditorInput().getFile().getModificationStamp();
    }

    @Override
    public boolean isReadOnly(IEditorInput input) {
        return false;
    }

    @Override
    public boolean isDeleted(IEditorInput input) {
        IFileEditorInput fileEditorInput;
        return input instanceof IFileEditorInput && !(fileEditorInput = (IFileEditorInput)input).getFile().exists();
    }

    @Override
    protected FileLibraryElementInfo createLibraryElementInfo(IEditorInput input) throws CoreException {
        if (input instanceof IFileEditorInput) {
            IFileEditorInput fileEditorInput = (IFileEditorInput)input;
            fileEditorInput.getFile().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            return new FileLibraryElementInfo(fileEditorInput, FileLibraryElementProvider.copyLibraryElement(fileEditorInput.getFile()));
        }
        return (FileLibraryElementInfo)super.createLibraryElementInfo(input);
    }

    protected void handleLibraryElementContentChanged(FileLibraryElementInfo info) {
        if (info.getSynchronizationStamp() == info.getEditorInput().getFile().getModificationStamp() || info.isDirty()) {
            return;
        }
        try {
            this.doResetLibraryElement(info, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            FordiacLogHelper.logWarning((String)"Error refreshing changed library element", (Exception)((Object)e));
        }
    }

    protected void handleLibraryElementMoved(FileLibraryElementInfo info, IFileEditorInput movedInput) {
        this.fireLibraryElementStateChange(listener -> listener.elementMoved((IEditorInput)info.getEditorInput(), (IEditorInput)movedInput));
    }

    protected void handleLibraryElementDeleted(FileLibraryElementInfo info) {
        this.fireLibraryElementStateChange(listener -> listener.elementDeleted((IEditorInput)info.getEditorInput()));
    }

    protected static LibraryElement copyLibraryElement(IFile file) throws CoreException {
        TypeEntry entry = TypeLibraryManager.INSTANCE.getTypeEntryForFile(file);
        if (entry == null) {
            throw new CoreException(Status.error((String)MessageFormat.format(Messages.FileLibraryElementProvider_LibraryElementDoesNotExist, file.getFullPath())));
        }
        LibraryElement libraryElement = entry.copyType();
        if (libraryElement == null) {
            throw new CoreException(Status.error((String)MessageFormat.format(Messages.FileLibraryElementProvider_LibraryElementCannotBeLoaded, file.getFullPath())));
        }
        return libraryElement;
    }

    @Override
    protected WorkspaceModifyOperation wrapOperation(final FileLibraryElementInfo info, final AbstractLibraryElementProvider.LibraryElementProviderOperation<FileLibraryElementInfo> operation) {
        return new WorkspaceModifyOperation((ISchedulingRule)info.getEditorInput().getFile().getParent()){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                operation.run(info, monitor);
            }
        };
    }

    protected class FileLibraryElementInfo
    extends AbstractLibraryElementProvider.LibraryElementInfo {
        private final GraphicalAnnotationModel annotationModel;
        private final ValidationJob validationJob;
        private boolean readOnly;

        protected FileLibraryElementInfo(IFileEditorInput input, LibraryElement libraryElement) {
            super((IEditorInput)input, libraryElement);
            this.setSynchronizationStamp(input.getFile().getModificationStamp());
            this.annotationModel = new FordiacMarkerGraphicalAnnotationModel((IResource)input.getFile(), this::getLibraryElement);
            this.validationJob = new ValidationJob(PackageNameHelper.getFullTypeName((LibraryElement)libraryElement), this::getUndoContext, this.annotationModel);
        }

        protected boolean isReadOnly() {
            return this.readOnly;
        }

        protected void setReadOnly(boolean readOnly) {
            this.readOnly = readOnly;
        }

        @Override
        protected GraphicalAnnotationModel getAnnotationModel() {
            return this.annotationModel;
        }

        protected ValidationJob getValidationJob() {
            return this.validationJob;
        }

        protected IFileEditorInput getEditorInput() {
            return (IFileEditorInput)super.getEditorInput();
        }

        @Override
        protected void dispose() {
            this.validationJob.dispose();
            this.annotationModel.dispose();
            super.dispose();
        }
    }

    protected class LibraryElementSynchronizer
    implements IResourceChangeListener,
    IResourceDeltaVisitor {
        protected LibraryElementSynchronizer() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                if (delta != null) {
                    delta.accept((IResourceDeltaVisitor)this);
                }
            }
            catch (CoreException e) {
                FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
            }
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            switch (delta.getKind()) {
                case 4: {
                    this.handleResourceChanged(delta);
                    break;
                }
                case 2: {
                    this.handleResourceRemoved(delta);
                    break;
                }
            }
            return true;
        }

        protected void handleResourceChanged(IResourceDelta delta) {
            IFile file;
            FileLibraryElementInfo info;
            IResource iResource = delta.getResource();
            if (iResource instanceof IFile && (info = (FileLibraryElementInfo)FileLibraryElementProvider.this.getLibraryElementInfo((IEditorInput)new FileEditorInput(file = (IFile)iResource))) != null && (0x100 & delta.getFlags()) != 0) {
                Display.getDefault().asyncExec(() -> FileLibraryElementProvider.this.handleLibraryElementContentChanged(info));
            }
        }

        protected void handleResourceRemoved(IResourceDelta delta) {
            IFile file;
            FileLibraryElementInfo info;
            IResource iResource = delta.getResource();
            if (iResource instanceof IFile && (info = (FileLibraryElementInfo)FileLibraryElementProvider.this.getLibraryElementInfo((IEditorInput)new FileEditorInput(file = (IFile)iResource))) != null) {
                if ((0x2000 & delta.getFlags()) != 0) {
                    IFile newFile = file.getWorkspace().getRoot().getFile(delta.getMovedToPath());
                    Display.getDefault().asyncExec(() -> FileLibraryElementProvider.this.handleLibraryElementMoved(info, (IFileEditorInput)new FileEditorInput(newFile)));
                } else {
                    Display.getDefault().asyncExec(() -> FileLibraryElementProvider.this.handleLibraryElementDeleted(info));
                }
            }
        }

        public void install() {
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        }

        public void uninstall() {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        }
    }
}

