/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.debug.replaydebugging.simulator.interpreter;

import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.debug.replaydebugging.trace.SendOutputEvent;
import org.eclipse.fordiac.ide.debug.replaydebugging.core.Utils;
import org.eclipse.fordiac.ide.fb.interpreter.api.EventManagerFactory;
import org.eclipse.fordiac.ide.fb.interpreter.mm.EventManagerProcessor;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;

public class ResourceSimulator {
    private final Resource resource;
    private final List<SendOutputEvent> externalEvents;
    private int externalEventCounter = 0;
    private final EventManagerProcessor eventManagerProcessor;

    public ResourceSimulator(Resource resource, List<SendOutputEvent> externalEvents) {
        this.resource = resource;
        this.externalEvents = externalEvents;
        this.eventManagerProcessor = new EventManagerProcessor(EventManagerFactory.createFrom(List.of()), resource.getFBNetwork());
    }

    public List<Event> getLastOutputEvents() {
        return this.eventManagerProcessor.getLastOutputEvents();
    }

    public Optional<Event> reproduceNextEvent() {
        if (this.externalEvents.size() <= this.externalEventCounter) {
            return this.eventManagerProcessor.processOne(OptionalLong.empty());
        }
        SendOutputEvent externalEvent = this.externalEvents.get(this.externalEventCounter);
        int eventCounter = externalEvent.eventCounter();
        if (this.eventManagerProcessor.getEventCounter() < eventCounter) {
            return this.eventManagerProcessor.processOne(OptionalLong.empty());
        }
        ++this.externalEventCounter;
        FB instanceFB = Utils.getInstanceFB(this.resource, externalEvent.instanceName());
        if (instanceFB == null) {
            return Optional.empty();
        }
        Event event = (Event)instanceFB.getInterface().getEventOutputs().get(externalEvent.eventId());
        List<String> outputValues = externalEvent.outputs();
        EList fbDataOutput = instanceFB.getInterface().getOutputVars();
        HashMap<String, String> dataOutputValues = new HashMap<String, String>();
        int i = 0;
        while (i < fbDataOutput.size()) {
            dataOutputValues.put(((VarDeclaration)fbDataOutput.get(i)).getName(), outputValues.get(i));
            ++i;
        }
        this.eventManagerProcessor.injectOutputEvent(instanceFB, event, dataOutputValues);
        return this.eventManagerProcessor.processOne(OptionalLong.empty());
    }
}

