/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group.command;

import org.eclipse.nebula.widgets.nattable.command.AbstractRowCommand;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;

public class ViewportSelectRowGroupCommand
extends AbstractRowCommand {
    private int originRowPosition;
    private final int rowSpan;
    private final boolean withShiftMask;
    private final boolean withControlMask;

    public ViewportSelectRowGroupCommand(ILayer layer, int rowPosition, int originRowPosition, int rowSpan, boolean withShiftMask, boolean withControlMask) {
        super(layer, rowPosition);
        this.originRowPosition = originRowPosition;
        this.rowSpan = rowSpan;
        this.withShiftMask = withShiftMask;
        this.withControlMask = withControlMask;
    }

    protected ViewportSelectRowGroupCommand(ViewportSelectRowGroupCommand command) {
        super(command);
        this.originRowPosition = command.originRowPosition;
        this.rowSpan = command.rowSpan;
        this.withShiftMask = command.withShiftMask;
        this.withControlMask = command.withControlMask;
    }

    @Override
    public boolean convertToTargetLayer(ILayer targetLayer) {
        int prev = this.getRowPosition();
        if (super.convertToTargetLayer(targetLayer)) {
            this.originRowPosition -= prev - this.getRowPosition();
            return true;
        }
        return false;
    }

    public int getOriginRowPosition() {
        return this.originRowPosition;
    }

    public int getRowSpan() {
        return this.rowSpan;
    }

    public boolean isWithShiftMask() {
        return this.withShiftMask;
    }

    public boolean isWithControlMask() {
        return this.withControlMask;
    }

    @Override
    public ViewportSelectRowGroupCommand cloneCommand() {
        return new ViewportSelectRowGroupCommand(this);
    }
}

