/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.datachange;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.nebula.widgets.nattable.datachange.CellKeyHandler;
import org.eclipse.nebula.widgets.nattable.datachange.DataChangeLayer;
import org.eclipse.nebula.widgets.nattable.datachange.PersistenceUpdateDataChange;
import org.eclipse.nebula.widgets.nattable.datachange.UpdateDataChange;
import org.eclipse.nebula.widgets.nattable.datachange.UpdateDataChangeHandler;
import org.eclipse.nebula.widgets.nattable.edit.event.DataUpdateEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEventHandler;

public class PersistenceUpdateDataChangeHandler
extends UpdateDataChangeHandler<PersistenceUpdateDataChange>
implements ILayerEventHandler<DataUpdateEvent> {
    public PersistenceUpdateDataChangeHandler(DataChangeLayer layer, CellKeyHandler<?> keyHandler) {
        super(layer, keyHandler, new ConcurrentHashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleLayerEvent(DataUpdateEvent event) {
        Object key;
        if (this.handleDataUpdate && (key = this.keyHandler.getKey(event.getColumnPosition(), event.getRowPosition())) != null) {
            Map map = this.dataChanges;
            synchronized (map) {
                this.layer.addDataChange(new PersistenceUpdateDataChange(key, event.getOldValue(), this.keyHandler));
                UpdateDataChange stored = (UpdateDataChange)this.dataChanges.get(key);
                if (stored == null) {
                    this.changedColumns.add(event.getColumnPosition());
                    this.changedRows.add(event.getRowPosition());
                    this.dataChanges.put(key, new PersistenceUpdateDataChange(key, event.getOldValue(), this.keyHandler));
                } else if (stored.getValue() != null && stored.getValue().equals(event.getNewValue()) || stored.getValue() == null && event.getNewValue() == null) {
                    this.dataChanges.remove(key);
                    this.rebuildPositionCollections();
                }
            }
        }
    }

    @Override
    public Class<DataUpdateEvent> getLayerEventClass() {
        return DataUpdateEvent.class;
    }
}

