/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.grid.internal.win7;

import org.eclipse.nebula.widgets.grid.internal.win7.Win7PaletteProvider;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class Win7ColumnHeaderUtil {
    public static void drawColumn(GC graphics, Rectangle bounds, Win7PaletteProvider palette, boolean hover, boolean selected, boolean mousedown) {
        if (mousedown) {
            Win7ColumnHeaderUtil.drawColumnHeader(graphics, bounds, palette.getPalette((Display)graphics.getDevice(), Win7PaletteProvider.MOUSEDOWN_GRID_COLUMN_HEADER));
            Win7ColumnHeaderUtil.drawColumnSelectedTopShadow(graphics, bounds, palette.getPalette((Display)graphics.getDevice(), Win7PaletteProvider.SHADOW_GRID_COLUMN_HEADER));
        } else if (hover) {
            Win7ColumnHeaderUtil.drawColumnHeader(graphics, bounds, palette.getPalette((Display)graphics.getDevice(), Win7PaletteProvider.HOVER_GRID_COLUMN_HEADER));
        } else if (selected) {
            Win7ColumnHeaderUtil.drawColumnHeader(graphics, bounds, palette.getPalette((Display)graphics.getDevice(), Win7PaletteProvider.SELECTED_GRID_COLUMN_HEADER));
        } else {
            Win7ColumnHeaderUtil.drawColumnHeader(graphics, bounds, palette.getPalette((Display)graphics.getDevice(), Win7PaletteProvider.NORMAL_GRID_COLUMN_HEADER));
        }
    }

    protected static void drawColumnSelectedTopShadow(GC graphics, Rectangle bounds, Win7PaletteProvider.Palette palette) {
        int x = bounds.x;
        int y = bounds.y;
        graphics.setForeground(palette.getColors()[0]);
        graphics.drawLine(x + 1, y, x + bounds.width - 2, y);
        graphics.setForeground(palette.getColors()[1]);
        graphics.drawLine(x + 1, y + 1, x + bounds.width - 2, y + 1);
    }

    protected static void drawColumnHeader(GC graphics, Rectangle bounds, Win7PaletteProvider.Palette palette) {
        int x = bounds.x;
        int y = bounds.y;
        int topRectHeight = (int)Math.round((double)(bounds.height - 3) * 0.45);
        int bottomRectHeight = bounds.height - 3 - topRectHeight;
        int bottomRectY = y + topRectHeight + 1;
        graphics.setBackground(palette.getColors()[1]);
        graphics.fillRectangle(x, y, 1, topRectHeight + 1);
        graphics.setBackground(palette.getColors()[2]);
        graphics.fillRectangle(x + 1, y, bounds.width - 3, topRectHeight + 1);
        graphics.setBackground(palette.getColors()[3]);
        graphics.fillRectangle(x + bounds.width - 2, y, 1, topRectHeight + 1);
        graphics.setBackground(palette.getColors()[5]);
        if (palette.getColors()[4] != null) {
            graphics.setForeground(palette.getColors()[4]);
            graphics.fillGradientRectangle(x + bounds.width - 1, y, 1, topRectHeight + 1, true);
        } else {
            graphics.fillRectangle(x + bounds.width - 1, y, 1, topRectHeight + 1);
        }
        graphics.setBackground(palette.getColors()[7]);
        if (palette.getColors()[6] != null) {
            graphics.setForeground(palette.getColors()[6]);
            graphics.fillGradientRectangle(x, bottomRectY, 1, bottomRectHeight, true);
        } else {
            graphics.fillRectangle(x, bottomRectY, 1, bottomRectHeight);
        }
        graphics.setBackground(palette.getColors()[9]);
        if (palette.getColors()[8] != null) {
            graphics.setForeground(palette.getColors()[8]);
            graphics.fillGradientRectangle(x + 1, bottomRectY, bounds.width - 3, bottomRectHeight, true);
        } else {
            graphics.fillRectangle(x + 1, bottomRectY, bounds.width - 3, bottomRectHeight);
        }
        graphics.setBackground(palette.getColors()[11]);
        if (palette.getColors()[10] != null) {
            graphics.setForeground(palette.getColors()[10]);
            graphics.fillGradientRectangle(x + bounds.width - 2, bottomRectY, 1, bottomRectHeight, true);
        } else {
            graphics.fillRectangle(x + bounds.width - 2, bottomRectY, 1, bottomRectHeight);
        }
        graphics.setBackground(palette.getColors()[13]);
        if (palette.getColors()[12] != null) {
            graphics.setForeground(palette.getColors()[12]);
            graphics.fillGradientRectangle(x + bounds.width - 1, bottomRectY, 1, bottomRectHeight, true);
        } else {
            graphics.fillRectangle(x + bounds.width - 1, bottomRectY, 1, bottomRectHeight);
        }
        graphics.setForeground(palette.getColors()[14]);
        graphics.drawLine(x, y + bounds.height - 2, x + bounds.width - 1, y + bounds.height - 2);
        graphics.setForeground(palette.getColors()[15]);
        graphics.drawLine(x, y + bounds.height - 1, x + bounds.width - 1, y + bounds.height - 1);
    }
}

