/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.AbstractStructTree;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;

public abstract class AbstractStructTreeNode {
    private VarDeclaration variable;
    private final String pinName;
    private final List<AbstractStructTreeNode> children;
    private AbstractStructTreeNode parent;
    private AbstractStructTree<? extends AbstractStructTreeNode> tree;

    protected AbstractStructTreeNode(VarDeclaration variable, AbstractStructTreeNode parent, AbstractStructTree<? extends AbstractStructTreeNode> tree) {
        this.variable = variable;
        this.parent = parent;
        this.pinName = this.getFullPinName();
        this.children = new ArrayList<AbstractStructTreeNode>();
        this.tree = tree;
    }

    protected AbstractStructTreeNode() {
        this.variable = null;
        this.parent = null;
        this.pinName = null;
        this.children = new ArrayList<AbstractStructTreeNode>();
        this.tree = null;
    }

    protected static String getVariableName(VarDeclaration variable) {
        return variable == null ? "" : variable.getName();
    }

    public Object[] getChildrenAsArray() {
        return this.children.toArray();
    }

    public VarDeclaration getVariable() {
        return this.variable;
    }

    public AbstractStructTreeNode getParent() {
        return this.parent;
    }

    public String getParentVarName() {
        return this.parent.pinName;
    }

    public String getPinName() {
        return this.pinName;
    }

    public AbstractStructTree<? extends AbstractStructTreeNode> getTree() {
        return this.tree;
    }

    public void setVariable(VarDeclaration variable) {
        this.variable = variable;
    }

    public void setParent(AbstractStructTreeNode parent) {
        this.parent = parent;
    }

    protected void setTree(AbstractStructTree<? extends AbstractStructTreeNode> tree) {
        this.tree = tree;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public List<AbstractStructTreeNode> getChildren() {
        return this.children;
    }

    private String getFullPinName() {
        if (this.parent == null || this.parent.pinName == null) {
            return AbstractStructTreeNode.getVariableName(this.variable);
        }
        return this.parent.pinName + "." + AbstractStructTreeNode.getVariableName(this.variable);
    }

    public abstract AbstractStructTreeNode addChild(EObject var1);
}

