/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.ui.actions;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.CFBInstance;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Group;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.Segment;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.SystemConfiguration;
import org.eclipse.fordiac.ide.model.ui.Messages;
import org.eclipse.fordiac.ide.model.ui.actions.OpenListenerManager;
import org.eclipse.fordiac.ide.model.ui.editors.HandlerHelper;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class Open4DIACElementAction
extends BaseSelectionListenerAction {
    public static final String ID = "org.eclipse.fordiac.ide.model.ui.OpenAction";

    public Open4DIACElementAction(IWorkbenchPart part) {
        super(Messages.OpenEditorAction_text);
        this.setId(ID);
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return false;
        }
        Object model = Open4DIACElementAction.convertFromEditPart(this.getStructuredSelection().getFirstElement());
        this.customizeOpenMenu(model);
        return model instanceof Device || model instanceof SystemConfiguration || model instanceof Application || model instanceof SubApp || model instanceof CFBInstance || model instanceof Resource;
    }

    private void customizeOpenMenu(Object model) {
        if (Open4DIACElementAction.isTypedSubAppOrCFBInstance(model)) {
            this.setText(Messages.OpenEditorAction_viewertext);
        } else {
            this.setText(Messages.OpenEditorAction_text);
        }
    }

    public void run() {
        Object selected = Open4DIACElementAction.convertFromEditPart(this.getStructuredSelection().getFirstElement());
        Object refObject = null;
        if (selected instanceof FBNetworkElement) {
            FBNetworkElement fbnElement = (FBNetworkElement)selected;
            if (!Open4DIACElementAction.isTypedComposite(selected)) {
                if (selected instanceof FB || selected instanceof Group) {
                    refObject = selected;
                    selected = fbnElement.eContainer().eContainer();
                } else if (Open4DIACElementAction.isExpandedSubapp(selected)) {
                    refObject = selected;
                }
                while (Open4DIACElementAction.isExpandedSubapp(selected)) {
                    selected = ((SubApp)selected).eContainer().eContainer();
                }
            }
        } else if (selected instanceof Device) {
            Device device = (Device)selected;
            refObject = selected;
            selected = device.getSystemConfiguration();
        } else if (selected instanceof Segment) {
            Segment segment = (Segment)selected;
            refObject = selected;
            selected = segment.eContainer();
        }
        IEditorPart editor = OpenListenerManager.openEditor((EObject)selected);
        if (Open4DIACElementAction.isExpandedSubapp(refObject) && editor != null) {
            HandlerHelper.showExpandedSubapp((SubApp)refObject, editor);
        } else {
            HandlerHelper.selectElement(refObject, editor);
        }
    }

    private static boolean isExpandedSubapp(Object selected) {
        SubApp subapp;
        return selected instanceof SubApp && (subapp = (SubApp)selected).isUnfolded();
    }

    private static boolean isTypedSubAppOrCFBInstance(Object obj) {
        if (obj instanceof SubApp) {
            SubApp subApp = (SubApp)obj;
            return subApp.isTyped() || subApp.isContainedInTypedInstance();
        }
        if (obj instanceof FB) {
            return Open4DIACElementAction.isTypedComposite(obj);
        }
        return false;
    }

    private static boolean isTypedComposite(Object obj) {
        return obj instanceof CFBInstance;
    }

    private static Object convertFromEditPart(Object model) {
        Object object;
        if (model instanceof EditPart) {
            EditPart ep = (EditPart)model;
            object = ep.getModel();
        } else {
            object = model;
        }
        return object;
    }
}

