/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.change;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.commands.ScopedCommand;
import org.eclipse.fordiac.ide.model.commands.create.AbstractConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteConnectionCommand;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.gef.commands.Command;

public abstract class AbstractReconnectConnectionCommand
extends Command
implements ScopedCommand {
    private FBNetwork parent;
    private final Connection connection;
    private final boolean isSourceReconnect;
    private final IInterfaceElement newTarget;
    private DeleteConnectionCommand deleteConnectionCmd;
    private AbstractConnectionCreateCommand connectionCreateCmd;

    protected AbstractReconnectConnectionCommand(String label, Connection connection, boolean isSourceReconnect, IInterfaceElement newTarget, FBNetwork parent) {
        super(label);
        this.connection = Objects.requireNonNull(connection);
        this.isSourceReconnect = isSourceReconnect;
        this.newTarget = newTarget;
        this.parent = parent;
    }

    public FBNetwork getParent() {
        return this.parent;
    }

    public void setParent(FBNetwork parent) {
        this.parent = parent;
    }

    public boolean canExecute() {
        IInterfaceElement sourceIE = this.getNewSource();
        IInterfaceElement targetIE = this.getNewDestination();
        if (sourceIE != null && targetIE != null) {
            return this.checkSourceAndTarget(sourceIE, targetIE);
        }
        return false;
    }

    public IInterfaceElement getNewSource() {
        if (!this.isSourceReconnect) {
            return this.getConnnection().getSource();
        }
        return this.newTarget;
    }

    public IInterfaceElement getNewDestination() {
        if (this.isSourceReconnect) {
            return this.getConnnection().getDestination();
        }
        return this.newTarget;
    }

    protected Connection getConnnection() {
        return this.connection;
    }

    public boolean canRedo() {
        return true;
    }

    public void execute() {
        Connection con = this.getConnnection();
        this.deleteConnectionCmd = new DeleteConnectionCommand(con);
        this.connectionCreateCmd = this.createConnectionCreateCommand(this.parent);
        this.connectionCreateCmd.setSource(this.getNewSource());
        this.connectionCreateCmd.setDestination(this.getNewDestination());
        this.connectionCreateCmd.setArrangementConstraints(con.getRoutingData());
        this.connectionCreateCmd.setVisible(con.isVisible());
        this.connectionCreateCmd.setElementIndex(this.parent.getConnectionIndex(con));
        this.connectionCreateCmd.execute();
        this.deleteConnectionCmd.execute();
        AbstractReconnectConnectionCommand.copyAttributes(this.connectionCreateCmd.getConnection(), this.deleteConnectionCmd.getConnection());
    }

    public void redo() {
        this.connectionCreateCmd.redo();
        this.deleteConnectionCmd.redo();
    }

    public void undo() {
        this.deleteConnectionCmd.undo();
        this.connectionCreateCmd.undo();
    }

    private static void copyAttributes(Connection dstCon, Connection srcCon) {
        srcCon.getAttributes().forEach(attr -> dstCon.setAttribute(attr.getName(), attr.getType(), attr.getValue(), attr.getComment()));
    }

    @Override
    public Set<EObject> getAffectedObjects() {
        Set result = Stream.of(this.parent, this.connection).filter(Objects::nonNull).collect(Collectors.toCollection(HashSet::new));
        if (this.connectionCreateCmd != null) {
            result.addAll(this.connectionCreateCmd.getAffectedObjects());
        }
        if (this.deleteConnectionCmd != null) {
            result.addAll(this.deleteConnectionCmd.getAffectedObjects());
        }
        return Set.copyOf(result);
    }

    protected abstract AbstractConnectionCreateCommand createConnectionCreateCommand(FBNetwork var1);

    protected abstract boolean checkSourceAndTarget(IInterfaceElement var1, IInterfaceElement var2);
}

