/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.NameQualifiedType;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.WildcardType;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.jdt.ui.JavaElementLabels;

public class ASTResolving
extends org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving {
    public static String getMethodSignature(IMethodBinding binding) {
        return BindingLabelProvider.getBindingLabel((IBinding)binding, BindingLabelProvider.DEFAULT_TEXTFLAGS);
    }

    public static String getMethodSignature(String name, ITypeBinding[] params, boolean isVarArgs) {
        StringBuffer buf = new StringBuffer();
        buf.append(name).append('(');
        int i = 0;
        while (i < params.length) {
            if (i > 0) {
                buf.append(JavaElementLabels.COMMA_STRING);
            }
            if (isVarArgs && i == params.length - 1) {
                buf.append(ASTResolving.getTypeSignature(params[i].getElementType()));
                buf.append("...");
            } else {
                buf.append(ASTResolving.getTypeSignature(params[i]));
            }
            ++i;
        }
        buf.append(')');
        return BasicElementLabels.getJavaElementName((String)buf.toString());
    }

    public static int getPossibleTypeKinds(ASTNode node, boolean is50OrHigher) {
        int kinds = ASTResolving.internalGetPossibleTypeKinds(node);
        if (!is50OrHigher) {
            kinds &= 6;
        }
        return kinds;
    }

    public static String getTypeSignature(ITypeBinding type) {
        return BindingLabelProvider.getBindingLabel((IBinding)type, BindingLabelProvider.DEFAULT_TEXTFLAGS);
    }

    public static Type guessTypeForReference(AST ast, ASTNode node) {
        ASTNode parent = node.getParent();
        while (parent != null) {
            switch (parent.getNodeType()) {
                case 59: {
                    if (((VariableDeclarationFragment)parent).getInitializer() == node) {
                        return ASTNodeFactory.newType(ast, (VariableDeclaration)parent);
                    }
                    return null;
                }
                case 44: {
                    if (((VariableDeclarationFragment)parent).getInitializer() == node) {
                        return ASTNodeFactory.newType(ast, (VariableDeclaration)parent);
                    }
                    return null;
                }
                case 2: {
                    Type type;
                    if (!((ArrayAccess)parent).getIndex().equals((Object)node) && (type = ASTResolving.guessTypeForReference(ast, parent)) != null) {
                        return ASTNodeFactory.newArrayType(type);
                    }
                    return null;
                }
                case 22: {
                    if (node.equals((Object)((FieldAccess)parent).getName())) {
                        node = parent;
                        parent = parent.getParent();
                        break;
                    }
                    return null;
                }
                case 36: 
                case 47: {
                    node = parent;
                    parent = parent.getParent();
                    break;
                }
                case 40: {
                    if (node.equals((Object)((QualifiedName)parent).getName())) {
                        node = parent;
                        parent = parent.getParent();
                        break;
                    }
                    return null;
                }
                default: {
                    return null;
                }
            }
        }
        return null;
    }

    private static int internalGetPossibleTypeKinds(ASTNode node) {
        int kind = 126;
        int mask = 254;
        ASTNode parent = node.getParent();
        while (parent instanceof QualifiedName) {
            if (node.getLocationInParent() == QualifiedName.QUALIFIER_PROPERTY) {
                return 30;
            }
            node = parent;
            parent = parent.getParent();
            mask = 30;
        }
        while (parent instanceof Type) {
            if (parent instanceof QualifiedType) {
                if (node.getLocationInParent() == QualifiedType.QUALIFIER_PROPERTY) {
                    return mask & 0x1E;
                }
                mask &= 0x1E;
            } else if (parent instanceof NameQualifiedType) {
                if (node.getLocationInParent() == NameQualifiedType.QUALIFIER_PROPERTY) {
                    return mask & 0x1E;
                }
                mask &= 0x1E;
            } else if (parent instanceof ParameterizedType) {
                if (node.getLocationInParent() == ParameterizedType.TYPE_ARGUMENTS_PROPERTY) {
                    return mask & 0x3E;
                }
                mask &= 6;
            } else if (parent instanceof WildcardType && node.getLocationInParent() == WildcardType.BOUND_PROPERTY) {
                return mask & 0x3E;
            }
            node = parent;
            parent = parent.getParent();
        }
        if (parent != null) {
            switch (parent.getNodeType()) {
                case 55: {
                    if (node.getLocationInParent() == TypeDeclaration.SUPER_INTERFACE_TYPES_PROPERTY) {
                        kind = 4;
                        break;
                    }
                    if (node.getLocationInParent() != TypeDeclaration.SUPERCLASS_TYPE_PROPERTY) break;
                    kind = 2;
                    break;
                }
                case 71: {
                    kind = 4;
                    break;
                }
                case 31: {
                    if (node.getLocationInParent() == MethodDeclaration.THROWN_EXCEPTION_TYPES_PROPERTY) {
                        kind = 2;
                        break;
                    }
                    if (node.getLocationInParent() != MethodDeclaration.RETURN_TYPE2_PROPERTY) break;
                    kind = 254;
                    break;
                }
                case 82: {
                    kind = 88;
                    break;
                }
                case 62: {
                    kind = 30;
                    break;
                }
                case 53: {
                    kind = 2;
                    break;
                }
                case 14: {
                    if (((ClassInstanceCreation)parent).getAnonymousClassDeclaration() == null) {
                        kind = 2;
                        break;
                    }
                    kind = 6;
                    break;
                }
                case 44: {
                    int superParent = parent.getParent().getNodeType();
                    if (superParent == 12) {
                        kind = 2;
                        break;
                    }
                    if (superParent != 70) break;
                    kind = 30;
                    break;
                }
                case 65: {
                    kind = 30;
                    break;
                }
                case 77: 
                case 78: 
                case 79: {
                    kind = 8;
                    break;
                }
                case 73: {
                    if (((TypeParameter)parent).typeBounds().indexOf(node) > 0) {
                        kind = 4;
                        break;
                    }
                    kind = 62;
                    break;
                }
                case 57: {
                    kind = 30;
                }
            }
        }
        return kind & mask;
    }
}

