/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.util.comm.datatypes;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.fordiac.ide.util.Activator;
import org.eclipse.fordiac.ide.util.comm.datatypes.IEC_ANY;
import org.eclipse.fordiac.ide.util.comm.datatypes.IEC_LINT;

public class IEC_UDINT
extends IEC_LINT {
    protected static final long BOUNDS_MASK = -4294967296L;

    public IEC_UDINT() {
    }

    public IEC_UDINT(long initial) {
        super(initial);
    }

    public IEC_UDINT(DataInputStream in) {
        super(in);
    }

    @Override
    public void decodeValueFrom(DataInputStream in) {
        try {
            int firstByte = 0xFF & in.readByte();
            int secondByte = 0xFF & in.readByte();
            int thirdByte = 0xFF & in.readByte();
            int fourthByte = 0xFF & in.readByte();
            this.value = (long)(firstByte << 24 | secondByte << 16 | thirdByte << 8 | fourthByte) & 0xFFFFFFFFL;
        }
        catch (IOException e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
    }

    @Override
    public byte[] encodeTag() {
        byte[] retval = new byte[]{72};
        return retval;
    }

    @Override
    public byte[] encodeValue() {
        ByteArrayOutputStream myOut = new ByteArrayOutputStream();
        DataOutputStream DOS = new DataOutputStream(myOut);
        try {
            int tempByte = (int)(this.value & 0xFFL);
            DOS.writeByte(tempByte);
            tempByte = (int)((this.value & 0xFF00L) >> 8);
            DOS.writeByte(tempByte);
            tempByte = (int)((this.value & 0xFF0000L) >> 16);
            DOS.writeByte(tempByte);
            tempByte = (int)((this.value & 0xFF000000L) >> 24);
            DOS.writeByte(tempByte);
        }
        catch (IOException e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
        return myOut.toByteArray();
    }

    @Override
    public boolean setValue(IEC_ANY source) {
        boolean retval = false;
        if (source.getClass().equals(this.getClass())) {
            this.value = ((IEC_UDINT)source).getValue();
            retval = true;
        }
        return retval;
    }
}

