/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.util.comm.datatypes;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.fordiac.ide.util.Activator;
import org.eclipse.fordiac.ide.util.comm.datatypes.IEC_ANY;
import org.eclipse.fordiac.ide.util.comm.datatypes.IEC_REAL;
import org.eclipse.fordiac.ide.util.comm.exceptions.DataTypeValueOutOfBoundsException;

public class IEC_LREAL
extends IEC_REAL {
    protected static final long BOUNDS_MASK_32bit = -4294967296L;
    protected double value;

    public IEC_LREAL() {
        this.value = 0.0;
    }

    public IEC_LREAL(double initial) {
        this.value = initial;
    }

    public IEC_LREAL(DataInputStream in) {
        super(in);
    }

    public void setValue(double value) {
        this.value = value;
    }

    @Override
    public float getValue() {
        if (((long)((int)this.value) & 0xFFFFFFFF00000000L) == 0L) {
            return super.getValue();
        }
        throw new DataTypeValueOutOfBoundsException("Value out of range. Use getDoubleValue() instead.");
    }

    public double getDoubleValue() {
        return this.value;
    }

    @Override
    public void decodeValueFrom(DataInputStream in) {
        try {
            this.value = in.readDouble();
        }
        catch (IOException e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
    }

    @Override
    public byte[] encodeTag() {
        byte[] retval = new byte[]{75};
        return retval;
    }

    @Override
    public byte[] encodeValue() {
        ByteArrayOutputStream myOut = new ByteArrayOutputStream();
        DataOutputStream DOS = new DataOutputStream(myOut);
        try {
            DOS.writeDouble(this.value);
        }
        catch (IOException e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
        return myOut.toByteArray();
    }

    @Override
    public String toString() {
        return Double.toString(this.value);
    }

    @Override
    public boolean setValue(IEC_ANY source) {
        boolean retval = false;
        if (source.getClass().equals(this.getClass())) {
            this.value = ((IEC_LREAL)source).getValue();
            retval = true;
        }
        return retval;
    }

    @Override
    public boolean setValue(String source) {
        try {
            this.value = Double.parseDouble(source);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

