/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.util.comm.datatypes;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.fordiac.ide.util.Activator;
import org.eclipse.fordiac.ide.util.comm.datatypes.IEC_ANY;
import org.eclipse.fordiac.ide.util.comm.datatypes.IEC_INT;
import org.eclipse.fordiac.ide.util.comm.datatypes.IEC_LINT;
import org.eclipse.fordiac.ide.util.comm.exceptions.DataTypeValueOutOfBoundsException;

public class IEC_DINT
extends IEC_ANY {
    protected static final int BOUNDS_MASK = 0;
    protected int value;

    public IEC_DINT() {
        this.value = 0;
    }

    public IEC_DINT(int initial) {
        this.value = this.verifyValue(initial);
    }

    public IEC_DINT(DataInputStream in) {
        super(in);
    }

    @Override
    public void decodeValueFrom(DataInputStream in) {
        try {
            this.value = in.readInt();
        }
        catch (IOException e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
    }

    @Override
    public byte[] encodeTag() {
        byte[] retval = new byte[]{68};
        return retval;
    }

    @Override
    public byte[] encodeValue() {
        ByteArrayOutputStream myOut = new ByteArrayOutputStream();
        DataOutputStream DOS = new DataOutputStream(myOut);
        try {
            DOS.writeInt(this.value);
        }
        catch (IOException e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
        return myOut.toByteArray();
    }

    public boolean equals(Object data) {
        if (data instanceof IEC_INT) {
            return ((IEC_INT)data).value == this.value;
        }
        if (data instanceof IEC_LINT) {
            return ((IEC_LINT)data).value == (long)this.value;
        }
        return false;
    }

    public int hashCode() {
        return this.value;
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = this.verifyValue(value);
    }

    protected int verifyValue(int val) {
        if (!false) {
            return val;
        }
        throw new DataTypeValueOutOfBoundsException("Data type value out of bounds.");
    }

    @Override
    public boolean setValue(IEC_ANY source) {
        boolean retval = false;
        if (source.getClass().equals(this.getClass())) {
            this.value = ((IEC_DINT)source).getValue();
            retval = true;
        }
        return retval;
    }

    @Override
    public boolean setValue(String source) {
        try {
            this.value = this.verifyValue(Integer.parseInt(source));
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

