/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.util.comm.datatypes;

import java.io.DataInputStream;
import org.eclipse.fordiac.ide.util.comm.datatypes.IEC_ANY;

public class IEC_BOOL
extends IEC_ANY {
    public boolean value;

    public IEC_BOOL(int ASN1typeID) {
        switch (ASN1typeID) {
            case 0: {
                this.value = false;
                break;
            }
            case 1: {
                this.value = true;
                break;
            }
            default: {
                this.value = false;
            }
        }
    }

    public IEC_BOOL(boolean value) {
        this.value = value;
    }

    public IEC_BOOL() {
        this.value = false;
    }

    @Override
    public void decodeValueFrom(DataInputStream in) {
    }

    @Override
    public byte[] encode() {
        return this.encodeTag();
    }

    @Override
    public byte[] encodeTag() {
        byte[] retval = new byte[]{this.value ? (byte)65 : 64};
        return retval;
    }

    @Override
    public byte[] encodeValue() {
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IEC_BOOL) {
            return ((IEC_BOOL)obj).value == this.value;
        }
        return false;
    }

    public int hashCode() {
        return Boolean.valueOf(this.value).hashCode();
    }

    public String toString() {
        return Boolean.toString(this.value);
    }

    @Override
    public boolean setValue(IEC_ANY source) {
        boolean retval = false;
        if (source.getClass().equals(this.getClass())) {
            this.value = ((IEC_BOOL)source).value;
            retval = true;
        }
        return retval;
    }

    @Override
    public boolean setValue(String source) {
        this.value = Boolean.parseBoolean(source);
        return true;
    }
}

