/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemmanagement.ui.actions;

import org.eclipse.core.resources.IProject;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.CloseResourceAction;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;

public class CloseSystemActionProvider
extends CommonActionProvider {
    private CloseResourceAction closeProjectAction;

    public void init(ICommonActionExtensionSite aSite) {
        super.init(aSite);
        IShellProvider sp = new IShellProvider(){

            public Shell getShell() {
                return CloseSystemActionProvider.this.getActionSite().getViewSite().getShell();
            }
        };
        this.closeProjectAction = new CloseResourceAction(sp);
    }

    public void fillActionBars(IActionBars actionBars) {
        actionBars.setGlobalActionHandler(IDEActionFactory.CLOSE_PROJECT.getId(), (IAction)this.closeProjectAction);
        this.updateActionBars();
    }

    public void fillContextMenu(IMenuManager menu) {
        IProject project = this.getSelectedProject();
        if (project != null) {
            this.closeProjectAction.selectionChanged((IStructuredSelection)new StructuredSelection((Object)project));
            menu.appendToGroup("group.build", (IAction)this.closeProjectAction);
        }
    }

    public void updateActionBars() {
        IProject project = this.getSelectedProject();
        if (project != null) {
            this.closeProjectAction.selectionChanged((IStructuredSelection)new StructuredSelection((Object)project));
        }
    }

    private IProject getSelectedProject() {
        IProject project = null;
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        if (selection.getFirstElement() instanceof AutomationSystem) {
            project = ((AutomationSystem)selection.getFirstElement()).getProject();
        }
        return project;
    }
}

