/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemconfiguration.policies;

import org.eclipse.fordiac.ide.systemconfiguration.commands.LinkCreateCommand;
import org.eclipse.fordiac.ide.systemconfiguration.editparts.DeviceEditPart;
import org.eclipse.fordiac.ide.systemconfiguration.editparts.SegmentEditPart;
import org.eclipse.fordiac.ide.systemconfiguration.editparts.SystemNetworkEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.ReconnectRequest;

public class SegmentNodeEditPolicy
extends GraphicalNodeEditPolicy {
    protected Command getConnectionCompleteCommand(CreateConnectionRequest request) {
        if (request.getStartCommand() instanceof LinkCreateCommand) {
            LinkCreateCommand command = (LinkCreateCommand)request.getStartCommand();
            if (command.isSegmentDeviceLink()) {
                if (this.getHost() instanceof DeviceEditPart) {
                    command.setDestination(((DeviceEditPart)this.getHost()).getModel());
                } else if (this.getHost() instanceof SegmentEditPart) {
                    command.setDestination(null);
                }
            } else if (this.getHost() instanceof SegmentEditPart) {
                command.setSource(((SegmentEditPart)this.getHost()).getModel());
            } else if (this.getHost() instanceof DeviceEditPart) {
                command.setSource(null);
            }
            return command;
        }
        return null;
    }

    protected Command getConnectionCreateCommand(CreateConnectionRequest request) {
        LinkCreateCommand cmd = new LinkCreateCommand();
        if (this.getHost() instanceof SegmentEditPart) {
            cmd.setSource(((SegmentEditPart)this.getHost()).getModel());
            cmd.setSegmentDeviceLink(true);
        } else if (this.getHost() instanceof DeviceEditPart) {
            cmd.setDestination(((DeviceEditPart)this.getHost()).getModel());
        }
        EditPart parent = this.getHost().getParent();
        if (parent instanceof SystemNetworkEditPart) {
            SystemNetworkEditPart systemNetworkEditPart = (SystemNetworkEditPart)parent;
            cmd.setSystemConfigurationNetwork(systemNetworkEditPart.getModel());
        }
        request.setStartCommand((Command)cmd);
        return cmd;
    }

    protected Command getReconnectTargetCommand(ReconnectRequest request) {
        return null;
    }

    protected Command getReconnectSourceCommand(ReconnectRequest request) {
        return null;
    }
}

