/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemconfiguration.editor;

import org.eclipse.fordiac.ide.gef.utilities.TemplateCreationFactory;
import org.eclipse.fordiac.ide.model.Palette.DeviceTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.ResourceTypeEntry;
import org.eclipse.fordiac.ide.model.Palette.SegmentTypePaletteEntry;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.dnd.TemplateTransfer;
import org.eclipse.gef.dnd.TemplateTransferDropTargetListener;
import org.eclipse.gef.requests.CreationFactory;

public class SysConfTemplateTransferDropTargetListener
extends TemplateTransferDropTargetListener {
    AutomationSystem system;

    public SysConfTemplateTransferDropTargetListener(EditPartViewer viewer, AutomationSystem system) {
        super(viewer);
        this.system = system;
    }

    protected void handleDragOver() {
        super.handleDragOver();
        this.getCurrentEvent().feedback = 24;
        if (TemplateTransfer.getInstance().getTemplate() == null) {
            this.getCurrentEvent().detail = 0;
            this.getCurrentEvent().operations = 0;
        } else if (TemplateTransfer.getInstance().getTemplate() instanceof PaletteEntry) {
            PaletteEntry entry = (PaletteEntry)TemplateTransfer.getInstance().getTemplate();
            AutomationSystem paletteSystem = entry.getGroup().getPallete().getAutomationSystem();
            if (this.isSysConfEditorType(TemplateTransfer.getInstance().getTemplate()) && paletteSystem != null && paletteSystem.equals(this.system)) {
                this.getCurrentEvent().detail = 1;
            } else {
                this.getCurrentEvent().detail = 0;
                this.getCurrentEvent().operations = 0;
            }
        }
    }

    protected void handleDrop() {
        System.out.println("Handle drop: " + this.getCurrentEvent().data.getClass().getName());
        if (!this.isSysConfEditorType(this.getCurrentEvent().data) && !(this.getCurrentEvent().data instanceof TemplateCreationFactory)) {
            return;
        }
        super.handleDrop();
        TemplateTransfer.getInstance().setTemplate(null);
    }

    protected CreationFactory getFactory(Object template) {
        this.getCurrentEvent().detail = 1;
        if (this.isSysConfEditorType(template)) {
            return new SysConfTemplateCreationFactory(template);
        }
        if (template instanceof TemplateCreationFactory) {
            return super.getFactory(template);
        }
        System.out.println("Type not in list: " + template.getClass().getName());
        return null;
    }

    private boolean isSysConfEditorType(Object template) {
        return template instanceof DeviceTypePaletteEntry || template instanceof ResourceTypeEntry || template instanceof SegmentTypePaletteEntry;
    }

    private class SysConfTemplateCreationFactory
    implements CreationFactory {
        private final Object typeTemplate;

        public SysConfTemplateCreationFactory(Object typeTemplate) {
            this.typeTemplate = typeTemplate;
        }

        public Object getNewObject() {
            return null;
        }

        public Object getObjectType() {
            return this.typeTemplate;
        }
    }
}

