/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.runtime.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.fordiac.ide.runtime.Activator;
import org.eclipse.fordiac.ide.runtime.IRuntimeLauncher;
import org.eclipse.fordiac.ide.runtime.LaunchParameter;
import org.eclipse.fordiac.ide.runtime.LaunchRuntimeException;
import org.eclipse.fordiac.ide.runtime.views.RuntimeModifyListener;
import org.eclipse.fordiac.ide.runtime.views.RuntimeSelectionListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public class RuntimeLauncherView
extends ViewPart {
    private static final String VALUES = "values";
    private IMemento memento;
    private final List<IRuntimeLauncher> launchers = new ArrayList<IRuntimeLauncher>();
    private final Map<String, Combo> comboTable = new HashMap<String, Combo>();

    public void createPartControl(Composite parent) {
        GridLayout parentLayout = new GridLayout(3, false);
        parent.setLayout((Layout)parentLayout);
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elems = registry.getConfigurationElementsFor("org.eclipse.fordiac.ide.runtime", "RuntimeLauncher");
        Arrays.sort(elems, new Comparator<IConfigurationElement>(){

            @Override
            public int compare(IConfigurationElement element1, IConfigurationElement element2) {
                String order1 = element1.getAttribute("order");
                String order2 = element2.getAttribute("order");
                if (order1 == null) {
                    return order2 == null ? 0 : 1;
                }
                if (order2 == null) {
                    return -1;
                }
                return order1.compareTo(order2);
            }
        });
        int i = 0;
        while (i < elems.length) {
            IConfigurationElement element = elems[i];
            try {
                Object object = element.createExecutableExtension("class");
                if (object instanceof IRuntimeLauncher) {
                    IRuntimeLauncher launcher = (IRuntimeLauncher)object;
                    this.launchers.add(launcher);
                    Group launcherGroup = new Group(parent, 0);
                    launcherGroup.setText(launcher.getName());
                    launcherGroup.setLayout((Layout)new GridLayout(3, false));
                    GridData launcherGroupData = new GridData();
                    launcherGroupData.horizontalAlignment = 4;
                    launcherGroupData.grabExcessHorizontalSpace = true;
                    launcherGroupData.horizontalSpan = 3;
                    launcherGroup.setLayoutData((Object)launcherGroupData);
                    List<LaunchParameter> params = launcher.getParams();
                    boolean firstButton = true;
                    int j = 0;
                    while (j < launcher.getNumParameters()) {
                        Label paramName = new Label((Composite)launcherGroup, 64);
                        paramName.setText(params.get(j).getName());
                        int style = 2048;
                        if (params.get(j).isFixedValues()) {
                            style |= 8;
                        }
                        Combo paramValue = new Combo((Composite)launcherGroup, style);
                        if (params.get(j).isFixedValues()) {
                            int k = 0;
                            while (k < params.get(j).getValues().length) {
                                String deviceString = params.get(j).getValues()[k];
                                paramValue.add(deviceString);
                                ++k;
                            }
                        } else {
                            paramValue.add(params.get(j).getValue());
                        }
                        GridData textAreaData = new GridData();
                        textAreaData.horizontalAlignment = 4;
                        textAreaData.grabExcessHorizontalSpace = true;
                        paramValue.setLayoutData((Object)textAreaData);
                        paramValue.addModifyListener((ModifyListener)new RuntimeModifyListener(launcher, paramName.getText()){

                            @Override
                            public void modifyText(ModifyEvent e) {
                                this.launcher.setParam(this.name, ((Combo)e.getSource()).getText());
                            }
                        });
                        this.comboTable.put(String.valueOf(launcher.getName()) + "." + paramName.getText(), paramValue);
                        if (firstButton) {
                            Button launchButton = new Button((Composite)launcherGroup, 64);
                            launchButton.setText("Launch " + launcher.getName());
                            GridData launchButtonData = new GridData();
                            launchButtonData.verticalSpan = launcher.getNumParameters();
                            launchButtonData.verticalAlignment = 4;
                            launchButtonData.horizontalAlignment = 4;
                            launchButton.setLayoutData((Object)launchButtonData);
                            launchButton.addSelectionListener((SelectionListener)new RuntimeSelectionListener(launcher){

                                @Override
                                public void widgetSelected(SelectionEvent e) {
                                    try {
                                        this.launcher.launch();
                                        RuntimeLauncherView.this.getViewSite().getActionBars().getStatusLineManager().setErrorMessage(null);
                                        for (LaunchParameter param : this.launcher.getParams()) {
                                            if (Arrays.asList(((Combo)RuntimeLauncherView.this.comboTable.get(String.valueOf(this.launcher.getName()) + "." + param.getName())).getItems()).contains(((Combo)RuntimeLauncherView.this.comboTable.get(String.valueOf(this.launcher.getName()) + "." + param.getName())).getText())) continue;
                                            ((Combo)RuntimeLauncherView.this.comboTable.get(String.valueOf(this.launcher.getName()) + "." + param.getName())).add(((Combo)RuntimeLauncherView.this.comboTable.get(String.valueOf(this.launcher.getName()) + "." + param.getName())).getText(), 0);
                                        }
                                    }
                                    catch (LaunchRuntimeException e1) {
                                        Activator.getDefault().logError(e1.getMessage(), e1);
                                        RuntimeLauncherView.this.getViewSite().getActionBars().getStatusLineManager().setErrorMessage(e1.getMessage());
                                    }
                                }

                                @Override
                                public void widgetDefaultSelected(SelectionEvent e) {
                                }
                            });
                            firstButton = false;
                        }
                        ++j;
                    }
                }
            }
            catch (CoreException corex) {
                Activator.getDefault().logError("Error loading Export Filter", (Exception)((Object)corex));
            }
            ++i;
        }
        this.initFields();
    }

    public void setFocus() {
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.memento = memento;
    }

    private void initFields() {
        if (this.memento != null) {
            IMemento[] values = this.memento.getChildren(VALUES);
            for (IRuntimeLauncher launcher : this.launchers) {
                for (LaunchParameter param : launcher.getParams()) {
                    if (!param.isFixedValues()) {
                        this.configureDynamicParam(values, launcher, param);
                    }
                    this.comboTable.get(String.valueOf(launcher.getName()) + "." + param.getName()).select(0);
                }
            }
        }
    }

    private void configureDynamicParam(IMemento[] values, IRuntimeLauncher launcher, LaunchParameter param) {
        int i = 0;
        while (i < values.length) {
            String text;
            IMemento mem = values[i];
            if (mem.getID().equals(String.valueOf(launcher.getName()) + "." + param.getName()) && (text = mem.getTextData()) != null) {
                text = text.substring(1, text.length() - 1);
                String[] data = text.split(",");
                int j = 0;
                while (j < data.length) {
                    String temp = data[j].trim();
                    if (!Arrays.asList(this.comboTable.get(String.valueOf(launcher.getName()) + "." + param.getName()).getItems()).contains(temp)) {
                        this.comboTable.get(String.valueOf(launcher.getName()) + "." + param.getName()).add(temp);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public void saveState(IMemento memento) {
        for (IRuntimeLauncher launcher : this.launchers) {
            for (LaunchParameter param : launcher.getParams()) {
                if (param.isFixedValues()) continue;
                IMemento mem = memento.createChild(VALUES, String.valueOf(launcher.getName()) + "." + param.getName());
                mem.putTextData(Arrays.deepToString(this.comboTable.get(String.valueOf(launcher.getName()) + "." + param.getName()).getItems()));
            }
        }
    }
}

