/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.monitoring;

import java.util.ArrayList;
import org.eclipse.fordiac.ide.application.editparts.FBEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.network.viewer.CompositeNetworkViewerEditPart;
import org.eclipse.fordiac.ide.gef.editparts.InterfaceEditPart;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.monitoring.MonitoringFactory;
import org.eclipse.fordiac.ide.model.monitoring.PortElement;

public class MonitoringManagerUtils {
    private MonitoringManagerUtils() {
        throw new AssertionError();
    }

    public static boolean canBeMonitored(InterfaceEditPart editPart) {
        PortElement port = MonitoringManagerUtils.createPortElement(editPart);
        return port != null && port.getPortString() != null;
    }

    public static boolean canBeMonitored(FBEditPart obj) {
        for (Object child : obj.getChildren()) {
            if (!(child instanceof InterfaceEditPart)) continue;
            return MonitoringManagerUtils.canBeMonitored((InterfaceEditPart)child);
        }
        return false;
    }

    public static PortElement createPortElement(InterfaceEditPart editPart) {
        if (editPart.getParent() instanceof FBEditPart && editPart.getParent().getParent() instanceof CompositeNetworkViewerEditPart) {
            return MonitoringManagerUtils.createCompositeInternalPortString(editPart);
        }
        FBNetworkElement obj = editPart.getModel().getFBNetworkElement();
        if (obj instanceof FB) {
            FB fb = (FB)obj;
            return MonitoringManagerUtils.createPortElement(fb, editPart);
        }
        return null;
    }

    private static PortElement createPortElement(FB fb, InterfaceEditPart ep) {
        Resource res = MonitoringManagerUtils.findResourceForFB(fb);
        if (res == null) {
            return null;
        }
        Device dev = (Device)res.eContainer();
        if (dev == null) {
            return null;
        }
        AutomationSystem system = dev.getAutomationSystem();
        PortElement p = ep.getModel() instanceof AdapterDeclaration ? MonitoringFactory.eINSTANCE.createAdapterPortElement() : MonitoringFactory.eINSTANCE.createPortElement();
        p.setSystem(system);
        p.setDevice(dev);
        p.setResource(res);
        p.setFb(fb);
        p.setInterfaceElement(ep.getModel());
        return p;
    }

    private static PortElement createCompositeInternalPortString(InterfaceEditPart editPart) {
        FBEditPart fbep = (FBEditPart)editPart.getParent();
        CompositeNetworkViewerEditPart cnep = (CompositeNetworkViewerEditPart)editPart.getParent().getParent();
        ArrayList<CompositeNetworkViewerEditPart> parents = new ArrayList<CompositeNetworkViewerEditPart>();
        CompositeNetworkViewerEditPart root = cnep;
        parents.add(0, root);
        while (root.getparentInstanceViewerEditPart() != null) {
            parents.add(0, root.getparentInstanceViewerEditPart());
            root = root.getparentInstanceViewerEditPart();
        }
        FB fb = root.getFbInstance();
        PortElement pe = MonitoringManagerUtils.createPortElement(fb, editPart);
        if (pe != null) {
            pe.setFb(fbep.getModel());
            for (CompositeNetworkViewerEditPart compositeNetworkEditPart : parents) {
                pe.getHierarchy().add((Object)compositeNetworkEditPart.getFbInstance().getName());
            }
            return pe;
        }
        return null;
    }

    private static Resource findResourceForFB(FB fb) {
        return fb.getResource();
    }
}

