/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataimport;

import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.Activator;
import org.eclipse.fordiac.ide.model.Palette.DeviceTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.Palette;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.ResourceTypeEntry;
import org.eclipse.fordiac.ide.model.Palette.SegmentTypePaletteEntry;
import org.eclipse.fordiac.ide.model.dataimport.CommonElementImporter;
import org.eclipse.fordiac.ide.model.dataimport.ImportUtils;
import org.eclipse.fordiac.ide.model.dataimport.ResDevFBNetworkImporter;
import org.eclipse.fordiac.ide.model.dataimport.SubAppNetworkImporter;
import org.eclipse.fordiac.ide.model.dataimport.exceptions.TypeImportException;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.Color;
import org.eclipse.fordiac.ide.model.libraryElement.ColorizableElement;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableObject;
import org.eclipse.fordiac.ide.model.libraryElement.DataConnection;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.EventConnection;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.IVarElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Link;
import org.eclipse.fordiac.ide.model.libraryElement.Mapping;
import org.eclipse.fordiac.ide.model.libraryElement.PositionableElement;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.ResourceType;
import org.eclipse.fordiac.ide.model.libraryElement.ResourceTypeFB;
import org.eclipse.fordiac.ide.model.libraryElement.Segment;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.SystemConfiguration;
import org.eclipse.fordiac.ide.model.libraryElement.TypedConfigureableObject;
import org.eclipse.fordiac.ide.model.libraryElement.Value;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SystemImporter {
    Palette palette = null;
    AutomationSystem system;

    public void importSystem(InputStream systemStream, AutomationSystem system) {
        this.palette = system.getPalette();
        this.system = system;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(false);
        try {
            dbf.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", Boolean.FALSE);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document document = db.parse(systemStream);
            Element rootNode = document.getDocumentElement();
            this.parseAutomationSystem(rootNode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void parseAutomationSystem(Element rootNode) throws TypeImportException, ParseException {
        if (rootNode.getNodeName().equals("System")) {
            NamedNodeMap map = rootNode.getAttributes();
            CommonElementImporter.readNameCommentAttributes(this.system, map);
            SystemConfiguration sysConf = this.system.getSystemConfiguration();
            NodeList childNodes = rootNode.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                Node n = childNodes.item(i);
                if (n.getNodeName().equals("VersionInfo")) {
                    CommonElementImporter.parseVersionInfo(this.system, n);
                }
                if (n.getNodeName().equals("Application")) {
                    this.system.getApplication().add((Object)this.parseApplication(n));
                }
                if (n.getNodeName().equals("Device")) {
                    sysConf.getDevices().add((Object)this.parseDevice(n));
                }
                if (n.getNodeName().equals("Mapping")) {
                    this.parseMapping(n);
                }
                if (n.getNodeName().equals("Segment")) {
                    sysConf.getSegments().add((Object)this.parseSegment(n));
                }
                if (n.getNodeName().equals("Link")) {
                    this.parseLink(n, sysConf);
                }
                ++i;
            }
        }
    }

    private Segment parseSegment(Node n) throws TypeImportException {
        PaletteEntry entry;
        Segment segment = LibraryElementFactory.eINSTANCE.createSegment();
        NamedNodeMap mapSegment = n.getAttributes();
        CommonElementImporter.readNameCommentAttributes(segment, mapSegment);
        Node dx1 = mapSegment.getNamedItem("dx1");
        if (dx1 != null) {
            String dx1String = dx1.getNodeValue();
            double dx1double = 0.0;
            if (dx1String != null && dx1String.length() != 0) {
                dx1double = ImportUtils.convertCoordinate(Double.parseDouble(dx1.getNodeValue()));
            }
            segment.setWidth((int)dx1double);
        }
        CommonElementImporter.getXandY(mapSegment, segment);
        Node type = mapSegment.getNamedItem("Type");
        if (type != null && (entry = this.palette.getTypeEntry(type.getNodeValue())) instanceof SegmentTypePaletteEntry) {
            segment.setPaletteEntry(entry);
        }
        this.parseSegmentNodeChildren(segment, n.getChildNodes());
        return segment;
    }

    private void parseSegmentNodeChildren(Segment segment, NodeList childNodes) {
        int i = 0;
        while (i < childNodes.getLength()) {
            Node node = childNodes.item(i);
            if (node.getNodeName().equals("Attribute")) {
                NamedNodeMap attributeMap = node.getAttributes();
                if (SystemImporter.isColorAttributeNode(attributeMap)) {
                    SystemImporter.parseColor(segment, attributeMap);
                } else {
                    CommonElementImporter.parseGenericAttributeNode(segment, attributeMap);
                }
            }
            ++i;
        }
    }

    private void parseLink(Node linkNode, SystemConfiguration sysConf) {
        NamedNodeMap attributeMap = linkNode.getAttributes();
        String commResource = CommonElementImporter.getAttributeValue(attributeMap, "CommResource");
        String comment = CommonElementImporter.getAttributeValue(attributeMap, "Comment");
        String segmentName = CommonElementImporter.getAttributeValue(attributeMap, "SegmentName");
        Segment segment = sysConf.getSegmentNamed(segmentName);
        Device device = sysConf.getDeviceNamed(commResource);
        if (segment != null && device != null) {
            Link link = LibraryElementFactory.eINSTANCE.createLink();
            link.setComment(comment);
            segment.getOutConnections().add((Object)link);
            device.getInConnections().add((Object)link);
            sysConf.getLinks().add((Object)link);
        }
    }

    private Device parseDevice(Node node) throws TypeImportException {
        Device device = LibraryElementFactory.eINSTANCE.createDevice();
        this.parseCommon(node, device);
        this.parseDeviceNodeChildren(device, node.getChildNodes());
        return device;
    }

    private void parseCommon(Node node, IVarElement element) throws TypeImportException {
        PaletteEntry entry;
        NamedNodeMap mapElement = node.getAttributes();
        CommonElementImporter.readNameCommentAttributes((INamedElement)((Object)element), mapElement);
        Node type = mapElement.getNamedItem("Type");
        if (type != null && (entry = this.palette.getTypeEntry(type.getNodeValue())) != null) {
            ((TypedConfigureableObject)((Object)element)).setPaletteEntry(entry);
            SystemImporter.createParamters(element);
        }
        if (element instanceof PositionableElement) {
            CommonElementImporter.getXandY(mapElement, (PositionableElement)((Object)element));
        }
    }

    private void parseMapping(Node n) {
        NamedNodeMap attributes = n.getAttributes();
        String fromValue = CommonElementImporter.getAttributeValue(attributes, "From");
        String toValue = CommonElementImporter.getAttributeValue(attributes, "To");
        FBNetworkElement fromElement = this.findMappingTargetFromName(fromValue);
        FBNetworkElement toElement = this.findMappingTargetFromName(toValue);
        if (fromElement != null && toElement != null) {
            this.system.getMapping().add((Object)this.createMappingEntry(toElement, fromElement));
        }
    }

    private Mapping createMappingEntry(FBNetworkElement toElement, FBNetworkElement fromElement) {
        Mapping mapping = LibraryElementFactory.eINSTANCE.createMapping();
        mapping.setFrom(fromElement);
        mapping.setTo(toElement);
        toElement.setMapping(mapping);
        fromElement.setMapping(mapping);
        return mapping;
    }

    private FBNetworkElement findMappingTargetFromName(String targetName) {
        ArrayDeque<String> parts;
        FBNetworkElement element = null;
        if (targetName != null && (parts = new ArrayDeque<String>(Arrays.asList(targetName.split("\\.")))).size() >= 2) {
            FBNetwork nw = null;
            Device dev = this.system.getDeviceNamed(parts.getFirst());
            Application application = this.system.getApplicationNamed(parts.getFirst());
            if (dev != null) {
                parts.pollFirst();
                Resource res = dev.getResourceNamed(parts.pollFirst());
                if (res != null) {
                    nw = res.getFBNetwork();
                    element = this.findMappingTargetInFBNetwork(nw, parts);
                }
            }
            if (element == null && application != null) {
                parts = new ArrayDeque<String>(Arrays.asList(targetName.split("\\.")));
                parts.pollFirst();
                nw = application.getFBNetwork();
                element = this.findMappingTargetInFBNetwork(nw, parts);
            }
        }
        return element;
    }

    private FBNetworkElement findMappingTargetInFBNetwork(FBNetwork nw, ArrayDeque<String> parts) {
        FBNetworkElement element;
        if (nw != null && (element = nw.getElementNamed(parts.pollFirst())) != null) {
            if (parts.isEmpty()) {
                return element;
            }
            if (element instanceof SubApp) {
                this.findMappingTargetInFBNetwork(((SubApp)element).getFbNetwork(), parts);
            }
        }
        return null;
    }

    private void parseDeviceNodeChildren(Device device, NodeList childNodes) throws TypeImportException {
        int i = 0;
        while (i < childNodes.getLength()) {
            Node n = childNodes.item(i);
            switch (n.getNodeName()) {
                case "Attribute": {
                    SystemImporter.parseDeviceAttribute(device, n);
                    break;
                }
                case "Parameter": {
                    try {
                        VarDeclaration parameter = ImportUtils.parseParameter(n);
                        if (parameter == null) break;
                        VarDeclaration devParam = this.getDeviceParamter(device, parameter.getName());
                        if (devParam != null) {
                            devParam.setValue(parameter.getValue());
                            break;
                        }
                        parameter.setIsInput(true);
                        device.getVarDeclarations().add((Object)parameter);
                    }
                    catch (TypeImportException e) {
                        Activator.getDefault().logError(e.getMessage(), e);
                    }
                    break;
                }
                case "Resource": {
                    device.getResource().add((Object)this.parseResource(n));
                    break;
                }
            }
            ++i;
        }
    }

    private static void parseDeviceAttribute(Device device, Node node) {
        NamedNodeMap attributeMap = node.getAttributes();
        if (SystemImporter.isColorAttributeNode(attributeMap)) {
            SystemImporter.parseColor(device, attributeMap);
        } else if (CommonElementImporter.isProfileAttribute(attributeMap)) {
            SystemImporter.parseProfile(device, attributeMap);
        } else {
            CommonElementImporter.parseGenericAttributeNode(device, attributeMap);
        }
    }

    private static boolean isColorAttributeNode(NamedNodeMap attributeMap) {
        Node name = attributeMap.getNamedItem("Name");
        return name != null && "Color".equals(name.getNodeValue());
    }

    static void parseColor(ColorizableElement colElement, NamedNodeMap attributeMap) {
        Color color = LibraryElementFactory.eINSTANCE.createColor();
        Node value = attributeMap.getNamedItem("Value");
        if (value != null) {
            String[] colors = value.getNodeValue().split(",");
            color.setRed(Integer.valueOf(colors[0]));
            color.setGreen(Integer.valueOf(colors[1]));
            color.setBlue(Integer.valueOf(colors[2]));
            colElement.setColor(color);
        }
    }

    private static void parseProfile(Device device, NamedNodeMap attributeMap) {
        Node value = attributeMap.getNamedItem("Value");
        if (value != null) {
            device.setProfile(value.getNodeValue());
        }
    }

    public static void createParamters(IVarElement element) {
        if (element instanceof Device) {
            element.getVarDeclarations().addAll(EcoreUtil.copyAll(((DeviceTypePaletteEntry)((TypedConfigureableObject)((Object)element)).getPaletteEntry()).getDeviceType().getVarDeclaration()));
        }
        if (element instanceof Resource) {
            element.getVarDeclarations().addAll(EcoreUtil.copyAll(((ResourceTypeEntry)((TypedConfigureableObject)((Object)element)).getPaletteEntry()).getResourceType().getVarDeclaration()));
        }
        for (VarDeclaration varDecl : element.getVarDeclarations()) {
            Value value = LibraryElementFactory.eINSTANCE.createValue();
            varDecl.setValue(value);
            if (varDecl.getVarInitialization() == null || varDecl.getVarInitialization().getInitialValue() == null) continue;
            String initialValue = varDecl.getVarInitialization().getInitialValue();
            value.setValue(initialValue);
        }
    }

    private VarDeclaration getDeviceParamter(Device device, String name) {
        for (VarDeclaration varDecl : device.getVarDeclarations()) {
            if (!varDecl.getName().equals(name)) continue;
            return varDecl;
        }
        return null;
    }

    private Resource parseResource(Node n) throws TypeImportException {
        Resource resource = LibraryElementFactory.eINSTANCE.createResource();
        resource.setDeviceTypeResource(false);
        this.parseCommon(n, resource);
        FBNetwork fbNetwork = LibraryElementFactory.eINSTANCE.createFBNetwork();
        SystemImporter.createResourceTypeNetwork(((ResourceTypeEntry)resource.getPaletteEntry()).getResourceType(), fbNetwork);
        resource.setFBNetwork(new ResDevFBNetworkImporter(this.palette, fbNetwork, (EList<VarDeclaration>)resource.getVarDeclarations()).parseFBNetwork(CommonElementImporter.findChildNodeNamed(n, "FBNetwork")));
        return resource;
    }

    private Application parseApplication(Node node) throws TypeImportException {
        Application application = LibraryElementFactory.eINSTANCE.createApplication();
        NamedNodeMap mapApplicationElement = node.getAttributes();
        CommonElementImporter.readNameCommentAttributes(application, mapApplicationElement);
        this.parseAttributes(application, node.getChildNodes());
        application.setFBNetwork(new SubAppNetworkImporter(this.palette).parseFBNetwork(CommonElementImporter.findChildNodeNamed(node, "SubAppNetwork")));
        return application;
    }

    public void parseAttributes(ConfigurableObject configurableObject, NodeList node) {
        int i = 0;
        while (i < node.getLength()) {
            Node n = node.item(i);
            if (n.getNodeName() == "Attribute") {
                CommonElementImporter.parseGenericAttributeNode(configurableObject, n.getAttributes());
            }
            ++i;
        }
    }

    public static void createResourceTypeNetwork(ResourceType type, FBNetwork resourceFBNetwork) {
        IInterfaceElement dest;
        IInterfaceElement source;
        FB destFB;
        FB sourceFB;
        Hashtable<String, Event> events = new Hashtable<String, Event>();
        Hashtable<String, VarDeclaration> varDecls = new Hashtable<String, VarDeclaration>();
        for (FBNetworkElement element : type.getFBNetwork().getNetworkElements()) {
            Event eventCopy;
            VarDeclaration varDeclCopy;
            ResourceTypeFB copy = LibraryElementFactory.eINSTANCE.createResourceTypeFB();
            resourceFBNetwork.getNetworkElements().add((Object)copy);
            copy.setPaletteEntry(element.getPaletteEntry());
            copy.setName(element.getName());
            InterfaceList interfaceList = LibraryElementFactory.eINSTANCE.createInterfaceList();
            for (VarDeclaration varDecl : element.getInterface().getOutputVars()) {
                varDeclCopy = LibraryElementFactory.eINSTANCE.createVarDeclaration();
                varDeclCopy.setType(varDecl.getType());
                varDeclCopy.setName(varDecl.getName());
                varDeclCopy.setComment(varDecl.getComment());
                varDeclCopy.setIsInput(varDecl.isIsInput());
                if (varDecl.getValue() != null) {
                    varDeclCopy.setValue((Value)EcoreUtil.copy((EObject)varDecl.getValue()));
                }
                varDecls.put(String.valueOf(element.getName()) + "." + varDeclCopy.getName(), varDeclCopy);
                interfaceList.getOutputVars().add((Object)varDeclCopy);
            }
            for (VarDeclaration varDecl : element.getInterface().getInputVars()) {
                varDeclCopy = LibraryElementFactory.eINSTANCE.createVarDeclaration();
                varDeclCopy.setType(varDecl.getType());
                varDeclCopy.setName(varDecl.getName());
                varDeclCopy.setComment(varDecl.getComment());
                varDeclCopy.setIsInput(varDecl.isIsInput());
                if (varDecl.getValue() != null) {
                    varDeclCopy.setValue((Value)EcoreUtil.copy((EObject)varDecl.getValue()));
                }
                varDecls.put(String.valueOf(element.getName()) + "." + varDeclCopy.getName(), varDeclCopy);
                interfaceList.getInputVars().add((Object)varDeclCopy);
            }
            for (Event event : element.getInterface().getEventInputs()) {
                eventCopy = LibraryElementFactory.eINSTANCE.createEvent();
                eventCopy.setName(event.getName());
                eventCopy.setComment(event.getComment());
                eventCopy.setIsInput(event.isIsInput());
                if (event.getValue() != null) {
                    eventCopy.setValue((Value)EcoreUtil.copy((EObject)event.getValue()));
                }
                events.put(String.valueOf(element.getName()) + "." + event.getName(), eventCopy);
                interfaceList.getEventInputs().add((Object)eventCopy);
            }
            for (Event event : element.getInterface().getEventOutputs()) {
                eventCopy = LibraryElementFactory.eINSTANCE.createEvent();
                eventCopy.setName(event.getName());
                eventCopy.setComment(event.getComment());
                eventCopy.setIsInput(event.isIsInput());
                if (event.getValue() != null) {
                    eventCopy.setValue((Value)EcoreUtil.copy((EObject)event.getValue()));
                }
                events.put(String.valueOf(element.getName()) + "." + event.getName(), eventCopy);
                interfaceList.getEventOutputs().add((Object)eventCopy);
            }
            copy.setInterface(interfaceList);
            copy.setX(element.getX());
            copy.setY(element.getY());
        }
        for (EventConnection eventCon : type.getFBNetwork().getEventConnections()) {
            if (eventCon.getSource() == null || eventCon.getDestination() == null) continue;
            sourceFB = (FB)eventCon.getSource().eContainer().eContainer();
            destFB = (FB)eventCon.getDestination().eContainer().eContainer();
            source = (Event)events.get(String.valueOf(sourceFB.getName()) + "." + eventCon.getSource().getName());
            dest = (Event)events.get(String.valueOf(destFB.getName()) + "." + eventCon.getDestination().getName());
            EventConnection copyEventCon = LibraryElementFactory.eINSTANCE.createEventConnection();
            copyEventCon.setSource(source);
            copyEventCon.setDestination(dest);
            copyEventCon.setResTypeConnection(true);
            resourceFBNetwork.getEventConnections().add((Object)copyEventCon);
        }
        for (DataConnection dataCon : type.getFBNetwork().getDataConnections()) {
            if (dataCon.getSource() == null || dataCon.getDestination() == null) continue;
            sourceFB = (FB)dataCon.getSource().eContainer().eContainer();
            destFB = (FB)dataCon.getDestination().eContainer().eContainer();
            source = (VarDeclaration)varDecls.get(String.valueOf(sourceFB.getName()) + "." + dataCon.getSource().getName());
            dest = (VarDeclaration)varDecls.get(String.valueOf(destFB.getName()) + "." + dataCon.getDestination().getName());
            DataConnection copyDataCon = LibraryElementFactory.eINSTANCE.createDataConnection();
            copyDataCon.setSource(source);
            copyDataCon.setDestination(dest);
            copyDataCon.setResTypeConnection(true);
            resourceFBNetwork.getDataConnections().add((Object)copyDataCon);
        }
    }
}

