/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataimport;

import org.eclipse.fordiac.ide.model.Activator;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.dataimport.ImportUtils;
import org.eclipse.fordiac.ide.model.dataimport.exceptions.TypeImportException;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableObject;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.Identification;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.PositionableElement;
import org.eclipse.fordiac.ide.model.libraryElement.VersionInfo;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class CommonElementImporter {
    CommonElementImporter() {
    }

    public static Identification parseIdentification(LibraryElement elem, Node node) {
        Node description;
        Node type;
        Node function;
        Node applicationDomain;
        Node classification;
        NamedNodeMap map = node.getAttributes();
        Identification ident = LibraryElementFactory.eINSTANCE.createIdentification();
        elem.setIdentification(ident);
        Node standard = map.getNamedItem("Standard");
        if (standard != null) {
            ident.setStandard(standard.getNodeValue());
        }
        if ((classification = map.getNamedItem("Classification")) != null) {
            ident.setClassification(classification.getNodeValue());
        }
        if ((applicationDomain = map.getNamedItem("ApplicationDomain")) != null) {
            ident.setApplicationDomain(applicationDomain.getNodeValue());
        }
        if ((function = map.getNamedItem("Function")) != null) {
            ident.setFunction(function.getNodeValue());
        }
        if ((type = map.getNamedItem("Type")) != null) {
            ident.setType(type.getNodeValue());
        }
        if ((description = map.getNamedItem("Description")) != null) {
            ident.setDescription(description.getNodeValue());
        }
        return ident;
    }

    public static VersionInfo parseVersionInfo(LibraryElement elem, Node node) throws TypeImportException {
        Node remarks;
        Node version;
        NamedNodeMap map = node.getAttributes();
        VersionInfo versionInfo = LibraryElementFactory.eINSTANCE.createVersionInfo();
        elem.getVersionInfo().add((Object)versionInfo);
        Node organization = map.getNamedItem("Organization");
        if (organization != null) {
            versionInfo.setOrganization(organization.getNodeValue());
        }
        if ((version = map.getNamedItem("Version")) == null) {
            throw new TypeImportException(Messages.CommonElementImporter_ERROR_MissingVersionInfo);
        }
        versionInfo.setVersion(version.getNodeValue());
        Node author = map.getNamedItem("Author");
        if (author == null) {
            throw new TypeImportException(Messages.CommonElementImporter_ERROR_MissingAuthorInfo);
        }
        versionInfo.setAuthor(author.getNodeValue());
        Node date = map.getNamedItem("Date");
        if (date != null) {
            versionInfo.setDate(date.getNodeValue());
        }
        if ((remarks = map.getNamedItem("Remarks")) != null) {
            versionInfo.setRemarks(remarks.getNodeValue());
        } else {
            versionInfo.setRemarks("");
        }
        return versionInfo;
    }

    public static Node findChildNodeNamed(Node node, String nodeName) {
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node n = childNodes.item(i);
            if (n.getNodeName().equals(nodeName)) {
                return n;
            }
            ++i;
        }
        return null;
    }

    public static void getXandY(NamedNodeMap map, PositionableElement positionableElement) throws TypeImportException {
        try {
            Node y;
            Node x = map.getNamedItem("x");
            if (x != null) {
                String xValueString = x.getNodeValue();
                double xValue = 0.0;
                if (xValueString != null && xValueString.length() != 0) {
                    xValue = ImportUtils.convertCoordinate(Double.parseDouble(x.getNodeValue()));
                } else {
                    Activator.getDefault().logWarning(Messages.FBTImporter_POSITION_X_WRONG);
                }
                positionableElement.setX((int)xValue);
            }
            if ((y = map.getNamedItem("y")) != null) {
                String yValueString = y.getNodeValue();
                double yValue = 0.0;
                if (yValueString != null && yValueString.length() != 0) {
                    yValue = ImportUtils.convertCoordinate(Double.parseDouble(y.getNodeValue()));
                } else {
                    Activator.getDefault().logWarning(Messages.FBTImporter_POSITION_Y_WRONG);
                }
                positionableElement.setY((int)yValue);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new TypeImportException(Messages.FBTImporter_POSITION_EXCEPTION);
        }
    }

    static void readNameCommentAttributes(INamedElement namedElement, NamedNodeMap attributeMap) {
        CommonElementImporter.readNameAttribute(namedElement, attributeMap);
        CommonElementImporter.readCommentAttribute(namedElement, attributeMap);
    }

    private static void readNameAttribute(INamedElement namedElement, NamedNodeMap attributeMap) {
        Node name = attributeMap.getNamedItem("Name");
        if (name != null) {
            namedElement.setName(name.getNodeValue());
        }
    }

    private static void readCommentAttribute(INamedElement namedElement, NamedNodeMap attributeMap) {
        Node comment = attributeMap.getNamedItem("Comment");
        if (comment != null) {
            namedElement.setComment(comment.getNodeValue());
        }
    }

    static void parseGenericAttributeNode(ConfigurableObject confObject, NamedNodeMap attributeMap) {
        Node name = attributeMap.getNamedItem("Name");
        Node type = attributeMap.getNamedItem("Type");
        Node value = attributeMap.getNamedItem("Value");
        Node comment = attributeMap.getNamedItem("Comment");
        if (name != null && value != null) {
            confObject.setAttribute(name.getNodeValue(), type == null ? "STRING" : type.getNodeValue(), value.getNodeValue(), comment.getNodeValue());
        }
    }

    static String getAttributeValue(NamedNodeMap attributeMap, String attName) {
        Node value = attributeMap.getNamedItem(attName);
        return value != null ? value.getNodeValue() : null;
    }

    static boolean isProfileAttribute(NamedNodeMap attributeMap) {
        Node name = attributeMap.getNamedItem("Name");
        return name != null && "Profile".equals(name.getNodeValue());
    }
}

