/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataexport;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.model.Activator;
import org.eclipse.fordiac.ide.model.dataexport.CommonElementExporter;
import org.eclipse.fordiac.ide.model.dataexport.FBNetworkExporter;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableObject;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.Link;
import org.eclipse.fordiac.ide.model.libraryElement.Mapping;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.Segment;
import org.eclipse.fordiac.ide.model.libraryElement.SystemConfiguration;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SystemExporter {
    private List<String> warnings = new ArrayList<String>();
    private List<String> errors = new ArrayList<String>();
    private List<String> infos = new ArrayList<String>();
    private final Document dom = SystemExporter.createDomElement();
    private AutomationSystem system;
    private Element systemRootElement;

    private static Document createDomElement() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            return db.newDocument();
        }
        catch (ParserConfigurationException e) {
            Activator.getDefault().logError(e.getMessage(), e);
            return null;
        }
    }

    public void generateSYSFileContent(AutomationSystem system, Result result) throws TransformerException {
        if (this.dom != null) {
            this.addSystem(system);
            Transformer transformer = this.createTransformer();
            DOMSource source = new DOMSource(this.dom);
            transformer.transform(source, result);
        }
    }

    private void addSystem(AutomationSystem system) {
        this.system = system;
        this.systemRootElement = this.dom.createElement("System");
        CommonElementExporter.setNameAndCommentAttribute(this.systemRootElement, system);
        this.dom.appendChild(this.systemRootElement);
        CommonElementExporter.addIdentification(this.dom, this.systemRootElement, system);
        CommonElementExporter.addVersionInfo(this.dom, this.systemRootElement, system);
        this.addApplication();
        SystemConfiguration systemConfiguration = system.getSystemConfiguration();
        if (systemConfiguration != null) {
            this.addDevices((List<Device>)systemConfiguration.getDevices());
            this.addMapping();
            this.addSegment((List<Segment>)systemConfiguration.getSegments());
            this.addLink((List<Link>)systemConfiguration.getLinks());
        }
    }

    private void addApplication() {
        for (Application app : this.system.getApplication()) {
            Element appElement = this.dom.createElement("Application");
            CommonElementExporter.setNameAndCommentAttribute(appElement, app);
            this.addAttributes(appElement, app.getAttributes(), app);
            appElement.appendChild(new FBNetworkExporter(this.dom).createFBNetworkElement(app.getFBNetwork()));
            this.systemRootElement.appendChild(appElement);
        }
    }

    private void addLink(List<Link> linksList) {
        for (Link link : linksList) {
            Element linkElement = this.dom.createElement("Link");
            linkElement.setAttribute("SegmentName", link.getSegment().getName());
            linkElement.setAttribute("CommResource", link.getDevice().getName());
            linkElement.setAttribute("Comment", link.getComment());
            this.systemRootElement.appendChild(linkElement);
        }
    }

    private void addSegment(List<Segment> segmentsList) {
        for (Segment segment : segmentsList) {
            Element segmentElement = this.dom.createElement("Segment");
            CommonElementExporter.setNameTypeCommentAttribute(segmentElement, segment, segment.getType());
            segmentElement.setAttribute("x", CommonElementExporter.reConvertCoordinate(segment.getX()).toString());
            segmentElement.setAttribute("y", CommonElementExporter.reConvertCoordinate(segment.getY()).toString());
            segmentElement.setAttribute("dx1", CommonElementExporter.reConvertCoordinate(segment.getWidth()).toString());
            CommonElementExporter.addColorAttributeElement(this.dom, segmentElement, segment);
            this.addAttributes(segmentElement, segment.getAttributes(), segment);
            this.systemRootElement.appendChild(segmentElement);
        }
    }

    private void addMapping() {
        for (Mapping mappingEntry : this.system.getMapping()) {
            String fromString = this.getFullHierarchicalName(mappingEntry.getFrom());
            String toString = this.getFullHierarchicalName(mappingEntry.getTo());
            if (fromString == null || toString == null) continue;
            Element mappingElement = this.dom.createElement("Mapping");
            mappingElement.setAttribute("From", fromString);
            mappingElement.setAttribute("To", toString);
            this.systemRootElement.appendChild(mappingElement);
        }
    }

    private String getFullHierarchicalName(FBNetworkElement fbNetworkElement) {
        ArrayDeque<String> names = new ArrayDeque<String>();
        if (fbNetworkElement != null) {
            FBNetworkElement runner;
            names.addFirst(fbNetworkElement.getName());
            FBNetworkElement container = fbNetworkElement;
            while ((container = (runner = container).getFbNetwork().eContainer()) != null && container instanceof INamedElement) {
                names.addFirst(".");
                names.addFirst(((INamedElement)container).getName());
                if (container instanceof Resource) {
                    names.addFirst(".");
                    names.addFirst(((Resource)((Object)container)).getDevice().getName());
                    break;
                }
                if (container instanceof FBNetworkElement) continue;
            }
            StringBuilder fullName = new StringBuilder();
            for (String string : names) {
                fullName.append(string);
            }
            return fullName.toString();
        }
        return null;
    }

    private void addDevices(List<Device> devicesList) {
        for (Device device : devicesList) {
            this.addDevice(device);
        }
    }

    private void addDevice(Device device) {
        Element deviceElement = this.dom.createElement("Device");
        CommonElementExporter.setNameTypeCommentAttribute(deviceElement, device, device.getType());
        CommonElementExporter.exportXandY(device, deviceElement);
        CommonElementExporter.addParamsConfig(this.dom, deviceElement, (EList<VarDeclaration>)device.getVarDeclarations());
        this.addDeviceAttributes(deviceElement, device.getAttributes(), device);
        this.addResources(deviceElement, (List<Resource>)device.getResource());
        this.systemRootElement.appendChild(deviceElement);
    }

    private void addDeviceAttributes(Element deviceElement, EList<Attribute> attributes, Device device) {
        this.addDeviceProfile(deviceElement, device);
        CommonElementExporter.addColorAttributeElement(this.dom, deviceElement, device);
        this.addAttributes(deviceElement, attributes, device);
    }

    private void addAttributes(Element element, EList<Attribute> attributes, ConfigurableObject configurableObject) {
        for (Attribute attribute : attributes) {
            Element domAttribute = CommonElementExporter.createAttributeElement(this.dom, attribute.getName(), attribute.getType().getName(), attribute.getValue(), attribute.getComment());
            element.appendChild(domAttribute);
        }
    }

    private void addDeviceProfile(Element deviceElement, Device device) {
        String profileName = device.getProfile();
        if (profileName != null && !"".equals(profileName)) {
            Element profileAttribute = CommonElementExporter.createAttributeElement(this.dom, "Profile", "STRING", profileName, "device profile");
            deviceElement.appendChild(profileAttribute);
        }
    }

    private void addResources(Element deviceElement, List<Resource> resourcesList) {
        for (Resource resource : resourcesList) {
            if (resource.isDeviceTypeResource()) continue;
            this.addResource(deviceElement, resource);
        }
    }

    private void addResource(Element parent, Resource resource) {
        Element resourceElement = this.dom.createElement("Resource");
        CommonElementExporter.setNameTypeCommentAttribute(resourceElement, resource, resource.getType());
        CommonElementExporter.setXYAttributes(resourceElement, 0, 0);
        CommonElementExporter.addParamsConfig(this.dom, resourceElement, (EList<VarDeclaration>)resource.getVarDeclarations());
        resourceElement.appendChild(new FBNetworkExporter(this.dom).createFBNetworkElement(resource.getFBNetwork()));
        parent.appendChild(resourceElement);
    }

    private Transformer createTransformer() throws TransformerFactoryConfigurationError, TransformerConfigurationException {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        tFactory.setAttribute("indent-number", 2);
        Transformer transformer = tFactory.newTransformer();
        transformer.setOutputProperty("doctype-system", "http://www.holobloc.com/xml/LibraryElement.dtd");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("version", "1.0");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("standalone", "no");
        transformer.setOutputProperty("method", "xml");
        return transformer;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public List<String> getInfos() {
        return this.infos;
    }

    public List<String> getWarnings() {
        return this.warnings;
    }
}

