/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.create;

import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.ui.controls.Abstract4DIACUIPlugin;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.IEditorPart;

public abstract class AbstractConnectionCreateCommand
extends Command {
    private int connDx1 = 0;
    private int connDx2 = 0;
    private int connDy = 0;
    private IEditorPart editor;
    private final FBNetwork parent;
    private Connection connection;
    protected IInterfaceElement source;
    protected IInterfaceElement destination;
    private boolean performMappingCheck;
    private AbstractConnectionCreateCommand mirroredConnection;

    protected IEditorPart getEditor() {
        return this.editor;
    }

    public AbstractConnectionCreateCommand(FBNetwork parent) {
        this.parent = parent;
        this.performMappingCheck = true;
    }

    public void setArrangementConstraints(int dx1, int dx2, int dy) {
        this.connDx1 = dx1;
        this.connDx2 = dx2;
        this.connDy = dy;
    }

    public boolean canUndo() {
        return this.getEditor().equals(Abstract4DIACUIPlugin.getCurrentActiveEditor());
    }

    public abstract boolean canExecute();

    public void setSource(IInterfaceElement source) {
        this.source = source;
    }

    public IInterfaceElement getSource() {
        return this.source;
    }

    public void setDestination(IInterfaceElement target) {
        this.destination = target;
    }

    public void execute() {
        this.editor = Abstract4DIACUIPlugin.getCurrentActiveEditor();
        this.checkSourceAndTarget();
        this.connection = this.createConnectionElement();
        this.connection.setSource(this.source);
        this.connection.setDestination(this.destination);
        this.connection.setDx1(this.connDx1);
        this.connection.setDx2(this.connDx2);
        this.connection.setDy(this.connDy);
        this.parent.addConnection(this.connection);
        if (this.performMappingCheck) {
            this.mirroredConnection = this.checkAndCreateMirroredConnection();
            if (this.mirroredConnection != null) {
                this.mirroredConnection.execute();
            }
        }
    }

    public void undo() {
        if (this.mirroredConnection != null) {
            this.mirroredConnection.undo();
        }
        this.connection.setSource(null);
        this.connection.setDestination(null);
        this.parent.removeConnection(this.connection);
    }

    public void redo() {
        this.connection.setSource(this.source);
        this.connection.setDestination(this.destination);
        this.parent.addConnection(this.connection);
        if (this.mirroredConnection != null) {
            this.mirroredConnection.redo();
        }
    }

    protected void checkSourceAndTarget() {
        boolean needsChange = this.source.eContainer().eContainer() instanceof CompositeFBType || this.source.getFBNetworkElement().getFbNetwork() != this.parent ? !this.source.isIsInput() : this.source.isIsInput();
        if (needsChange) {
            IInterfaceElement buf = this.destination;
            this.destination = this.source;
            this.source = buf;
        }
    }

    protected abstract Connection createConnectionElement();

    private AbstractConnectionCreateCommand checkAndCreateMirroredConnection() {
        if (this.source.getFBNetworkElement() != null && this.destination.getFBNetworkElement() != null) {
            FBNetworkElement opSource = this.source.getFBNetworkElement().getOpposite();
            FBNetworkElement opDestination = this.destination.getFBNetworkElement().getOpposite();
            if (opSource != null && opDestination != null && opSource.getFbNetwork() == opDestination.getFbNetwork()) {
                AbstractConnectionCreateCommand cmd = this.createMirroredConnectionCommand(opSource.getFbNetwork());
                cmd.setPerformMappingCheck(false);
                cmd.setSource(opSource.getInterfaceElement(this.source.getName()));
                cmd.setDestination(opDestination.getInterfaceElement(this.destination.getName()));
                return cmd.canExecute() ? cmd : null;
            }
        }
        return null;
    }

    protected abstract AbstractConnectionCreateCommand createMirroredConnectionCommand(FBNetwork var1);

    private void setPerformMappingCheck(boolean performMappingCheck) {
        this.performMappingCheck = performMappingCheck;
    }
}

