/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.change;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.Palette.AdapterTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.FBTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.commands.change.MapToCommand;
import org.eclipse.fordiac.ide.model.commands.change.UnmapCommand;
import org.eclipse.fordiac.ide.model.commands.create.AbstractConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.AdapterConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.DataConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.EventConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteConnectionCommand;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterConnection;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterFB;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.DataConnection;
import org.eclipse.fordiac.ide.model.libraryElement.EventConnection;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.Value;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.gef.commands.Command;

public class UpdateFBTypeCommand
extends Command {
    private FB fb;
    private FB copiedFB;
    private PaletteEntry entry;
    private FBNetwork network;
    private List<DeleteConnectionCommand> deleteConnCmds = new ArrayList<DeleteConnectionCommand>();
    private List<AbstractConnectionCreateCommand> connCreateCmds = new ArrayList<AbstractConnectionCreateCommand>();
    private MapToCommand mapCmd = null;
    private UnmapCommand unmapCmd = null;

    public UpdateFBTypeCommand(FB fb) {
        this.fb = fb;
        this.network = (FBNetwork)fb.eContainer();
    }

    public UpdateFBTypeCommand(FB fb, PaletteEntry entry) {
        this.fb = fb;
        this.network = (FBNetwork)fb.eContainer();
        if (entry instanceof FBTypePaletteEntry || entry instanceof AdapterTypePaletteEntry) {
            this.entry = entry;
        }
    }

    public boolean canExecute() {
        return true;
    }

    public void execute() {
        Resource resource = null;
        if (this.fb.isMapped()) {
            if (this.network.equals(this.fb.getResource().getFBNetwork())) {
                this.fb = (FB)this.fb.getOpposite();
                this.network = this.fb.getFbNetwork();
            }
            resource = this.fb.getResource();
            this.unmapCmd = new UnmapCommand((FBNetworkElement)this.fb);
            this.unmapCmd.execute();
        }
        this.copyFB(this.fb);
        ArrayList reConnections = new ArrayList();
        for (IInterfaceElement ifEle : this.fb.getInterface().getAllInterfaceElements()) {
            reConnections.addAll(ifEle.getInputConnections());
            reConnections.addAll(ifEle.getOutputConnections());
        }
        for (Connection conn : reConnections) {
            this.doReconnect(conn, this.findUpdatedInterfaceElement(this.copiedFB, conn.getSource()), this.findUpdatedInterfaceElement(this.copiedFB, conn.getDestination()));
        }
        String name = this.fb.getName();
        this.copiedFB.setName(name);
        if (resource != null) {
            this.mapCmd = new MapToCommand((FBNetworkElement)this.copiedFB, resource);
            if (this.mapCmd.canExecute()) {
                this.mapCmd.execute();
            }
        }
    }

    public void redo() {
        if (this.unmapCmd != null) {
            this.unmapCmd.redo();
        }
        for (DeleteConnectionCommand deleteConnectionCommand : this.deleteConnCmds) {
            deleteConnectionCommand.redo();
        }
        this.replaceFBs(this.fb, this.copiedFB);
        for (AbstractConnectionCreateCommand abstractConnectionCreateCommand : this.connCreateCmds) {
            abstractConnectionCreateCommand.redo();
        }
        if (this.mapCmd != null) {
            this.mapCmd.redo();
        }
    }

    public void undo() {
        if (this.mapCmd != null) {
            this.mapCmd.undo();
        }
        for (AbstractConnectionCreateCommand abstractConnectionCreateCommand : this.connCreateCmds) {
            abstractConnectionCreateCommand.undo();
        }
        this.replaceFBs(this.copiedFB, this.fb);
        for (DeleteConnectionCommand deleteConnectionCommand : this.deleteConnCmds) {
            deleteConnectionCommand.undo();
        }
        if (this.unmapCmd != null) {
            this.unmapCmd.undo();
        }
    }

    private IInterfaceElement findUpdatedInterfaceElement(FB copiedFB, IInterfaceElement orig) {
        if (orig == null) {
            return null;
        }
        IInterfaceElement retval = orig;
        if (orig.getFBNetworkElement() == this.fb) {
            retval = copiedFB.getInterfaceElement(orig.getName());
        }
        return retval;
    }

    private void doReconnect(Connection oldConn, IInterfaceElement source, IInterfaceElement dest) {
        if (!this.isInDeleteConnList(oldConn)) {
            FBNetwork fbn = oldConn.getFBNetwork();
            DeleteConnectionCommand cmd = new DeleteConnectionCommand(oldConn);
            cmd.execute();
            this.deleteConnCmds.add(cmd);
            if (source != null && dest != null) {
                AbstractConnectionCreateCommand dccc = null;
                if (oldConn instanceof EventConnection) {
                    dccc = new EventConnectionCreateCommand(fbn);
                } else if (oldConn instanceof DataConnection) {
                    dccc = new DataConnectionCreateCommand(fbn);
                } else if (oldConn instanceof AdapterConnection) {
                    dccc = new AdapterConnectionCreateCommand(fbn);
                }
                if (dccc != null) {
                    dccc.setSource(source);
                    dccc.setDestination(dest);
                    if (dccc.canExecute()) {
                        dccc.execute();
                        this.connCreateCmds.add(dccc);
                    }
                }
            }
        }
    }

    private boolean isInDeleteConnList(Connection conn) {
        for (DeleteConnectionCommand cmd : this.deleteConnCmds) {
            if (!cmd.getConnectionView().equals(conn)) continue;
            return true;
        }
        return false;
    }

    private void replaceFBs(FB oldFB, FB newFB) {
        this.network.getNetworkElements().remove((Object)oldFB);
        this.network.getNetworkElements().add((Object)newFB);
    }

    private void copyFB(FB srcFB) {
        this.copiedFB = this.createCopiedFBEntry(srcFB);
        this.copiedFB.setInterface((InterfaceList)EcoreUtil.copy((EObject)this.copiedFB.getType().getInterfaceList()));
        this.copiedFB.setName(srcFB.getName());
        for (VarDeclaration var : this.copiedFB.getInterface().getInputVars()) {
            if (var.getValue() != null) continue;
            var.setValue(LibraryElementFactory.eINSTANCE.createValue());
        }
        this.copiedFB.setX(srcFB.getX());
        this.copiedFB.setY(srcFB.getY());
        this.createValues(this.copiedFB);
        UpdateFBTypeCommand.pasteParams(srcFB, this.copiedFB);
        this.replaceFBs(srcFB, this.copiedFB);
    }

    protected FB createCopiedFBEntry(FB srcFB) {
        FB copy = null;
        if (srcFB instanceof AdapterFB) {
            AdapterFB aFB = LibraryElementFactory.eINSTANCE.createAdapterFB();
            aFB.setAdapterDecl(((AdapterFB)srcFB).getAdapterDecl());
            copy = aFB;
        } else {
            copy = LibraryElementFactory.eINSTANCE.createFB();
        }
        if (this.entry == null) {
            copy.setPaletteEntry(srcFB.getPaletteEntry());
        } else {
            copy.setPaletteEntry(this.entry);
        }
        return copy;
    }

    private static void pasteParams(FB src, FB dst) {
        InterfaceList interfaceList = src.getInterface();
        if (interfaceList != null) {
            for (VarDeclaration varDecl : interfaceList.getInputVars()) {
                Value value;
                if (dst.getInterfaceElement(varDecl.getName()) == null || (value = varDecl.getValue()) == null || value.getValue() == null) continue;
                Value newValue = LibraryElementFactory.eINSTANCE.createValue();
                newValue.setValue(value.getValue());
                dst.getInterfaceElement(varDecl.getName()).setValue(newValue);
            }
        }
    }

    protected void createValues(FB copiedFB) {
        for (IInterfaceElement element : copiedFB.getInterface().getInputVars()) {
            Value value = LibraryElementFactory.eINSTANCE.createValue();
            element.setValue(value);
        }
    }
}

