/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.properties;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.fordiac.ide.gef.Messages;
import org.eclipse.fordiac.ide.gef.editparts.AbstractViewEditPart;
import org.eclipse.fordiac.ide.model.commands.change.ChangeBackgroundcolorCommand;
import org.eclipse.fordiac.ide.model.libraryElement.Color;
import org.eclipse.fordiac.ide.model.libraryElement.ColorizableElement;
import org.eclipse.fordiac.ide.ui.controls.Abstract4DIACUIPlugin;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class AppearancePropertySection
extends AbstractPropertySection {
    private AbstractViewEditPart abstractViewEditPart;
    private ColorizableElement colorizableElement;
    private final List<ColorizableElement> selectedViews = new ArrayList<ColorizableElement>();
    private org.eclipse.swt.graphics.Color color;
    protected Label colorLabel;
    protected Button chooseColorBtn;
    protected Group colorsGroup;

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        FormLayout layout = (FormLayout)composite.getLayout();
        layout.spacing = 3;
        this.initializeControls(composite);
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection));
        Object input = ((IStructuredSelection)selection).getFirstElement();
        Assert.isTrue((boolean)(input instanceof AbstractViewEditPart));
        this.abstractViewEditPart = (AbstractViewEditPart)((Object)input);
        if (this.abstractViewEditPart.getModel() instanceof ColorizableElement) {
            this.colorizableElement = (ColorizableElement)this.abstractViewEditPart.getModel();
        }
        this.selectedViews.clear();
        for (Object object : (IStructuredSelection)selection) {
            if (!(object instanceof AbstractViewEditPart) || !(((AbstractViewEditPart)((Object)object)).getModel() instanceof ColorizableElement)) continue;
            this.selectedViews.add((ColorizableElement)((AbstractViewEditPart)((Object)object)).getModel());
        }
        if (this.selectedViews.size() <= 1) {
            this.selectedViews.clear();
        }
    }

    public void refresh() {
        if (this.colorizableElement != null && this.colorizableElement.getColor() != null) {
            Color color = this.colorizableElement.getColor();
            this.color.dispose();
            this.color = new org.eclipse.swt.graphics.Color(null, new RGB(color.getRed(), color.getGreen(), color.getBlue()));
            this.colorLabel.setBackground(this.color);
        } else {
            this.color.dispose();
            this.color = new org.eclipse.swt.graphics.Color(null, new RGB(255, 255, 255));
            this.colorLabel.setBackground(this.color);
        }
        super.refresh();
    }

    protected void initializeControls(Composite parent) {
        this.createColorsGroup(parent);
    }

    protected void createColorsGroup(Composite parent) {
        this.colorsGroup = this.getWidgetFactory().createGroup(parent, Messages.AppearancePropertySection_LABLE_Color);
        GridLayout layout = new GridLayout(1, false);
        this.colorsGroup.setLayout((Layout)layout);
        this.color = new org.eclipse.swt.graphics.Color(null, new RGB(255, 255, 255));
        this.colorLabel = this.getWidgetFactory().createLabel((Composite)this.colorsGroup, "");
        this.colorLabel.setText("          ");
        this.colorLabel.setBackground(this.color);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        this.colorLabel.setLayoutData((Object)gd);
        this.chooseColorBtn = new Button((Composite)this.colorsGroup, 8);
        this.chooseColorBtn.setText(Messages.AppearancePropertySection_LABEL_BackgroundColor);
        this.chooseColorBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ColorDialog dlg = new ColorDialog(AppearancePropertySection.this.colorsGroup.getShell());
                dlg.setRGB(AppearancePropertySection.this.colorLabel.getBackground().getRGB());
                dlg.setText(Messages.AppearancePropertySection_LABEL_ChooseColor);
                RGB rgb = dlg.open();
                if (rgb != null) {
                    CompoundCommand cmd;
                    if (AppearancePropertySection.this.selectedViews.size() > 0) {
                        cmd = new CompoundCommand("Change Background Color");
                        for (ColorizableElement colorizableElement : AppearancePropertySection.this.selectedViews) {
                            ChangeBackgroundcolorCommand tmp = new ChangeBackgroundcolorCommand(colorizableElement, rgb);
                            cmd.add((Command)tmp);
                        }
                    } else {
                        cmd = new ChangeBackgroundcolorCommand(AppearancePropertySection.this.colorizableElement, rgb);
                    }
                    if (cmd.canExecute()) {
                        Object viewer = Abstract4DIACUIPlugin.getCurrentActiveEditor().getAdapter(GraphicalViewer.class);
                        if (viewer instanceof GraphicalViewer) {
                            ((GraphicalViewer)viewer).getEditDomain().getCommandStack().execute((Command)cmd);
                        } else {
                            cmd.execute();
                        }
                        AppearancePropertySection.this.color.dispose();
                        AppearancePropertySection.this.color = new org.eclipse.swt.graphics.Color(null, rgb);
                        AppearancePropertySection.this.colorLabel.setBackground(AppearancePropertySection.this.color);
                    }
                }
            }
        });
    }
}

