/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.editparts;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.fordiac.ide.gef.Activator;
import org.eclipse.fordiac.ide.gef.editparts.AbstractDirectEditableEditPart;
import org.eclipse.fordiac.ide.gef.editparts.AbstractViewEditPart;
import org.eclipse.fordiac.ide.gef.editparts.ValueEditPart;
import org.eclipse.fordiac.ide.ui.controls.Abstract4DIACUIPlugin;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.CellEditorActionHandler;

public class LabelDirectEditManager
extends DirectEditManager {
    private IActionBars actionBars;
    private CellEditorActionHandler actionHandler;
    private IAction copy;
    private IAction cut;
    private IAction paste;
    private IAction undo;
    private IAction redo;
    private IAction find;
    private IAction selectAll;
    private IAction delete;
    protected Label label;
    protected Font scaledFont;
    protected String initialString = null;
    private VerifyListener aditionalVerify = null;

    public LabelDirectEditManager(GraphicalEditPart source, Class editorType, CellEditorLocator locator, Label label) {
        super(source, editorType, locator);
        this.label = label;
    }

    public LabelDirectEditManager(GraphicalEditPart source, Class editorType, CellEditorLocator locator, Label label, VerifyListener aditionalVerifyListener) {
        super(source, editorType, locator);
        this.label = label;
        this.aditionalVerify = aditionalVerifyListener;
    }

    public void show(char initialChar) {
        this.initialString = new String(new char[]{initialChar});
        this.show();
        Text textControl = (Text)this.getCellEditor().getControl();
        textControl.setSelection(1);
        this.setDirty(true);
        this.getLocator().relocate(this.getCellEditor());
    }

    protected void bringDown() {
        if (this.getEditPart() instanceof ValueEditPart) {
            ((ValueEditPart)this.getEditPart()).refreshValue();
        }
        if (this.getEditPart() instanceof AbstractViewEditPart) {
            ((AbstractViewEditPart)this.getEditPart()).refreshName();
        }
        if (this.getEditPart() instanceof AbstractDirectEditableEditPart) {
            ((AbstractDirectEditableEditPart)this.getEditPart()).refreshName();
        }
        Font disposeFont = this.scaledFont;
        this.scaledFont = null;
        this.initialString = null;
        if (this.actionHandler != null) {
            this.actionHandler.dispose();
            this.actionHandler = null;
        }
        if (this.actionBars != null) {
            this.restoreSavedActions(this.actionBars);
            this.actionBars.updateActionBars();
            this.actionBars = null;
        }
        this.getLocator().relocate(this.getCellEditor());
        super.bringDown();
        if (disposeFont != null) {
            disposeFont.dispose();
        }
    }

    protected void initCellEditor() {
        Text text = (Text)this.getCellEditor().getControl();
        if (this.aditionalVerify != null) {
            text.addVerifyListener(this.aditionalVerify);
        }
        String initialLabelText = "";
        if (this.initialString == null) {
            initialLabelText = this.label.getText();
            this.getCellEditor().setValue((Object)initialLabelText);
        } else {
            initialLabelText = this.initialString.toString();
            this.getCellEditor().setValue((Object)initialLabelText);
        }
        IFigure figure = this.getEditPart().getFigure();
        this.scaledFont = figure.getFont();
        FontData data = this.scaledFont.getFontData()[0];
        Dimension fontSize = new Dimension(0, data.getHeight());
        this.label.translateToAbsolute((Translatable)fontSize);
        data.setHeight(fontSize.height);
        this.scaledFont = new Font(null, data);
        text.setFont(this.scaledFont);
        text.selectAll();
        this.actionBars = Abstract4DIACUIPlugin.getCurrentActiveEditor().getEditorSite().getActionBars();
        this.saveCurrentActions(this.actionBars);
        this.actionHandler = new CellEditorActionHandler(this.actionBars);
        this.actionHandler.addCellEditor(this.getCellEditor());
        this.actionBars.updateActionBars();
    }

    private void restoreSavedActions(IActionBars actionBars) {
        actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), this.copy);
        actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), this.paste);
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), this.delete);
        actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), this.selectAll);
        actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), this.cut);
        actionBars.setGlobalActionHandler(ActionFactory.FIND.getId(), this.find);
        actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), this.undo);
        actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), this.redo);
    }

    private void saveCurrentActions(IActionBars actionBars) {
        this.copy = actionBars.getGlobalActionHandler(ActionFactory.COPY.getId());
        this.paste = actionBars.getGlobalActionHandler(ActionFactory.PASTE.getId());
        this.delete = actionBars.getGlobalActionHandler(ActionFactory.DELETE.getId());
        this.selectAll = actionBars.getGlobalActionHandler(ActionFactory.SELECT_ALL.getId());
        this.cut = actionBars.getGlobalActionHandler(ActionFactory.CUT.getId());
        this.find = actionBars.getGlobalActionHandler(ActionFactory.FIND.getId());
        this.undo = actionBars.getGlobalActionHandler(ActionFactory.UNDO.getId());
        this.redo = actionBars.getGlobalActionHandler(ActionFactory.REDO.getId());
    }

    public void setInitialString(String val) {
        this.initialString = val;
        if (this.getCellEditor() != null) {
            this.getCellEditor().setValue((Object)this.initialString);
        }
    }

    protected void unhookListeners() {
        super.unhookListeners();
        try {
            Text text = (Text)this.getCellEditor().getControl();
            if (this.aditionalVerify != null) {
                text.removeVerifyListener(this.aditionalVerify);
            }
        }
        catch (Exception e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
    }
}

