/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.editparts;

import java.util.ArrayList;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.fordiac.ide.gef.Activator;
import org.eclipse.fordiac.ide.gef.router.RouterUtil;
import org.eclipse.gef.CompoundSnapToHelper;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.SnapToGrid;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.SnapFeedbackPolicy;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public abstract class AbstractDiagramEditPart
extends AbstractGraphicalEditPart {
    private IPropertyChangeListener listener;

    protected IFigure createFigure() {
        FreeformLayer f = new FreeformLayer();
        f.setBorder((Border)new MarginBorder(10));
        f.setLayoutManager((LayoutManager)new FreeformLayout());
        f.setOpaque(false);
        ConnectionLayer connLayer = (ConnectionLayer)this.getLayer("Connection Layer");
        connLayer.setConnectionRouter(RouterUtil.getConnectionRouter((IFigure)f));
        return f;
    }

    public void refresh() {
        super.refresh();
        this.updateGrid();
        this.showGrid();
        this.updateRuler();
    }

    private void updateRuler() {
        this.getViewer().setProperty("ruler$visibility", (Object)Activator.getDefault().getPreferenceStore().getBoolean("ShowRulers"));
    }

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            if (this.getPreferenceChangeListener() != null) {
                Activator.getDefault().getPreferenceStore().addPropertyChangeListener(this.getPreferenceChangeListener());
            }
        }
    }

    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            if (this.getPreferenceChangeListener() != null) {
                Activator.getDefault().getPreferenceStore().removePropertyChangeListener(this.getPreferenceChangeListener());
            }
        }
    }

    protected void showGrid() {
        this.getViewer().setProperty("SnapToGrid.isVisible", (Object)new Boolean(Activator.getDefault().getPreferenceStore().getBoolean("ShowGrid")));
    }

    public IPropertyChangeListener getPreferenceChangeListener() {
        if (this.listener == null) {
            this.listener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    event.getProperty().equals("SnapToGrid");
                    if (event.getProperty().equals("ShowGrid")) {
                        AbstractDiagramEditPart.this.showGrid();
                    }
                    if (event.getProperty().equals("GridSpacing")) {
                        AbstractDiagramEditPart.this.updateGrid();
                    }
                    if (event.getProperty().equals("ShowRulers")) {
                        AbstractDiagramEditPart.this.updateRuler();
                    }
                    if (event.getProperty().equals("ConnectionRouter")) {
                        AbstractDiagramEditPart.this.updateRouter();
                    }
                }
            };
        }
        return this.listener;
    }

    protected void updateRouter() {
        ConnectionLayer connLayer = (ConnectionLayer)this.getLayer("Connection Layer");
        connLayer.setConnectionRouter(RouterUtil.getConnectionRouter(this.getFigure()));
    }

    protected void updateGrid() {
        int gridSpacing = Activator.getDefault().getPreferenceStore().getInt("GridSpacing");
        this.getViewer().setProperty("SnapToGrid.GridSpacing", (Object)new Dimension(gridSpacing, gridSpacing));
    }

    public Object getAdapter(Class key) {
        if (key == SnapToHelper.class) {
            ArrayList<SnapToGrid> snapStrategies = new ArrayList<SnapToGrid>();
            Boolean val = Activator.getDefault().getPreferenceStore().getBoolean("SnapToGrid");
            if (val != null && val.booleanValue()) {
                snapStrategies.add(new SnapToGrid((GraphicalEditPart)this));
            }
            if (snapStrategies.size() == 0) {
                return null;
            }
            if (snapStrategies.size() == 1) {
                return snapStrategies.get(0);
            }
            SnapToHelper[] ss = new SnapToHelper[snapStrategies.size()];
            int i = 0;
            while (i < snapStrategies.size()) {
                ss[i] = (SnapToHelper)snapStrategies.get(i);
                ++i;
            }
            return new CompoundSnapToHelper(ss);
        }
        return super.getAdapter(key);
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Snap Feedback", (EditPolicy)new SnapFeedbackPolicy());
    }
}

