/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.export.forte1_0_x;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.export.ExportFilter;
import org.eclipse.fordiac.ide.export.forte1_0_x.StructuredTextEmitter;
import org.eclipse.fordiac.ide.export.utils.ExportException;
import org.eclipse.fordiac.ide.export.utils.IExportFilter;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterFBType;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterType;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.CompilableType;
import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.DataConnection;
import org.eclipse.fordiac.ide.model.libraryElement.ECState;
import org.eclipse.fordiac.ide.model.libraryElement.ECTransition;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.EventConnection;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceInterfaceFBType;
import org.eclipse.fordiac.ide.model.libraryElement.Value;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.VersionInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ForteExportFilter1_0_x
extends ExportFilter
implements IExportFilter {
    private String baseClass;
    private int fannedOutEventConns = 0;
    private int fannedOutDataConns = 0;
    private int numCompFBParams = 0;
    protected int eventInCount;
    protected int eventOutCount;
    protected int adapterCount;
    protected ArrayList<adapterInstance> adapters = new ArrayList();
    Vector<FB> internalFBs = new Vector();
    protected Vector<String> eventInputs = new Vector();
    private StructuredTextEmitter structuredTextEmitter = new StructuredTextEmitter(this);
    private Vector<ExportFilter.VarDefinition> initialValues = new Vector();
    private final ArrayList<String> anyVars = new ArrayList();
    private boolean inputWithsUsed;

    public ForteExportFilter1_0_x() {
    }

    public ForteExportFilter1_0_x(Document doc, String dest) {
        super(doc, dest);
    }

    public void addErrorMsg(String msg) {
        this.forteEmitterErrors.add(" - " + this.libraryType.getName() + ": " + msg);
    }

    public void addWarningMsg(String msg) {
        this.forteEmitterWarnings.add(" - " + this.libraryType.getName() + ": " + msg);
    }

    public void addInfoMsg(String msg) {
        this.forteEmitterInfos.add(" - " + this.libraryType.getName() + ": " + msg);
    }

    public Map<String, ExportFilter.VarDefinition> getVars() {
        return this.vars;
    }

    public ArrayList<adapterInstance> getAdapters() {
        return this.adapters;
    }

    protected void exportHeader() {
        String buf = "/*************************************************************************";
        this.pwH.println(buf);
        this.pwCPP.println(buf);
        buf = " *** FORTE Library Element";
        this.pwH.println(buf);
        this.pwCPP.println(buf);
        buf = " ***";
        this.pwH.println(buf);
        this.pwCPP.println(buf);
        buf = " *** This file was generated using the 4DIAC FORTE Export Filter V1.0.x!";
        this.pwH.println(buf);
        this.pwCPP.println(buf);
        buf = " ***";
        this.pwH.println(buf);
        this.pwCPP.println(buf);
        buf = " *** Name: " + this.name;
        this.pwH.println(buf);
        this.pwCPP.println(buf);
        buf = " *** Description: " + this.libraryType.getComment();
        this.pwH.println(buf);
        this.pwCPP.println(buf);
        buf = " *** Version: ";
        this.pwH.println(buf);
        this.pwCPP.println(buf);
        if (this.libraryType instanceof FBType && !((FBType)this.libraryType).getVersionInfo().isEmpty()) {
            int i = 0;
            while (i < ((FBType)this.libraryType).getVersionInfo().size()) {
                VersionInfo vi = (VersionInfo)((FBType)this.libraryType).getVersionInfo().get(i);
                buf = " ***     " + vi.getVersion() + ": " + vi.getDate() + "/" + vi.getAuthor() + " - " + vi.getOrganization() + " - " + vi.getRemarks();
                this.pwH.println(buf);
                this.pwCPP.println(buf);
                ++i;
            }
        }
        buf = " *************************************************************************/";
        this.pwH.println(buf);
        this.pwCPP.println(buf);
        buf = "\n#ifndef _" + this.libraryType.getName().toUpperCase() + "_H_";
        this.pwH.println(buf);
        buf = "#define _" + this.libraryType.getName().toUpperCase() + "_H_";
        this.pwH.println(buf);
        buf = "\n#include \"" + this.libraryType.getName() + ".h\"";
        this.pwCPP.println(buf);
        this.pwCPP.println("#ifdef FORTE_ENABLE_GENERATED_SOURCE_CPP");
        this.pwCPP.println("#include \"" + this.libraryType.getName() + "_gen.cpp\"");
        this.pwCPP.println("#endif");
        this.exportCompilerInfoHeaders();
    }

    private void exportCompilerInfoHeaders() {
        CompilableType type;
        if (this.libraryType instanceof CompilableType && (type = (CompilableType)this.libraryType).getCompilerInfo() != null && type.getCompilerInfo().getHeader() != null) {
            this.pwCPP.println(type.getCompilerInfo().getHeader());
        }
    }

    protected void exportClosingCode() {
        String buf = "\n};\n\n#endif //close the ifdef sequence from the beginning of the file\n";
        this.pwH.println(buf);
        buf = "\n";
        this.pwCPP.println(buf);
    }

    protected void exportFBStarter() {
        InterfaceList interfaceList = null;
        if (this.libraryType instanceof BasicFBType) {
            this.baseClass = "CBasicFB";
            this.pwH.println("\n#include <basicfb.h>");
            this.forteEmitterInfos.add("  - Creating header and source files for Basic Function Block " + this.libraryType.getName());
            interfaceList = ((FBType)this.libraryType).getInterfaceList();
        } else if (this.libraryType instanceof CompositeFBType) {
            this.pwH.println("\n#include <cfb.h>");
            this.pwH.println("#include <typelib.h>");
            this.baseClass = "CCompositeFB";
            this.forteEmitterInfos.add("  - Creating header and source files for Composite Function Block " + this.libraryType.getName());
            interfaceList = ((FBType)this.libraryType).getInterfaceList();
        } else if (this.libraryType instanceof ServiceInterfaceFBType) {
            this.pwH.println("\n#include <funcbloc.h>");
            this.baseClass = "CFunctionBlock";
            this.forteEmitterInfos.add("  - Creating header and source files for Service Interface Function Block " + this.name);
            interfaceList = ((FBType)this.libraryType).getInterfaceList();
        } else if (this.libraryType instanceof AdapterType) {
            this.pwH.println("\n#include <adapter.h>");
            this.pwH.println("#include <typelib.h>");
            this.baseClass = "CAdapter";
            this.forteEmitterInfos.add("  - Creating header and source files for Adapter Function Block " + this.libraryType.getName());
            interfaceList = ((AdapterType)this.libraryType).getInterfaceList();
        } else {
            this.forteEmitterErrors.add("  - FB is not of supported class {Basic Function Block, Composite Function Block, Service Interface Function Block}");
        }
        if (interfaceList != null) {
            int i;
            String[] x;
            HashSet<String> datatypeNames = new HashSet<String>();
            HashSet<String> adapterNames = new HashSet<String>();
            boolean lArrayUsed = false;
            lArrayUsed = ForteExportFilter1_0_x.extractDataTypeNames((EList<VarDeclaration>)interfaceList.getInputVars(), datatypeNames, lArrayUsed);
            lArrayUsed = ForteExportFilter1_0_x.extractDataTypeNames((EList<VarDeclaration>)interfaceList.getOutputVars(), datatypeNames, lArrayUsed);
            if (this.libraryType instanceof BasicFBType) {
                lArrayUsed = ForteExportFilter1_0_x.extractDataTypeNames((EList<VarDeclaration>)((BasicFBType)this.libraryType).getInternalVars(), datatypeNames, lArrayUsed);
            }
            if (!datatypeNames.isEmpty()) {
                x = datatypeNames.toArray(new String[0]);
                i = 0;
                while (i < x.length) {
                    this.pwH.println("#include <forte_" + x[i].toLowerCase() + ".h>");
                    if (x[i].startsWith("ANY")) {
                        this.pwH.println("\n#ERROR type contains variables of type ANY. Please check the usage of these variables as we can not gurantee correct usage on export!\n");
                    }
                    ++i;
                }
                if (lArrayUsed) {
                    this.pwH.println("#include <forte_array.h>");
                }
            }
            ForteExportFilter1_0_x.extractAdapterTypeNames((EList<AdapterDeclaration>)interfaceList.getPlugs(), adapterNames);
            ForteExportFilter1_0_x.extractAdapterTypeNames((EList<AdapterDeclaration>)interfaceList.getSockets(), adapterNames);
            if (!adapterNames.isEmpty()) {
                x = adapterNames.toArray(new String[0]);
                i = 0;
                while (i < x.length) {
                    this.pwH.println("#include \"" + x[i] + ".h\"");
                    ++i;
                }
            }
        }
        this.pwH.println("\nclass FORTE_" + this.name + ": public " + this.baseClass + "{");
        if (this.libraryType instanceof AdapterType) {
            this.pwH.print("  DECLARE_ADAPTER_TYPE");
        } else {
            this.pwH.print("  DECLARE_FIRMWARE_FB");
        }
        this.pwH.println("(FORTE_" + this.name + ")");
        this.pwH.println("\nprivate:");
        if (this.libraryType instanceof AdapterType) {
            this.pwCPP.print("\nDEFINE_ADAPTER_TYPE");
        } else {
            this.pwCPP.print("\nDEFINE_FIRMWARE_FB");
        }
        this.pwCPP.println("(FORTE_" + this.name + ", g_nStringId" + this.name + ")\n");
    }

    private static void extractAdapterTypeNames(EList<AdapterDeclaration> pa_Adapters, HashSet<String> pa_datatypeNames) {
        if (!pa_Adapters.isEmpty()) {
            int i = 0;
            while (i < pa_Adapters.size()) {
                pa_datatypeNames.add(((AdapterDeclaration)pa_Adapters.get(i)).getTypeName());
                ++i;
            }
        }
    }

    private static Boolean extractDataTypeNames(EList<VarDeclaration> pa_InputVars, HashSet<String> pa_datatypeNames, boolean pa_UsesArray) {
        if (!pa_InputVars.isEmpty()) {
            int i = 0;
            while (i < pa_InputVars.size()) {
                VarDeclaration var = (VarDeclaration)pa_InputVars.get(i);
                if (!(var instanceof AdapterDeclaration)) {
                    pa_datatypeNames.add(var.getTypeName());
                    if (var.isArray()) {
                        pa_UsesArray = true;
                    }
                }
                ++i;
            }
        }
        return pa_UsesArray;
    }

    protected void exportCompFBExecuteEventMethod() {
    }

    protected void exportSIFBExecuteEvent() {
        this.pwH.println("\n  void executeEvent(int pa_nEIID);");
        this.pwCPP.println("\nvoid FORTE_" + this.name + "::executeEvent(int pa_nEIID){");
        this.pwCPP.println("  switch(pa_nEIID){");
        int i = 0;
        while (i < this.eventInCount) {
            this.pwCPP.println("    case scm_nEvent" + this.eventInputs.elementAt(i) + "ID:");
            this.pwCPP.println("#error add code for " + this.eventInputs.elementAt(i) + " event!");
            this.pwCPP.println("/*\n  do not forget to send output event, calling e.g.\n      sendOutputEvent(scm_nEventCNFID);\n*/");
            this.pwCPP.println("      break;");
            ++i;
        }
        this.pwCPP.println("  }");
        this.pwCPP.println("}\n");
    }

    protected void exportFBNetworkInternalInterface() {
    }

    protected void exportFBConstructor() {
        this.pwH.println("\npublic:");
        if (this.baseClass.equals("CBasicFB")) {
            this.pwH.println("  FORTE_" + this.name + "(CStringDictionary::TStringId pa_nInstanceNameId, CResource *pa_poSrcRes) : ");
            this.pwH.print("       " + this.baseClass + "(pa_poSrcRes, &scm_stFBInterfaceSpec, pa_nInstanceNameId");
            if (this.internalCount != 0) {
                this.pwH.print(",\n           &scm_stInternalVars");
            } else {
                this.pwH.print(",\n              0");
            }
            this.pwH.print(", m_anFBConnData, m_anFBVarsData");
        } else {
            if (this.baseClass.equals("CCompositeFB")) {
                this.pwH.print("  COMPOSITE_FUNCTION_BLOCK_CTOR");
            } else if (this.libraryType instanceof AdapterType) {
                this.pwH.print("  ADAPTER_CTOR");
            } else {
                this.pwH.print("  FUNCTION_BLOCK_CTOR");
            }
            this.pwH.print("(FORTE_" + this.name);
        }
        this.pwH.print("){\n");
        this.pwH.println("  };\n");
        this.pwH.println("  virtual ~FORTE_" + this.name + "(){};");
    }

    protected void exportFBManagedObjectMethods() {
    }

    protected void exportResStarter() {
        this.baseClass = "CResource";
        this.pwH.println("\n#include <resource.h>");
        this.pwH.println("#include <class0objhand.h>");
        this.forteEmitterInfos.add("  - Creating header and source files for Resource " + this.name);
        this.exportResDevHeader();
        this.pwH.println("\nclass FORTE_" + this.name + ": public CResource{");
        this.pwH.println("  DECLARE_FIRMWARE_FB(FORTE_" + this.name + ")");
        this.pwH.println("\nprivate:");
        this.pwCPP.println("\nDEFINE_FIRMWARE_FB(FORTE_" + this.name + ", g_nStringId" + this.name + ");\n");
        this.exportVarInputs(this.docel);
        this.exportFBInterfaceSpec();
    }

    protected void exportResConstructor() {
        this.pwH.println("\n  C61499Class0ObjectHandler m_oClass0ObjectHandler;  //!< The object handler to be used for this resources");
        this.pwH.println("\npublic:");
        this.pwH.println("  FORTE_" + this.name + "(CStringDictionary::TStringId pa_nInstanceNameId, CResource* pa_poDevice);");
        this.pwH.println("  virtual ~FORTE_" + this.name + "(){};");
        this.pwCPP.println("FORTE_" + this.name + "::FORTE_" + this.name + "(CStringDictionary::TStringId pa_nInstanceNameId, CResource* pa_poDevice) : ");
        this.pwCPP.println("       CResource(pa_poDevice, &scm_stFBInterfaceSpec, pa_nInstanceNameId, m_oClass0ObjectHandler, m_anFBConnData, m_anFBVarsData),");
        this.pwCPP.println("       m_oClass0ObjectHandler(*this){");
        this.exportDevResElements("FB");
        this.exportResDevConnections(this.docel.getElementsByTagName("EventConnections"));
        this.exportResDevConnections(this.docel.getElementsByTagName("DataConnections"));
        this.pwCPP.println("}\n");
    }

    protected void exportDeviceStarter() {
        this.baseClass = "CDevice";
        this.pwH.println("\n#include <device.h>");
        this.pwH.println("#include <class1objhand.h>");
        this.forteEmitterInfos.add("  - Creating header and source files for Device " + this.name);
        this.exportResDevHeader();
        this.pwH.println("\nclass FORTE_" + this.name + ": public CDevice{");
        this.pwH.println("\nprivate:");
        this.exportVarInputs(this.docel);
        this.exportFBInterfaceSpec();
    }

    protected void exportDeviceConstructor() {
        this.pwH.println("\n  C61499Class1ObjectHandler m_oClass1ObjectHandler;  //!< The object handler to be used for this device");
        this.pwH.println("\npublic:");
        this.pwH.println("  FORTE_" + this.name + "();");
        this.pwH.println("  virtual ~FORTE_" + this.name + "(){};");
        this.pwCPP.println("FORTE_" + this.name + "::FORTE_" + this.name + "() : ");
        this.pwCPP.println("       CDevice(&scm_stFBInterfaceSpec, CStringDictionary::scm_nInvalidStringId, m_oClass1ObjectHandler, m_anFBConnData, m_anFBVarsData),");
        this.pwCPP.println("       m_oClass1ObjectHandler(*this){");
        this.exportDevResElements("Resource");
        this.exportResDevConnections(this.docel.getElementsByTagName("DataConnections"));
        this.pwCPP.println("}\n");
    }

    private void exportResDevHeader() {
        HashSet<String> resVarsTypes = new HashSet<String>();
        NodeList l1 = this.docel.getElementsByTagName("VarDeclaration");
        int i = 0;
        while (i < l1.getLength()) {
            Node node = l1.item(i);
            if (node instanceof Element) {
                Element el = (Element)node;
                resVarsTypes.add(el.getAttribute("Type"));
            }
            ++i;
        }
        for (String element : resVarsTypes) {
            this.pwH.println("#include <forte_" + element.toLowerCase() + ".h>");
        }
    }

    private void exportResDevConnections(NodeList l1) {
        Node node;
        if (l1.getLength() > 0 && (node = l1.item(0)) instanceof Element) {
            Element el = (Element)node;
            NodeList childs = el.getChildNodes();
            int i = 0;
            while (i < childs.getLength()) {
                Node childnode = childs.item(i);
                if (childnode instanceof Element) {
                    Element childel = (Element)childnode;
                    Object[] source = childel.getAttribute("Source").split("\\.");
                    Object[] dest = childel.getAttribute("Destination").split("\\.");
                    this.pwCPP.println(MessageFormat.format("  m_roObjectHandler.createConnection({0}, {1});", source.length == 2 ? MessageFormat.format("GENERATE_CONNECTION_PORT_ID_2_ARG(g_nStringId{0}, g_nStringId{1})", source) : MessageFormat.format("GENERATE_CONNECTION_PORT_ID_1_ARG(g_nStringId{0})", source), dest.length == 2 ? MessageFormat.format("GENERATE_CONNECTION_PORT_ID_2_ARG(g_nStringId{0}, g_nStringId{1})", dest) : MessageFormat.format("GENERATE_CONNECTION_PORT_ID_1_ARG(g_nStringId{0})", dest)));
                }
                ++i;
            }
        }
    }

    private void exportDevResElements(String elementType) {
        NodeList l1 = this.docel.getElementsByTagName(elementType);
        int i = 0;
        while (i < l1.getLength()) {
            Node node = l1.item(i);
            if (node instanceof Element) {
                Element el = (Element)node;
                this.pwCPP.println("  m_roObjectHandler.addFB(CTypeLib::createFB(g_nStringId" + el.getAttribute("Name") + ", g_nStringId" + el.getAttribute("Type") + ", this));");
                NodeList childs = el.getChildNodes();
                int j = 0;
                while (j < childs.getLength()) {
                    Node childnode = childs.item(j);
                    if (childnode instanceof Element) {
                        Element childel = (Element)childnode;
                        this.pwCPP.println(MessageFormat.format("  m_roObjectHandler.getFB(g_nStringId{0})->getDataInput(g_nStringId{1})->fromString(\"{2}\");", el.getAttribute("Name"), childel.getAttribute("Name"), childel.getAttribute("Value")));
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    protected void exportVarNameArrays(String namePrefix, NodeList nodes) {
        int count = 0;
        StringBuilder names = new StringBuilder();
        StringBuilder typenames = new StringBuilder();
        int len = nodes.getLength();
        int i = 0;
        while (i < len) {
            Element el;
            Node node = nodes.item(i);
            if (node instanceof Element && (el = (Element)node).getNodeName().equals("VarDeclaration")) {
                if (++count != 1) {
                    names.append(", ");
                    typenames.append(", ");
                }
                names.append("g_nStringId");
                names.append(el.getAttribute("Name"));
                String arraySize = el.getAttribute("ArraySize");
                if (arraySize != null && !arraySize.equals("")) {
                    typenames.append("g_nStringIdARRAY, ");
                    typenames.append(arraySize);
                    typenames.append(", ");
                }
                typenames.append("g_nStringId");
                typenames.append(el.getAttribute("Type"));
            }
            ++i;
        }
        if (count != 0) {
            if (this.libraryType instanceof AdapterType) {
                this.pwH.println(" private:");
            }
            this.pwH.println("  static const CStringDictionary::TStringId scm_an" + namePrefix + "Names[];");
            this.pwCPP.println("const CStringDictionary::TStringId FORTE_" + this.name + "::scm_an" + namePrefix + "Names[] = {" + names.toString() + "};\n");
            this.pwH.println("  static const CStringDictionary::TStringId scm_an" + namePrefix + "TypeIds[];");
            this.pwCPP.println("const CStringDictionary::TStringId FORTE_" + this.name + "::scm_an" + namePrefix + "TypeIds[] = {" + typenames + "};\n");
            if (this.libraryType instanceof AdapterType) {
                this.pwH.println(" public:");
            }
        }
    }

    protected void exportEvents(String namePrefix, NodeList nodes, List<String> varNames) {
        int nowithcount;
        int startindex;
        int count = 0;
        String names = "";
        String withs = "";
        String withIndexes = "";
        int[] withcount = new int[varNames.size()];
        int i = 0;
        while (i < varNames.size()) {
            withcount[i] = 0;
            ++i;
        }
        int indexCount = 0;
        int len = nodes.getLength();
        if (this.libraryType instanceof AdapterType && !namePrefix.equals("EventInputs")) {
            this.pwH.println(" public:");
        }
        int i2 = 0;
        while (i2 < len) {
            Element el;
            Node node = nodes.item(i2);
            if (node instanceof Element && (el = (Element)node).getNodeName().equals("Event")) {
                this.exportEventID(el.getAttribute("Name"), count);
                if (++count != 1) {
                    names = String.valueOf(names) + ", ";
                    withIndexes = String.valueOf(withIndexes) + ", ";
                }
                names = String.valueOf(names) + "g_nStringId" + el.getAttribute("Name");
                if (namePrefix.equals("EventInput")) {
                    this.eventInputs.add(el.getAttribute("Name"));
                }
                NodeList eventChilds = el.getChildNodes();
                int childsLen = eventChilds.getLength();
                int eventwithcount = 0;
                startindex = indexCount;
                int j = 0;
                while (j < childsLen) {
                    Element childElement;
                    Node childNode = eventChilds.item(j);
                    if (childNode instanceof Element && (childElement = (Element)childNode).getNodeName().equals("With")) {
                        int pos;
                        String var = childElement.getAttribute("Var");
                        int n = pos = varNames.indexOf(var);
                        withcount[n] = withcount[n] + 1;
                        if (indexCount != 0) {
                            withs = String.valueOf(withs) + ", ";
                        }
                        withs = String.valueOf(withs) + pos;
                        ++indexCount;
                        ++eventwithcount;
                    }
                    ++j;
                }
                if (eventwithcount == 0) {
                    withIndexes = String.valueOf(withIndexes) + "-1";
                } else {
                    withs = String.valueOf(withs) + ", 255";
                    ++indexCount;
                    withIndexes = String.valueOf(withIndexes) + startindex;
                }
            }
            ++i2;
        }
        if (this.libraryType instanceof AdapterType) {
            this.pwH.println(" private:");
        }
        if (namePrefix.equals("EventOutput")) {
            this.eventOutCount = count;
            this.pwH.println("  static const TForteInt16 scm_anEOWithIndexes[];");
            if (count != 0) {
                if (this.dataOutCount != 0) {
                    nowithcount = 0;
                    startindex = indexCount;
                    int i3 = 0;
                    while (i3 < this.dataOutCount) {
                        if (withcount[i3] == 0) {
                            if (indexCount != 0) {
                                withs = String.valueOf(withs) + ", ";
                            }
                            withs = String.valueOf(withs) + i3;
                            ++nowithcount;
                            ++indexCount;
                        }
                        ++i3;
                    }
                    if (nowithcount == 0) {
                        withIndexes = String.valueOf(withIndexes) + ", -1";
                    } else {
                        withs = String.valueOf(withs) + ", 255";
                        withIndexes = String.valueOf(withIndexes) + ", " + startindex;
                    }
                    this.pwH.println("  static const TDataIOID scm_anEOWith[];");
                    this.pwCPP.println("const TDataIOID FORTE_" + this.name + "::scm_anEOWith[] = {" + withs + "};");
                } else {
                    withIndexes = String.valueOf(withIndexes) + ", -1";
                }
            } else if (this.dataOutCount != 0) {
                this.pwH.println("  static const TDataIOID scm_anEOWith[];");
                i2 = 0;
                while (i2 < this.dataOutCount) {
                    withs = String.valueOf(withs) + i2 + ", ";
                    ++i2;
                }
                withs = String.valueOf(withs) + "255";
                this.pwCPP.println("const TDataIOID FORTE_" + this.name + "::scm_anEOWith[] = {" + withs + "};");
                withIndexes = String.valueOf(withIndexes) + "0";
            } else {
                withIndexes = String.valueOf(withIndexes) + "-1";
            }
            this.pwCPP.println("const TForteInt16 FORTE_" + this.name + "::scm_anEOWithIndexes[] = {" + withIndexes + "};");
        } else {
            this.eventInCount = count;
            if (this.libraryType instanceof AdapterType) {
                this.pwH.println("  static const TForteInt16 scm_anEIWithIndexes[];");
                if (count != 0) {
                    if (this.dataInCount != 0) {
                        nowithcount = 0;
                        startindex = indexCount;
                        int i4 = 0;
                        while (i4 < this.dataInCount) {
                            if (withcount[i4] == 0) {
                                if (indexCount != 0) {
                                    withs = String.valueOf(withs) + ", ";
                                }
                                withs = String.valueOf(withs) + i4;
                                ++nowithcount;
                                ++indexCount;
                            }
                            ++i4;
                        }
                        if (nowithcount == 0) {
                            withIndexes = String.valueOf(withIndexes) + ", -1";
                        } else {
                            withs = String.valueOf(withs) + ", 255";
                            withIndexes = String.valueOf(withIndexes) + ", " + startindex;
                        }
                        this.pwH.println("  static const TDataIOID scm_anEIWith[];");
                        this.pwCPP.println("const TDataIOID FORTE_" + this.name + "::scm_anEIWith[] = {" + withs + "};");
                    } else {
                        withIndexes = String.valueOf(withIndexes) + ", -1";
                    }
                } else if (this.dataInCount != 0) {
                    this.pwH.println("  static const TDataIOID scm_anEIWith[];");
                    i2 = 0;
                    while (i2 < this.dataInCount) {
                        withs = String.valueOf(withs) + i2 + ", ";
                        ++i2;
                    }
                    withs = String.valueOf(withs) + "255";
                    this.pwCPP.println("const TDataIOID FORTE_" + this.name + "::scm_anEIWith[] = {" + withs + "};");
                    withIndexes = String.valueOf(withIndexes) + "0";
                } else {
                    withIndexes = String.valueOf(withIndexes) + "-1";
                }
                this.pwCPP.println("const TForteInt16 FORTE_" + this.name + "::scm_anEIWithIndexes[] = {" + withIndexes + "};");
            } else if (count != 0) {
                this.pwH.println("  static const TForteInt16 scm_anEIWithIndexes[];");
                this.pwCPP.println("const TForteInt16 FORTE_" + this.name + "::scm_anEIWithIndexes[] = {" + withIndexes + "};");
                if (this.dataInCount != 0 && withs.length() != 0) {
                    this.pwH.println("  static const TDataIOID scm_anEIWith[];");
                    this.pwCPP.println("const TDataIOID FORTE_" + this.name + "::scm_anEIWith[] = {" + withs + "};");
                }
            }
            if (this.dataInCount != 0) {
                boolean bl = this.inputWithsUsed = withs.length() != 0;
            }
        }
        if (count != 0) {
            this.pwH.println("  static const CStringDictionary::TStringId scm_an" + namePrefix + "Names[];\n");
            this.pwCPP.println("const CStringDictionary::TStringId FORTE_" + this.name + "::scm_an" + namePrefix + "Names[] = {" + names + "};\n");
        }
    }

    private void exportEventID(String evName, int count) {
        this.pwH.println("  static const TEventID scm_nEvent" + evName + "ID = " + Integer.toString(count) + ";");
        if (this.libraryType instanceof AdapterType) {
            this.pwH.println("  int " + evName + "() {");
            this.pwH.println("    return m_nParentAdapterListEventID + scm_nEvent" + evName + "ID;");
            this.pwH.println("  }");
        }
    }

    protected void exportAlgorithm(String algName, String type, String src) {
        this.pwH.println("  void alg_" + algName + "(void);");
        this.pwCPP.println("void FORTE_" + this.name + "::alg_" + algName + "(void){");
        if (type.equals("ST")) {
            this.structuredTextEmitter.exportStructuredTextAlgorithm(src, this.pwCPP);
        } else {
            this.pwCPP.println("#error Algorithm of type: '" + type + "' not supported!!!");
            this.pwCPP.println(src);
        }
        this.pwCPP.println("\n}\n");
    }

    protected void exportVariable(ExportFilter.VarDefinition newVarDef) {
        this.createVarAccessoryFunction(newVarDef);
        if (newVarDef.arraySizeValue > 0) {
            ExportFilter.VarDefinition arraydef = newVarDef;
            arraydef.arraySizeValue = 0;
            arraydef.name = String.valueOf(newVarDef.name) + "_Array";
            arraydef.type = "ARRAY";
            this.createVarAccessoryFunction(arraydef);
        }
        if (newVarDef.initialValue != null && !newVarDef.initialValue.isEmpty()) {
            this.initialValues.add(newVarDef);
        }
    }

    private void createVarAccessoryFunction(ExportFilter.VarDefinition newVarDef) {
        this.pwH.print("  CIEC_" + newVarDef.type + " ");
        if (newVarDef.arraySizeValue < 1) {
            this.pwH.print("&");
        } else {
            this.pwH.print("*");
        }
        this.pwH.println(String.valueOf(newVarDef.name) + "() {");
        this.pwH.print("    return ");
        if (newVarDef.arraySizeValue < 1) {
            this.pwH.print("*static_cast<CIEC_" + newVarDef.type + "*>(");
        } else {
            this.pwH.print("(CIEC_" + newVarDef.type + "*)(*static_cast<CIEC_ARRAY *>(");
        }
        if (this.libraryType instanceof AdapterType) {
            this.pwH.print("(isSocket()) ? ");
        }
        this.pwH.print("get");
        switch (newVarDef.inoutinternal) {
            case 0: {
                this.pwH.print("DI");
                break;
            }
            case 1: {
                this.pwH.print("DO");
                break;
            }
            case 2: {
                this.pwH.print("VarInternal");
                break;
            }
        }
        this.pwH.print("(" + Integer.toString(newVarDef.count) + ")");
        if (this.libraryType instanceof AdapterType) {
            this.pwH.print(" : get");
            switch (newVarDef.inoutinternal) {
                case 0: {
                    this.pwH.print("DO");
                    break;
                }
                case 1: {
                    this.pwH.print("DI");
                    break;
                }
            }
            this.pwH.print("(" + Integer.toString(newVarDef.count) + ")");
        }
        this.pwH.print(")");
        if (newVarDef.arraySizeValue < 1) {
            this.pwH.println(";\n  };\n");
        } else {
            this.pwH.println(")[0]; //the first element marks the start of the array\n  };\n");
        }
    }

    protected void exportFBVar() {
        if (this.libraryType instanceof CompositeFBType) {
            FBNetwork fbNetwork = ((CompositeFBType)this.libraryType).getFBNetwork();
            EList allIntFBs = fbNetwork.getNetworkElements();
            int i = 0;
            while (i < allIntFBs.size() - this.adapterCount) {
                if (((FBNetworkElement)allIntFBs.get(i)).getType() instanceof AdapterFBType) {
                    allIntFBs.move(allIntFBs.size() - 1, i);
                    --i;
                }
                ++i;
            }
            if (allIntFBs.size() - this.adapterCount > 0) {
                this.exportCFBFBs((EList<FBNetworkElement>)allIntFBs);
            }
            this.exportCFBParams((EList<FBNetworkElement>)allIntFBs);
            this.exportCFBEventConns((EList<EventConnection>)fbNetwork.getEventConnections(), (EList<FBNetworkElement>)allIntFBs);
            this.exportCFBDataConns((EList<DataConnection>)fbNetwork.getDataConnections(), (EList<FBNetworkElement>)allIntFBs);
            this.pwH.println("  static const SCFB_FBNData scm_stFBNData;");
            this.pwCPP.println("\nconst SCFB_FBNData FORTE_" + this.name + "::scm_stFBNData = {");
            if (allIntFBs.size() - this.adapterCount > 0) {
                this.pwCPP.println("  " + (allIntFBs.size() - this.adapterCount) + ", scm_astInternalFBs,");
            } else {
                this.pwCPP.println("  0, 0,");
            }
            if (!fbNetwork.getEventConnections().isEmpty()) {
                this.pwCPP.println("  " + (fbNetwork.getEventConnections().size() - this.fannedOutEventConns) + ", scm_astEventConnections,");
                if (this.fannedOutEventConns != 0) {
                    this.pwCPP.println("  " + this.fannedOutEventConns + ", scm_astFannedOutEventConnections,");
                } else {
                    this.pwCPP.println("  0, 0,");
                }
            } else {
                this.pwCPP.println("  0, 0,");
                this.pwCPP.println("  0, 0,");
            }
            if (!fbNetwork.getDataConnections().isEmpty()) {
                this.pwCPP.println("  " + (fbNetwork.getDataConnections().size() - this.fannedOutDataConns) + ", scm_astDataConnections,");
                if (this.fannedOutDataConns != 0) {
                    this.pwCPP.println("  " + this.fannedOutDataConns + ", scm_astFannedOutDataConnections,");
                } else {
                    this.pwCPP.println("  0, 0,");
                }
            } else {
                this.pwCPP.println("  0, 0,");
                this.pwCPP.println("  0, 0,");
            }
            if (this.numCompFBParams != 0) {
                this.pwCPP.println("  " + this.numCompFBParams + ", scm_astParamters");
            } else {
                this.pwCPP.println("  0, 0");
            }
            this.pwCPP.println("};");
        }
    }

    protected void exportEC() {
    }

    protected void exportDC() {
    }

    private AdapterFBType findAdapterType(AdapterDeclaration paAdapter) {
        DataType myDT = paAdapter.getType();
        AdapterType myAT = null;
        if (myDT instanceof AdapterType) {
            myAT = (AdapterType)myDT;
            return myAT.getAdapterFBType();
        }
        return null;
    }

    protected void exportFBInterfaceSpec() {
        if (this.libraryType != null) {
            InterfaceList interfaceList = null;
            if (this.libraryType instanceof FBType) {
                interfaceList = ((FBType)this.libraryType).getInterfaceList();
            } else if (this.libraryType instanceof AdapterType) {
                interfaceList = ((AdapterType)this.libraryType).getInterfaceList();
            }
            if (interfaceList != null) {
                adapterInstance myLocalAdapterInst;
                EList myPlugs = interfaceList.getPlugs();
                EList mySockets = interfaceList.getSockets();
                this.adapterCount = myPlugs.size() + mySockets.size();
                int i = 0;
                while (i < myPlugs.size()) {
                    myLocalAdapterInst = new adapterInstance();
                    myLocalAdapterInst.stName = ((AdapterDeclaration)myPlugs.get(i)).getName();
                    myLocalAdapterInst.stAdapterType = ((AdapterDeclaration)myPlugs.get(i)).getTypeName();
                    myLocalAdapterInst.bIsPlug = true;
                    myLocalAdapterInst.oAdapterFBType = this.findAdapterType((AdapterDeclaration)myPlugs.get(i));
                    this.adapters.add(myLocalAdapterInst);
                    ++i;
                }
                i = 0;
                while (i < mySockets.size()) {
                    myLocalAdapterInst = new adapterInstance();
                    myLocalAdapterInst.stName = ((AdapterDeclaration)mySockets.get(i)).getName();
                    myLocalAdapterInst.stAdapterType = ((AdapterDeclaration)mySockets.get(i)).getTypeName();
                    myLocalAdapterInst.bIsPlug = false;
                    myLocalAdapterInst.oAdapterFBType = this.findAdapterType((AdapterDeclaration)mySockets.get(i));
                    this.adapters.add(myLocalAdapterInst);
                    ++i;
                }
                if (this.adapterCount > 0) {
                    this.pwH.println("  static const SAdapterInstanceDef scm_astAdapterInstances[];\n");
                    this.pwCPP.println("const SAdapterInstanceDef FORTE_" + this.name + "::scm_astAdapterInstances[] = {");
                    i = 0;
                    while (i < this.adapters.size()) {
                        adapterInstance myAdapter = this.adapters.get(i);
                        if (i > 0) {
                            this.pwCPP.println(",");
                        }
                        this.pwCPP.print("{g_nStringId" + myAdapter.stAdapterType + ", " + "g_nStringId" + myAdapter.stName + ", ");
                        if (myAdapter.bIsPlug) {
                            this.pwCPP.print("true }");
                        } else {
                            this.pwCPP.print("false }");
                        }
                        this.pwH.print("  FORTE_" + myAdapter.stAdapterType + "& " + myAdapter.stName + "() {\n" + "    return (*static_cast<FORTE_" + myAdapter.stAdapterType + "*>(m_apoAdapters[" + i + "]));\n  };\n");
                        this.pwH.println("  static const int scm_n" + myAdapter.stName + "AdpNum = " + i + ";");
                        ++i;
                    }
                    this.pwCPP.println("};\n");
                }
            }
        }
        if (this.libraryType instanceof AdapterType) {
            this.pwH.println("  static const SFBInterfaceSpec scm_stFBInterfaceSpecSocket;\n");
            this.pwCPP.println("const SFBInterfaceSpec FORTE_" + this.name + "::scm_stFBInterfaceSpecSocket = {");
        } else {
            this.pwH.println("  static const SFBInterfaceSpec scm_stFBInterfaceSpec;\n");
            this.pwCPP.println("const SFBInterfaceSpec FORTE_" + this.name + "::scm_stFBInterfaceSpec = {");
        }
        this.pwCPP.print("  " + this.eventInCount + ",");
        if (this.eventInCount != 0) {
            this.pwCPP.print("  scm_anEventInputNames,");
            if (this.dataInCount != 0 && this.inputWithsUsed) {
                this.pwCPP.print("  scm_anEIWith,");
            } else {
                this.pwCPP.print("  0,");
            }
            this.pwCPP.println("  scm_anEIWithIndexes,");
        } else {
            this.pwCPP.print("  0,");
            this.pwCPP.print("  0,");
            this.pwCPP.println("  0,");
        }
        this.pwCPP.print("  " + this.eventOutCount + ",");
        if (this.eventOutCount != 0) {
            this.pwCPP.print("  scm_anEventOutputNames,");
        } else {
            this.pwCPP.print("  0, ");
        }
        if (this.dataOutCount != 0) {
            this.pwCPP.print("  scm_anEOWith, scm_anEOWithIndexes,");
        } else {
            this.pwCPP.print("  0, 0,");
        }
        this.pwCPP.print("  " + this.dataInCount + ",");
        if (this.dataInCount != 0) {
            this.pwCPP.println("  scm_anDataInputNames, scm_anDataInputTypeIds,");
        } else {
            this.pwCPP.println("  0, 0, ");
        }
        this.pwCPP.print("  " + this.dataOutCount + ",");
        if (this.dataOutCount != 0) {
            this.pwCPP.println("  scm_anDataOutputNames, scm_anDataOutputTypeIds,");
        } else {
            this.pwCPP.println("  0, 0,");
        }
        this.pwCPP.print("  " + this.adapterCount + ",");
        if (this.adapterCount > 0) {
            this.pwCPP.print("scm_astAdapterInstances};");
        } else {
            this.pwCPP.print(" 0\n};");
        }
        this.pwCPP.println("\n");
        if (this.baseClass.equals("CBasicFB") && this.internalCount != 0) {
            this.pwH.println("\n  static const SInternalVarsInformation scm_stInternalVars;\n");
            this.pwCPP.println("\nconst SInternalVarsInformation FORTE_" + this.name + "::scm_stInternalVars = {" + this.internalCount + ", scm_anInternalsNames, scm_anInternalsTypeIds};\n");
        }
        if (this.libraryType instanceof AdapterType) {
            this.pwH.println("  static const SFBInterfaceSpec scm_stFBInterfaceSpecPlug;\n");
            this.pwCPP.println("const SFBInterfaceSpec FORTE_" + this.name + "::scm_stFBInterfaceSpecPlug = {");
            this.pwCPP.print("  " + this.eventOutCount + ",");
            if (this.eventOutCount != 0) {
                this.pwCPP.print("  scm_anEventOutputNames,");
                if (this.dataOutCount != 0) {
                    this.pwCPP.print("  scm_anEOWith,");
                } else {
                    this.pwCPP.print("  0,");
                }
                this.pwCPP.println("  scm_anEOWithIndexes,");
            } else {
                this.pwCPP.print("  0,");
                this.pwCPP.print("  0,");
                this.pwCPP.println("  0,");
            }
            this.pwCPP.print("  " + this.eventInCount + ",");
            if (this.eventInCount != 0) {
                this.pwCPP.print("  scm_anEventInputNames,");
            } else {
                this.pwCPP.print("  0, ");
            }
            if (this.dataInCount != 0) {
                this.pwCPP.print("  scm_anEIWith, scm_anEIWithIndexes,");
            } else {
                this.pwCPP.print("  0, 0,");
            }
            this.pwCPP.print("  " + this.dataOutCount + ",");
            if (this.dataOutCount != 0) {
                this.pwCPP.println("  scm_anDataOutputNames, scm_anDataOutputTypeIds,");
            } else {
                this.pwCPP.println("  0, 0, ");
            }
            this.pwCPP.print("  " + this.dataInCount + ",");
            if (this.dataInCount != 0) {
                this.pwCPP.println("  scm_anDataInputNames, scm_anDataInputTypeIds,");
            } else {
                this.pwCPP.println("  0, 0,");
            }
            this.pwCPP.print("  " + this.adapterCount + ",");
            if (this.adapterCount > 0) {
                this.pwCPP.print("scm_astAdapterInstances};");
            } else {
                this.pwCPP.print(" 0\n};");
            }
            this.pwCPP.println("\n");
        }
        this.exportFBDataArray();
        if (!this.initialValues.isEmpty()) {
            this.exportInitialValues();
        }
    }

    protected void exportECC(Element eccNode) {
        Element el;
        Node node;
        NodeList nodes = eccNode.getChildNodes();
        int alglen = nodes.getLength();
        int stateCount = 0;
        int ii = 0;
        while (ii < alglen) {
            node = nodes.item(ii);
            if (node instanceof Element && (el = (Element)node).getNodeName().equals("ECState")) {
                this.pwH.println("  static const TForteInt16 scm_nState" + el.getAttribute("Name") + " = " + stateCount + ";");
                ++stateCount;
            }
            ++ii;
        }
        this.pwH.println("");
        this.pwCPP.println("");
        ii = 0;
        while (ii < alglen) {
            node = nodes.item(ii);
            if (node instanceof Element && (el = (Element)node).getNodeName().equals("ECState")) {
                this.emitEnterState(el.getAttribute("Name"), el.getChildNodes());
            }
            ++ii;
        }
        --stateCount;
        this.pwH.println("\n  virtual void executeEvent(int pa_nEIID);");
        this.pwCPP.println("void FORTE_" + this.name + "::executeEvent(int pa_nEIID){");
        this.pwCPP.println("  bool bTransitionCleared;");
        this.pwCPP.println("  do{");
        this.pwCPP.println("    bTransitionCleared = true;");
        this.pwCPP.println("    switch(m_nECCState){");
        ii = 0;
        while (ii < alglen) {
            node = nodes.item(ii);
            if (node instanceof Element && (el = (Element)node).getNodeName().equals("ECState")) {
                String stateName = el.getAttribute("Name");
                this.pwCPP.println("      case scm_nState" + stateName + ":");
                this.emitStateTransitions(this.getStateNamed(stateName));
                this.pwCPP.println("          bTransitionCleared  = false; //no transition cleared");
                this.pwCPP.println("        break;");
            }
            ++ii;
        }
        this.pwCPP.println("      default:");
        this.pwCPP.println("      DEVLOG_ERROR(\"The state is not in the valid range! The state value is: %d. The max value can be: " + stateCount + ".\", m_nECCState.operator TForteUInt16 ());");
        this.pwCPP.println("        m_nECCState = 0; //0 is always the initial state");
        this.pwCPP.println("        break;");
        this.pwCPP.println("    }");
        this.pwCPP.println("    pa_nEIID = cg_nInvalidEventID;  // we have to clear the event after the first check in order to ensure correct behavior");
        this.pwCPP.println("  }while(bTransitionCleared);");
        this.pwCPP.println("}");
    }

    private void emitEnterState(String stateName, NodeList actionNodes) {
        this.pwH.println("  void enterState" + stateName + "(void);");
        this.pwCPP.println("void FORTE_" + this.name + "::enterState" + stateName + "(void){");
        this.pwCPP.println("  m_nECCState = scm_nState" + stateName + ";");
        int actionlen = actionNodes.getLength();
        int ii = 0;
        while (ii < actionlen) {
            Element el;
            Node node = actionNodes.item(ii);
            if (node instanceof Element && (el = (Element)node).getNodeName().equals("ECAction")) {
                String buf = el.getAttribute("Algorithm");
                if (!buf.equals("")) {
                    this.pwCPP.println("  alg_" + buf + "();");
                }
                if (!(buf = el.getAttribute("Output")).equals("")) {
                    if (buf.contains(".")) {
                        String[] adapterevent = buf.split("\\.", 2);
                        this.pwCPP.println("  sendAdapterEvent(scm_n" + adapterevent[0] + "AdpNum, FORTE_" + this.getAdapterTypeName(adapterevent[0]) + "::scm_nEvent" + adapterevent[1] + "ID);");
                    } else {
                        this.pwCPP.println("  sendOutputEvent( scm_nEvent" + buf + "ID);");
                    }
                }
            }
            ++ii;
        }
        this.pwCPP.println("}\n");
    }

    private String getAdapterTypeName(String string) {
        InterfaceList interfaceList = ((FBType)this.libraryType).getInterfaceList();
        for (AdapterDeclaration adapter : interfaceList.getPlugs()) {
            if (!adapter.getName().equals(string)) continue;
            return adapter.getTypeName();
        }
        for (AdapterDeclaration adapter : interfaceList.getSockets()) {
            if (!adapter.getName().equals(string)) continue;
            return adapter.getTypeName();
        }
        return "";
    }

    private ECState getStateNamed(String stateName) {
        for (ECState state : ((BasicFBType)this.libraryType).getECC().getECState()) {
            if (!state.getName().equals(stateName)) continue;
            return state;
        }
        return null;
    }

    private void emitStateTransitions(ECState state) {
        if (state != null) {
            String alternativeGuard = "";
            String alternativeEvent = "";
            for (ECTransition transition : state.getOutTransitions()) {
                String event = transition.getConditionEvent() != null ? transition.getConditionEvent().getName() : "";
                String guard = transition.getConditionExpression();
                if (event.length() == 0 && guard.length() == 0) continue;
                this.pwCPP.print("        if(");
                if (event.length() != 0) {
                    if (guard.length() != 0) {
                        this.pwCPP.print("(");
                    }
                    if (event.contains(".")) {
                        String[] adapterevent = event.split("\\.", 2);
                        this.pwCPP.print(String.valueOf(adapterevent[0]) + "()." + adapterevent[1] + "()");
                    } else {
                        this.pwCPP.print("scm_nEvent" + event + "ID");
                    }
                    this.pwCPP.print(" == pa_nEIID");
                    if (guard.length() != 0) {
                        this.pwCPP.print(") && ((");
                        this.emitGuardCondition(guard);
                        this.pwCPP.print("))");
                    }
                } else {
                    StringTokenizer mySTok2;
                    String myTestString2;
                    AdapterFBType myAd;
                    boolean AdapterEvent = false;
                    StringTokenizer mySTok = new StringTokenizer(guard, "&", true);
                    String myTestString = new String();
                    if (mySTok.hasMoreTokens()) {
                        myTestString = mySTok.nextToken();
                    }
                    if (myTestString.contains(".") && (myAd = this.checkIfAdapter(myTestString2 = (mySTok2 = new StringTokenizer(myTestString, ".", false)).nextToken())) != null) {
                        alternativeEvent = String.valueOf(myTestString2) + "().";
                        if (mySTok2.hasMoreTokens()) {
                            String myTest4Event = mySTok2.nextToken();
                            myTest4Event = myTest4Event.trim();
                            InterfaceList myIL = myAd.getInterfaceList();
                            Event myEv = null;
                            EList myIEvents = myIL.getEventInputs();
                            EList myOEvents = myIL.getEventOutputs();
                            for (Event Test4Event : myIEvents) {
                                if (!Test4Event.getName().equals(myTest4Event)) continue;
                                myEv = Test4Event;
                                break;
                            }
                            if (myEv == null) {
                                for (Event Test4Event : myOEvents) {
                                    if (!Test4Event.getName().equals(myTest4Event)) continue;
                                    myEv = Test4Event;
                                    break;
                                }
                            }
                            if (myEv != null) {
                                alternativeEvent = String.valueOf(alternativeEvent) + myTest4Event + "()";
                                AdapterEvent = true;
                                if (mySTok.hasMoreTokens()) {
                                    myTestString = mySTok.nextToken();
                                }
                                alternativeGuard = "";
                                while (mySTok.hasMoreTokens()) {
                                    alternativeGuard = String.valueOf(alternativeGuard) + mySTok.nextToken();
                                }
                            }
                        }
                    }
                    if (AdapterEvent) {
                        if (alternativeGuard.length() != 0) {
                            this.pwCPP.print("(");
                        }
                        this.pwCPP.print(String.valueOf(alternativeEvent) + " == pa_nEIID");
                        if (alternativeGuard.length() != 0) {
                            this.pwCPP.print(") && ((");
                            this.emitGuardCondition(alternativeGuard);
                            this.pwCPP.print("))");
                        }
                    } else {
                        this.emitGuardCondition(guard);
                    }
                }
                this.pwCPP.println(")");
                this.pwCPP.println("          enterState" + transition.getDestination().getName() + "();");
                this.pwCPP.println("        else");
            }
        }
    }

    private AdapterFBType checkIfAdapter(String Name) {
        for (adapterInstance myAdapterInfo : this.adapters) {
            if (!myAdapterInfo.stName.equals(Name)) continue;
            return myAdapterInfo.oAdapterFBType;
        }
        return null;
    }

    private void emitGuardCondition(String guard) {
        if (guard.contains("&") || guard.toUpperCase().contains("AND")) {
            this.pwCPP.print("(");
        }
        this.structuredTextEmitter.exportGuardCondition(guard, this.pwCPP);
        if (guard.contains("&") || guard.toUpperCase().contains("AND")) {
            this.pwCPP.print(")");
        }
    }

    public void export(IFile typeFile, String destination, boolean forceOverwrite) throws ExportException {
        this.eventInCount = 0;
        this.eventOutCount = 0;
        this.eventInputs = new Vector();
        this.adapterCount = 0;
        this.adapters.clear();
        this.initialValues.clear();
        this.anyVars.clear();
        if (typeFile.exists()) {
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setNamespaceAware(false);
                dbf.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", Boolean.FALSE);
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document document = db.parse(typeFile.getContents());
                this.docel = document.getDocumentElement();
                ForteExportFilter1_0_x.convertToLibraryElement2((Element)this.docel);
                this.destDir = destination;
                this.name = this.docel.getAttribute("Name");
                this.startExport(forceOverwrite);
            }
            catch (Exception e) {
                this.forteEmitterErrors.add(" - " + this.name + " " + e.getMessage() + " (" + typeFile.getName() + ")");
            }
        }
    }

    protected void handleNotPresentEOTag() {
        StringBuilder withs = new StringBuilder();
        String withIndexes = "-1";
        if (this.dataOutCount != 0) {
            this.pwH.println("  static const TDataIOID scm_anEOWith[];");
            int i = 0;
            while (i < this.dataOutCount) {
                withs.append(i);
                withs.append(", ");
                ++i;
            }
            withs.append("255");
            this.pwCPP.println("const TDataIOID FORTE_" + this.name + "::scm_anEOWith[] = {" + withs.toString() + "};");
            withIndexes = "0";
        }
        this.pwH.println("  static const TForteInt16 scm_anEOWithIndexes[];");
        this.pwCPP.println("const TForteInt16 FORTE_" + this.name + "::scm_anEOWithIndexes[] = {" + withIndexes + "};");
    }

    int getInputIdForContainedFB(String name, String paramName) {
        int retVal = 0;
        FBNetwork containedNetwork = ((CompositeFBType)this.libraryType).getFBNetwork();
        EList inputs = containedNetwork.getFBNamed(name).getInterface().getInputVars();
        for (VarDeclaration var : inputs) {
            if (var.getName().equals(paramName)) {
                return retVal;
            }
            ++retVal;
        }
        return -1;
    }

    public String getExportFilterDescription() {
        return "FORTE Export for FORTE 1.x";
    }

    public String getExportFilterName() {
        return "FORTE 1.x";
    }

    private void exportInitialValues() {
        this.pwH.println("\nvirtual void setInitialValues();");
        this.pwCPP.println("\nvoid FORTE_" + this.name + "::setInitialValues(){");
        for (ExportFilter.VarDefinition var : this.initialValues) {
            if (var.initialValue.isEmpty()) continue;
            this.pwCPP.print("  " + var.name + "()");
            if (var.type.equals("STRING") || var.type.equals("WSTRING")) {
                this.pwCPP.println(" = \"" + var.initialValue + "\";");
                continue;
            }
            if (var.type.equals("ARRAY")) {
                this.pwCPP.println(".fromString(\"" + var.initialValue + "\");");
                continue;
            }
            if (var.type.equals("TIME") || var.type.equals("DATE") || var.type.equals("TIME_OF_DAY") || var.type.equals("DATE_AND_TIME")) {
                this.pwCPP.print(".fromString(\"" + var.initialValue + "\")");
            } else if (var.type.equals("BOOL")) {
                this.pwCPP.print(" = " + var.initialValue.toLowerCase());
            } else {
                this.pwCPP.print(" = " + var.initialValue);
            }
            this.pwCPP.println(";");
        }
        this.pwCPP.println("}\n");
    }

    private void exportCFBFBs(EList<FBNetworkElement> fbs) {
        if (!fbs.isEmpty()) {
            this.pwH.println("\n  static const SCFB_FBInstanceData scm_astInternalFBs[];");
            this.pwCPP.println("\nconst SCFB_FBInstanceData FORTE_" + this.name + "::scm_astInternalFBs[] = {");
            for (FBNetworkElement fb : fbs) {
                if (fb.getType() instanceof AdapterFBType) continue;
                this.pwCPP.println("  {g_nStringId" + fb.getName() + ", g_nStringId" + fb.getTypeName() + "},");
            }
            this.pwCPP.println("};");
        }
    }

    private void exportCFBParams(EList<FBNetworkElement> fbs) {
        this.numCompFBParams = 0;
        StringBuilder paramString = new StringBuilder();
        for (FBNetworkElement fb : fbs) {
            InterfaceList il = fb.getInterface();
            if (il == null) continue;
            for (VarDeclaration v : il.getInputVars()) {
                Value value = v.getValue();
                if (value == null || v.getInputConnections().size() != 0 || value.getValue() == null || value.getValue().isEmpty()) continue;
                paramString.append("  {");
                paramString.append(this.getCompFBIndex(fbs, (INamedElement)fb));
                paramString.append(", g_nStringId");
                paramString.append(v.getName());
                paramString.append(", \"");
                paramString.append(value.getValue());
                paramString.append("\"},\n");
                ++this.numCompFBParams;
            }
        }
        if (this.numCompFBParams != 0) {
            this.pwH.println("\n  static const SCFB_FBParameter scm_astParamters[];");
            this.pwCPP.println("\nconst SCFB_FBParameter FORTE_" + this.name + "::scm_astParamters[] = {");
            this.pwCPP.print(paramString.toString());
            this.pwCPP.println("};");
        }
    }

    private void exportCFBEventConns(EList<EventConnection> eConns, EList<FBNetworkElement> fbs) {
        this.fannedOutEventConns = 0;
        if (!eConns.isEmpty()) {
            HashSet<EventConnection> conSet = new HashSet<EventConnection>();
            StringBuilder fannedOutConns = new StringBuilder();
            this.pwH.println("\n  static const SCFB_FBConnectionData scm_astEventConnections[];");
            this.pwCPP.println("\nconst SCFB_FBConnectionData FORTE_" + this.name + "::scm_astEventConnections[] = {");
            int eConnNumber = 0;
            for (EventConnection eConn : eConns) {
                if (conSet.contains(eConn)) continue;
                conSet.add(eConn);
                Event src = eConn.getEventSource();
                Event dst = eConn.getEventDestination();
                INamedElement srcFB = (INamedElement)src.eContainer().eContainer();
                INamedElement dstFB = (INamedElement)dst.eContainer().eContainer();
                this.pwCPP.println(this.genConnString(src.getName(), srcFB.getName(), this.getCompFBIndex(fbs, srcFB), dst.getName(), dstFB.getName(), this.getCompFBIndex(fbs, dstFB)));
                if (src.getOutputConnections().size() > 1) {
                    Iterator itRunner = src.getOutputConnections().iterator();
                    itRunner.next();
                    while (itRunner.hasNext()) {
                        eConn = (EventConnection)itRunner.next();
                        conSet.add(eConn);
                        src = eConn.getEventSource();
                        dst = eConn.getEventDestination();
                        srcFB = src.getFBNetworkElement();
                        dstFB = dst.getFBNetworkElement();
                        fannedOutConns.append(this.genFannedOutConnString(eConnNumber, this.getCompFBIndex(fbs, srcFB), dst.getName(), dstFB != null ? dstFB.getName() : "", this.getCompFBIndex(fbs, dstFB)));
                        ++this.fannedOutEventConns;
                    }
                }
                ++eConnNumber;
            }
            this.pwCPP.println("};");
            if (this.fannedOutEventConns != 0) {
                this.pwH.println("\n  static const SCFB_FBFannedOutConnectionData scm_astFannedOutEventConnections[];");
                this.pwCPP.println("\nconst SCFB_FBFannedOutConnectionData FORTE_" + this.name + "::scm_astFannedOutEventConnections[] = {");
                this.pwCPP.print(fannedOutConns.toString());
                this.pwCPP.println("};");
            }
        }
    }

    private String genConnString(String srcName, String srcFBName, int srcFBNum, String dstName, String dstFBName, int dstFBNum) {
        String retVal = new String("  {");
        retVal = String.valueOf(retVal) + this.genConnPortPartString(srcName, srcFBName, srcFBNum);
        retVal = String.valueOf(retVal) + ", ";
        retVal = String.valueOf(retVal) + this.genConnPortPartString(dstName, dstFBName, dstFBNum);
        retVal = String.valueOf(retVal) + "},";
        return retVal;
    }

    private String genConnPortPartString(String name, String fBName, int fBNum) {
        StringBuilder retVal = new StringBuilder();
        if (-1 == fBNum) {
            retVal.append("GENERATE_CONNECTION_PORT_ID_1_ARG(g_nStringId");
        } else {
            retVal.append("GENERATE_CONNECTION_PORT_ID_2_ARG(g_nStringId");
            retVal.append(fBName);
            retVal.append(", g_nStringId");
        }
        if (-2 == fBNum) {
            retVal.append(name);
            retVal.append("), CCompositeFB::scm_nAdapterMarker |");
            int i = 0;
            while (i < this.adapterCount) {
                if (this.adapters.get((int)i).stName.equals(fBName)) {
                    retVal.append(i);
                    break;
                }
                ++i;
            }
        } else {
            retVal.append(name);
            retVal.append("), ");
            retVal.append(fBNum);
        }
        return retVal.toString();
    }

    private String genFannedOutConnString(int connNum, int srcFBNum, String dstName, String dstFBName, int dstFBNum) {
        String retVal = new String("  {");
        retVal = String.valueOf(retVal) + connNum + ", ";
        retVal = String.valueOf(retVal) + this.genConnPortPartString(dstName, dstFBName, dstFBNum);
        retVal = String.valueOf(retVal) + "},\n";
        return retVal;
    }

    private void exportCFBDataConns(EList<DataConnection> dataConns, EList<FBNetworkElement> fbs) {
        this.fannedOutDataConns = 0;
        if (!dataConns.isEmpty()) {
            HashSet<DataConnection> conSet = new HashSet<DataConnection>();
            StringBuilder fannedOutConns = new StringBuilder();
            this.pwH.println("\n  static const SCFB_FBConnectionData scm_astDataConnections[];");
            this.pwCPP.println("\nconst SCFB_FBConnectionData FORTE_" + this.name + "::scm_astDataConnections[] = {");
            int dConnNumber = 0;
            for (DataConnection dConn : dataConns) {
                if (conSet.contains(dConn)) continue;
                DataConnection primConn = this.getInterfaceDstedDataConn((EList<Connection>)dConn.getSource().getOutputConnections());
                if (primConn == null) {
                    primConn = dConn;
                }
                conSet.add(primConn);
                VarDeclaration src = primConn.getDataSource();
                VarDeclaration dst = primConn.getDataDestination();
                if (src == null || dst == null) continue;
                INamedElement srcFB = (INamedElement)src.eContainer().eContainer();
                INamedElement dstFB = (INamedElement)dst.eContainer().eContainer();
                int primDstIndex = this.getCompFBIndex(fbs, dstFB);
                this.pwCPP.println(this.genConnString(src.getName(), srcFB.getName(), this.getCompFBIndex(fbs, srcFB), dst.getName(), dstFB.getName(), primDstIndex));
                if (src.getOutputConnections().size() > 1) {
                    for (Connection itRunner : src.getOutputConnections()) {
                        DataConnection dataConn = (DataConnection)itRunner;
                        if (conSet.contains(itRunner)) continue;
                        conSet.add(dataConn);
                        src = dataConn.getDataSource();
                        dst = dataConn.getDataDestination();
                        srcFB = (INamedElement)src.eContainer().eContainer();
                        dstFB = (INamedElement)dst.eContainer().eContainer();
                        int dstIndex = this.getCompFBIndex(fbs, dstFB);
                        if (-1 == dstIndex && -1 == primDstIndex) {
                            fannedOutConns.append("#error a fannout to several composite FB's outputs is currently not supported: ");
                            this.forteEmitterErrors.add(" - " + this.name + " FORTE does currently not allow that a data a composite's data connection may be connected to several data outputs of the composite FB.");
                        }
                        fannedOutConns.append(this.genFannedOutConnString(dConnNumber, this.getCompFBIndex(fbs, srcFB), dst.getName(), dstFB.getName(), dstIndex));
                        ++this.fannedOutDataConns;
                    }
                }
                ++dConnNumber;
            }
            this.pwCPP.println("};");
            if (this.fannedOutDataConns != 0) {
                this.pwH.println("\n  static const SCFB_FBFannedOutConnectionData scm_astFannedOutDataConnections[];");
                this.pwCPP.println("\nconst SCFB_FBFannedOutConnectionData FORTE_" + this.name + "::scm_astFannedOutDataConnections[] = {");
                this.pwCPP.print(fannedOutConns.toString());
                this.pwCPP.println("};");
            }
        }
    }

    private void exportFBDataArray() {
        if (this.baseClass.equals("CBasicFB")) {
            this.pwH.print("   FORTE_BASIC_FB_DATA_ARRAY(");
        } else if (this.libraryType instanceof AdapterType) {
            this.pwH.print("   FORTE_ADAPTER_DATA_ARRAY(" + this.eventInCount + ", ");
        } else {
            this.pwH.print("   FORTE_FB_DATA_ARRAY(");
        }
        this.pwH.print(String.valueOf(this.eventOutCount) + ", " + this.dataInCount + ", " + this.dataOutCount);
        if (this.baseClass.equals("CBasicFB")) {
            this.pwH.print(", " + this.internalCount);
        }
        this.pwH.println(", " + this.adapterCount + ");");
    }

    private DataConnection getInterfaceDstedDataConn(EList<Connection> dataConns) {
        for (Connection dc : dataConns) {
            if (dc.getDestination() == null || dc.getDestination().eContainer() == null || !(dc.getDestination().eContainer().eContainer() instanceof CompositeFBType)) continue;
            return (DataConnection)dc;
        }
        return null;
    }

    private int getCompFBIndex(EList<FBNetworkElement> fbs, INamedElement fb) {
        int retval = -1;
        retval = fbs.indexOf((Object)fb);
        if (retval != -1 && ((FBNetworkElement)fbs.get(retval)).getType() instanceof AdapterFBType) {
            retval = -2;
        }
        return retval;
    }

    protected class adapterInstance {
        public String stName;
        public String stAdapterType;
        public boolean bIsPlug;
        public AdapterFBType oAdapterFBType;

        protected adapterInstance() {
        }
    }
}

