/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.ui.wizard;

import org.eclipse.fordiac.ide.deployment.ui.Messages;
import org.eclipse.fordiac.ide.deployment.ui.views.DownloadSelectionTree;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.ui.controls.DirectoryChooserControl;
import org.eclipse.fordiac.ide.ui.controls.IDirectoryChanged;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class CreateBootFilesWizardPage
extends WizardPage {
    private IStructuredSelection selection;
    private DirectoryChooserControl dcc;
    private DownloadSelectionTree systemTree;

    public CreateBootFilesWizardPage(IStructuredSelection selection) {
        super(Messages.FordiacCreateBootfilesWizard_PageName);
        this.selection = selection;
        this.setDescription(Messages.FordiacCreateBootfilesWizard_PageDESCRIPTION);
        this.setTitle(Messages.FordiacCreateBootfilesWizard_PageTITLE);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        this.initializeDialogUnits((Control)parent);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.createSystemsContainer(composite);
        this.createDestinationGroup(composite);
        this.setPageComplete(this.validatePage());
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
    }

    public Object[] getSelectedElements() {
        return this.systemTree.getCheckedElements();
    }

    private void createSystemsContainer(Composite composite) {
        this.systemTree = new DownloadSelectionTree(composite, 66308);
        GridData fillBoth = new GridData();
        fillBoth.horizontalAlignment = 4;
        fillBoth.grabExcessHorizontalSpace = true;
        fillBoth.verticalAlignment = 4;
        fillBoth.grabExcessVerticalSpace = true;
        this.systemTree.getTree().setLayoutData((Object)fillBoth);
        this.systemTree.setInput((Object)this);
        this.systemTree.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                CreateBootFilesWizardPage.this.setPageComplete(CreateBootFilesWizardPage.this.validatePage());
            }
        });
        this.checkSelectedElements();
    }

    private void createDestinationGroup(Composite composite) {
        GridData stretch = new GridData();
        stretch.grabExcessHorizontalSpace = true;
        stretch.horizontalAlignment = 4;
        this.dcc = new DirectoryChooserControl(composite, 0, "Destination: ");
        this.dcc.addDirectoryChangedListener(new IDirectoryChanged(){

            public void directoryChanged(String newDirectory) {
                CreateBootFilesWizardPage.this.saveDir(newDirectory);
                CreateBootFilesWizardPage.this.setPageComplete(CreateBootFilesWizardPage.this.validatePage());
            }
        });
        this.dcc.setLayoutData((Object)stretch);
        this.loadDir();
    }

    private boolean validatePage() {
        if (this.dcc.getDirectory() == null || this.dcc.getDirectory().equals("")) {
            this.setErrorMessage("Destination not selected!");
            return false;
        }
        if (this.systemTree.getCheckedElements().length == 0) {
            this.setErrorMessage("Nothing selected for boot-file generation!");
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private void loadDir() {
        String cachedDir;
        if (this.getDialogSettings() != null && (cachedDir = this.getDialogSettings().get("currentDir")) != null) {
            this.setDirectory(cachedDir);
        }
    }

    public void setDirectory(String dir) {
        this.dcc.setDirectory(dir);
    }

    public String getDirectory() {
        return this.dcc.getDirectory();
    }

    private void saveDir(String currentDir) {
        this.getDialogSettings().put("currentDir", currentDir);
    }

    private void checkSelectedElements() {
        Object[] objectArray = this.selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj instanceof AutomationSystem) {
                this.expandSystem(obj);
            } else if (obj instanceof Device) {
                this.expandDevice((Device)obj);
            } else if (obj instanceof Resource) {
                this.expandResource((Resource)obj);
            }
            ++n2;
        }
        this.systemTree.setSelection((ISelection)this.selection);
        this.systemTree.setCheckedElements(this.selection.toArray());
    }

    private void expandResource(Resource obj) {
        this.expandDevice(obj.getDevice());
    }

    private void expandDevice(Device obj) {
        this.expandSystem(obj.getAutomationSystem());
        this.systemTree.setExpandedState(obj, true);
    }

    private void expandSystem(Object obj) {
        this.systemTree.setExpandedState(obj, true);
    }
}

