/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ide.dialogs;

import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor;
import org.eclipse.epp.internal.logging.aeri.ide.dialogs.UI;
import org.eclipse.epp.internal.logging.aeri.ide.l10n.Messages;
import org.eclipse.epp.internal.logging.aeri.ide.utils.Browsers;
import org.eclipse.epp.internal.logging.aeri.ide.utils.Formats;
import org.eclipse.epp.internal.logging.aeri.ide.utils.Servers;
import org.eclipse.epp.logging.aeri.core.ILink;
import org.eclipse.epp.logging.aeri.core.ILinkable;
import org.eclipse.epp.logging.aeri.core.IModelPackage;
import org.eclipse.epp.logging.aeri.core.ISystemSettings;
import org.eclipse.epp.logging.aeri.core.util.Links;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ConfigureServerDialog
extends TitleAreaDialog {
    public static final int ESC_CANCEL = 84;
    private static final Point TOOLTIP_DISPLACEMENT = new Point(5, 20);
    private static int TOOLTIP_MS_HIDE_DELAY = 20000;
    private IServerDescriptor server;
    private DataBindingContext context;

    @Inject
    public ConfigureServerDialog(IServerDescriptor server, ISystemSettings settings, @Named(value="activeShell") @Optional Shell parentShell, ImageRegistry registry) {
        super(parentShell);
        this.server = server;
        this.setTitleImage(registry.get("icons/wizban/stacktraces_wiz.png"));
        this.setHelpAvailable(false);
        this.setShellStyle(268436720);
        this.context = new DataBindingContext();
        Servers.copySystemDefaultsIfUnset(settings, server);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, Messages.BUTTON_TEXT_ENABLE, true);
        this.createButton(parent, 1, Messages.BUTTON_TEXT_DISABLE, false);
    }

    public void create() {
        super.create();
        this.setTitle(Formats.format(Messages.DIALOG_TITLE_CONFIGURE_SERVER, this.server.getName()));
        this.setMessage(Messages.DIALOG_MESSAGE_CONFIGURE_SERVER);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        UI.gl().extendedMargins(5, 5, 5, 0).applyTo(container);
        UI.gdGrabHV().applyTo((Control)container);
        Composite personalGroup = this.createPersonalGroup(container);
        GridDataFactory.fillDefaults().indent(0, 10).grab(true, false).applyTo((Control)personalGroup);
        Group makeAnonymousGroup = this.createAnonymizeGroup(container);
        UI.gd().indent(0, 5).applyTo((Control)makeAnonymousGroup);
        ILink termsOfUse = Links.Link((ILinkable)this.server, (String)"terms-of-use");
        ILink privacyPolicy = Links.Link((ILinkable)this.server, (String)"privacy-policy");
        String legalText = null;
        if (termsOfUse != null && privacyPolicy != null) {
            legalText = Formats.format(Messages.LINK_TEXT_ENABLE_ADMONITION_WITH_TERMS_OF_USE_AND_PRIVACY_POLICY, StringUtils.defaultString((String)termsOfUse.getTitle(), (String)Messages.LINK_TEXT_TERMS_OF_USE), termsOfUse.getHref(), StringUtils.defaultString((String)privacyPolicy.getTitle(), (String)Messages.LINK_TEXT_PRIVACY_POLICY), privacyPolicy.getHref());
        } else if (termsOfUse != null && privacyPolicy == null) {
            legalText = Formats.format(Messages.LINK_TEXT_ENABLE_ADMONITION_WITH_TERMS_OF_USE, StringUtils.defaultString((String)termsOfUse.getTitle(), (String)Messages.LINK_TEXT_TERMS_OF_USE), termsOfUse.getHref());
        } else if (termsOfUse == null && privacyPolicy != null) {
            legalText = Formats.format(Messages.LINK_TEXT_ENABLE_ADMONITION_WITH_PRIVACY_POLICY, StringUtils.defaultString((String)privacyPolicy.getTitle(), (String)Messages.LINK_TEXT_PRIVACY_POLICY), privacyPolicy.getHref());
        }
        if (legalText != null) {
            Link termsAndConditions = new Link(container, 0);
            termsAndConditions.setText(legalText);
            termsAndConditions.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Browsers.openInExternalBrowser(e.text);
                }
            });
            UI.gd().indent(10, 10).hint(300, -1).align(4, 0x1000000).applyTo((Control)termsAndConditions);
        }
        Dialog.applyDialogFont((Control)container);
        return container;
    }

    private Composite createPersonalGroup(Composite parent) {
        Group personalGroup = new Group(parent, 0);
        personalGroup.setText(Messages.GROUP_TEXT_CONTACT_INFORMATION);
        UI.gl().margins(5, 5).numColumns(2).applyTo((Composite)personalGroup);
        Text name = UI.createLabelWithText((Composite)personalGroup, Messages.FIELD_LABEL_NAME, Messages.FIELD_MESSAGE_NAME, Messages.FIELD_MESSAGE_NAME);
        ISWTObservableValue swt = WidgetProperties.text((int)24).observe((Widget)name);
        IObservableValue emf = EMFProperties.value((EStructuralFeature)IModelPackage.Literals.USER_SETTINGS__REPORTER_NAME).observe((Object)this.server);
        this.context.bindValue((IObservableValue)swt, emf);
        String tooltip = String.valueOf(Messages.FIELD_MESSAGE_EMAIL) + '\n' + Messages.TOOLTIP_SETTINGS_EMAIL;
        Text email = UI.createLabelWithText((Composite)personalGroup, Messages.FIELD_LABEL_EMAIL, Messages.FIELD_MESSAGE_EMAIL, tooltip);
        ISWTObservableValue swt2 = WidgetProperties.text((int)24).observe((Widget)email);
        IObservableValue emf2 = EMFProperties.value((EStructuralFeature)IModelPackage.Literals.USER_SETTINGS__REPORTER_EMAIL).observe((Object)this.server);
        this.context.bindValue((IObservableValue)swt2, emf2);
        return personalGroup;
    }

    private Group createAnonymizeGroup(Composite container) {
        Group makeAnonymousGroup = new Group(container, 92);
        makeAnonymousGroup.setLayout((Layout)new RowLayout(512));
        makeAnonymousGroup.setText(Messages.GROUP_TEXT_ANONYMIZATION);
        Button anonStackTraces = this.createGroupCheckButton(makeAnonymousGroup, Messages.FIELD_LABEL_ANONYMIZE_STACKTRACES, Messages.TOOLTIP_SETTINGS_MAKE_STACKTRACE_ANONYMOUS);
        anonStackTraces.setFocus();
        ISWTObservableValue swt = WidgetProperties.selection().observe((Widget)anonStackTraces);
        IObservableValue emf = EMFProperties.value((EStructuralFeature)IModelPackage.Literals.USER_SETTINGS__ANONYMIZE_STACK_TRACES).observe((Object)this.server);
        this.context.bindValue((IObservableValue)swt, emf);
        Button anonMessages = this.createGroupCheckButton(makeAnonymousGroup, Messages.FIELD_LABEL_ANONYMIZE_MESSAGES, Messages.TOOLTIP_SETTINGS_MAKE_MESSAGES_ANONYMOUS);
        swt = WidgetProperties.selection().observe((Widget)anonMessages);
        emf = EMFProperties.value((EStructuralFeature)IModelPackage.Literals.USER_SETTINGS__ANONYMIZE_MESSAGES).observe((Object)this.server);
        this.context.bindValue((IObservableValue)swt, emf);
        return makeAnonymousGroup;
    }

    private Button createGroupCheckButton(Group group, String buttonText, String toolTipText) {
        Button button = new Button((Composite)group, 32);
        button.setText(buttonText);
        this.calibrateTooltip(new DefaultToolTip((Control)button), toolTipText);
        return button;
    }

    private void calibrateTooltip(DefaultToolTip toolTip, String toolTipText) {
        toolTip.setText(toolTipText);
        toolTip.setFont(JFaceResources.getDialogFont());
        toolTip.setShift(TOOLTIP_DISPLACEMENT);
        toolTip.setHideDelay(TOOLTIP_MS_HIDE_DELAY);
    }

    protected void okPressed() {
        this.server.setEnabled(true);
        super.okPressed();
    }

    protected void cancelPressed() {
        this.server.setEnabled(false);
        super.cancelPressed();
    }
}

