/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */

/*
 * Copyright 2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#pragma ident	"@(#)mlib_GraphicsAliasTab.c	9.2	07/10/09 SMI"

/*
 * TABLES
 *   mlib_GraphicsAliasTab_u8 - table with precalculated alpha values
 *   mlib_GraphicsSqrtTab_u8   - table with precalculated sqrt values
 *
 * DESCRIPTION
 *
 *   offset   = 0..255
 *   step     = 0..256
 *   atable   = mlib_GraphicsAliasTab_u8 + 512 *
 *              mlib_GraphicsSqrtTab_u8[step];
 *   u_alpha  = atable[offset] / 128.;
 *   c_alpha  = atable[256+offset] / 128.;
 *   d_alpha  = atable[~offset] / 128.;
 *
 * COMMENTS
 *  These tables are used by drawing functions with anti-aliased mode
 *  to find alpha pixels values.
 *
 */

#include <mlib_types.h>
#include <mlib_GraphicsDrawSet.h>

/* *********************************************************** */

#ifdef _LITTLE_ENDIAN

static mlib_u32 mlib_GraphicsAliasTab_u8_xxx[39 * 512 / 4] = {
	0x0a090909, 0x0a0a0a0a, 0x0b0b0b0b, 0x0c0c0c0b,
	0x0d0d0c0c, 0x0e0d0d0d, 0x0f0e0e0e, 0x0f0f0f0f,
	0x10101010, 0x11111111, 0x12121212, 0x13131313,
	0x15141414, 0x16151515, 0x17171616, 0x18181717,
	0x19191918, 0x1a1a1a1a, 0x1c1b1b1b, 0x1d1d1c1c,
	0x1e1e1e1d, 0x201f1f1f, 0x21212020, 0x22222221,
	0x24242323, 0x25252524, 0x27272626, 0x28282827,
	0x2a2a2929, 0x2c2b2b2a, 0x2d2d2c2c, 0x2f2e2e2e,
	0x3030302f, 0x32323131, 0x34333333, 0x36353534,
	0x37373636, 0x39393838, 0x3b3a3a3a, 0x3d3c3c3b,
	0x3e3e3d3d, 0x40403f3f, 0x42414141, 0x44434342,
	0x45454544, 0x47474646, 0x49494848, 0x4b4a4a49,
	0x4c4c4c4b, 0x4e4e4d4d, 0x50504f4f, 0x52515150,
	0x53535352, 0x55555454, 0x57565656, 0x59585857,
	0x5a5a5959, 0x5c5c5b5b, 0x5e5d5d5c, 0x5f5f5e5e,
	0x61606060, 0x62626261, 0x64646363, 0x65656564,
	0x67666665, 0x68686767, 0x69696968, 0x6b6b6a6a,
	0x6c6c6c6b, 0x6e6d6d6d, 0x6f6f6e6e, 0x70706f6f,
	0x71717170, 0x72727272, 0x74737373, 0x75747474,
	0x76757575, 0x77767676, 0x78777777, 0x78787878,
	0x79797979, 0x7a7a7a79, 0x7b7b7a7a, 0x7b7b7b7b,
	0x7c7c7c7c, 0x7d7d7c7c, 0x7d7d7d7d, 0x7e7e7d7d,
	0x7e7e7e7e, 0x7e7e7e7e, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f80, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7e7e7e7f, 0x7e7e7e7e,
	0x7d7e7e7e, 0x7d7d7d7d, 0x7c7d7d7d, 0x7c7c7c7c,
	0x7b7b7b7c, 0x7a7b7b7b, 0x7a7a7a7a, 0x79797979,
	0x78787879, 0x77777878, 0x76767777, 0x75757676,
	0x74747575, 0x73737474, 0x72727273, 0x71717172,
	0x6f707070, 0x6e6f6f6f, 0x6d6d6e6e, 0x6c6c6c6d,
	0x6a6b6b6b, 0x6969696a, 0x67686868, 0x66666767,
	0x0a0a0a0a, 0x0b0b0b0a, 0x0c0c0b0b, 0x0d0c0c0c,
	0x0d0d0d0d, 0x0e0e0e0e, 0x0f0f0f0f, 0x1010100f,
	0x11111110, 0x12121211, 0x13131312, 0x14141413,
	0x15151515, 0x17161616, 0x18171717, 0x19191818,
	0x1a1a1919, 0x1b1b1a1a, 0x1c1c1c1b, 0x1e1d1d1d,
	0x1f1f1e1e, 0x2020201f, 0x22212121, 0x23232222,
	0x25242424, 0x26262525, 0x28272727, 0x29292828,
	0x2b2a2a2a, 0x2c2c2c2b, 0x2e2e2d2d, 0x302f2f2e,
	0x31313030, 0x33333232, 0x35343433, 0x36363635,
	0x38383737, 0x3a3a3939, 0x3c3b3b3a, 0x3d3d3d3c,
	0x3f3f3e3e, 0x41414040, 0x43424241, 0x45444443,
	0x46464545, 0x48484747, 0x4a494949, 0x4c4b4b4a,
	0x4d4c4c4c, 0x4f4e4e4d, 0x5050504f, 0x52525151,
	0x54535353, 0x56555554, 0x57575656, 0x59595858,
	0x5b5a5a59, 0x5c5c5c5b, 0x5e5e5d5d, 0x605f5f5e,
	0x61616060, 0x63626262, 0x64646463, 0x66656565,
	0x67676666, 0x68686867, 0x6a696969, 0x6b6b6b6a,
	0x6d6c6c6c, 0x6e6e6d6d, 0x6f6f6f6e, 0x7070706f,
	0x72717171, 0x73727272, 0x74747373, 0x75757474,
	0x76767575, 0x77777676, 0x78787777, 0x79787878,
	0x79797979, 0x7a7a7a7a, 0x7b7b7b7a, 0x7c7b7b7b,
	0x7c7c7c7c, 0x7d7d7d7c, 0x7d7d7d7d, 0x7e7e7e7d,
	0x7e7e7e7e, 0x7f7e7e7e, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x807f7f7f,
	0x7f7f8080, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7e7e7f7f, 0x7e7e7e7e,
	0x7e7e7e7e, 0x7d7d7d7d, 0x7d7d7d7d, 0x7c7c7c7c,
	0x7b7b7c7c, 0x7b7b7b7b, 0x7a7a7a7a, 0x7979797a,
	0x78787979, 0x77787878, 0x76777777, 0x75767676,
	0x74757575, 0x73747474, 0x72727373, 0x71717272,
	0x70707071, 0x6f6f6f6f, 0x6d6e6e6e, 0x6c6c6d6d,
	0x6b6b6b6c, 0x69696a6a, 0x68686869, 0x66676767,
	0x0b0b0a0a, 0x0c0b0b0b, 0x0c0c0c0c, 0x0d0d0d0d,
	0x0e0e0e0d, 0x0f0f0f0e, 0x10100f0f, 0x11111010,
	0x12111111, 0x13121212, 0x14131313, 0x15151414,
	0x16161515, 0x17171716, 0x18181817, 0x1a191919,
	0x1b1a1a1a, 0x1c1c1b1b, 0x1d1d1d1c, 0x1f1e1e1e,
	0x20201f1f, 0x21212120, 0x23222222, 0x24242423,
	0x25252524, 0x27272626, 0x28282827, 0x2a2a2929,
	0x2c2b2b2a, 0x2d2d2c2c, 0x2f2e2e2e, 0x3030302f,
	0x32323131, 0x34333333, 0x36353534, 0x37373636,
	0x39393838, 0x3b3a3a3a, 0x3d3c3c3b, 0x3e3e3d3d,
	0x403f3f3e, 0x41414140, 0x43434242, 0x45454444,
	0x47464645, 0x49484847, 0x4a4a4949, 0x4c4c4b4b,
	0x4e4d4d4c, 0x504f4f4e, 0x51515050, 0x53535252,
	0x55545453, 0x56565655, 0x58585757, 0x5a595959,
	0x5b5b5a5a, 0x5d5c5c5c, 0x5e5e5e5d, 0x60605f5f,
	0x62616160, 0x63636262, 0x65646464, 0x66666565,
	0x67676766, 0x69686868, 0x6a6a6969, 0x6c6b6b6b,
	0x6d6d6c6c, 0x6e6e6e6d, 0x6f6f6f6f, 0x71707070,
	0x72727171, 0x73737272, 0x74747473, 0x75757574,
	0x76767675, 0x77777776, 0x78787877, 0x79797878,
	0x79797979, 0x7a7a7a7a, 0x7b7b7b7a, 0x7c7b7b7b,
	0x7c7c7c7c, 0x7d7d7d7c, 0x7d7d7d7d, 0x7e7e7e7d,
	0x7e7e7e7e, 0x7f7e7e7e, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x807f7f7f,
	0x7f7f8080, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7e7e7f7f, 0x7e7e7e7e,
	0x7e7e7e7e, 0x7d7d7d7d, 0x7d7d7d7d, 0x7c7c7c7c,
	0x7b7b7c7c, 0x7b7b7b7b, 0x7a7a7a7a, 0x7979797a,
	0x78797979, 0x78787878, 0x77777777, 0x76767676,
	0x75757575, 0x74747474, 0x72737373, 0x71727272,
	0x70707171, 0x6f6f6f70, 0x6e6e6e6f, 0x6c6d6d6d,
	0x6b6b6c6c, 0x696a6a6b, 0x68686969, 0x67676768,
	0x0b0b0b0b, 0x0c0c0c0c, 0x0d0d0d0c, 0x0e0e0d0d,
	0x0f0f0e0e, 0x0f0f0f0f, 0x10101010, 0x11111111,
	0x12121212, 0x13131313, 0x15141414, 0x16151515,
	0x17171616, 0x18181717, 0x19191918, 0x1a1a1a1a,
	0x1b1b1b1a, 0x1d1c1c1c, 0x1e1e1d1d, 0x1f1f1f1e,
	0x21202020, 0x22222121, 0x24232322, 0x25252424,
	0x27262625, 0x28282727, 0x29292928, 0x2b2a2a2a,
	0x2c2c2c2b, 0x2e2e2d2d, 0x302f2f2e, 0x31313030,
	0x33333232, 0x35343433, 0x36363635, 0x38383737,
	0x3a3a3939, 0x3b3b3a3a, 0x3d3d3c3c, 0x3f3e3e3d,
	0x4140403f, 0x42424141, 0x44444343, 0x46454545,
	0x48474746, 0x49494948, 0x4b4b4a4a, 0x4d4c4c4c,
	0x4e4e4d4d, 0x50504f4f, 0x52515150, 0x53535352,
	0x55555454, 0x57565656, 0x59585857, 0x5a5a5959,
	0x5c5c5b5b, 0x5e5d5d5c, 0x5f5f5e5e, 0x6060605f,
	0x62626161, 0x64636362, 0x65656464, 0x67666665,
	0x68676767, 0x69696868, 0x6b6a6a69, 0x6c6c6b6b,
	0x6d6d6d6c, 0x6f6e6e6e, 0x706f6f6f, 0x71717070,
	0x72727271, 0x73737372, 0x74747474, 0x75757574,
	0x76767675, 0x77777776, 0x78787877, 0x79797878,
	0x7a797979, 0x7a7a7a7a, 0x7b7b7b7b, 0x7c7c7b7b,
	0x7c7c7c7c, 0x7d7d7d7d, 0x7d7d7d7d, 0x7e7e7e7d,
	0x7e7e7e7e, 0x7f7e7e7e, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x807f7f7f,
	0x7f7f8080, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7e7e7f7f, 0x7e7e7e7e,
	0x7e7e7e7e, 0x7d7d7d7d, 0x7d7d7d7d, 0x7c7c7c7d,
	0x7b7c7c7c, 0x7b7b7b7b, 0x7a7a7a7b, 0x79797a7a,
	0x78797979, 0x78787878, 0x77777777, 0x76767676,
	0x75757575, 0x74747474, 0x73737374, 0x72727272,
	0x70717171, 0x6f6f7070, 0x6e6e6f6f, 0x6d6d6d6e,
	0x6b6c6c6c, 0x6a6a6b6b, 0x68696969, 0x67676868,
	0x0c0c0c0b, 0x0d0d0c0c, 0x0e0d0d0d, 0x0f0e0e0e,
	0x0f0f0f0f, 0x1010100f, 0x11111110, 0x12121211,
	0x13131312, 0x14141413, 0x15151515, 0x17161616,
	0x17171717, 0x19181818, 0x1a1a1919, 0x1b1b1a1a,
	0x1c1c1c1b, 0x1e1d1d1d, 0x1f1f1e1e, 0x2020201f,
	0x21212120, 0x23222222, 0x24242423, 0x26252525,
	0x27272726, 0x29282828, 0x2a2a2a29, 0x2c2c2b2b,
	0x2d2d2c2c, 0x2f2e2e2e, 0x3030302f, 0x32323131,
	0x34333333, 0x36353534, 0x37373636, 0x39393838,
	0x3a3a3a39, 0x3c3c3b3b, 0x3e3d3d3d, 0x403f3f3e,
	0x41414140, 0x43434242, 0x45454444, 0x47464645,
	0x48484747, 0x4a494949, 0x4c4b4b4a, 0x4d4d4c4c,
	0x4f4f4e4e, 0x51505050, 0x53525251, 0x54545353,
	0x56555554, 0x57575656, 0x59595858, 0x5b5a5a59,
	0x5c5c5c5b, 0x5e5e5d5d, 0x605f5f5e, 0x61616060,
	0x62626261, 0x64646363, 0x65656564, 0x67676666,
	0x68686767, 0x69696968, 0x6b6b6a6a, 0x6c6c6c6b,
	0x6e6d6d6d, 0x6f6f6e6e, 0x70706f6f, 0x71717170,
	0x72727271, 0x73737372, 0x74747474, 0x75757575,
	0x76767676, 0x77777777, 0x78787878, 0x79797978,
	0x7a797979, 0x7a7a7a7a, 0x7b7b7b7b, 0x7c7c7b7b,
	0x7c7c7c7c, 0x7d7d7d7d, 0x7d7d7d7d, 0x7e7e7e7e,
	0x7e7e7e7e, 0x7f7e7e7e, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x807f7f7f,
	0x7f7f8080, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7e7e7f7f, 0x7e7e7e7e,
	0x7e7e7e7e, 0x7d7d7d7e, 0x7d7d7d7d, 0x7c7c7c7d,
	0x7b7c7c7c, 0x7b7b7b7b, 0x7a7a7a7b, 0x79797a7a,
	0x79797979, 0x78787878, 0x77777778, 0x76767677,
	0x75757576, 0x74747475, 0x73737374, 0x72727272,
	0x71717171, 0x6f707070, 0x6e6f6f6f, 0x6d6d6e6e,
	0x6c6c6c6d, 0x6a6b6b6b, 0x6969696a, 0x67686868,
	0x0d0c0c0c, 0x0d0d0d0d, 0x0e0e0e0e, 0x0f0f0f0f,
	0x10100f0f, 0x11111010, 0x12121111, 0x13131212,
	0x14141313, 0x15151514, 0x16161515, 0x17171716,
	0x18181817, 0x1a191919, 0x1b1a1a1a, 0x1c1c1b1b,
	0x1d1d1c1c, 0x1e1e1e1d, 0x201f1f1f, 0x21212020,
	0x22222221, 0x24242323, 0x25252524, 0x27262625,
	0x28282727, 0x2a292928, 0x2b2b2a2a, 0x2d2c2c2c,
	0x2e2e2e2d, 0x302f2f2e, 0x31313030, 0x33333232,
	0x35343433, 0x36363635, 0x38383737, 0x3a393939,
	0x3b3b3a3a, 0x3d3d3c3c, 0x3f3e3e3d, 0x4140403f,
	0x42424141, 0x44434343, 0x45454544, 0x47474646,
	0x49494848, 0x4b4a4a49, 0x4c4c4c4b, 0x4e4e4d4d,
	0x504f4f4e, 0x51515050, 0x53535252, 0x55545453,
	0x56565655, 0x58585757, 0x59595959, 0x5b5b5a5a,
	0x5d5c5c5c, 0x5e5e5e5d, 0x60605f5f, 0x62616160,
	0x63636262, 0x64646463, 0x66656565, 0x67676766,
	0x68686867, 0x6a696969, 0x6b6b6b6a, 0x6d6c6c6c,
	0x6e6e6d6d, 0x6f6f6f6e, 0x7070706f, 0x71717170,
	0x72727272, 0x74737373, 0x75747474, 0x76757575,
	0x77767676, 0x77777777, 0x78787878, 0x79797978,
	0x7a7a7979, 0x7b7a7a7a, 0x7b7b7b7b, 0x7c7c7b7b,
	0x7c7c7c7c, 0x7d7d7d7d, 0x7d7d7d7d, 0x7e7e7e7e,
	0x7e7e7e7e, 0x7f7f7e7e, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x807f7f7f,
	0x7f7f8080, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7e7f7f7f, 0x7e7e7e7e,
	0x7e7e7e7e, 0x7d7d7d7e, 0x7d7d7d7d, 0x7c7c7c7d,
	0x7b7c7c7c, 0x7b7b7b7b, 0x7a7a7b7b, 0x797a7a7a,
	0x79797979, 0x78787878, 0x77777778, 0x76767777,
	0x75757676, 0x74747575, 0x73737474, 0x72727273,
	0x71717172, 0x70707070, 0x6f6f6f6f, 0x6d6e6e6e,
	0x6c6c6d6d, 0x6b6b6b6c, 0x69696a6a, 0x68686869,
	0x0d0d0d0d, 0x0e0e0e0d, 0x0f0f0f0e, 0x100f0f0f,
	0x11101010, 0x12111111, 0x13121212, 0x14131313,
	0x15141414, 0x16151515, 0x17171616, 0x18181717,
	0x19191918, 0x1a1a1a1a, 0x1b1b1b1a, 0x1d1c1c1c,
	0x1e1e1d1d, 0x1f1f1f1e, 0x20202020, 0x22212121,
	0x23232222, 0x25242424, 0x26262525, 0x28272727,
	0x29282828, 0x2a2a2a29, 0x2c2c2b2b, 0x2e2d2d2c,
	0x2f2f2e2e, 0x30303030, 0x32323131, 0x34333333,
	0x36353534, 0x37373636, 0x39393838, 0x3a3a3a39,
	0x3c3c3b3b, 0x3e3d3d3d, 0x403f3f3e, 0x41414140,
	0x43424241, 0x45444443, 0x46464545, 0x48484747,
	0x4a494949, 0x4b4b4a4a, 0x4d4c4c4c, 0x4f4e4e4d,
	0x5050504f, 0x52525151, 0x53535353, 0x55555454,
	0x57565656, 0x59585857, 0x5a5a5959, 0x5c5c5b5b,
	0x5d5d5c5c, 0x5f5e5e5e, 0x6060605f, 0x62626161,
	0x64636362, 0x65646464, 0x66666565, 0x68676767,
	0x69686868, 0x6a6a6969, 0x6c6b6b6b, 0x6d6d6c6c,
	0x6e6e6e6d, 0x6f6f6f6f, 0x7070706f, 0x72717171,
	0x73727272, 0x74747373, 0x75757474, 0x76757575,
	0x77767676, 0x78777777, 0x78787878, 0x79797979,
	0x7a7a7979, 0x7b7a7a7a, 0x7b7b7b7b, 0x7c7c7c7b,
	0x7d7c7c7c, 0x7d7d7d7d, 0x7d7d7d7d, 0x7e7e7e7e,
	0x7e7e7e7e, 0x7f7f7e7e, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x807f7f7f,
	0x7f7f8080, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7e7f7f7f, 0x7e7e7e7e,
	0x7e7e7e7e, 0x7d7d7d7e, 0x7d7d7d7d, 0x7c7c7d7d,
	0x7c7c7c7c, 0x7b7b7b7b, 0x7a7a7b7b, 0x797a7a7a,
	0x79797979, 0x78787879, 0x77777878, 0x76767777,
	0x75757676, 0x74757575, 0x73747474, 0x72727373,
	0x71717272, 0x70707071, 0x6f6f6f6f, 0x6e6e6e6f,
	0x6c6d6d6d, 0x6b6b6c6c, 0x696a6a6b, 0x68686969,
	0x0e0e0d0d, 0x0f0f0e0e, 0x0f0f0f0f, 0x10101010,
	0x11111111, 0x12121212, 0x13131313, 0x14141413,
	0x15151515, 0x17161616, 0x18171717, 0x19181818,
	0x1a1a1919, 0x1b1b1a1a, 0x1c1c1c1b, 0x1e1d1d1d,
	0x1f1e1e1e, 0x20201f1f, 0x21212120, 0x23222222,
	0x24242423, 0x25252524, 0x27272626, 0x28282827,
	0x2a2a2929, 0x2b2b2a2a, 0x2d2c2c2c, 0x2e2e2e2d,
	0x30302f2f, 0x31313130, 0x33333232, 0x35343433,
	0x36363635, 0x38383737, 0x3a393939, 0x3b3b3a3a,
	0x3d3d3c3c, 0x3f3e3e3d, 0x4040403f, 0x42414141,
	0x44434342, 0x45454544, 0x47474646, 0x49484848,
	0x4a4a4949, 0x4c4c4b4b, 0x4e4d4d4c, 0x504f4f4e,
	0x51505050, 0x53525251, 0x54545353, 0x56565555,
	0x57575756, 0x59595858, 0x5b5a5a59, 0x5c5c5c5b,
	0x5e5e5d5d, 0x5f5f5e5e, 0x61606060, 0x62626261,
	0x64646363, 0x65656564, 0x67666665, 0x68686767,
	0x69696868, 0x6b6a6a69, 0x6c6c6b6b, 0x6d6d6d6c,
	0x6e6e6e6e, 0x6f6f6f6f, 0x71707070, 0x72727171,
	0x73737272, 0x74747373, 0x75757474, 0x76767575,
	0x77777676, 0x78787777, 0x78787878, 0x79797979,
	0x7a7a7a79, 0x7b7b7a7a, 0x7b7b7b7b, 0x7c7c7c7b,
	0x7d7c7c7c, 0x7d7d7d7d, 0x7e7d7d7d, 0x7e7e7e7e,
	0x7e7e7e7e, 0x7f7f7e7e, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x807f7f7f,
	0x7f7f8080, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7e7f7f7f, 0x7e7e7e7e,
	0x7e7e7e7e, 0x7d7d7e7e, 0x7d7d7d7d, 0x7c7c7d7d,
	0x7c7c7c7c, 0x7b7b7b7b, 0x7a7b7b7b, 0x7a7a7a7a,
	0x79797979, 0x78787879, 0x77787878, 0x76777777,
	0x75767676, 0x74757575, 0x73747474, 0x72737373,
	0x71727272, 0x70707171, 0x6f6f6f70, 0x6e6e6e6f,
	0x6d6d6d6e, 0x6b6c6c6c, 0x6a6a6b6b, 0x68696969,
	0x0f0e0e0e, 0x0f0f0f0f, 0x1010100f, 0x11111110,
	0x12121211, 0x13131312, 0x14141313, 0x15151514,
	0x16161615, 0x17171717, 0x18181817, 0x1a191919,
	0x1b1a1a1a, 0x1c1c1b1b, 0x1d1d1c1c, 0x1e1e1e1d,
	0x201f1f1f, 0x21212020, 0x22222121, 0x24232322,
	0x25252424, 0x27262625, 0x28272727, 0x29292828,
	0x2b2a2a2a, 0x2c2c2c2b, 0x2e2d2d2c, 0x2f2f2e2e,
	0x31303030, 0x33323231, 0x34333333, 0x36353534,
	0x37373636, 0x39393838, 0x3a3a3a39, 0x3c3c3b3b,
	0x3e3d3d3d, 0x403f3f3e, 0x41414040, 0x43424241,
	0x45444443, 0x46464545, 0x48474746, 0x49494948,
	0x4b4b4a4a, 0x4d4c4c4c, 0x4e4e4d4d, 0x50504f4f,
	0x52515150, 0x53535352, 0x55545453, 0x56565655,
	0x58585757, 0x5a595959, 0x5b5b5a5a, 0x5d5c5c5c,
	0x5e5e5e5d, 0x60605f5f, 0x61616060, 0x63626262,
	0x64646463, 0x66656565, 0x67676666, 0x68686867,
	0x69696968, 0x6b6b6a6a, 0x6c6c6c6b, 0x6e6d6d6d,
	0x6f6e6e6e, 0x706f6f6f, 0x71717070, 0x72727271,
	0x73737272, 0x74747473, 0x75757574, 0x76767675,
	0x77777676, 0x78787777, 0x79787878, 0x79797979,
	0x7a7a7a79, 0x7b7b7a7a, 0x7b7b7b7b, 0x7c7c7c7c,
	0x7d7c7c7c, 0x7d7d7d7d, 0x7e7d7d7d, 0x7e7e7e7e,
	0x7e7e7e7e, 0x7f7f7e7e, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x807f7f7f,
	0x7f7f8080, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7e7f7f7f, 0x7e7e7e7e,
	0x7e7e7e7e, 0x7d7d7e7e, 0x7d7d7d7d, 0x7c7c7d7d,
	0x7c7c7c7c, 0x7b7b7b7c, 0x7a7b7b7b, 0x7a7a7a7a,
	0x79797979, 0x78787979, 0x77787878, 0x76777777,
	0x76767676, 0x75757575, 0x74747474, 0x72737373,
	0x72727272, 0x70717171, 0x6f6f7070, 0x6e6e6f6f,
	0x6d6d6e6e, 0x6c6c6c6d, 0x6a6b6b6b, 0x6969696a,
	0x0f0f0f0f, 0x1010100f, 0x11111010, 0x12121111,
	0x13131212, 0x14131313, 0x15151414, 0x16161515,
	0x17171716, 0x18181717, 0x19191918, 0x1a1a1a1a,
	0x1b1b1b1b, 0x1d1c1c1c, 0x1e1e1d1d, 0x1f1f1f1e,
	0x2020201f, 0x22212121, 0x23232222, 0x24242424,
	0x26252525, 0x27272726, 0x29282828, 0x2a2a2929,
	0x2c2b2b2a, 0x2d2d2c2c, 0x2e2e2e2e, 0x30302f2f,
	0x32313130, 0x33333332, 0x35343434, 0x36363635,
	0x38383737, 0x3a3a3939, 0x3b3b3a3a, 0x3d3d3c3c,
	0x3f3e3e3d, 0x40403f3f, 0x42414141, 0x44434342,
	0x45454544, 0x47464645, 0x49484847, 0x4a4a4949,
	0x4c4b4b4b, 0x4d4d4c4c, 0x4f4f4e4e, 0x51505050,
	0x52525151, 0x54535353, 0x56555554, 0x57565656,
	0x59585857, 0x5a5a5959, 0x5c5c5b5b, 0x5d5d5c5c,
	0x5f5e5e5e, 0x6060605f, 0x62626161, 0x63636262,
	0x65646464, 0x66666565, 0x67676767, 0x69686868,
	0x6a696969, 0x6b6b6b6a, 0x6d6c6c6c, 0x6e6e6d6d,
	0x6f6f6e6e, 0x70706f6f, 0x71717170, 0x72727272,
	0x73737372, 0x74747474, 0x75757575, 0x76767675,
	0x77777776, 0x78787877, 0x79787878, 0x79797979,
	0x7a7a7a7a, 0x7b7b7b7a, 0x7b7b7b7b, 0x7c7c7c7c,
	0x7d7d7c7c, 0x7d7d7d7d, 0x7e7d7d7d, 0x7e7e7e7e,
	0x7e7e7e7e, 0x7f7f7e7e, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x807f7f7f,
	0x7f7f8080, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7e7f7f7f, 0x7e7e7e7e,
	0x7e7e7e7e, 0x7d7d7e7e, 0x7d7d7d7d, 0x7c7d7d7d,
	0x7c7c7c7c, 0x7b7b7b7c, 0x7b7b7b7b, 0x7a7a7a7a,
	0x7979797a, 0x78787979, 0x78787878, 0x77777777,
	0x76767676, 0x75757575, 0x74747475, 0x73737374,
	0x72727272, 0x71717172, 0x6f707070, 0x6e6f6f6f,
	0x6d6e6e6e, 0x6c6c6d6d, 0x6b6b6b6c, 0x69696a6a,
	0x10100f0f, 0x11101010, 0x12111111, 0x13121212,
	0x13131313, 0x15141414, 0x16151515, 0x17171616,
	0x18171717, 0x19191818, 0x1a1a1a19, 0x1b1b1a1a,
	0x1c1c1c1b, 0x1e1d1d1d, 0x1f1e1e1e, 0x20201f1f,
	0x21212120, 0x22222222, 0x24242323, 0x25252524,
	0x27272626, 0x28282727, 0x2a292928, 0x2b2b2a2a,
	0x2c2c2c2b, 0x2e2e2d2d, 0x302f2f2e, 0x31303030,
	0x33323231, 0x34343333, 0x36353535, 0x37373636,
	0x39393838, 0x3a3a3a3a, 0x3c3c3b3b, 0x3e3d3d3d,
	0x3f3f3f3e, 0x41414040, 0x43424241, 0x45444443,
	0x46454545, 0x48474746, 0x49494948, 0x4b4a4a4a,
	0x4c4c4c4b, 0x4e4e4d4d, 0x504f4f4f, 0x51515050,
	0x53535252, 0x54545453, 0x56565555, 0x58575756,
	0x59595958, 0x5b5a5a59, 0x5c5c5c5b, 0x5e5e5d5d,
	0x5f5f5e5e, 0x61606060, 0x62626261, 0x64636363,
	0x65656464, 0x67666665, 0x68676767, 0x69696868,
	0x6a6a6969, 0x6c6b6b6b, 0x6d6d6c6c, 0x6e6e6d6d,
	0x6f6f6f6e, 0x7070706f, 0x71717171, 0x72727272,
	0x74737373, 0x74747474, 0x75757575, 0x76767676,
	0x77777777, 0x78787877, 0x79797878, 0x7a797979,
	0x7a7a7a7a, 0x7b7b7b7a, 0x7c7b7b7b, 0x7c7c7c7c,
	0x7d7d7c7c, 0x7d7d7d7d, 0x7e7d7d7d, 0x7e7e7e7e,
	0x7e7e7e7e, 0x7f7f7f7e, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x807f7f7f,
	0x7f7f8080, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x7e7e7e7e,
	0x7e7e7e7e, 0x7d7d7e7e, 0x7d7d7d7d, 0x7c7d7d7d,
	0x7c7c7c7c, 0x7b7b7c7c, 0x7b7b7b7b, 0x7a7a7a7a,
	0x79797a7a, 0x78797979, 0x78787878, 0x77777777,
	0x76767677, 0x75757576, 0x74747475, 0x73737474,
	0x72727273, 0x71717172, 0x70707071, 0x6f6f6f6f,
	0x6d6e6e6e, 0x6c6d6d6d, 0x6b6b6c6c, 0x696a6a6b,
	0x11101010, 0x11111111, 0x12121212, 0x13131313,
	0x14141414, 0x15151515, 0x17161616, 0x17171717,
	0x19181818, 0x1a1a1919, 0x1b1a1a1a, 0x1c1c1b1b,
	0x1d1d1d1c, 0x1e1e1e1d, 0x201f1f1f, 0x21212020,
	0x22222121, 0x24232322, 0x25252424, 0x26262525,
	0x28272727, 0x29292828, 0x2a2a2a29, 0x2c2c2b2b,
	0x2d2d2d2c, 0x2f2e2e2e, 0x3030302f, 0x32323131,
	0x33333332, 0x35353434, 0x36363636, 0x38383737,
	0x3a3a3939, 0x3b3b3b3a, 0x3d3d3c3c, 0x3f3e3e3d,
	0x40403f3f, 0x42414141, 0x44434342, 0x45454444,
	0x47464645, 0x49484847, 0x4a494949, 0x4c4b4b4a,
	0x4d4d4c4c, 0x4f4e4e4d, 0x5050504f, 0x52525151,
	0x53535352, 0x55555454, 0x57565656, 0x58585757,
	0x5a595959, 0x5b5b5b5a, 0x5d5c5c5c, 0x5e5e5e5d,
	0x60605f5f, 0x61616060, 0x63626262, 0x64646463,
	0x65656564, 0x67676666, 0x68686867, 0x69696968,
	0x6b6a6a69, 0x6c6c6b6b, 0x6d6d6d6c, 0x6e6e6e6d,
	0x6f6f6f6f, 0x71707070, 0x72717171, 0x73727272,
	0x74747373, 0x75747474, 0x76757575, 0x76767676,
	0x77777777, 0x78787878, 0x79797978, 0x7a797979,
	0x7a7a7a7a, 0x7b7b7b7b, 0x7c7b7b7b, 0x7c7c7c7c,
	0x7d7d7d7c, 0x7d7d7d7d, 0x7e7e7d7d, 0x7e7e7e7e,
	0x7e7e7e7e, 0x7f7f7f7e, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x807f7f7f,
	0x7f7f8080, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x7e7e7e7e,
	0x7e7e7e7e, 0x7d7e7e7e, 0x7d7d7d7d, 0x7d7d7d7d,
	0x7c7c7c7c, 0x7b7b7c7c, 0x7b7b7b7b, 0x7a7a7a7b,
	0x79797a7a, 0x79797979, 0x78787878, 0x77777778,
	0x76767677, 0x75757676, 0x74747575, 0x73747474,
	0x72727373, 0x71717272, 0x70707171, 0x6f6f6f70,
	0x6e6e6e6f, 0x6d6d6d6d, 0x6b6c6c6c, 0x6a6a6b6b,
	0x11111111, 0x12121212, 0x13131312, 0x14141413,
	0x15151514, 0x16161615, 0x17171717, 0x18181817,
	0x1a191919, 0x1a1a1a1a, 0x1c1b1b1b, 0x1d1d1c1c,
	0x1e1e1d1d, 0x1f1f1f1e, 0x20202020, 0x22212121,
	0x23232222, 0x24242424, 0x26252525, 0x27272726,
	0x28282827, 0x2a2a2929, 0x2b2b2b2a, 0x2d2c2c2c,
	0x2e2e2e2d, 0x302f2f2f, 0x31313030, 0x33333232,
	0x34343333, 0x36363535, 0x37373736, 0x39393838,
	0x3b3a3a3a, 0x3c3c3b3b, 0x3e3d3d3d, 0x403f3f3e,
	0x41414040, 0x43424241, 0x44444443, 0x46454545,
	0x48474746, 0x49494848, 0x4b4a4a49, 0x4c4c4c4b,
	0x4e4d4d4c, 0x504f4f4e, 0x51515050, 0x53525251,
	0x54545353, 0x56555555, 0x57575656, 0x59595858,
	0x5a5a5959, 0x5c5c5b5b, 0x5d5d5d5c, 0x5f5e5e5e,
	0x6060605f, 0x62616161, 0x63636262, 0x65646464,
	0x66656565, 0x67676766, 0x68686868, 0x6a696969,
	0x6b6b6a6a, 0x6c6c6c6b, 0x6d6d6d6d, 0x6f6e6e6e,
	0x706f6f6f, 0x71707070, 0x72727171, 0x73737272,
	0x74747373, 0x75757474, 0x76767575, 0x77767676,
	0x78777777, 0x78787878, 0x79797978, 0x7a7a7979,
	0x7a7a7a7a, 0x7b7b7b7b, 0x7c7c7b7b, 0x7c7c7c7c,
	0x7d7d7d7c, 0x7d7d7d7d, 0x7e7e7d7d, 0x7e7e7e7e,
	0x7e7e7e7e, 0x7f7f7f7e, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x807f7f7f,
	0x7f7f8080, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x7e7e7e7e,
	0x7e7e7e7e, 0x7d7e7e7e, 0x7d7d7d7d, 0x7d7d7d7d,
	0x7c7c7c7c, 0x7b7c7c7c, 0x7b7b7b7b, 0x7a7a7a7b,
	0x797a7a7a, 0x79797979, 0x78787878, 0x77777878,
	0x76767777, 0x75767676, 0x74757575, 0x73747474,
	0x72737373, 0x71727272, 0x70707171, 0x6f6f7070,
	0x6e6e6f6f, 0x6d6d6d6e, 0x6c6c6c6d, 0x6a6b6b6b,
	0x12121211, 0x13131212, 0x14141313, 0x15151514,
	0x16161515, 0x17171716, 0x18181717, 0x19191918,
	0x1a1a1a1a, 0x1b1b1b1a, 0x1d1c1c1c, 0x1e1d1d1d,
	0x1f1f1e1e, 0x2020201f, 0x21212120, 0x23222222,
	0x24242323, 0x25252524, 0x27262626, 0x28282727,
	0x2a292928, 0x2b2a2a2a, 0x2c2c2c2b, 0x2e2d2d2d,
	0x2f2f2e2e, 0x30303030, 0x32323131, 0x34333333,
	0x35353434, 0x37363636, 0x38383837, 0x3a3a3939,
	0x3c3b3b3a, 0x3d3d3c3c, 0x3f3e3e3d, 0x4040403f,
	0x42414141, 0x44434342, 0x45454444, 0x47464645,
	0x48484847, 0x4a494949, 0x4c4b4b4a, 0x4d4c4c4c,
	0x4f4e4e4d, 0x5050504f, 0x52515150, 0x53535352,
	0x55545453, 0x56565655, 0x58575757, 0x59595958,
	0x5b5b5a5a, 0x5c5c5c5b, 0x5e5e5d5d, 0x5f5f5f5e,
	0x61606060, 0x62626261, 0x64636362, 0x65656464,
	0x66666565, 0x68676767, 0x69696868, 0x6a6a6969,
	0x6b6b6b6a, 0x6d6c6c6c, 0x6e6d6d6d, 0x6f6f6e6e,
	0x70706f6f, 0x71717070, 0x72727271, 0x73737372,
	0x74747473, 0x75757574, 0x76767575, 0x77777676,
	0x78777777, 0x78787878, 0x79797979, 0x7a7a7979,
	0x7b7a7a7a, 0x7b7b7b7b, 0x7c7c7b7b, 0x7c7c7c7c,
	0x7d7d7d7c, 0x7d7d7d7d, 0x7e7e7d7d, 0x7e7e7e7e,
	0x7e7e7e7e, 0x7f7f7f7e, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x807f7f7f,
	0x7f7f8080, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x7e7e7e7e,
	0x7e7e7e7e, 0x7d7e7e7e, 0x7d7d7d7d, 0x7d7d7d7d,
	0x7c7c7c7c, 0x7b7c7c7c, 0x7b7b7b7b, 0x7a7a7b7b,
	0x797a7a7a, 0x79797979, 0x78787879, 0x77777878,
	0x76777777, 0x75767676, 0x75757575, 0x74747474,
	0x73737373, 0x72727272, 0x70717171, 0x6f707070,
	0x6e6f6f6f, 0x6d6d6e6e, 0x6c6c6d6d, 0x6b6b6b6c,
	0x13131212, 0x14131313, 0x15151414, 0x16151515,
	0x17171616, 0x18181717, 0x19191818, 0x1a1a1a19,
	0x1b1b1a1a, 0x1c1c1c1b, 0x1d1d1d1d, 0x1f1e1e1e,
	0x201f1f1f, 0x21212020, 0x22222221, 0x24232322,
	0x25252424, 0x26262525, 0x28272727, 0x29282828,
	0x2a2a2a29, 0x2c2c2b2b, 0x2d2d2c2c, 0x2f2e2e2e,
	0x30302f2f, 0x32313130, 0x33333232, 0x35343433,
	0x36363635, 0x38373736, 0x39393938, 0x3b3a3a3a,
	0x3d3c3c3b, 0x3e3d3d3d, 0x403f3f3e, 0x41414140,
	0x43424241, 0x44444443, 0x46454545, 0x48474746,
	0x49494848, 0x4b4a4a49, 0x4c4c4b4b, 0x4e4d4d4c,
	0x4f4f4f4e, 0x51505050, 0x52525251, 0x54535353,
	0x56555554, 0x57565656, 0x59585857, 0x5a595959,
	0x5c5b5b5a, 0x5d5d5c5c, 0x5e5e5e5d, 0x60605f5f,
	0x61616060, 0x63626262, 0x64646363, 0x65656564,
	0x67666666, 0x68686767, 0x69696968, 0x6b6a6a69,
	0x6c6b6b6b, 0x6d6d6c6c, 0x6e6e6e6d, 0x6f6f6f6e,
	0x7070706f, 0x71717170, 0x72727272, 0x73737372,
	0x74747474, 0x75757575, 0x76767675, 0x77777776,
	0x78787777, 0x78787878, 0x79797979, 0x7a7a7a79,
	0x7b7a7a7a, 0x7b7b7b7b, 0x7c7c7c7b, 0x7c7c7c7c,
	0x7d7d7d7d, 0x7d7d7d7d, 0x7e7e7e7d, 0x7e7e7e7e,
	0x7e7e7e7e, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x807f7f7f,
	0x7f7f8080, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x7e7e7e7f,
	0x7e7e7e7e, 0x7e7e7e7e, 0x7d7d7d7d, 0x7d7d7d7d,
	0x7c7c7c7d, 0x7c7c7c7c, 0x7b7b7b7b, 0x7a7a7b7b,
	0x7a7a7a7a, 0x79797979, 0x78787879, 0x77787878,
	0x77777777, 0x76767676, 0x75757575, 0x74747475,
	0x73737374, 0x72727272, 0x71717172, 0x70707070,
	0x6f6f6f6f, 0x6e6e6e6e, 0x6c6d6d6d, 0x6b6b6c6c,
	0x14131313, 0x15141414, 0x16151515, 0x17161616,
	0x18171717, 0x19181818, 0x1a1a1919, 0x1b1a1a1a,
	0x1c1c1b1b, 0x1d1d1d1c, 0x1e1e1e1d, 0x1f1f1f1f,
	0x21202020, 0x22222121, 0x23232222, 0x25242424,
	0x26252525, 0x27272726, 0x28282828, 0x2a2a2929,
	0x2b2b2a2a, 0x2d2c2c2c, 0x2e2e2e2d, 0x302f2f2e,
	0x31303030, 0x33323231, 0x34343333, 0x36353534,
	0x37373636, 0x39383837, 0x3a3a3a39, 0x3c3b3b3a,
	0x3d3d3d3c, 0x3f3e3e3d, 0x4140403f, 0x42414141,
	0x44434342, 0x45454444, 0x47464645, 0x48484847,
	0x4a494949, 0x4b4b4b4a, 0x4d4c4c4c, 0x4e4e4e4d,
	0x50504f4f, 0x51515150, 0x53535252, 0x55545453,
	0x56565555, 0x58575756, 0x59595858, 0x5b5a5a59,
	0x5c5c5b5b, 0x5e5d5d5c, 0x5f5e5e5e, 0x6060605f,
	0x62616161, 0x63636262, 0x64646464, 0x66656565,
	0x67676766, 0x68686867, 0x6a696969, 0x6b6b6a6a,
	0x6c6c6b6b, 0x6d6d6d6c, 0x6e6e6e6e, 0x6f6f6f6f,
	0x70707070, 0x72717171, 0x72727272, 0x74737373,
	0x74747474, 0x75757575, 0x76767676, 0x77777776,
	0x78787877, 0x79787878, 0x79797979, 0x7a7a7a79,
	0x7b7b7a7a, 0x7b7b7b7b, 0x7c7c7c7b, 0x7c7c7c7c,
	0x7d7d7d7d, 0x7d7d7d7d, 0x7e7e7e7d, 0x7e7e7e7e,
	0x7e7e7e7e, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x807f7f7f,
	0x7f7f8080, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x7e7e7e7f,
	0x7e7e7e7e, 0x7e7e7e7e, 0x7d7d7d7d, 0x7d7d7d7d,
	0x7c7c7c7d, 0x7c7c7c7c, 0x7b7b7b7b, 0x7a7b7b7b,
	0x7a7a7a7a, 0x79797979, 0x78787979, 0x78787878,
	0x77777777, 0x76767676, 0x75757576, 0x74747475,
	0x73737474, 0x72727273, 0x71717272, 0x70707071,
	0x6f6f6f70, 0x6e6e6e6f, 0x6d6d6d6e, 0x6b6c6c6c,
	0x15141414, 0x15151515, 0x17161616, 0x17171717,
	0x19181818, 0x1a191919, 0x1b1a1a1a, 0x1c1b1b1b,
	0x1d1d1c1c, 0x1e1e1d1d, 0x1f1f1f1e, 0x2020201f,
	0x22212121, 0x23222222, 0x24242423, 0x25252524,
	0x27272626, 0x28282727, 0x2a292928, 0x2b2a2a2a,
	0x2c2c2c2b, 0x2e2d2d2c, 0x2f2f2e2e, 0x3030302f,
	0x32323131, 0x33333332, 0x35353434, 0x36363635,
	0x38383737, 0x3a393938, 0x3b3b3a3a, 0x3d3c3c3b,
	0x3e3e3d3d, 0x403f3f3e, 0x41414140, 0x43424241,
	0x45444443, 0x46454545, 0x48474746, 0x49494848,
	0x4b4a4a49, 0x4c4c4b4b, 0x4e4d4d4c, 0x4f4f4e4e,
	0x51505050, 0x52525151, 0x54535353, 0x55555454,
	0x57565656, 0x58585757, 0x5a595959, 0x5b5b5a5a,
	0x5d5c5c5c, 0x5e5e5d5d, 0x605f5f5e, 0x61606060,
	0x62626261, 0x64636362, 0x65656464, 0x66666565,
	0x68676767, 0x69686868, 0x6a6a6969, 0x6b6b6b6a,
	0x6c6c6c6b, 0x6e6d6d6d, 0x6f6e6e6e, 0x706f6f6f,
	0x71707070, 0x72727171, 0x73727272, 0x74747373,
	0x75747474, 0x76757575, 0x76767676, 0x77777777,
	0x78787877, 0x79797878, 0x79797979, 0x7a7a7a7a,
	0x7b7b7a7a, 0x7b7b7b7b, 0x7c7c7c7b, 0x7d7c7c7c,
	0x7d7d7d7d, 0x7d7d7d7d, 0x7e7e7e7d, 0x7e7e7e7e,
	0x7e7e7e7e, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x807f7f7f,
	0x7f7f8080, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x7e7e7e7f,
	0x7e7e7e7e, 0x7e7e7e7e, 0x7d7d7d7d, 0x7d7d7d7d,
	0x7c7c7d7d, 0x7c7c7c7c, 0x7b7b7b7b, 0x7a7b7b7b,
	0x7a7a7a7a, 0x7979797a, 0x78797979, 0x78787878,
	0x77777777, 0x76767677, 0x75757676, 0x74747575,
	0x73747474, 0x72727373, 0x71727272, 0x70707171,
	0x6f6f7070, 0x6e6e6f6f, 0x6d6d6e6e, 0x6c6c6c6d,
	0x15151515, 0x16161615, 0x17171717, 0x18181817,
	0x19191919, 0x1a1a1a1a, 0x1b1b1b1b, 0x1d1c1c1c,
	0x1e1d1d1d, 0x1f1f1e1e, 0x20201f1f, 0x21212120,
	0x22222222, 0x24242323, 0x25252424, 0x27262625,
	0x28272727, 0x29292828, 0x2a2a2a29, 0x2c2c2b2b,
	0x2d2d2c2c, 0x2e2e2e2e, 0x30302f2f, 0x31313130,
	0x33333232, 0x34343433, 0x36363535, 0x37373636,
	0x39393838, 0x3a3a3a3a, 0x3c3c3b3b, 0x3d3d3d3c,
	0x3f3f3e3e, 0x4140403f, 0x42424141, 0x44434342,
	0x45454544, 0x47464645, 0x48484847, 0x4a494949,
	0x4b4b4b4a, 0x4d4c4c4c, 0x4e4e4d4d, 0x50504f4f,
	0x51515050, 0x53535252, 0x54545353, 0x56565555,
	0x57575656, 0x59595858, 0x5a5a5959, 0x5c5c5b5b,
	0x5d5d5c5c, 0x5e5e5e5e, 0x60605f5f, 0x61616160,
	0x63626262, 0x64646463, 0x65656564, 0x67666666,
	0x68686767, 0x69696868, 0x6b6a6a69, 0x6c6b6b6b,
	0x6d6c6c6c, 0x6e6e6d6d, 0x6f6f6e6e, 0x70706f6f,
	0x71717070, 0x72727271, 0x73737272, 0x74747473,
	0x75757474, 0x76757575, 0x77767676, 0x77777777,
	0x78787878, 0x79797878, 0x7a797979, 0x7a7a7a7a,
	0x7b7b7b7a, 0x7b7b7b7b, 0x7c7c7c7c, 0x7d7c7c7c,
	0x7d7d7d7d, 0x7d7d7d7d, 0x7e7e7e7e, 0x7e7e7e7e,
	0x7e7e7e7e, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x807f7f7f,
	0x7f7f8080, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x7e7e7e7f,
	0x7e7e7e7e, 0x7e7e7e7e, 0x7d7d7d7e, 0x7d7d7d7d,
	0x7c7c7d7d, 0x7c7c7c7c, 0x7b7b7b7c, 0x7b7b7b7b,
	0x7a7a7a7a, 0x79797a7a, 0x78797979, 0x78787878,
	0x77777778, 0x76767777, 0x75757676, 0x74757575,
	0x74747474, 0x72737373, 0x72727272, 0x70717171,
	0x6f707070, 0x6e6f6f6f, 0x6d6e6e6e, 0x6c6c6d6d,
	0x16161615, 0x17171716, 0x18181817, 0x19191918,
	0x1a1a1a1a, 0x1b1b1b1a, 0x1c1c1c1c, 0x1e1d1d1d,
	0x1f1e1e1e, 0x20201f1f, 0x21212020, 0x22222221,
	0x24232322, 0x25242424, 0x26262525, 0x27272726,
	0x29282828, 0x2a2a2929, 0x2b2b2b2a, 0x2d2c2c2c,
	0x2e2e2e2d, 0x302f2f2e, 0x31303030, 0x33323231,
	0x34333333, 0x35353534, 0x37363636, 0x38383837,
	0x3a3a3939, 0x3b3b3a3a, 0x3d3d3c3c, 0x3e3e3d3d,
	0x40403f3f, 0x41414140, 0x43434242, 0x45444443,
	0x46454545, 0x48474746, 0x49494848, 0x4b4a4a49,
	0x4c4c4b4b, 0x4d4d4d4c, 0x4f4f4e4e, 0x50505050,
	0x52525151, 0x53535353, 0x55555454, 0x56565655,
	0x58585757, 0x59595958, 0x5b5b5a5a, 0x5c5c5c5b,
	0x5e5d5d5d, 0x5f5f5e5e, 0x60606060, 0x62626161,
	0x63636262, 0x64646464, 0x66656565, 0x67676766,
	0x68686867, 0x69696969, 0x6b6b6a6a, 0x6c6c6b6b,
	0x6d6d6c6c, 0x6e6e6e6d, 0x6f6f6f6e, 0x7070706f,
	0x71717170, 0x72727272, 0x73737372, 0x74747474,
	0x75757574, 0x76767575, 0x77777676, 0x78777777,
	0x78787878, 0x79797978, 0x7a797979, 0x7a7a7a7a,
	0x7b7b7b7a, 0x7c7b7b7b, 0x7c7c7c7c, 0x7d7d7c7c,
	0x7d7d7d7d, 0x7d7d7d7d, 0x7e7e7e7e, 0x7e7e7e7e,
	0x7f7e7e7e, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x807f7f7f,
	0x7f7f8080, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x7e7e7f7f,
	0x7e7e7e7e, 0x7e7e7e7e, 0x7d7d7d7e, 0x7d7d7d7d,
	0x7c7d7d7d, 0x7c7c7c7c, 0x7b7b7c7c, 0x7b7b7b7b,
	0x7a7a7a7a, 0x79797a7a, 0x79797979, 0x78787878,
	0x77777878, 0x76777777, 0x75767676, 0x75757575,
	0x74747474, 0x73737374, 0x72727272, 0x71717172,
	0x70707070, 0x6f6f6f6f, 0x6e6e6e6e, 0x6c6d6d6d,
	0x17171716, 0x18181717, 0x19191918, 0x1a1a1a19,
	0x1b1b1a1a, 0x1c1c1c1b, 0x1d1d1d1c, 0x1e1e1e1e,
	0x201f1f1f, 0x21202020, 0x22222121, 0x23232222,
	0x24242424, 0x26252525, 0x27272626, 0x28282827,
	0x2a292928, 0x2b2b2a2a, 0x2c2c2c2b, 0x2e2d2d2d,
	0x2f2f2e2e, 0x3030302f, 0x32323131, 0x33333332,
	0x35343434, 0x36363635, 0x38373736, 0x39393938,
	0x3b3a3a3a, 0x3c3c3c3b, 0x3e3d3d3d, 0x3f3f3e3e,
	0x41414040, 0x42424141, 0x44434343, 0x45454544,
	0x47464646, 0x49484847, 0x4a494949, 0x4b4b4b4a,
	0x4d4c4c4c, 0x4e4e4d4d, 0x50504f4f, 0x51515050,
	0x53535252, 0x54545353, 0x56555555, 0x57575656,
	0x59585857, 0x5a5a5959, 0x5c5b5b5a, 0x5d5c5c5c,
	0x5e5e5e5d, 0x605f5f5e, 0x61616060, 0x62626261,
	0x64636363, 0x65656464, 0x66666565, 0x67676767,
	0x69686868, 0x6a696969, 0x6b6b6b6a, 0x6c6c6c6c,
	0x6d6d6d6c, 0x6e6e6e6e, 0x6f6f6f6f, 0x70707070,
	0x72717171, 0x72727272, 0x73737373, 0x74747474,
	0x75757575, 0x76767675, 0x77777676, 0x78787777,
	0x78787878, 0x79797979, 0x7a7a7979, 0x7a7a7a7a,
	0x7b7b7b7b, 0x7c7b7b7b, 0x7c7c7c7c, 0x7d7d7c7c,
	0x7d7d7d7d, 0x7e7d7d7d, 0x7e7e7e7e, 0x7e7e7e7e,
	0x7f7e7e7e, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x807f7f7f,
	0x7f7f8080, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x7e7e7f7f,
	0x7e7e7e7e, 0x7e7e7e7e, 0x7d7d7e7e, 0x7d7d7d7d,
	0x7c7d7d7d, 0x7c7c7c7c, 0x7b7b7c7c, 0x7b7b7b7b,
	0x7a7a7a7b, 0x797a7a7a, 0x79797979, 0x78787879,
	0x77787878, 0x76777777, 0x76767676, 0x75757575,
	0x74747475, 0x73737374, 0x72727273, 0x71717272,
	0x70707071, 0x6f6f6f70, 0x6e6e6e6f, 0x6d6d6d6e,
	0x18181717, 0x19191818, 0x1a1a1a19, 0x1b1b1a1a,
	0x1c1c1b1b, 0x1d1d1d1c, 0x1e1e1e1d, 0x1f1f1f1f,
	0x20202020, 0x22212121, 0x23222222, 0x24242423,
	0x25252524, 0x27262626, 0x28282727, 0x29292828,
	0x2a2a2a2a, 0x2c2c2b2b, 0x2d2d2d2c, 0x2f2e2e2e,
	0x30302f2f, 0x31313130, 0x33333232, 0x34343333,
	0x36363535, 0x37373636, 0x39383838, 0x3a3a3a39,
	0x3c3b3b3a, 0x3d3d3d3c, 0x3f3e3e3d, 0x40403f3f,
	0x41414141, 0x43434242, 0x45444444, 0x46464545,
	0x48474746, 0x49494948, 0x4b4a4a49, 0x4c4c4b4b,
	0x4d4d4d4c, 0x4f4f4e4e, 0x50505050, 0x52525151,
	0x53535352, 0x55545454, 0x56565655, 0x58575757,
	0x59595958, 0x5b5a5a59, 0x5c5c5c5b, 0x5e5d5d5c,
	0x5f5e5e5e, 0x6060605f, 0x62616160, 0x63626262,
	0x64646463, 0x65656564, 0x67666666, 0x68686767,
	0x69696868, 0x6a6a6a69, 0x6c6b6b6b, 0x6d6c6c6c,
	0x6e6d6d6d, 0x6f6f6e6e, 0x706f6f6f, 0x71707070,
	0x72727171, 0x73727272, 0x74737373, 0x75747474,
	0x75757575, 0x76767676, 0x77777776, 0x78787777,
	0x79787878, 0x79797979, 0x7a7a7a79, 0x7b7a7a7a,
	0x7b7b7b7b, 0x7c7c7b7b, 0x7c7c7c7c, 0x7d7d7c7c,
	0x7d7d7d7d, 0x7e7d7d7d, 0x7e7e7e7e, 0x7e7e7e7e,
	0x7f7e7e7e, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x807f7f7f,
	0x7f7f8080, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x7e7e7f7f,
	0x7e7e7e7e, 0x7e7e7e7e, 0x7d7d7e7e, 0x7d7d7d7d,
	0x7c7d7d7d, 0x7c7c7c7c, 0x7b7c7c7c, 0x7b7b7b7b,
	0x7a7a7b7b, 0x7a7a7a7a, 0x79797979, 0x78787979,
	0x77787878, 0x77777777, 0x76767676, 0x75757576,
	0x74747575, 0x73737474, 0x72727373, 0x71727272,
	0x70707171, 0x6f6f7070, 0x6e6f6f6f, 0x6d6d6e6e,
	0x19191818, 0x1a1a1919, 0x1b1a1a1a, 0x1c1c1b1b,
	0x1d1d1c1c, 0x1e1e1d1d, 0x1f1f1f1e, 0x2020201f,
	0x21212121, 0x23222222, 0x24242323, 0x25252524,
	0x27262625, 0x28272727, 0x29282828, 0x2a2a2a29,
	0x2c2b2b2a, 0x2d2c2c2c, 0x2e2e2e2d, 0x302f2f2e,
	0x31303030, 0x33323231, 0x34333333, 0x35353534,
	0x37363636, 0x38383737, 0x3a3a3939, 0x3b3b3a3a,
	0x3d3c3c3c, 0x3e3e3d3d, 0x403f3f3e, 0x41414040,
	0x42424241, 0x44444343, 0x45454545, 0x47474646,
	0x49484847, 0x4a494949, 0x4b4b4b4a, 0x4d4c4c4c,
	0x4e4e4e4d, 0x50504f4f, 0x51515050, 0x53525252,
	0x54545353, 0x56555554, 0x57565656, 0x59585857,
	0x5a595959, 0x5b5b5b5a, 0x5d5c5c5c, 0x5e5e5d5d,
	0x5f5f5f5e, 0x61606060, 0x62626161, 0x63636362,
	0x65646464, 0x66656565, 0x67676766, 0x68686867,
	0x69696969, 0x6b6b6a6a, 0x6c6c6b6b, 0x6d6d6c6c,
	0x6e6e6d6d, 0x6f6f6f6e, 0x70706f6f, 0x71717070,
	0x72727271, 0x73737272, 0x74747373, 0x75757474,
	0x76757575, 0x76767676, 0x77777777, 0x78787877,
	0x79787878, 0x79797979, 0x7a7a7a79, 0x7b7a7a7a,
	0x7b7b7b7b, 0x7c7c7b7b, 0x7c7c7c7c, 0x7d7d7d7c,
	0x7d7d7d7d, 0x7e7d7d7d, 0x7e7e7e7e, 0x7e7e7e7e,
	0x7f7e7e7e, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x807f7f7f,
	0x7f7f8080, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x7e7e7f7f,
	0x7e7e7e7e, 0x7e7e7e7e, 0x7d7d7e7e, 0x7d7d7d7d,
	0x7d7d7d7d, 0x7c7c7c7c, 0x7b7c7c7c, 0x7b7b7b7b,
	0x7a7a7b7b, 0x7a7a7a7a, 0x79797979, 0x78787979,
	0x78787878, 0x77777777, 0x76767677, 0x75757676,
	0x74757575, 0x73747474, 0x72737373, 0x72727272,
	0x70717171, 0x6f707070, 0x6f6f6f6f, 0x6d6e6e6e,
	0x1a1a1919, 0x1b1a1a1a, 0x1c1b1b1b, 0x1d1d1c1c,
	0x1e1e1d1d, 0x1f1f1e1e, 0x2020201f, 0x21212120,
	0x22222221, 0x24232323, 0x25252424, 0x26262525,
	0x27272727, 0x28282828, 0x2a2a2929, 0x2b2b2a2a,
	0x2c2c2c2c, 0x2e2e2d2d, 0x2f2f2e2e, 0x30303030,
	0x32323131, 0x33333332, 0x35343434, 0x36363635,
	0x38373736, 0x39393938, 0x3b3a3a3a, 0x3c3c3b3b,
	0x3d3d3d3d, 0x3f3f3e3e, 0x4140403f, 0x42414141,
	0x43434342, 0x45454444, 0x46464545, 0x48484747,
	0x49494948, 0x4b4a4a49, 0x4c4c4c4b, 0x4e4d4d4c,
	0x4f4f4e4e, 0x50505050, 0x52525151, 0x53535352,
	0x55545454, 0x56565655, 0x58575756, 0x59595858,
	0x5a5a5a59, 0x5c5c5b5b, 0x5d5d5c5c, 0x5e5e5e5e,
	0x60605f5f, 0x61616060, 0x62626262, 0x64646363,
	0x65656464, 0x66666665, 0x68676767, 0x69686868,
	0x6a696969, 0x6b6b6b6a, 0x6c6c6c6b, 0x6d6d6d6d,
	0x6e6e6e6d, 0x6f6f6f6f, 0x7070706f, 0x71717170,
	0x72727272, 0x73737372, 0x74747473, 0x75757574,
	0x76767575, 0x77767676, 0x77777777, 0x78787878,
	0x79797878, 0x79797979, 0x7a7a7a7a, 0x7b7b7a7a,
	0x7b7b7b7b, 0x7c7c7c7b, 0x7c7c7c7c, 0x7d7d7d7c,
	0x7d7d7d7d, 0x7e7e7d7d, 0x7e7e7e7e, 0x7e7e7e7e,
	0x7f7f7e7e, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x807f7f7f,
	0x7f7f8080, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x7e7f7f7f,
	0x7e7e7e7e, 0x7e7e7e7e, 0x7d7e7e7e, 0x7d7d7d7d,
	0x7d7d7d7d, 0x7c7c7c7c, 0x7c7c7c7c, 0x7b7b7b7b,
	0x7a7b7b7b, 0x7a7a7a7a, 0x7979797a, 0x78797979,
	0x78787878, 0x77777778, 0x76767777, 0x75767676,
	0x75757575, 0x74747474, 0x73737373, 0x72727272,
	0x71717172, 0x70707070, 0x6f6f6f6f, 0x6e6e6e6f,
	0x1a1a1a1a, 0x1c1b1b1b, 0x1d1c1c1c, 0x1e1d1d1d,
	0x1f1f1e1e, 0x20201f1f, 0x21212020, 0x22222221,
	0x24232322, 0x25242424, 0x26252525, 0x27272726,
	0x28282827, 0x2a292929, 0x2b2a2a2a, 0x2c2c2c2b,
	0x2e2d2d2c, 0x2f2e2e2e, 0x3030302f, 0x32313130,
	0x33333232, 0x34343433, 0x36363535, 0x37373636,
	0x39383838, 0x3a3a3a39, 0x3c3b3b3a, 0x3d3d3c3c,
	0x3e3e3e3d, 0x40403f3f, 0x41414140, 0x43424242,
	0x44444443, 0x46454545, 0x47474646, 0x49484848,
	0x4a4a4949, 0x4c4b4b4a, 0x4d4c4c4c, 0x4e4e4e4d,
	0x50504f4f, 0x51515050, 0x53525252, 0x54545353,
	0x56555554, 0x57565656, 0x58585857, 0x5a595959,
	0x5b5b5a5a, 0x5c5c5c5c, 0x5e5e5d5d, 0x5f5f5e5e,
	0x60606060, 0x62616161, 0x63636262, 0x64646463,
	0x65656565, 0x67676666, 0x68686767, 0x69696868,
	0x6a6a6a69, 0x6c6b6b6b, 0x6d6c6c6c, 0x6e6d6d6d,
	0x6f6e6e6e, 0x6f6f6f6f, 0x71707070, 0x72717171,
	0x72727272, 0x73737373, 0x74747474, 0x75757574,
	0x76767675, 0x77777676, 0x78777777, 0x78787878,
	0x79797978, 0x7a797979, 0x7a7a7a7a, 0x7b7b7b7a,
	0x7b7b7b7b, 0x7c7c7c7b, 0x7c7c7c7c, 0x7d7d7d7d,
	0x7d7d7d7d, 0x7e7e7d7d, 0x7e7e7e7e, 0x7e7e7e7e,
	0x7f7f7e7e, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x807f7f7f,
	0x7f7f8080, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x7e7f7f7f,
	0x7e7e7e7e, 0x7e7e7e7e, 0x7d7e7e7e, 0x7d7d7d7d,
	0x7d7d7d7d, 0x7c7c7c7d, 0x7c7c7c7c, 0x7b7b7b7b,
	0x7b7b7b7b, 0x7a7a7a7a, 0x79797a7a, 0x79797979,
	0x78787878, 0x77777878, 0x76777777, 0x76767676,
	0x75757575, 0x74747474, 0x73737374, 0x72727273,
	0x71717272, 0x70707171, 0x6f6f6f70, 0x6e6e6f6f,
	0x1b1b1b1b, 0x1d1c1c1c, 0x1e1d1d1d, 0x1f1e1e1e,
	0x20201f1f, 0x21212020, 0x22222121, 0x23232222,
	0x24242424, 0x26252525, 0x27272626, 0x28282727,
	0x29292928, 0x2b2a2a2a, 0x2c2c2b2b, 0x2d2d2c2c,
	0x2e2e2e2e, 0x30302f2f, 0x31313030, 0x33323232,
	0x34343333, 0x36353534, 0x37363636, 0x38383737,
	0x3a3a3939, 0x3b3b3a3a, 0x3d3c3c3b, 0x3e3d3d3d,
	0x3f3f3f3e, 0x41414040, 0x42424141, 0x44434343,
	0x45454544, 0x47464645, 0x48484747, 0x49494949,
	0x4b4b4a4a, 0x4c4c4c4b, 0x4e4d4d4c, 0x4f4f4e4e,
	0x50505050, 0x52525151, 0x53535352, 0x55545454,
	0x56565655, 0x58575756, 0x59595858, 0x5a5a5959,
	0x5c5c5b5b, 0x5d5d5c5c, 0x5e5e5e5d, 0x605f5f5f,
	0x61616060, 0x62626261, 0x64636362, 0x65646464,
	0x66666565, 0x67676766, 0x68686867, 0x69696969,
	0x6b6b6a6a, 0x6c6c6b6b, 0x6d6d6c6c, 0x6e6e6d6d,
	0x6f6f6e6e, 0x706f6f6f, 0x71717070, 0x72727171,
	0x73727272, 0x74737373, 0x74747474, 0x75757575,
	0x76767675, 0x77777776, 0x78787777, 0x78787878,
	0x79797978, 0x7a797979, 0x7a7a7a7a, 0x7b7b7b7a,
	0x7b7b7b7b, 0x7c7c7c7c, 0x7c7c7c7c, 0x7d7d7d7d,
	0x7d7d7d7d, 0x7e7e7e7d, 0x7e7e7e7e, 0x7e7e7e7e,
	0x7f7f7e7e, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x807f7f7f,
	0x7f7f8080, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x7e7f7f7f,
	0x7e7e7e7e, 0x7e7e7e7e, 0x7e7e7e7e, 0x7d7d7d7d,
	0x7d7d7d7d, 0x7c7c7c7d, 0x7c7c7c7c, 0x7b7b7b7c,
	0x7b7b7b7b, 0x7a7a7a7a, 0x79797a7a, 0x79797979,
	0x78787878, 0x77787878, 0x77777777, 0x76767676,
	0x75757575, 0x74747475, 0x73737474, 0x72727373,
	0x71727272, 0x70717171, 0x6f6f7070, 0x6e6f6f6f,
	0x1c1c1c1c, 0x1e1d1d1d, 0x1f1e1e1e, 0x201f1f1f,
	0x21202020, 0x22222121, 0x23232222, 0x24242423,
	0x25252525, 0x27262626, 0x28282727, 0x29292828,
	0x2a2a2a2a, 0x2c2b2b2b, 0x2d2d2c2c, 0x2e2e2e2d,
	0x302f2f2e, 0x31303030, 0x32323231, 0x33333333,
	0x35353434, 0x36363635, 0x38373737, 0x39393938,
	0x3b3a3a3a, 0x3c3c3b3b, 0x3d3d3d3d, 0x3f3e3e3e,
	0x4040403f, 0x42414141, 0x43434242, 0x45444444,
	0x46464545, 0x48474746, 0x49494848, 0x4a4a4949,
	0x4c4b4b4b, 0x4d4d4c4c, 0x4f4e4e4d, 0x50504f4f,
	0x51515050, 0x53525252, 0x54545353, 0x56555554,
	0x57565656, 0x58585857, 0x59595959, 0x5b5b5a5a,
	0x5c5c5c5b, 0x5e5d5d5d, 0x5f5e5e5e, 0x6060605f,
	0x62616160, 0x63626262, 0x64646463, 0x65656564,
	0x67666665, 0x68676767, 0x69686868, 0x6a696969,
	0x6b6b6b6a, 0x6c6c6c6b, 0x6d6d6d6c, 0x6e6e6e6e,
	0x6f6f6f6e, 0x7070706f, 0x71717170, 0x72727271,
	0x73737272, 0x74747373, 0x75747474, 0x75757575,
	0x76767676, 0x77777776, 0x78787777, 0x78787878,
	0x79797979, 0x7a7a7979, 0x7a7a7a7a, 0x7b7b7b7b,
	0x7b7b7b7b, 0x7c7c7c7c, 0x7d7c7c7c, 0x7d7d7d7d,
	0x7d7d7d7d, 0x7e7e7e7d, 0x7e7e7e7e, 0x7e7e7e7e,
	0x7f7f7f7e, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x807f7f7f,
	0x7f7f8080, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7e7e7e7e, 0x7e7e7e7e, 0x7e7e7e7e, 0x7d7d7d7d,
	0x7d7d7d7d, 0x7c7c7d7d, 0x7c7c7c7c, 0x7b7b7b7c,
	0x7b7b7b7b, 0x7a7a7a7b, 0x797a7a7a, 0x79797979,
	0x78787879, 0x77787878, 0x77777777, 0x76767676,
	0x75757576, 0x74747575, 0x73747474, 0x72737373,
	0x72727272, 0x71717171, 0x70707070, 0x6f6f6f6f,
	0x1d1d1d1d, 0x1e1e1e1e, 0x201f1f1f, 0x21202020,
	0x22212121, 0x23222222, 0x24242423, 0x25252524,
	0x27262625, 0x28272727, 0x29282828, 0x2a2a2a29,
	0x2c2b2b2a, 0x2d2c2c2c, 0x2e2e2d2d, 0x2f2f2f2e,
	0x30303030, 0x32323131, 0x33333332, 0x35343433,
	0x36363535, 0x37373736, 0x39393838, 0x3a3a3a39,
	0x3c3b3b3a, 0x3d3d3c3c, 0x3e3e3e3d, 0x40403f3f,
	0x41414140, 0x43424241, 0x44444343, 0x45454545,
	0x47464646, 0x48484847, 0x4a494949, 0x4b4b4a4a,
	0x4c4c4c4c, 0x4e4d4d4d, 0x4f4f4f4e, 0x51505050,
	0x52525151, 0x53535353, 0x55545454, 0x56565655,
	0x58575756, 0x59595858, 0x5a5a5959, 0x5c5b5b5b,
	0x5d5c5c5c, 0x5e5e5e5d, 0x605f5f5e, 0x61606060,
	0x62626161, 0x63636362, 0x64646464, 0x66656565,
	0x67676666, 0x68686767, 0x69696968, 0x6a6a6a69,
	0x6c6b6b6b, 0x6d6c6c6c, 0x6e6d6d6d, 0x6f6e6e6e,
	0x6f6f6f6f, 0x70707070, 0x71717171, 0x72727272,
	0x73737372, 0x74747473, 0x75757474, 0x76757575,
	0x76767676, 0x77777777, 0x78787877, 0x79787878,
	0x79797979, 0x7a7a7a79, 0x7b7a7a7a, 0x7b7b7b7b,
	0x7c7b7b7b, 0x7c7c7c7c, 0x7d7c7c7c, 0x7d7d7d7d,
	0x7d7d7d7d, 0x7e7e7e7d, 0x7e7e7e7e, 0x7e7e7e7e,
	0x7f7f7f7e, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x807f7f7f,
	0x7f7f8080, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7e7e7e7e, 0x7e7e7e7e, 0x7e7e7e7e, 0x7d7d7d7d,
	0x7d7d7d7d, 0x7c7c7d7d, 0x7c7c7c7c, 0x7b7b7c7c,
	0x7b7b7b7b, 0x7a7a7b7b, 0x7a7a7a7a, 0x79797979,
	0x78787979, 0x78787878, 0x77777777, 0x76767677,
	0x75757676, 0x74757575, 0x74747474, 0x73737373,
	0x72727272, 0x71717172, 0x70707071, 0x6f6f6f70,
	0x1e1e1e1e, 0x1f1f1f1f, 0x21202020, 0x22212121,
	0x23222222, 0x24242323, 0x25252524, 0x26262625,
	0x28272727, 0x29282828, 0x2a2a2929, 0x2b2b2a2a,
	0x2c2c2c2c, 0x2e2e2d2d, 0x2f2f2e2e, 0x3030302f,
	0x32313130, 0x33333232, 0x34343333, 0x36353535,
	0x37373636, 0x39383837, 0x3a3a3939, 0x3b3b3a3a,
	0x3d3c3c3c, 0x3e3d3d3d, 0x3f3f3f3e, 0x41414040,
	0x42424141, 0x44434342, 0x45454444, 0x46464645,
	0x48474747, 0x49494948, 0x4b4a4a49, 0x4c4c4b4b,
	0x4d4d4c4c, 0x4f4e4e4e, 0x5050504f, 0x51515150,
	0x53535252, 0x54545353, 0x56555554, 0x57565656,
	0x58585857, 0x59595959, 0x5b5b5a5a, 0x5c5c5c5b,
	0x5e5d5d5c, 0x5f5e5e5e, 0x60605f5f, 0x61616160,
	0x62626262, 0x64646363, 0x65656464, 0x66666565,
	0x67676767, 0x68686868, 0x69696969, 0x6b6b6a6a,
	0x6c6c6b6b, 0x6d6d6c6c, 0x6e6e6d6d, 0x6f6f6f6e,
	0x706f6f6f, 0x71707070, 0x72717171, 0x72727272,
	0x73737373, 0x74747474, 0x75757574, 0x76767575,
	0x77767676, 0x77777777, 0x78787878, 0x79797878,
	0x79797979, 0x7a7a7a7a, 0x7b7a7a7a, 0x7b7b7b7b,
	0x7c7c7b7b, 0x7c7c7c7c, 0x7d7d7c7c, 0x7d7d7d7d,
	0x7d7d7d7d, 0x7e7e7e7e, 0x7e7e7e7e, 0x7e7e7e7e,
	0x7f7f7f7e, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x807f7f7f,
	0x7f7f8080, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7e7e7e7e, 0x7e7e7e7e, 0x7e7e7e7e, 0x7d7d7d7e,
	0x7d7d7d7d, 0x7c7d7d7d, 0x7c7c7c7c, 0x7b7c7c7c,
	0x7b7b7b7b, 0x7a7a7b7b, 0x7a7a7a7a, 0x7979797a,
	0x78797979, 0x78787878, 0x77777778, 0x76767777,
	0x75767676, 0x75757575, 0x74747474, 0x73737374,
	0x72727273, 0x71717272, 0x70707171, 0x6f6f7070,
	0x1f1f1f1f, 0x20202020, 0x21212121, 0x23222222,
	0x24242323, 0x25252424, 0x26262525, 0x27272727,
	0x28282828, 0x2a2a2929, 0x2b2b2a2a, 0x2c2c2c2b,
	0x2e2d2d2c, 0x2f2e2e2e, 0x30302f2f, 0x31313130,
	0x33323232, 0x34343333, 0x35353534, 0x37363636,
	0x38383737, 0x3a393939, 0x3b3a3a3a, 0x3c3c3c3b,
	0x3d3d3d3d, 0x3f3f3e3e, 0x4040403f, 0x42414141,
	0x43434242, 0x45444444, 0x46454545, 0x47474746,
	0x49484848, 0x4a4a4949, 0x4b4b4b4a, 0x4d4c4c4c,
	0x4e4e4d4d, 0x504f4f4f, 0x51505050, 0x52525251,
	0x53535353, 0x55555454, 0x56565655, 0x58575756,
	0x59595858, 0x5a5a5959, 0x5c5b5b5b, 0x5d5c5c5c,
	0x5e5e5e5d, 0x5f5f5f5e, 0x60606060, 0x62626161,
	0x63636262, 0x64646464, 0x65656565, 0x67666666,
	0x68676767, 0x69696868, 0x6a6a6969, 0x6b6b6b6a,
	0x6c6c6c6b, 0x6d6d6d6d, 0x6e6e6e6e, 0x6f6f6f6f,
	0x70706f6f, 0x71717070, 0x72727271, 0x73727272,
	0x74747373, 0x74747474, 0x75757575, 0x76767675,
	0x77777676, 0x78777777, 0x78787878, 0x79797978,
	0x79797979, 0x7a7a7a7a, 0x7b7b7a7a, 0x7b7b7b7b,
	0x7c7c7b7b, 0x7c7c7c7c, 0x7d7d7d7c, 0x7d7d7d7d,
	0x7d7d7d7d, 0x7e7e7e7e, 0x7e7e7e7e, 0x7e7e7e7e,
	0x7f7f7f7e, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x807f7f7f,
	0x7f7f8080, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7e7e7e7e, 0x7e7e7e7e, 0x7e7e7e7e, 0x7d7d7d7e,
	0x7d7d7d7d, 0x7d7d7d7d, 0x7c7c7c7c, 0x7b7c7c7c,
	0x7b7b7b7b, 0x7a7b7b7b, 0x7a7a7a7a, 0x7979797a,
	0x79797979, 0x78787878, 0x77777878, 0x76777777,
	0x76767676, 0x75757575, 0x74747475, 0x73747474,
	0x72727373, 0x72727272, 0x70717171, 0x6f707070,
	0x20202020, 0x21212121, 0x22222222, 0x24242323,
	0x25252424, 0x26262525, 0x27272726, 0x28282828,
	0x2a292929, 0x2b2a2a2a, 0x2c2c2c2b, 0x2d2d2d2c,
	0x2e2e2e2e, 0x30302f2f, 0x31313030, 0x33323231,
	0x34333333, 0x35353434, 0x36363636, 0x38373737,
	0x39393938, 0x3a3a3a3a, 0x3c3b3b3b, 0x3d3d3d3c,
	0x3e3e3e3d, 0x40403f3f, 0x41414140, 0x43424241,
	0x44444343, 0x45454545, 0x47464646, 0x48484847,
	0x49494949, 0x4b4b4a4a, 0x4c4c4c4b, 0x4d4d4d4c,
	0x4f4f4e4e, 0x5050504f, 0x52515150, 0x53535252,
	0x54545353, 0x56555555, 0x57565656, 0x58585857,
	0x59595959, 0x5b5b5a5a, 0x5c5c5c5b, 0x5e5d5d5c,
	0x5f5e5e5e, 0x60605f5f, 0x61616060, 0x62626262,
	0x64636363, 0x65646464, 0x66656565, 0x67676766,
	0x68686867, 0x69696968, 0x6b6a6a69, 0x6c6b6b6b,
	0x6d6c6c6c, 0x6e6d6d6d, 0x6f6e6e6e, 0x6f6f6f6f,
	0x7070706f, 0x71717171, 0x72727272, 0x73737372,
	0x74747473, 0x75757474, 0x75757575, 0x76767676,
	0x77777776, 0x78787777, 0x78787878, 0x79797979,
	0x7a797979, 0x7a7a7a7a, 0x7b7b7b7a, 0x7b7b7b7b,
	0x7c7c7c7b, 0x7c7c7c7c, 0x7d7d7d7c, 0x7d7d7d7d,
	0x7e7d7d7d, 0x7e7e7e7e, 0x7e7e7e7e, 0x7e7e7e7e,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x807f7f7f,
	0x7f7f8080, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7e7e7e7f, 0x7e7e7e7e, 0x7e7e7e7e, 0x7d7d7e7e,
	0x7d7d7d7d, 0x7d7d7d7d, 0x7c7c7c7c, 0x7c7c7c7c,
	0x7b7b7b7b, 0x7b7b7b7b, 0x7a7a7a7a, 0x79797a7a,
	0x79797979, 0x78787879, 0x77787878, 0x77777777,
	0x76767676, 0x75757576, 0x74757575, 0x74747474,
	0x73737373, 0x72727272, 0x71717172, 0x70707071,
	0x21212121, 0x22222222, 0x24242323, 0x25252424,
	0x26262525, 0x27272726, 0x28282827, 0x2a292928,
	0x2b2a2a2a, 0x2c2c2b2b, 0x2d2d2c2c, 0x2e2e2e2e,
	0x302f2f2f, 0x31303030, 0x32323231, 0x33333333,
	0x35343434, 0x36363635, 0x37373736, 0x39393838,
	0x3a3a3a39, 0x3b3b3b3a, 0x3d3d3c3c, 0x3e3e3d3d,
	0x403f3f3e, 0x41414040, 0x42424141, 0x44434343,
	0x45454444, 0x46464545, 0x48474747, 0x49494948,
	0x4a4a4a49, 0x4c4b4b4b, 0x4d4d4c4c, 0x4e4e4e4d,
	0x50504f4f, 0x51515050, 0x53525251, 0x54535353,
	0x55555454, 0x56565655, 0x58575757, 0x59595858,
	0x5a5a5959, 0x5c5b5b5b, 0x5d5c5c5c, 0x5e5e5e5d,
	0x5f5f5f5e, 0x60606060, 0x62626161, 0x63636262,
	0x64646463, 0x65656564, 0x67666665, 0x68676767,
	0x69686868, 0x6a696969, 0x6b6b6a6a, 0x6c6c6b6b,
	0x6d6d6c6c, 0x6e6e6d6d, 0x6f6f6f6e, 0x706f6f6f,
	0x71707070, 0x72717171, 0x72727272, 0x73737373,
	0x74747474, 0x75757574, 0x76757575, 0x76767676,
	0x77777777, 0x78787877, 0x78787878, 0x79797979,
	0x7a7a7979, 0x7a7a7a7a, 0x7b7b7b7a, 0x7b7b7b7b,
	0x7c7c7c7b, 0x7c7c7c7c, 0x7d7d7d7d, 0x7d7d7d7d,
	0x7e7d7d7d, 0x7e7e7e7e, 0x7e7e7e7e, 0x7e7e7e7e,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x807f7f7f,
	0x7f7f8080, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7e7e7e7f, 0x7e7e7e7e, 0x7e7e7e7e, 0x7d7d7e7e,
	0x7d7d7d7d, 0x7d7d7d7d, 0x7c7c7c7d, 0x7c7c7c7c,
	0x7b7b7b7b, 0x7b7b7b7b, 0x7a7a7a7a, 0x797a7a7a,
	0x79797979, 0x78787879, 0x78787878, 0x77777777,
	0x76767677, 0x75757676, 0x75757575, 0x74747474,
	0x73737374, 0x72727273, 0x71717272, 0x70707171,
	0x22222222, 0x24232323, 0x25242424, 0x26252525,
	0x27272726, 0x28282827, 0x29292928, 0x2a2a2a2a,
	0x2c2c2b2b, 0x2d2d2c2c, 0x2e2e2e2d, 0x2f2f2f2e,
	0x31303030, 0x32323131, 0x33333332, 0x35343433,
	0x36363535, 0x37373636, 0x39383837, 0x3a3a3939,
	0x3b3b3a3a, 0x3d3c3c3c, 0x3e3d3d3d, 0x3f3f3e3e,
	0x41404040, 0x42414141, 0x43434242, 0x45444444,
	0x46454545, 0x47474746, 0x49484848, 0x4a494949,
	0x4b4b4b4a, 0x4c4c4c4c, 0x4e4d4d4d, 0x4f4f4f4e,
	0x50505050, 0x52525151, 0x53535352, 0x54545453,
	0x56565555, 0x57575656, 0x58585857, 0x59595959,
	0x5b5b5a5a, 0x5c5c5c5b, 0x5e5d5d5c, 0x5f5e5e5e,
	0x60605f5f, 0x61616060, 0x62626261, 0x64636362,
	0x65646464, 0x66656565, 0x67676666, 0x68686767,
	0x69696868, 0x6a6a6969, 0x6b6b6b6b, 0x6c6c6c6c,
	0x6d6d6d6d, 0x6e6e6e6e, 0x6f6f6f6f, 0x7070706f,
	0x71717070, 0x72727171, 0x73727272, 0x74737373,
	0x74747474, 0x75757575, 0x76767575, 0x77767676,
	0x77777777, 0x78787878, 0x79787878, 0x79797979,
	0x7a7a7a79, 0x7a7a7a7a, 0x7b7b7b7b, 0x7b7b7b7b,
	0x7c7c7c7c, 0x7c7c7c7c, 0x7d7d7d7d, 0x7d7d7d7d,
	0x7e7e7d7d, 0x7e7e7e7e, 0x7e7e7e7e, 0x7e7e7e7e,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x807f7f7f,
	0x7f7f8080, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7e7e7e7f, 0x7e7e7e7e, 0x7e7e7e7e, 0x7d7e7e7e,
	0x7d7d7d7d, 0x7d7d7d7d, 0x7c7c7c7d, 0x7c7c7c7c,
	0x7b7b7b7c, 0x7b7b7b7b, 0x7a7a7a7b, 0x7a7a7a7a,
	0x79797979, 0x78787979, 0x78787878, 0x77777778,
	0x76767777, 0x75767676, 0x75757575, 0x74747475,
	0x73737474, 0x72727373, 0x71727272, 0x70717171,
	0x24232323, 0x25242424, 0x26252525, 0x27272726,
	0x28282827, 0x29292928, 0x2a2a2a2a, 0x2c2b2b2b,
	0x2d2c2c2c, 0x2e2e2e2d, 0x2f2f2f2e, 0x30303030,
	0x32313131, 0x33333332, 0x34343433, 0x36353535,
	0x37363636, 0x38383837, 0x3a393939, 0x3b3a3a3a,
	0x3c3c3c3b, 0x3d3d3d3d, 0x3f3e3e3e, 0x4040403f,
	0x41414141, 0x43424242, 0x44444443, 0x45454545,
	0x47464646, 0x48484847, 0x49494949, 0x4b4a4a4a,
	0x4c4c4c4b, 0x4d4d4d4c, 0x4f4e4e4e, 0x5050504f,
	0x51515150, 0x53525252, 0x54535353, 0x55555554,
	0x56565656, 0x58575757, 0x59595958, 0x5a5a5a59,
	0x5c5b5b5b, 0x5d5c5c5c, 0x5e5e5e5d, 0x5f5f5f5e,
	0x60606060, 0x62616161, 0x63626262, 0x64646463,
	0x65656564, 0x66666665, 0x67676767, 0x68686868,
	0x69696969, 0x6b6a6a6a, 0x6c6b6b6b, 0x6d6c6c6c,
	0x6e6d6d6d, 0x6f6e6e6e, 0x6f6f6f6f, 0x70707070,
	0x71717170, 0x72727271, 0x73737272, 0x74747373,
	0x75747474, 0x75757575, 0x76767675, 0x77777676,
	0x78777777, 0x78787878, 0x79797878, 0x79797979,
	0x7a7a7a79, 0x7b7a7a7a, 0x7b7b7b7b, 0x7c7b7b7b,
	0x7c7c7c7c, 0x7d7c7c7c, 0x7d7d7d7d, 0x7d7d7d7d,
	0x7e7e7d7d, 0x7e7e7e7e, 0x7e7e7e7e, 0x7f7e7e7e,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x807f7f7f,
	0x7f7f8080, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7e7e7f7f, 0x7e7e7e7e, 0x7e7e7e7e, 0x7d7e7e7e,
	0x7d7d7d7d, 0x7d7d7d7d, 0x7c7c7d7d, 0x7c7c7c7c,
	0x7b7b7c7c, 0x7b7b7b7b, 0x7a7a7b7b, 0x7a7a7a7a,
	0x79797979, 0x78797979, 0x78787878, 0x77777878,
	0x76777777, 0x76767676, 0x75757575, 0x74747575,
	0x73747474, 0x72737373, 0x72727272, 0x71717171,
	0x25242424, 0x26252525, 0x27272726, 0x28282827,
	0x29292828, 0x2a2a2a2a, 0x2c2b2b2b, 0x2d2c2c2c,
	0x2e2e2d2d, 0x2f2f2e2e, 0x30303030, 0x32313131,
	0x33333232, 0x34343333, 0x36353534, 0x37363636,
	0x38383737, 0x3a393938, 0x3b3a3a3a, 0x3c3c3b3b,
	0x3d3d3d3c, 0x3e3e3e3d, 0x40403f3f, 0x41414140,
	0x42424241, 0x44444343, 0x45454544, 0x46464645,
	0x48474747, 0x49494948, 0x4a4a4a49, 0x4c4b4b4b,
	0x4d4c4c4c, 0x4e4e4e4d, 0x504f4f4f, 0x51505050,
	0x52525151, 0x53535353, 0x55545454, 0x56565555,
	0x57575656, 0x59585858, 0x5a595959, 0x5b5b5a5a,
	0x5c5c5c5b, 0x5e5d5d5c, 0x5f5e5e5e, 0x60605f5f,
	0x61616060, 0x62626261, 0x64636362, 0x65646464,
	0x65656565, 0x67676666, 0x68686767, 0x69696868,
	0x6a6a6969, 0x6b6b6b6a, 0x6c6c6c6b, 0x6d6d6d6c,
	0x6e6e6e6d, 0x6f6f6f6e, 0x706f6f6f, 0x71707070,
	0x72717171, 0x72727272, 0x73737372, 0x74747473,
	0x75757474, 0x76757575, 0x76767676, 0x77777776,
	0x78787777, 0x78787878, 0x79797978, 0x79797979,
	0x7a7a7a7a, 0x7b7b7a7a, 0x7b7b7b7b, 0x7c7c7b7b,
	0x7c7c7c7c, 0x7d7c7c7c, 0x7d7d7d7d, 0x7d7d7d7d,
	0x7e7e7e7d, 0x7e7e7e7e, 0x7e7e7e7e, 0x7f7e7e7e,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x807f7f7f,
	0x7f7f8080, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7e7e7f7f, 0x7e7e7e7e, 0x7e7e7e7e, 0x7e7e7e7e,
	0x7d7d7d7d, 0x7d7d7d7d, 0x7c7c7d7d, 0x7c7c7c7c,
	0x7b7c7c7c, 0x7b7b7b7b, 0x7a7b7b7b, 0x7a7a7a7a,
	0x7979797a, 0x79797979, 0x78787878, 0x77787878,
	0x77777777, 0x76767676, 0x75757676, 0x74757575,
	0x74747474, 0x73737373, 0x72727272, 0x71717272,
	0x26252525, 0x27272726, 0x28282727, 0x29292828,
	0x2a2a2a2a, 0x2c2b2b2b, 0x2d2c2c2c, 0x2e2e2d2d,
	0x2f2f2e2e, 0x3030302f, 0x31313130, 0x33333232,
	0x34343333, 0x35353534, 0x36363636, 0x38373737,
	0x39393938, 0x3a3a3a3a, 0x3c3b3b3b, 0x3d3d3c3c,
	0x3e3e3d3d, 0x403f3f3f, 0x41414040, 0x42424141,
	0x44434342, 0x45454444, 0x46464545, 0x47474746,
	0x49494848, 0x4a4a4949, 0x4b4b4b4a, 0x4c4c4c4c,
	0x4e4d4d4d, 0x4f4f4f4e, 0x50505050, 0x52515151,
	0x53535252, 0x54545353, 0x56555554, 0x57565656,
	0x58585757, 0x59595958, 0x5a5a5a59, 0x5c5c5b5b,
	0x5d5d5c5c, 0x5e5e5e5d, 0x5f5f5f5e, 0x60606060,
	0x62616161, 0x63626262, 0x64646363, 0x65656464,
	0x66666565, 0x67676767, 0x68686867, 0x69696968,
	0x6b6a6a69, 0x6c6b6b6b, 0x6c6c6c6c, 0x6d6d6d6d,
	0x6e6e6e6e, 0x6f6f6f6f, 0x7070706f, 0x71717170,
	0x72727171, 0x73727272, 0x74737373, 0x74747474,
	0x75757574, 0x76767575, 0x76767676, 0x77777777,
	0x78787877, 0x78787878, 0x79797979, 0x7a797979,
	0x7a7a7a7a, 0x7b7b7a7a, 0x7b7b7b7b, 0x7c7c7b7b,
	0x7c7c7c7c, 0x7d7d7c7c, 0x7d7d7d7d, 0x7d7d7d7d,
	0x7e7e7e7d, 0x7e7e7e7e, 0x7e7e7e7e, 0x7f7f7e7e,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x807f7f7f,
	0x7f7f8080, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7e7f7f7f, 0x7e7e7e7e, 0x7e7e7e7e, 0x7e7e7e7e,
	0x7d7d7d7d, 0x7d7d7d7d, 0x7c7d7d7d, 0x7c7c7c7c,
	0x7b7c7c7c, 0x7b7b7b7b, 0x7a7b7b7b, 0x7a7a7a7a,
	0x79797a7a, 0x79797979, 0x78787879, 0x78787878,
	0x77777777, 0x76767677, 0x75767676, 0x75757575,
	0x74747474, 0x73737474, 0x72727373, 0x71727272,
	0x27272726, 0x28282727, 0x29292828, 0x2a2a2a2a,
	0x2c2b2b2a, 0x2d2c2c2c, 0x2e2e2d2d, 0x2f2f2e2e,
	0x3030302f, 0x31313130, 0x33323232, 0x34333333,
	0x35353434, 0x36363636, 0x38373737, 0x39393838,
	0x3a3a3a39, 0x3b3b3b3a, 0x3d3d3c3c, 0x3e3e3d3d,
	0x3f3f3f3e, 0x41404040, 0x42414141, 0x43434242,
	0x45444444, 0x46454545, 0x47474646, 0x49484847,
	0x49494949, 0x4b4b4a4a, 0x4c4c4c4b, 0x4d4d4d4c,
	0x4f4e4e4e, 0x50504f4f, 0x51515050, 0x53525252,
	0x54535353, 0x55555454, 0x56565655, 0x57575756,
	0x59595858, 0x5a595959, 0x5b5b5b5a, 0x5c5c5c5c,
	0x5e5d5d5d, 0x5f5e5e5e, 0x60605f5f, 0x61616060,
	0x62626261, 0x63636362, 0x64646464, 0x65656565,
	0x67666666, 0x68676767, 0x69686868, 0x6a696969,
	0x6b6b6a6a, 0x6c6c6b6b, 0x6d6d6c6c, 0x6e6e6d6d,
	0x6f6f6e6e, 0x6f6f6f6f, 0x70707070, 0x71717171,
	0x72727271, 0x73737272, 0x74747373, 0x74747474,
	0x75757575, 0x76767675, 0x77767676, 0x77777777,
	0x78787878, 0x79787878, 0x79797979, 0x7a7a7979,
	0x7a7a7a7a, 0x7b7b7b7a, 0x7b7b7b7b, 0x7c7c7c7b,
	0x7c7c7c7c, 0x7d7d7d7c, 0x7d7d7d7d, 0x7d7d7d7d,
	0x7e7e7e7e, 0x7e7e7e7e, 0x7e7e7e7e, 0x7f7f7e7e,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x807f7f7f,
	0x7f7f8080, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7e7f7f7f, 0x7e7e7e7e, 0x7e7e7e7e, 0x7e7e7e7e,
	0x7d7d7d7e, 0x7d7d7d7d, 0x7d7d7d7d, 0x7c7c7c7c,
	0x7c7c7c7c, 0x7b7b7b7b, 0x7b7b7b7b, 0x7a7a7a7a,
	0x797a7a7a, 0x79797979, 0x78787979, 0x78787878,
	0x77777778, 0x76767777, 0x76767676, 0x75757575,
	0x74747475, 0x73747474, 0x72737373, 0x72727272,
	0x28282827, 0x29292828, 0x2a2a2a2a, 0x2c2b2b2a,
	0x2d2c2c2c, 0x2e2e2d2d, 0x2f2f2e2e, 0x3030302f,
	0x31313130, 0x33323232, 0x34333333, 0x35353434,
	0x36363635, 0x37373736, 0x39393838, 0x3a3a3a39,
	0x3b3b3b3a, 0x3d3c3c3c, 0x3e3d3d3d, 0x3f3f3e3e,
	0x4140403f, 0x41414141, 0x43434242, 0x44444443,
	0x45454545, 0x47464646, 0x48484747, 0x49494948,
	0x4b4a4a49, 0x4c4c4b4b, 0x4d4d4c4c, 0x4e4e4e4d,
	0x504f4f4f, 0x51505050, 0x52525151, 0x53535352,
	0x55545453, 0x56565555, 0x57575656, 0x58585857,
	0x59595959, 0x5b5a5a5a, 0x5c5c5b5b, 0x5d5d5c5c,
	0x5e5e5e5d, 0x5f5f5f5e, 0x60606060, 0x62616161,
	0x63626262, 0x64646363, 0x65656464, 0x66666565,
	0x67676766, 0x68686867, 0x69696968, 0x6a6a6a69,
	0x6b6b6b6b, 0x6c6c6c6c, 0x6d6d6d6d, 0x6e6e6e6d,
	0x6f6f6f6e, 0x70706f6f, 0x71717070, 0x72717171,
	0x72727272, 0x73737372, 0x74747473, 0x75757474,
	0x75757575, 0x76767676, 0x77777676, 0x78777777,
	0x78787878, 0x79797878, 0x79797979, 0x7a7a7a79,
	0x7a7a7a7a, 0x7b7b7b7b, 0x7b7b7b7b, 0x7c7c7c7c,
	0x7c7c7c7c, 0x7d7d7d7c, 0x7d7d7d7d, 0x7d7d7d7d,
	0x7e7e7e7e, 0x7e7e7e7e, 0x7e7e7e7e, 0x7f7f7e7e,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x807f7f7f,
	0x7f7f8080, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7e7f7f7f, 0x7e7e7e7e, 0x7e7e7e7e, 0x7e7e7e7e,
	0x7d7d7d7e, 0x7d7d7d7d, 0x7d7d7d7d, 0x7c7c7c7c,
	0x7c7c7c7c, 0x7b7b7b7c, 0x7b7b7b7b, 0x7a7a7a7b,
	0x7a7a7a7a, 0x79797979, 0x78797979, 0x78787878,
	0x77777878, 0x76777777, 0x76767676, 0x75757576,
	0x74757575, 0x74747474, 0x73737373, 0x72727272,
	0x29292928, 0x2a2a2a2a, 0x2c2b2b2b, 0x2d2c2c2c,
	0x2e2e2d2d, 0x2f2e2e2e, 0x3030302f, 0x31313030,
	0x33323232, 0x34333333, 0x35353434, 0x36363635,
	0x37373736, 0x39383838, 0x3a3a3939, 0x3b3b3a3a,
	0x3c3c3c3b, 0x3d3d3d3d, 0x3f3e3e3e, 0x4040403f,
	0x41414141, 0x43424242, 0x44444343, 0x45454544,
	0x46464645, 0x48474747, 0x49494948, 0x4a4a4949,
	0x4c4b4b4a, 0x4c4c4c4c, 0x4e4e4d4d, 0x4f4f4f4e,
	0x50505050, 0x52515151, 0x53535252, 0x54545353,
	0x55555554, 0x56565656, 0x58575757, 0x59595858,
	0x5a5a5959, 0x5c5b5b5a, 0x5c5c5c5c, 0x5e5e5d5d,
	0x5f5e5e5e, 0x6060605f, 0x61616060, 0x62626262,
	0x63636362, 0x64646464, 0x65656565, 0x67666666,
	0x68676767, 0x69686868, 0x6a696969, 0x6b6b6a6a,
	0x6c6c6b6b, 0x6d6c6c6c, 0x6e6d6d6d, 0x6f6e6e6e,
	0x6f6f6f6f, 0x7070706f, 0x71717170, 0x72727271,
	0x73727272, 0x73737373, 0x74747474, 0x75757574,
	0x76757575, 0x76767676, 0x77777777, 0x78787777,
	0x78787878, 0x79797978, 0x79797979, 0x7a7a7a7a,
	0x7b7a7a7a, 0x7b7b7b7b, 0x7b7b7b7b, 0x7c7c7c7c,
	0x7c7c7c7c, 0x7d7d7d7d, 0x7d7d7d7d, 0x7e7d7d7d,
	0x7e7e7e7e, 0x7e7e7e7e, 0x7e7e7e7e, 0x7f7f7f7e,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x807f7f7f,
	0x7f7f8080, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7e7e7e7e, 0x7e7e7e7e, 0x7e7e7e7e,
	0x7d7d7e7e, 0x7d7d7d7d, 0x7d7d7d7d, 0x7c7c7c7d,
	0x7c7c7c7c, 0x7b7b7b7c, 0x7b7b7b7b, 0x7a7a7b7b,
	0x7a7a7a7a, 0x7979797a, 0x79797979, 0x78787878,
	0x77787878, 0x77777777, 0x76767677, 0x75757676,
	0x75757575, 0x74747474, 0x73737374, 0x72727373,
	0x2a2a2a2a, 0x2c2b2b2b, 0x2d2c2c2c, 0x2e2e2d2d,
	0x2f2f2e2e, 0x3030302f, 0x31313030, 0x33323232,
	0x33333333, 0x35353434, 0x36363635, 0x37373636,
	0x39383838, 0x3a3a3939, 0x3b3b3a3a, 0x3c3c3c3b,
	0x3d3d3d3d, 0x3f3e3e3e, 0x40403f3f, 0x41414140,
	0x42424241, 0x44434343, 0x45454444, 0x46464545,
	0x47474746, 0x49494848, 0x4a494949, 0x4b4b4a4a,
	0x4c4c4c4c, 0x4e4d4d4c, 0x4f4f4e4e, 0x5050504f,
	0x51515150, 0x53525252, 0x54535353, 0x55555454,
	0x56565655, 0x57575756, 0x59585858, 0x5a595959,
	0x5b5b5a5a, 0x5c5c5c5b, 0x5d5d5d5c, 0x5e5e5e5e,
	0x605f5f5f, 0x61606060, 0x62626161, 0x63626262,
	0x64646463, 0x65656464, 0x66666565, 0x67676766,
	0x68686867, 0x69696968, 0x6a6a6969, 0x6b6b6b6b,
	0x6c6c6c6b, 0x6d6d6d6c, 0x6e6e6e6d, 0x6f6f6e6e,
	0x706f6f6f, 0x71707070, 0x71717171, 0x72727272,
	0x73737272, 0x74747373, 0x74747474, 0x75757575,
	0x76767575, 0x77767676, 0x77777777, 0x78787877,
	0x78787878, 0x79797979, 0x7a797979, 0x7a7a7a7a,
	0x7b7b7a7a, 0x7b7b7b7b, 0x7c7b7b7b, 0x7c7c7c7c,
	0x7d7c7c7c, 0x7d7d7d7d, 0x7d7d7d7d, 0x7e7d7d7d,
	0x7e7e7e7e, 0x7e7e7e7e, 0x7e7e7e7e, 0x7f7f7f7e,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x807f7f7f,
	0x7f7f8080, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
	0x7f7f7f7f, 0x7e7e7e7e, 0x7e7e7e7e, 0x7e7e7e7e,
	0x7d7d7e7e, 0x7d7d7d7d, 0x7d7d7d7d, 0x7c7c7d7d,
	0x7c7c7c7c, 0x7b7b7c7c, 0x7b7b7b7b, 0x7a7b7b7b,
	0x7a7a7a7a, 0x79797a7a, 0x79797979, 0x78787879,
	0x78787878, 0x77777777, 0x76767777, 0x75767676,
	0x75757575, 0x74747475, 0x73747474, 0x72737373,
};

#else /* _LITTLE_ENDIAN */

static mlib_u32 mlib_GraphicsAliasTab_u8_xxx[39 * 512 / 4] = {
	0x0909090aU, 0x0a0a0a0aU, 0x0b0b0b0bU, 0x0b0c0c0cU,
	0x0c0c0d0dU, 0x0d0d0d0eU, 0x0e0e0e0fU, 0x0f0f0f0fU,
	0x10101010U, 0x11111111U, 0x12121212U, 0x13131313U,
	0x14141415U, 0x15151516U, 0x16161717U, 0x17171818U,
	0x18191919U, 0x1a1a1a1aU, 0x1b1b1b1cU, 0x1c1c1d1dU,
	0x1d1e1e1eU, 0x1f1f1f20U, 0x20202121U, 0x21222222U,
	0x23232424U, 0x24252525U, 0x26262727U, 0x27282828U,
	0x29292a2aU, 0x2a2b2b2cU, 0x2c2c2d2dU, 0x2e2e2e2fU,
	0x2f303030U, 0x31313232U, 0x33333334U, 0x34353536U,
	0x36363737U, 0x38383939U, 0x3a3a3a3bU, 0x3b3c3c3dU,
	0x3d3d3e3eU, 0x3f3f4040U, 0x41414142U, 0x42434344U,
	0x44454545U, 0x46464747U, 0x48484949U, 0x494a4a4bU,
	0x4b4c4c4cU, 0x4d4d4e4eU, 0x4f4f5050U, 0x50515152U,
	0x52535353U, 0x54545555U, 0x56565657U, 0x57585859U,
	0x59595a5aU, 0x5b5b5c5cU, 0x5c5d5d5eU, 0x5e5e5f5fU,
	0x60606061U, 0x61626262U, 0x63636464U, 0x64656565U,
	0x65666667U, 0x67676868U, 0x68696969U, 0x6a6a6b6bU,
	0x6b6c6c6cU, 0x6d6d6d6eU, 0x6e6e6f6fU, 0x6f6f7070U,
	0x70717171U, 0x72727272U, 0x73737374U, 0x74747475U,
	0x75757576U, 0x76767677U, 0x77777778U, 0x78787878U,
	0x79797979U, 0x797a7a7aU, 0x7a7a7b7bU, 0x7b7b7b7bU,
	0x7c7c7c7cU, 0x7c7c7d7dU, 0x7d7d7d7dU, 0x7d7d7e7eU,
	0x7e7e7e7eU, 0x7e7e7e7eU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x807f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7e7e7eU, 0x7e7e7e7eU,
	0x7e7e7e7dU, 0x7d7d7d7dU, 0x7d7d7d7cU, 0x7c7c7c7cU,
	0x7c7b7b7bU, 0x7b7b7b7aU, 0x7a7a7a7aU, 0x79797979U,
	0x79787878U, 0x78787777U, 0x77777676U, 0x76767575U,
	0x75757474U, 0x74747373U, 0x73727272U, 0x72717171U,
	0x7070706fU, 0x6f6f6f6eU, 0x6e6e6d6dU, 0x6d6c6c6cU,
	0x6b6b6b6aU, 0x6a696969U, 0x68686867U, 0x67676666U,
	0x0a0a0a0aU, 0x0a0b0b0bU, 0x0b0b0c0cU, 0x0c0c0c0dU,
	0x0d0d0d0dU, 0x0e0e0e0eU, 0x0f0f0f0fU, 0x0f101010U,
	0x10111111U, 0x11121212U, 0x12131313U, 0x13141414U,
	0x15151515U, 0x16161617U, 0x17171718U, 0x18181919U,
	0x19191a1aU, 0x1a1a1b1bU, 0x1b1c1c1cU, 0x1d1d1d1eU,
	0x1e1e1f1fU, 0x1f202020U, 0x21212122U, 0x22222323U,
	0x24242425U, 0x25252626U, 0x27272728U, 0x28282929U,
	0x2a2a2a2bU, 0x2b2c2c2cU, 0x2d2d2e2eU, 0x2e2f2f30U,
	0x30303131U, 0x32323333U, 0x33343435U, 0x35363636U,
	0x37373838U, 0x39393a3aU, 0x3a3b3b3cU, 0x3c3d3d3dU,
	0x3e3e3f3fU, 0x40404141U, 0x41424243U, 0x43444445U,
	0x45454646U, 0x47474848U, 0x4949494aU, 0x4a4b4b4cU,
	0x4c4c4c4dU, 0x4d4e4e4fU, 0x4f505050U, 0x51515252U,
	0x53535354U, 0x54555556U, 0x56565757U, 0x58585959U,
	0x595a5a5bU, 0x5b5c5c5cU, 0x5d5d5e5eU, 0x5e5f5f60U,
	0x60606161U, 0x62626263U, 0x63646464U, 0x65656566U,
	0x66666767U, 0x67686868U, 0x6969696aU, 0x6a6b6b6bU,
	0x6c6c6c6dU, 0x6d6d6e6eU, 0x6e6f6f6fU, 0x6f707070U,
	0x71717172U, 0x72727273U, 0x73737474U, 0x74747575U,
	0x75757676U, 0x76767777U, 0x77777878U, 0x78787879U,
	0x79797979U, 0x7a7a7a7aU, 0x7a7b7b7bU, 0x7b7b7b7cU,
	0x7c7c7c7cU, 0x7c7d7d7dU, 0x7d7d7d7dU, 0x7d7e7e7eU,
	0x7e7e7e7eU, 0x7e7e7e7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f80U,
	0x80807f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7e7eU, 0x7e7e7e7eU,
	0x7e7e7e7eU, 0x7d7d7d7dU, 0x7d7d7d7dU, 0x7c7c7c7cU,
	0x7c7c7b7bU, 0x7b7b7b7bU, 0x7a7a7a7aU, 0x7a797979U,
	0x79797878U, 0x78787877U, 0x77777776U, 0x76767675U,
	0x75757574U, 0x74747473U, 0x73737272U, 0x72727171U,
	0x71707070U, 0x6f6f6f6fU, 0x6e6e6e6dU, 0x6d6d6c6cU,
	0x6c6b6b6bU, 0x6a6a6969U, 0x69686868U, 0x67676766U,
	0x0a0a0b0bU, 0x0b0b0b0cU, 0x0c0c0c0cU, 0x0d0d0d0dU,
	0x0d0e0e0eU, 0x0e0f0f0fU, 0x0f0f1010U, 0x10101111U,
	0x11111112U, 0x12121213U, 0x13131314U, 0x14141515U,
	0x15151616U, 0x16171717U, 0x17181818U, 0x1919191aU,
	0x1a1a1a1bU, 0x1b1b1c1cU, 0x1c1d1d1dU, 0x1e1e1e1fU,
	0x1f1f2020U, 0x20212121U, 0x22222223U, 0x23242424U,
	0x24252525U, 0x26262727U, 0x27282828U, 0x29292a2aU,
	0x2a2b2b2cU, 0x2c2c2d2dU, 0x2e2e2e2fU, 0x2f303030U,
	0x31313232U, 0x33333334U, 0x34353536U, 0x36363737U,
	0x38383939U, 0x3a3a3a3bU, 0x3b3c3c3dU, 0x3d3d3e3eU,
	0x3e3f3f40U, 0x40414141U, 0x42424343U, 0x44444545U,
	0x45464647U, 0x47484849U, 0x49494a4aU, 0x4b4b4c4cU,
	0x4c4d4d4eU, 0x4e4f4f50U, 0x50505151U, 0x52525353U,
	0x53545455U, 0x55565656U, 0x57575858U, 0x5959595aU,
	0x5a5a5b5bU, 0x5c5c5c5dU, 0x5d5e5e5eU, 0x5f5f6060U,
	0x60616162U, 0x62626363U, 0x64646465U, 0x65656666U,
	0x66676767U, 0x68686869U, 0x69696a6aU, 0x6b6b6b6cU,
	0x6c6c6d6dU, 0x6d6e6e6eU, 0x6f6f6f6fU, 0x70707071U,
	0x71717272U, 0x72727373U, 0x73747474U, 0x74757575U,
	0x75767676U, 0x76777777U, 0x77787878U, 0x78787979U,
	0x79797979U, 0x7a7a7a7aU, 0x7a7b7b7bU, 0x7b7b7b7cU,
	0x7c7c7c7cU, 0x7c7d7d7dU, 0x7d7d7d7dU, 0x7d7e7e7eU,
	0x7e7e7e7eU, 0x7e7e7e7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f80U,
	0x80807f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7e7eU, 0x7e7e7e7eU,
	0x7e7e7e7eU, 0x7d7d7d7dU, 0x7d7d7d7dU, 0x7c7c7c7cU,
	0x7c7c7b7bU, 0x7b7b7b7bU, 0x7a7a7a7aU, 0x7a797979U,
	0x79797978U, 0x78787878U, 0x77777777U, 0x76767676U,
	0x75757575U, 0x74747474U, 0x73737372U, 0x72727271U,
	0x71717070U, 0x706f6f6fU, 0x6f6e6e6eU, 0x6d6d6d6cU,
	0x6c6c6b6bU, 0x6b6a6a69U, 0x69696868U, 0x68676767U,
	0x0b0b0b0bU, 0x0c0c0c0cU, 0x0c0d0d0dU, 0x0d0d0e0eU,
	0x0e0e0f0fU, 0x0f0f0f0fU, 0x10101010U, 0x11111111U,
	0x12121212U, 0x13131313U, 0x14141415U, 0x15151516U,
	0x16161717U, 0x17171818U, 0x18191919U, 0x1a1a1a1aU,
	0x1a1b1b1bU, 0x1c1c1c1dU, 0x1d1d1e1eU, 0x1e1f1f1fU,
	0x20202021U, 0x21212222U, 0x22232324U, 0x24242525U,
	0x25262627U, 0x27272828U, 0x28292929U, 0x2a2a2a2bU,
	0x2b2c2c2cU, 0x2d2d2e2eU, 0x2e2f2f30U, 0x30303131U,
	0x32323333U, 0x33343435U, 0x35363636U, 0x37373838U,
	0x39393a3aU, 0x3a3a3b3bU, 0x3c3c3d3dU, 0x3d3e3e3fU,
	0x3f404041U, 0x41414242U, 0x43434444U, 0x45454546U,
	0x46474748U, 0x48494949U, 0x4a4a4b4bU, 0x4c4c4c4dU,
	0x4d4d4e4eU, 0x4f4f5050U, 0x50515152U, 0x52535353U,
	0x54545555U, 0x56565657U, 0x57585859U, 0x59595a5aU,
	0x5b5b5c5cU, 0x5c5d5d5eU, 0x5e5e5f5fU, 0x5f606060U,
	0x61616262U, 0x62636364U, 0x64646565U, 0x65666667U,
	0x67676768U, 0x68686969U, 0x696a6a6bU, 0x6b6b6c6cU,
	0x6c6d6d6dU, 0x6e6e6e6fU, 0x6f6f6f70U, 0x70707171U,
	0x71727272U, 0x72737373U, 0x74747474U, 0x74757575U,
	0x75767676U, 0x76777777U, 0x77787878U, 0x78787979U,
	0x7979797aU, 0x7a7a7a7aU, 0x7b7b7b7bU, 0x7b7b7c7cU,
	0x7c7c7c7cU, 0x7d7d7d7dU, 0x7d7d7d7dU, 0x7d7e7e7eU,
	0x7e7e7e7eU, 0x7e7e7e7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f80U,
	0x80807f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7e7eU, 0x7e7e7e7eU,
	0x7e7e7e7eU, 0x7d7d7d7dU, 0x7d7d7d7dU, 0x7d7c7c7cU,
	0x7c7c7c7bU, 0x7b7b7b7bU, 0x7b7a7a7aU, 0x7a7a7979U,
	0x79797978U, 0x78787878U, 0x77777777U, 0x76767676U,
	0x75757575U, 0x74747474U, 0x74737373U, 0x72727272U,
	0x71717170U, 0x70706f6fU, 0x6f6f6e6eU, 0x6e6d6d6dU,
	0x6c6c6c6bU, 0x6b6b6a6aU, 0x69696968U, 0x68686767U,
	0x0b0c0c0cU, 0x0c0c0d0dU, 0x0d0d0d0eU, 0x0e0e0e0fU,
	0x0f0f0f0fU, 0x0f101010U, 0x10111111U, 0x11121212U,
	0x12131313U, 0x13141414U, 0x15151515U, 0x16161617U,
	0x17171717U, 0x18181819U, 0x19191a1aU, 0x1a1a1b1bU,
	0x1b1c1c1cU, 0x1d1d1d1eU, 0x1e1e1f1fU, 0x1f202020U,
	0x20212121U, 0x22222223U, 0x23242424U, 0x25252526U,
	0x26272727U, 0x28282829U, 0x292a2a2aU, 0x2b2b2c2cU,
	0x2c2c2d2dU, 0x2e2e2e2fU, 0x2f303030U, 0x31313232U,
	0x33333334U, 0x34353536U, 0x36363737U, 0x38383939U,
	0x393a3a3aU, 0x3b3b3c3cU, 0x3d3d3d3eU, 0x3e3f3f40U,
	0x40414141U, 0x42424343U, 0x44444545U, 0x45464647U,
	0x47474848U, 0x4949494aU, 0x4a4b4b4cU, 0x4c4c4d4dU,
	0x4e4e4f4fU, 0x50505051U, 0x51525253U, 0x53535454U,
	0x54555556U, 0x56565757U, 0x58585959U, 0x595a5a5bU,
	0x5b5c5c5cU, 0x5d5d5e5eU, 0x5e5f5f60U, 0x60606161U,
	0x61626262U, 0x63636464U, 0x64656565U, 0x66666767U,
	0x67676868U, 0x68696969U, 0x6a6a6b6bU, 0x6b6c6c6cU,
	0x6d6d6d6eU, 0x6e6e6f6fU, 0x6f6f7070U, 0x70717171U,
	0x71727272U, 0x72737373U, 0x74747474U, 0x75757575U,
	0x76767676U, 0x77777777U, 0x78787878U, 0x78797979U,
	0x7979797aU, 0x7a7a7a7aU, 0x7b7b7b7bU, 0x7b7b7c7cU,
	0x7c7c7c7cU, 0x7d7d7d7dU, 0x7d7d7d7dU, 0x7e7e7e7eU,
	0x7e7e7e7eU, 0x7e7e7e7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f80U,
	0x80807f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7e7eU, 0x7e7e7e7eU,
	0x7e7e7e7eU, 0x7e7d7d7dU, 0x7d7d7d7dU, 0x7d7c7c7cU,
	0x7c7c7c7bU, 0x7b7b7b7bU, 0x7b7a7a7aU, 0x7a7a7979U,
	0x79797979U, 0x78787878U, 0x78777777U, 0x77767676U,
	0x76757575U, 0x75747474U, 0x74737373U, 0x72727272U,
	0x71717171U, 0x7070706fU, 0x6f6f6f6eU, 0x6e6e6d6dU,
	0x6d6c6c6cU, 0x6b6b6b6aU, 0x6a696969U, 0x68686867U,
	0x0c0c0c0dU, 0x0d0d0d0dU, 0x0e0e0e0eU, 0x0f0f0f0fU,
	0x0f0f1010U, 0x10101111U, 0x11111212U, 0x12121313U,
	0x13131414U, 0x14151515U, 0x15151616U, 0x16171717U,
	0x17181818U, 0x1919191aU, 0x1a1a1a1bU, 0x1b1b1c1cU,
	0x1c1c1d1dU, 0x1d1e1e1eU, 0x1f1f1f20U, 0x20202121U,
	0x21222222U, 0x23232424U, 0x24252525U, 0x25262627U,
	0x27272828U, 0x2829292aU, 0x2a2a2b2bU, 0x2c2c2c2dU,
	0x2d2e2e2eU, 0x2e2f2f30U, 0x30303131U, 0x32323333U,
	0x33343435U, 0x35363636U, 0x37373838U, 0x3939393aU,
	0x3a3a3b3bU, 0x3c3c3d3dU, 0x3d3e3e3fU, 0x3f404041U,
	0x41414242U, 0x43434344U, 0x44454545U, 0x46464747U,
	0x48484949U, 0x494a4a4bU, 0x4b4c4c4cU, 0x4d4d4e4eU,
	0x4e4f4f50U, 0x50505151U, 0x52525353U, 0x53545455U,
	0x55565656U, 0x57575858U, 0x59595959U, 0x5a5a5b5bU,
	0x5c5c5c5dU, 0x5d5e5e5eU, 0x5f5f6060U, 0x60616162U,
	0x62626363U, 0x63646464U, 0x65656566U, 0x66676767U,
	0x67686868U, 0x6969696aU, 0x6a6b6b6bU, 0x6c6c6c6dU,
	0x6d6d6e6eU, 0x6e6f6f6fU, 0x6f707070U, 0x70717171U,
	0x72727272U, 0x73737374U, 0x74747475U, 0x75757576U,
	0x76767677U, 0x77777777U, 0x78787878U, 0x78797979U,
	0x79797a7aU, 0x7a7a7a7bU, 0x7b7b7b7bU, 0x7b7b7c7cU,
	0x7c7c7c7cU, 0x7d7d7d7dU, 0x7d7d7d7dU, 0x7e7e7e7eU,
	0x7e7e7e7eU, 0x7e7e7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f80U,
	0x80807f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7eU, 0x7e7e7e7eU,
	0x7e7e7e7eU, 0x7e7d7d7dU, 0x7d7d7d7dU, 0x7d7c7c7cU,
	0x7c7c7c7bU, 0x7b7b7b7bU, 0x7b7b7a7aU, 0x7a7a7a79U,
	0x79797979U, 0x78787878U, 0x78777777U, 0x77777676U,
	0x76767575U, 0x75757474U, 0x74747373U, 0x73727272U,
	0x72717171U, 0x70707070U, 0x6f6f6f6fU, 0x6e6e6e6dU,
	0x6d6d6c6cU, 0x6c6b6b6bU, 0x6a6a6969U, 0x69686868U,
	0x0d0d0d0dU, 0x0d0e0e0eU, 0x0e0f0f0fU, 0x0f0f0f10U,
	0x10101011U, 0x11111112U, 0x12121213U, 0x13131314U,
	0x14141415U, 0x15151516U, 0x16161717U, 0x17171818U,
	0x18191919U, 0x1a1a1a1aU, 0x1a1b1b1bU, 0x1c1c1c1dU,
	0x1d1d1e1eU, 0x1e1f1f1fU, 0x20202020U, 0x21212122U,
	0x22222323U, 0x24242425U, 0x25252626U, 0x27272728U,
	0x28282829U, 0x292a2a2aU, 0x2b2b2c2cU, 0x2c2d2d2eU,
	0x2e2e2f2fU, 0x30303030U, 0x31313232U, 0x33333334U,
	0x34353536U, 0x36363737U, 0x38383939U, 0x393a3a3aU,
	0x3b3b3c3cU, 0x3d3d3d3eU, 0x3e3f3f40U, 0x40414141U,
	0x41424243U, 0x43444445U, 0x45454646U, 0x47474848U,
	0x4949494aU, 0x4a4a4b4bU, 0x4c4c4c4dU, 0x4d4e4e4fU,
	0x4f505050U, 0x51515252U, 0x53535353U, 0x54545555U,
	0x56565657U, 0x57585859U, 0x59595a5aU, 0x5b5b5c5cU,
	0x5c5c5d5dU, 0x5e5e5e5fU, 0x5f606060U, 0x61616262U,
	0x62636364U, 0x64646465U, 0x65656666U, 0x67676768U,
	0x68686869U, 0x69696a6aU, 0x6b6b6b6cU, 0x6c6c6d6dU,
	0x6d6e6e6eU, 0x6f6f6f6fU, 0x6f707070U, 0x71717172U,
	0x72727273U, 0x73737474U, 0x74747575U, 0x75757576U,
	0x76767677U, 0x77777778U, 0x78787878U, 0x79797979U,
	0x79797a7aU, 0x7a7a7a7bU, 0x7b7b7b7bU, 0x7b7c7c7cU,
	0x7c7c7c7dU, 0x7d7d7d7dU, 0x7d7d7d7dU, 0x7e7e7e7eU,
	0x7e7e7e7eU, 0x7e7e7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f80U,
	0x80807f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7eU, 0x7e7e7e7eU,
	0x7e7e7e7eU, 0x7e7d7d7dU, 0x7d7d7d7dU, 0x7d7d7c7cU,
	0x7c7c7c7cU, 0x7b7b7b7bU, 0x7b7b7a7aU, 0x7a7a7a79U,
	0x79797979U, 0x79787878U, 0x78787777U, 0x77777676U,
	0x76767575U, 0x75757574U, 0x74747473U, 0x73737272U,
	0x72727171U, 0x71707070U, 0x6f6f6f6fU, 0x6f6e6e6eU,
	0x6d6d6d6cU, 0x6c6c6b6bU, 0x6b6a6a69U, 0x69696868U,
	0x0d0d0e0eU, 0x0e0e0f0fU, 0x0f0f0f0fU, 0x10101010U,
	0x11111111U, 0x12121212U, 0x13131313U, 0x13141414U,
	0x15151515U, 0x16161617U, 0x17171718U, 0x18181819U,
	0x19191a1aU, 0x1a1a1b1bU, 0x1b1c1c1cU, 0x1d1d1d1eU,
	0x1e1e1e1fU, 0x1f1f2020U, 0x20212121U, 0x22222223U,
	0x23242424U, 0x24252525U, 0x26262727U, 0x27282828U,
	0x29292a2aU, 0x2a2a2b2bU, 0x2c2c2c2dU, 0x2d2e2e2eU,
	0x2f2f3030U, 0x30313131U, 0x32323333U, 0x33343435U,
	0x35363636U, 0x37373838U, 0x3939393aU, 0x3a3a3b3bU,
	0x3c3c3d3dU, 0x3d3e3e3fU, 0x3f404040U, 0x41414142U,
	0x42434344U, 0x44454545U, 0x46464747U, 0x48484849U,
	0x49494a4aU, 0x4b4b4c4cU, 0x4c4d4d4eU, 0x4e4f4f50U,
	0x50505051U, 0x51525253U, 0x53535454U, 0x55555656U,
	0x56575757U, 0x58585959U, 0x595a5a5bU, 0x5b5c5c5cU,
	0x5d5d5e5eU, 0x5e5e5f5fU, 0x60606061U, 0x61626262U,
	0x63636464U, 0x64656565U, 0x65666667U, 0x67676868U,
	0x68686969U, 0x696a6a6bU, 0x6b6b6c6cU, 0x6c6d6d6dU,
	0x6e6e6e6eU, 0x6f6f6f6fU, 0x70707071U, 0x71717272U,
	0x72727373U, 0x73737474U, 0x74747575U, 0x75757676U,
	0x76767777U, 0x77777878U, 0x78787878U, 0x79797979U,
	0x797a7a7aU, 0x7a7a7b7bU, 0x7b7b7b7bU, 0x7b7c7c7cU,
	0x7c7c7c7dU, 0x7d7d7d7dU, 0x7d7d7d7eU, 0x7e7e7e7eU,
	0x7e7e7e7eU, 0x7e7e7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f80U,
	0x80807f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7eU, 0x7e7e7e7eU,
	0x7e7e7e7eU, 0x7e7e7d7dU, 0x7d7d7d7dU, 0x7d7d7c7cU,
	0x7c7c7c7cU, 0x7b7b7b7bU, 0x7b7b7b7aU, 0x7a7a7a7aU,
	0x79797979U, 0x79787878U, 0x78787877U, 0x77777776U,
	0x76767675U, 0x75757574U, 0x74747473U, 0x73737372U,
	0x72727271U, 0x71717070U, 0x706f6f6fU, 0x6f6e6e6eU,
	0x6e6d6d6dU, 0x6c6c6c6bU, 0x6b6b6a6aU, 0x69696968U,
	0x0e0e0e0fU, 0x0f0f0f0fU, 0x0f101010U, 0x10111111U,
	0x11121212U, 0x12131313U, 0x13131414U, 0x14151515U,
	0x15161616U, 0x17171717U, 0x17181818U, 0x1919191aU,
	0x1a1a1a1bU, 0x1b1b1c1cU, 0x1c1c1d1dU, 0x1d1e1e1eU,
	0x1f1f1f20U, 0x20202121U, 0x21212222U, 0x22232324U,
	0x24242525U, 0x25262627U, 0x27272728U, 0x28282929U,
	0x2a2a2a2bU, 0x2b2c2c2cU, 0x2c2d2d2eU, 0x2e2e2f2fU,
	0x30303031U, 0x31323233U, 0x33333334U, 0x34353536U,
	0x36363737U, 0x38383939U, 0x393a3a3aU, 0x3b3b3c3cU,
	0x3d3d3d3eU, 0x3e3f3f40U, 0x40404141U, 0x41424243U,
	0x43444445U, 0x45454646U, 0x46474748U, 0x48494949U,
	0x4a4a4b4bU, 0x4c4c4c4dU, 0x4d4d4e4eU, 0x4f4f5050U,
	0x50515152U, 0x52535353U, 0x53545455U, 0x55565656U,
	0x57575858U, 0x5959595aU, 0x5a5a5b5bU, 0x5c5c5c5dU,
	0x5d5e5e5eU, 0x5f5f6060U, 0x60606161U, 0x62626263U,
	0x63646464U, 0x65656566U, 0x66666767U, 0x67686868U,
	0x68696969U, 0x6a6a6b6bU, 0x6b6c6c6cU, 0x6d6d6d6eU,
	0x6e6e6e6fU, 0x6f6f6f70U, 0x70707171U, 0x71727272U,
	0x72727373U, 0x73747474U, 0x74757575U, 0x75767676U,
	0x76767777U, 0x77777878U, 0x78787879U, 0x79797979U,
	0x797a7a7aU, 0x7a7a7b7bU, 0x7b7b7b7bU, 0x7c7c7c7cU,
	0x7c7c7c7dU, 0x7d7d7d7dU, 0x7d7d7d7eU, 0x7e7e7e7eU,
	0x7e7e7e7eU, 0x7e7e7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f80U,
	0x80807f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7eU, 0x7e7e7e7eU,
	0x7e7e7e7eU, 0x7e7e7d7dU, 0x7d7d7d7dU, 0x7d7d7c7cU,
	0x7c7c7c7cU, 0x7c7b7b7bU, 0x7b7b7b7aU, 0x7a7a7a7aU,
	0x79797979U, 0x79797878U, 0x78787877U, 0x77777776U,
	0x76767676U, 0x75757575U, 0x74747474U, 0x73737372U,
	0x72727272U, 0x71717170U, 0x70706f6fU, 0x6f6f6e6eU,
	0x6e6e6d6dU, 0x6d6c6c6cU, 0x6b6b6b6aU, 0x6a696969U,
	0x0f0f0f0fU, 0x0f101010U, 0x10101111U, 0x11111212U,
	0x12121313U, 0x13131314U, 0x14141515U, 0x15151616U,
	0x16171717U, 0x17171818U, 0x18191919U, 0x1a1a1a1aU,
	0x1b1b1b1bU, 0x1c1c1c1dU, 0x1d1d1e1eU, 0x1e1f1f1fU,
	0x1f202020U, 0x21212122U, 0x22222323U, 0x24242424U,
	0x25252526U, 0x26272727U, 0x28282829U, 0x29292a2aU,
	0x2a2b2b2cU, 0x2c2c2d2dU, 0x2e2e2e2eU, 0x2f2f3030U,
	0x30313132U, 0x32333333U, 0x34343435U, 0x35363636U,
	0x37373838U, 0x39393a3aU, 0x3a3a3b3bU, 0x3c3c3d3dU,
	0x3d3e3e3fU, 0x3f3f4040U, 0x41414142U, 0x42434344U,
	0x44454545U, 0x45464647U, 0x47484849U, 0x49494a4aU,
	0x4b4b4b4cU, 0x4c4c4d4dU, 0x4e4e4f4fU, 0x50505051U,
	0x51515252U, 0x53535354U, 0x54555556U, 0x56565657U,
	0x57585859U, 0x59595a5aU, 0x5b5b5c5cU, 0x5c5c5d5dU,
	0x5e5e5e5fU, 0x5f606060U, 0x61616262U, 0x62626363U,
	0x64646465U, 0x65656666U, 0x67676767U, 0x68686869U,
	0x6969696aU, 0x6a6b6b6bU, 0x6c6c6c6dU, 0x6d6d6e6eU,
	0x6e6e6f6fU, 0x6f6f7070U, 0x70717171U, 0x72727272U,
	0x72737373U, 0x74747474U, 0x75757575U, 0x75767676U,
	0x76777777U, 0x77787878U, 0x78787879U, 0x79797979U,
	0x7a7a7a7aU, 0x7a7b7b7bU, 0x7b7b7b7bU, 0x7c7c7c7cU,
	0x7c7c7d7dU, 0x7d7d7d7dU, 0x7d7d7d7eU, 0x7e7e7e7eU,
	0x7e7e7e7eU, 0x7e7e7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f80U,
	0x80807f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7eU, 0x7e7e7e7eU,
	0x7e7e7e7eU, 0x7e7e7d7dU, 0x7d7d7d7dU, 0x7d7d7d7cU,
	0x7c7c7c7cU, 0x7c7b7b7bU, 0x7b7b7b7bU, 0x7a7a7a7aU,
	0x7a797979U, 0x79797878U, 0x78787878U, 0x77777777U,
	0x76767676U, 0x75757575U, 0x75747474U, 0x74737373U,
	0x72727272U, 0x72717171U, 0x7070706fU, 0x6f6f6f6eU,
	0x6e6e6e6dU, 0x6d6d6c6cU, 0x6c6b6b6bU, 0x6a6a6969U,
	0x0f0f1010U, 0x10101011U, 0x11111112U, 0x12121213U,
	0x13131313U, 0x14141415U, 0x15151516U, 0x16161717U,
	0x17171718U, 0x18181919U, 0x191a1a1aU, 0x1a1a1b1bU,
	0x1b1c1c1cU, 0x1d1d1d1eU, 0x1e1e1e1fU, 0x1f1f2020U,
	0x20212121U, 0x22222222U, 0x23232424U, 0x24252525U,
	0x26262727U, 0x27272828U, 0x2829292aU, 0x2a2a2b2bU,
	0x2b2c2c2cU, 0x2d2d2e2eU, 0x2e2f2f30U, 0x30303031U,
	0x31323233U, 0x33333434U, 0x35353536U, 0x36363737U,
	0x38383939U, 0x3a3a3a3aU, 0x3b3b3c3cU, 0x3d3d3d3eU,
	0x3e3f3f3fU, 0x40404141U, 0x41424243U, 0x43444445U,
	0x45454546U, 0x46474748U, 0x48494949U, 0x4a4a4a4bU,
	0x4b4c4c4cU, 0x4d4d4e4eU, 0x4f4f4f50U, 0x50505151U,
	0x52525353U, 0x53545454U, 0x55555656U, 0x56575758U,
	0x58595959U, 0x595a5a5bU, 0x5b5c5c5cU, 0x5d5d5e5eU,
	0x5e5e5f5fU, 0x60606061U, 0x61626262U, 0x63636364U,
	0x64646565U, 0x65666667U, 0x67676768U, 0x68686969U,
	0x69696a6aU, 0x6b6b6b6cU, 0x6c6c6d6dU, 0x6d6d6e6eU,
	0x6e6f6f6fU, 0x6f707070U, 0x71717171U, 0x72727272U,
	0x73737374U, 0x74747474U, 0x75757575U, 0x76767676U,
	0x77777777U, 0x77787878U, 0x78787979U, 0x7979797aU,
	0x7a7a7a7aU, 0x7a7b7b7bU, 0x7b7b7b7cU, 0x7c7c7c7cU,
	0x7c7c7d7dU, 0x7d7d7d7dU, 0x7d7d7d7eU, 0x7e7e7e7eU,
	0x7e7e7e7eU, 0x7e7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f80U,
	0x80807f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7e7e7e7eU,
	0x7e7e7e7eU, 0x7e7e7d7dU, 0x7d7d7d7dU, 0x7d7d7d7cU,
	0x7c7c7c7cU, 0x7c7c7b7bU, 0x7b7b7b7bU, 0x7a7a7a7aU,
	0x7a7a7979U, 0x79797978U, 0x78787878U, 0x77777777U,
	0x77767676U, 0x76757575U, 0x75747474U, 0x74747373U,
	0x73727272U, 0x72717171U, 0x71707070U, 0x6f6f6f6fU,
	0x6e6e6e6dU, 0x6d6d6d6cU, 0x6c6c6b6bU, 0x6b6a6a69U,
	0x10101011U, 0x11111111U, 0x12121212U, 0x13131313U,
	0x14141414U, 0x15151515U, 0x16161617U, 0x17171717U,
	0x18181819U, 0x19191a1aU, 0x1a1a1a1bU, 0x1b1b1c1cU,
	0x1c1d1d1dU, 0x1d1e1e1eU, 0x1f1f1f20U, 0x20202121U,
	0x21212222U, 0x22232324U, 0x24242525U, 0x25252626U,
	0x27272728U, 0x28282929U, 0x292a2a2aU, 0x2b2b2c2cU,
	0x2c2d2d2dU, 0x2e2e2e2fU, 0x2f303030U, 0x31313232U,
	0x32333333U, 0x34343535U, 0x36363636U, 0x37373838U,
	0x39393a3aU, 0x3a3b3b3bU, 0x3c3c3d3dU, 0x3d3e3e3fU,
	0x3f3f4040U, 0x41414142U, 0x42434344U, 0x44444545U,
	0x45464647U, 0x47484849U, 0x4949494aU, 0x4a4b4b4cU,
	0x4c4c4d4dU, 0x4d4e4e4fU, 0x4f505050U, 0x51515252U,
	0x52535353U, 0x54545555U, 0x56565657U, 0x57575858U,
	0x5959595aU, 0x5a5b5b5bU, 0x5c5c5c5dU, 0x5d5e5e5eU,
	0x5f5f6060U, 0x60606161U, 0x62626263U, 0x63646464U,
	0x64656565U, 0x66666767U, 0x67686868U, 0x68696969U,
	0x696a6a6bU, 0x6b6b6c6cU, 0x6c6d6d6dU, 0x6d6e6e6eU,
	0x6f6f6f6fU, 0x70707071U, 0x71717172U, 0x72727273U,
	0x73737474U, 0x74747475U, 0x75757576U, 0x76767676U,
	0x77777777U, 0x78787878U, 0x78797979U, 0x7979797aU,
	0x7a7a7a7aU, 0x7b7b7b7bU, 0x7b7b7b7cU, 0x7c7c7c7cU,
	0x7c7d7d7dU, 0x7d7d7d7dU, 0x7d7d7e7eU, 0x7e7e7e7eU,
	0x7e7e7e7eU, 0x7e7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f80U,
	0x80807f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7e7e7e7eU,
	0x7e7e7e7eU, 0x7e7e7e7dU, 0x7d7d7d7dU, 0x7d7d7d7dU,
	0x7c7c7c7cU, 0x7c7c7b7bU, 0x7b7b7b7bU, 0x7b7a7a7aU,
	0x7a7a7979U, 0x79797979U, 0x78787878U, 0x78777777U,
	0x77767676U, 0x76767575U, 0x75757474U, 0x74747473U,
	0x73737272U, 0x72727171U, 0x71717070U, 0x706f6f6fU,
	0x6f6e6e6eU, 0x6d6d6d6dU, 0x6c6c6c6bU, 0x6b6b6a6aU,
	0x11111111U, 0x12121212U, 0x12131313U, 0x13141414U,
	0x14151515U, 0x15161616U, 0x17171717U, 0x17181818U,
	0x1919191aU, 0x1a1a1a1aU, 0x1b1b1b1cU, 0x1c1c1d1dU,
	0x1d1d1e1eU, 0x1e1f1f1fU, 0x20202020U, 0x21212122U,
	0x22222323U, 0x24242424U, 0x25252526U, 0x26272727U,
	0x27282828U, 0x29292a2aU, 0x2a2b2b2bU, 0x2c2c2c2dU,
	0x2d2e2e2eU, 0x2f2f2f30U, 0x30303131U, 0x32323333U,
	0x33333434U, 0x35353636U, 0x36373737U, 0x38383939U,
	0x3a3a3a3bU, 0x3b3b3c3cU, 0x3d3d3d3eU, 0x3e3f3f40U,
	0x40404141U, 0x41424243U, 0x43444444U, 0x45454546U,
	0x46474748U, 0x48484949U, 0x494a4a4bU, 0x4b4c4c4cU,
	0x4c4d4d4eU, 0x4e4f4f50U, 0x50505151U, 0x51525253U,
	0x53535454U, 0x55555556U, 0x56565757U, 0x58585959U,
	0x59595a5aU, 0x5b5b5c5cU, 0x5c5d5d5dU, 0x5e5e5e5fU,
	0x5f606060U, 0x61616162U, 0x62626363U, 0x64646465U,
	0x65656566U, 0x66676767U, 0x68686868U, 0x6969696aU,
	0x6a6a6b6bU, 0x6b6c6c6cU, 0x6d6d6d6dU, 0x6e6e6e6fU,
	0x6f6f6f70U, 0x70707071U, 0x71717272U, 0x72727373U,
	0x73737474U, 0x74747575U, 0x75757676U, 0x76767677U,
	0x77777778U, 0x78787878U, 0x78797979U, 0x79797a7aU,
	0x7a7a7a7aU, 0x7b7b7b7bU, 0x7b7b7c7cU, 0x7c7c7c7cU,
	0x7c7d7d7dU, 0x7d7d7d7dU, 0x7d7d7e7eU, 0x7e7e7e7eU,
	0x7e7e7e7eU, 0x7e7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f80U,
	0x80807f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7e7e7e7eU,
	0x7e7e7e7eU, 0x7e7e7e7dU, 0x7d7d7d7dU, 0x7d7d7d7dU,
	0x7c7c7c7cU, 0x7c7c7c7bU, 0x7b7b7b7bU, 0x7b7a7a7aU,
	0x7a7a7a79U, 0x79797979U, 0x78787878U, 0x78787777U,
	0x77777676U, 0x76767675U, 0x75757574U, 0x74747473U,
	0x73737372U, 0x72727271U, 0x71717070U, 0x70706f6fU,
	0x6f6f6e6eU, 0x6e6d6d6dU, 0x6d6c6c6cU, 0x6b6b6b6aU,
	0x11121212U, 0x12121313U, 0x13131414U, 0x14151515U,
	0x15151616U, 0x16171717U, 0x17171818U, 0x18191919U,
	0x1a1a1a1aU, 0x1a1b1b1bU, 0x1c1c1c1dU, 0x1d1d1d1eU,
	0x1e1e1f1fU, 0x1f202020U, 0x20212121U, 0x22222223U,
	0x23232424U, 0x24252525U, 0x26262627U, 0x27272828U,
	0x2829292aU, 0x2a2a2a2bU, 0x2b2c2c2cU, 0x2d2d2d2eU,
	0x2e2e2f2fU, 0x30303030U, 0x31313232U, 0x33333334U,
	0x34343535U, 0x36363637U, 0x37383838U, 0x39393a3aU,
	0x3a3b3b3cU, 0x3c3c3d3dU, 0x3d3e3e3fU, 0x3f404040U,
	0x41414142U, 0x42434344U, 0x44444545U, 0x45464647U,
	0x47484848U, 0x4949494aU, 0x4a4b4b4cU, 0x4c4c4c4dU,
	0x4d4e4e4fU, 0x4f505050U, 0x50515152U, 0x52535353U,
	0x53545455U, 0x55565656U, 0x57575758U, 0x58595959U,
	0x5a5a5b5bU, 0x5b5c5c5cU, 0x5d5d5e5eU, 0x5e5f5f5fU,
	0x60606061U, 0x61626262U, 0x62636364U, 0x64646565U,
	0x65656666U, 0x67676768U, 0x68686969U, 0x69696a6aU,
	0x6a6b6b6bU, 0x6c6c6c6dU, 0x6d6d6d6eU, 0x6e6e6f6fU,
	0x6f6f7070U, 0x70707171U, 0x71727272U, 0x72737373U,
	0x73747474U, 0x74757575U, 0x75757676U, 0x76767777U,
	0x77777778U, 0x78787878U, 0x79797979U, 0x79797a7aU,
	0x7a7a7a7bU, 0x7b7b7b7bU, 0x7b7b7c7cU, 0x7c7c7c7cU,
	0x7c7d7d7dU, 0x7d7d7d7dU, 0x7d7d7e7eU, 0x7e7e7e7eU,
	0x7e7e7e7eU, 0x7e7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f80U,
	0x80807f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7e7e7e7eU,
	0x7e7e7e7eU, 0x7e7e7e7dU, 0x7d7d7d7dU, 0x7d7d7d7dU,
	0x7c7c7c7cU, 0x7c7c7c7bU, 0x7b7b7b7bU, 0x7b7b7a7aU,
	0x7a7a7a79U, 0x79797979U, 0x79787878U, 0x78787777U,
	0x77777776U, 0x76767675U, 0x75757575U, 0x74747474U,
	0x73737373U, 0x72727272U, 0x71717170U, 0x7070706fU,
	0x6f6f6f6eU, 0x6e6e6d6dU, 0x6d6d6c6cU, 0x6c6b6b6bU,
	0x12121313U, 0x13131314U, 0x14141515U, 0x15151516U,
	0x16161717U, 0x17171818U, 0x18181919U, 0x191a1a1aU,
	0x1a1a1b1bU, 0x1b1c1c1cU, 0x1d1d1d1dU, 0x1e1e1e1fU,
	0x1f1f1f20U, 0x20202121U, 0x21222222U, 0x22232324U,
	0x24242525U, 0x25252626U, 0x27272728U, 0x28282829U,
	0x292a2a2aU, 0x2b2b2c2cU, 0x2c2c2d2dU, 0x2e2e2e2fU,
	0x2f2f3030U, 0x30313132U, 0x32323333U, 0x33343435U,
	0x35363636U, 0x36373738U, 0x38393939U, 0x3a3a3a3bU,
	0x3b3c3c3dU, 0x3d3d3d3eU, 0x3e3f3f40U, 0x40414141U,
	0x41424243U, 0x43444444U, 0x45454546U, 0x46474748U,
	0x48484949U, 0x494a4a4bU, 0x4b4b4c4cU, 0x4c4d4d4eU,
	0x4e4f4f4fU, 0x50505051U, 0x51525252U, 0x53535354U,
	0x54555556U, 0x56565657U, 0x57585859U, 0x5959595aU,
	0x5a5b5b5cU, 0x5c5c5d5dU, 0x5d5e5e5eU, 0x5f5f6060U,
	0x60606161U, 0x62626263U, 0x63636464U, 0x64656565U,
	0x66666667U, 0x67676868U, 0x68696969U, 0x696a6a6bU,
	0x6b6b6b6cU, 0x6c6c6d6dU, 0x6d6e6e6eU, 0x6e6f6f6fU,
	0x6f707070U, 0x70717171U, 0x72727272U, 0x72737373U,
	0x74747474U, 0x75757575U, 0x75767676U, 0x76777777U,
	0x77777878U, 0x78787878U, 0x79797979U, 0x797a7a7aU,
	0x7a7a7a7bU, 0x7b7b7b7bU, 0x7b7c7c7cU, 0x7c7c7c7cU,
	0x7d7d7d7dU, 0x7d7d7d7dU, 0x7d7e7e7eU, 0x7e7e7e7eU,
	0x7e7e7e7eU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f80U,
	0x80807f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7e7e7eU,
	0x7e7e7e7eU, 0x7e7e7e7eU, 0x7d7d7d7dU, 0x7d7d7d7dU,
	0x7d7c7c7cU, 0x7c7c7c7cU, 0x7b7b7b7bU, 0x7b7b7a7aU,
	0x7a7a7a7aU, 0x79797979U, 0x79787878U, 0x78787877U,
	0x77777777U, 0x76767676U, 0x75757575U, 0x75747474U,
	0x74737373U, 0x72727272U, 0x72717171U, 0x70707070U,
	0x6f6f6f6fU, 0x6e6e6e6eU, 0x6d6d6d6cU, 0x6c6c6b6bU,
	0x13131314U, 0x14141415U, 0x15151516U, 0x16161617U,
	0x17171718U, 0x18181819U, 0x19191a1aU, 0x1a1a1a1bU,
	0x1b1b1c1cU, 0x1c1d1d1dU, 0x1d1e1e1eU, 0x1f1f1f1fU,
	0x20202021U, 0x21212222U, 0x22222323U, 0x24242425U,
	0x25252526U, 0x26272727U, 0x28282828U, 0x29292a2aU,
	0x2a2a2b2bU, 0x2c2c2c2dU, 0x2d2e2e2eU, 0x2e2f2f30U,
	0x30303031U, 0x31323233U, 0x33333434U, 0x34353536U,
	0x36363737U, 0x37383839U, 0x393a3a3aU, 0x3a3b3b3cU,
	0x3c3d3d3dU, 0x3d3e3e3fU, 0x3f404041U, 0x41414142U,
	0x42434344U, 0x44444545U, 0x45464647U, 0x47484848U,
	0x4949494aU, 0x4a4b4b4bU, 0x4c4c4c4dU, 0x4d4e4e4eU,
	0x4f4f5050U, 0x50515151U, 0x52525353U, 0x53545455U,
	0x55555656U, 0x56575758U, 0x58585959U, 0x595a5a5bU,
	0x5b5b5c5cU, 0x5c5d5d5eU, 0x5e5e5e5fU, 0x5f606060U,
	0x61616162U, 0x62626363U, 0x64646464U, 0x65656566U,
	0x66676767U, 0x67686868U, 0x6969696aU, 0x6a6a6b6bU,
	0x6b6b6c6cU, 0x6c6d6d6dU, 0x6e6e6e6eU, 0x6f6f6f6fU,
	0x70707070U, 0x71717172U, 0x72727272U, 0x73737374U,
	0x74747474U, 0x75757575U, 0x76767676U, 0x76777777U,
	0x77787878U, 0x78787879U, 0x79797979U, 0x797a7a7aU,
	0x7a7a7b7bU, 0x7b7b7b7bU, 0x7b7c7c7cU, 0x7c7c7c7cU,
	0x7d7d7d7dU, 0x7d7d7d7dU, 0x7d7e7e7eU, 0x7e7e7e7eU,
	0x7e7e7e7eU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f80U,
	0x80807f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7e7e7eU,
	0x7e7e7e7eU, 0x7e7e7e7eU, 0x7d7d7d7dU, 0x7d7d7d7dU,
	0x7d7c7c7cU, 0x7c7c7c7cU, 0x7b7b7b7bU, 0x7b7b7b7aU,
	0x7a7a7a7aU, 0x79797979U, 0x79797878U, 0x78787878U,
	0x77777777U, 0x76767676U, 0x76757575U, 0x75747474U,
	0x74747373U, 0x73727272U, 0x72727171U, 0x71707070U,
	0x706f6f6fU, 0x6f6e6e6eU, 0x6e6d6d6dU, 0x6c6c6c6bU,
	0x14141415U, 0x15151515U, 0x16161617U, 0x17171717U,
	0x18181819U, 0x1919191aU, 0x1a1a1a1bU, 0x1b1b1b1cU,
	0x1c1c1d1dU, 0x1d1d1e1eU, 0x1e1f1f1fU, 0x1f202020U,
	0x21212122U, 0x22222223U, 0x23242424U, 0x24252525U,
	0x26262727U, 0x27272828U, 0x2829292aU, 0x2a2a2a2bU,
	0x2b2c2c2cU, 0x2c2d2d2eU, 0x2e2e2f2fU, 0x2f303030U,
	0x31313232U, 0x32333333U, 0x34343535U, 0x35363636U,
	0x37373838U, 0x3839393aU, 0x3a3a3b3bU, 0x3b3c3c3dU,
	0x3d3d3e3eU, 0x3e3f3f40U, 0x40414141U, 0x41424243U,
	0x43444445U, 0x45454546U, 0x46474748U, 0x48484949U,
	0x494a4a4bU, 0x4b4b4c4cU, 0x4c4d4d4eU, 0x4e4e4f4fU,
	0x50505051U, 0x51515252U, 0x53535354U, 0x54545555U,
	0x56565657U, 0x57575858U, 0x5959595aU, 0x5a5a5b5bU,
	0x5c5c5c5dU, 0x5d5d5e5eU, 0x5e5f5f60U, 0x60606061U,
	0x61626262U, 0x62636364U, 0x64646565U, 0x65656666U,
	0x67676768U, 0x68686869U, 0x69696a6aU, 0x6a6b6b6bU,
	0x6b6c6c6cU, 0x6d6d6d6eU, 0x6e6e6e6fU, 0x6f6f6f70U,
	0x70707071U, 0x71717272U, 0x72727273U, 0x73737474U,
	0x74747475U, 0x75757576U, 0x76767676U, 0x77777777U,
	0x77787878U, 0x78787979U, 0x79797979U, 0x7a7a7a7aU,
	0x7a7a7b7bU, 0x7b7b7b7bU, 0x7b7c7c7cU, 0x7c7c7c7dU,
	0x7d7d7d7dU, 0x7d7d7d7dU, 0x7d7e7e7eU, 0x7e7e7e7eU,
	0x7e7e7e7eU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f80U,
	0x80807f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7e7e7eU,
	0x7e7e7e7eU, 0x7e7e7e7eU, 0x7d7d7d7dU, 0x7d7d7d7dU,
	0x7d7d7c7cU, 0x7c7c7c7cU, 0x7b7b7b7bU, 0x7b7b7b7aU,
	0x7a7a7a7aU, 0x7a797979U, 0x79797978U, 0x78787878U,
	0x77777777U, 0x77767676U, 0x76767575U, 0x75757474U,
	0x74747473U, 0x73737272U, 0x72727271U, 0x71717070U,
	0x70706f6fU, 0x6f6f6e6eU, 0x6e6e6d6dU, 0x6d6c6c6cU,
	0x15151515U, 0x15161616U, 0x17171717U, 0x17181818U,
	0x19191919U, 0x1a1a1a1aU, 0x1b1b1b1bU, 0x1c1c1c1dU,
	0x1d1d1d1eU, 0x1e1e1f1fU, 0x1f1f2020U, 0x20212121U,
	0x22222222U, 0x23232424U, 0x24242525U, 0x25262627U,
	0x27272728U, 0x28282929U, 0x292a2a2aU, 0x2b2b2c2cU,
	0x2c2c2d2dU, 0x2e2e2e2eU, 0x2f2f3030U, 0x30313131U,
	0x32323333U, 0x33343434U, 0x35353636U, 0x36363737U,
	0x38383939U, 0x3a3a3a3aU, 0x3b3b3c3cU, 0x3c3d3d3dU,
	0x3e3e3f3fU, 0x3f404041U, 0x41414242U, 0x42434344U,
	0x44454545U, 0x45464647U, 0x47484848U, 0x4949494aU,
	0x4a4b4b4bU, 0x4c4c4c4dU, 0x4d4d4e4eU, 0x4f4f5050U,
	0x50505151U, 0x52525353U, 0x53535454U, 0x55555656U,
	0x56565757U, 0x58585959U, 0x59595a5aU, 0x5b5b5c5cU,
	0x5c5c5d5dU, 0x5e5e5e5eU, 0x5f5f6060U, 0x60616161U,
	0x62626263U, 0x63646464U, 0x64656565U, 0x66666667U,
	0x67676868U, 0x68686969U, 0x696a6a6bU, 0x6b6b6b6cU,
	0x6c6c6c6dU, 0x6d6d6e6eU, 0x6e6e6f6fU, 0x6f6f7070U,
	0x70707171U, 0x71727272U, 0x72727373U, 0x73747474U,
	0x74747575U, 0x75757576U, 0x76767677U, 0x77777777U,
	0x78787878U, 0x78787979U, 0x7979797aU, 0x7a7a7a7aU,
	0x7a7b7b7bU, 0x7b7b7b7bU, 0x7c7c7c7cU, 0x7c7c7c7dU,
	0x7d7d7d7dU, 0x7d7d7d7dU, 0x7e7e7e7eU, 0x7e7e7e7eU,
	0x7e7e7e7eU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f80U,
	0x80807f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7e7e7eU,
	0x7e7e7e7eU, 0x7e7e7e7eU, 0x7e7d7d7dU, 0x7d7d7d7dU,
	0x7d7d7c7cU, 0x7c7c7c7cU, 0x7c7b7b7bU, 0x7b7b7b7bU,
	0x7a7a7a7aU, 0x7a7a7979U, 0x79797978U, 0x78787878U,
	0x78777777U, 0x77777676U, 0x76767575U, 0x75757574U,
	0x74747474U, 0x73737372U, 0x72727272U, 0x71717170U,
	0x7070706fU, 0x6f6f6f6eU, 0x6e6e6e6dU, 0x6d6d6c6cU,
	0x15161616U, 0x16171717U, 0x17181818U, 0x18191919U,
	0x1a1a1a1aU, 0x1a1b1b1bU, 0x1c1c1c1cU, 0x1d1d1d1eU,
	0x1e1e1e1fU, 0x1f1f2020U, 0x20202121U, 0x21222222U,
	0x22232324U, 0x24242425U, 0x25252626U, 0x26272727U,
	0x28282829U, 0x29292a2aU, 0x2a2b2b2bU, 0x2c2c2c2dU,
	0x2d2e2e2eU, 0x2e2f2f30U, 0x30303031U, 0x31323233U,
	0x33333334U, 0x34353535U, 0x36363637U, 0x37383838U,
	0x39393a3aU, 0x3a3a3b3bU, 0x3c3c3d3dU, 0x3d3d3e3eU,
	0x3f3f4040U, 0x40414141U, 0x42424343U, 0x43444445U,
	0x45454546U, 0x46474748U, 0x48484949U, 0x494a4a4bU,
	0x4b4b4c4cU, 0x4c4d4d4dU, 0x4e4e4f4fU, 0x50505050U,
	0x51515252U, 0x53535353U, 0x54545555U, 0x55565656U,
	0x57575858U, 0x58595959U, 0x5a5a5b5bU, 0x5b5c5c5cU,
	0x5d5d5d5eU, 0x5e5e5f5fU, 0x60606060U, 0x61616262U,
	0x62626363U, 0x64646464U, 0x65656566U, 0x66676767U,
	0x67686868U, 0x69696969U, 0x6a6a6b6bU, 0x6b6b6c6cU,
	0x6c6c6d6dU, 0x6d6e6e6eU, 0x6e6f6f6fU, 0x6f707070U,
	0x70717171U, 0x72727272U, 0x72737373U, 0x74747474U,
	0x74757575U, 0x75757676U, 0x76767777U, 0x77777778U,
	0x78787878U, 0x78797979U, 0x7979797aU, 0x7a7a7a7aU,
	0x7a7b7b7bU, 0x7b7b7b7cU, 0x7c7c7c7cU, 0x7c7c7d7dU,
	0x7d7d7d7dU, 0x7d7d7d7dU, 0x7e7e7e7eU, 0x7e7e7e7eU,
	0x7e7e7e7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f80U,
	0x80807f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7e7eU,
	0x7e7e7e7eU, 0x7e7e7e7eU, 0x7e7d7d7dU, 0x7d7d7d7dU,
	0x7d7d7d7cU, 0x7c7c7c7cU, 0x7c7c7b7bU, 0x7b7b7b7bU,
	0x7a7a7a7aU, 0x7a7a7979U, 0x79797979U, 0x78787878U,
	0x78787777U, 0x77777776U, 0x76767675U, 0x75757575U,
	0x74747474U, 0x74737373U, 0x72727272U, 0x72717171U,
	0x70707070U, 0x6f6f6f6fU, 0x6e6e6e6eU, 0x6d6d6d6cU,
	0x16171717U, 0x17171818U, 0x18191919U, 0x191a1a1aU,
	0x1a1a1b1bU, 0x1b1c1c1cU, 0x1c1d1d1dU, 0x1e1e1e1eU,
	0x1f1f1f20U, 0x20202021U, 0x21212222U, 0x22222323U,
	0x24242424U, 0x25252526U, 0x26262727U, 0x27282828U,
	0x2829292aU, 0x2a2a2b2bU, 0x2b2c2c2cU, 0x2d2d2d2eU,
	0x2e2e2f2fU, 0x2f303030U, 0x31313232U, 0x32333333U,
	0x34343435U, 0x35363636U, 0x36373738U, 0x38393939U,
	0x3a3a3a3bU, 0x3b3c3c3cU, 0x3d3d3d3eU, 0x3e3e3f3fU,
	0x40404141U, 0x41414242U, 0x43434344U, 0x44454545U,
	0x46464647U, 0x47484849U, 0x4949494aU, 0x4a4b4b4bU,
	0x4c4c4c4dU, 0x4d4d4e4eU, 0x4f4f5050U, 0x50505151U,
	0x52525353U, 0x53535454U, 0x55555556U, 0x56565757U,
	0x57585859U, 0x59595a5aU, 0x5a5b5b5cU, 0x5c5c5c5dU,
	0x5d5e5e5eU, 0x5e5f5f60U, 0x60606161U, 0x61626262U,
	0x63636364U, 0x64646565U, 0x65656666U, 0x67676767U,
	0x68686869U, 0x6969696aU, 0x6a6b6b6bU, 0x6c6c6c6cU,
	0x6c6d6d6dU, 0x6e6e6e6eU, 0x6f6f6f6fU, 0x70707070U,
	0x71717172U, 0x72727272U, 0x73737373U, 0x74747474U,
	0x75757575U, 0x75767676U, 0x76767777U, 0x77777878U,
	0x78787878U, 0x79797979U, 0x79797a7aU, 0x7a7a7a7aU,
	0x7b7b7b7bU, 0x7b7b7b7cU, 0x7c7c7c7cU, 0x7c7c7d7dU,
	0x7d7d7d7dU, 0x7d7d7d7eU, 0x7e7e7e7eU, 0x7e7e7e7eU,
	0x7e7e7e7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f80U,
	0x80807f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7e7eU,
	0x7e7e7e7eU, 0x7e7e7e7eU, 0x7e7e7d7dU, 0x7d7d7d7dU,
	0x7d7d7d7cU, 0x7c7c7c7cU, 0x7c7c7b7bU, 0x7b7b7b7bU,
	0x7b7a7a7aU, 0x7a7a7a79U, 0x79797979U, 0x79787878U,
	0x78787877U, 0x77777776U, 0x76767676U, 0x75757575U,
	0x75747474U, 0x74737373U, 0x73727272U, 0x72727171U,
	0x71707070U, 0x706f6f6fU, 0x6f6e6e6eU, 0x6e6d6d6dU,
	0x17171818U, 0x18181919U, 0x191a1a1aU, 0x1a1a1b1bU,
	0x1b1b1c1cU, 0x1c1d1d1dU, 0x1d1e1e1eU, 0x1f1f1f1fU,
	0x20202020U, 0x21212122U, 0x22222223U, 0x23242424U,
	0x24252525U, 0x26262627U, 0x27272828U, 0x28282929U,
	0x2a2a2a2aU, 0x2b2b2c2cU, 0x2c2d2d2dU, 0x2e2e2e2fU,
	0x2f2f3030U, 0x30313131U, 0x32323333U, 0x33333434U,
	0x35353636U, 0x36363737U, 0x38383839U, 0x393a3a3aU,
	0x3a3b3b3cU, 0x3c3d3d3dU, 0x3d3e3e3fU, 0x3f3f4040U,
	0x41414141U, 0x42424343U, 0x44444445U, 0x45454646U,
	0x46474748U, 0x48494949U, 0x494a4a4bU, 0x4b4b4c4cU,
	0x4c4d4d4dU, 0x4e4e4f4fU, 0x50505050U, 0x51515252U,
	0x52535353U, 0x54545455U, 0x55565656U, 0x57575758U,
	0x58595959U, 0x595a5a5bU, 0x5b5c5c5cU, 0x5c5d5d5eU,
	0x5e5e5e5fU, 0x5f606060U, 0x60616162U, 0x62626263U,
	0x63646464U, 0x64656565U, 0x66666667U, 0x67676868U,
	0x68686969U, 0x696a6a6aU, 0x6b6b6b6cU, 0x6c6c6c6dU,
	0x6d6d6d6eU, 0x6e6e6f6fU, 0x6f6f6f70U, 0x70707071U,
	0x71717272U, 0x72727273U, 0x73737374U, 0x74747475U,
	0x75757575U, 0x76767676U, 0x76777777U, 0x77777878U,
	0x78787879U, 0x79797979U, 0x797a7a7aU, 0x7a7a7a7bU,
	0x7b7b7b7bU, 0x7b7b7c7cU, 0x7c7c7c7cU, 0x7c7c7d7dU,
	0x7d7d7d7dU, 0x7d7d7d7eU, 0x7e7e7e7eU, 0x7e7e7e7eU,
	0x7e7e7e7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f80U,
	0x80807f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7e7eU,
	0x7e7e7e7eU, 0x7e7e7e7eU, 0x7e7e7d7dU, 0x7d7d7d7dU,
	0x7d7d7d7cU, 0x7c7c7c7cU, 0x7c7c7c7bU, 0x7b7b7b7bU,
	0x7b7b7a7aU, 0x7a7a7a7aU, 0x79797979U, 0x79797878U,
	0x78787877U, 0x77777777U, 0x76767676U, 0x76757575U,
	0x75757474U, 0x74747373U, 0x73737272U, 0x72727271U,
	0x71717070U, 0x70706f6fU, 0x6f6f6f6eU, 0x6e6e6d6dU,
	0x18181919U, 0x19191a1aU, 0x1a1a1a1bU, 0x1b1b1c1cU,
	0x1c1c1d1dU, 0x1d1d1e1eU, 0x1e1f1f1fU, 0x1f202020U,
	0x21212121U, 0x22222223U, 0x23232424U, 0x24252525U,
	0x25262627U, 0x27272728U, 0x28282829U, 0x292a2a2aU,
	0x2a2b2b2cU, 0x2c2c2c2dU, 0x2d2e2e2eU, 0x2e2f2f30U,
	0x30303031U, 0x31323233U, 0x33333334U, 0x34353535U,
	0x36363637U, 0x37373838U, 0x39393a3aU, 0x3a3a3b3bU,
	0x3c3c3c3dU, 0x3d3d3e3eU, 0x3e3f3f40U, 0x40404141U,
	0x41424242U, 0x43434444U, 0x45454545U, 0x46464747U,
	0x47484849U, 0x4949494aU, 0x4a4b4b4bU, 0x4c4c4c4dU,
	0x4d4e4e4eU, 0x4f4f5050U, 0x50505151U, 0x52525253U,
	0x53535454U, 0x54555556U, 0x56565657U, 0x57585859U,
	0x5959595aU, 0x5a5b5b5bU, 0x5c5c5c5dU, 0x5d5d5e5eU,
	0x5e5f5f5fU, 0x60606061U, 0x61616262U, 0x62636363U,
	0x64646465U, 0x65656566U, 0x66676767U, 0x67686868U,
	0x69696969U, 0x6a6a6b6bU, 0x6b6b6c6cU, 0x6c6c6d6dU,
	0x6d6d6e6eU, 0x6e6f6f6fU, 0x6f6f7070U, 0x70707171U,
	0x71727272U, 0x72727373U, 0x73737474U, 0x74747575U,
	0x75757576U, 0x76767676U, 0x77777777U, 0x77787878U,
	0x78787879U, 0x79797979U, 0x797a7a7aU, 0x7a7a7a7bU,
	0x7b7b7b7bU, 0x7b7b7c7cU, 0x7c7c7c7cU, 0x7c7d7d7dU,
	0x7d7d7d7dU, 0x7d7d7d7eU, 0x7e7e7e7eU, 0x7e7e7e7eU,
	0x7e7e7e7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f80U,
	0x80807f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7e7eU,
	0x7e7e7e7eU, 0x7e7e7e7eU, 0x7e7e7d7dU, 0x7d7d7d7dU,
	0x7d7d7d7dU, 0x7c7c7c7cU, 0x7c7c7c7bU, 0x7b7b7b7bU,
	0x7b7b7a7aU, 0x7a7a7a7aU, 0x79797979U, 0x79797878U,
	0x78787878U, 0x77777777U, 0x77767676U, 0x76767575U,
	0x75757574U, 0x74747473U, 0x73737372U, 0x72727272U,
	0x71717170U, 0x7070706fU, 0x6f6f6f6fU, 0x6e6e6e6dU,
	0x19191a1aU, 0x1a1a1a1bU, 0x1b1b1b1cU, 0x1c1c1d1dU,
	0x1d1d1e1eU, 0x1e1e1f1fU, 0x1f202020U, 0x20212121U,
	0x21222222U, 0x23232324U, 0x24242525U, 0x25252626U,
	0x27272727U, 0x28282828U, 0x29292a2aU, 0x2a2a2b2bU,
	0x2c2c2c2cU, 0x2d2d2e2eU, 0x2e2e2f2fU, 0x30303030U,
	0x31313232U, 0x32333333U, 0x34343435U, 0x35363636U,
	0x36373738U, 0x38393939U, 0x3a3a3a3bU, 0x3b3b3c3cU,
	0x3d3d3d3dU, 0x3e3e3f3fU, 0x3f404041U, 0x41414142U,
	0x42434343U, 0x44444545U, 0x45454646U, 0x47474848U,
	0x48494949U, 0x494a4a4bU, 0x4b4c4c4cU, 0x4c4d4d4eU,
	0x4e4e4f4fU, 0x50505050U, 0x51515252U, 0x52535353U,
	0x54545455U, 0x55565656U, 0x56575758U, 0x58585959U,
	0x595a5a5aU, 0x5b5b5c5cU, 0x5c5c5d5dU, 0x5e5e5e5eU,
	0x5f5f6060U, 0x60606161U, 0x62626262U, 0x63636464U,
	0x64646565U, 0x65666666U, 0x67676768U, 0x68686869U,
	0x6969696aU, 0x6a6b6b6bU, 0x6b6c6c6cU, 0x6d6d6d6dU,
	0x6d6e6e6eU, 0x6f6f6f6fU, 0x6f707070U, 0x70717171U,
	0x72727272U, 0x72737373U, 0x73747474U, 0x74757575U,
	0x75757676U, 0x76767677U, 0x77777777U, 0x78787878U,
	0x78787979U, 0x79797979U, 0x7a7a7a7aU, 0x7a7a7b7bU,
	0x7b7b7b7bU, 0x7b7c7c7cU, 0x7c7c7c7cU, 0x7c7d7d7dU,
	0x7d7d7d7dU, 0x7d7d7e7eU, 0x7e7e7e7eU, 0x7e7e7e7eU,
	0x7e7e7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f80U,
	0x80807f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7eU,
	0x7e7e7e7eU, 0x7e7e7e7eU, 0x7e7e7e7dU, 0x7d7d7d7dU,
	0x7d7d7d7dU, 0x7c7c7c7cU, 0x7c7c7c7cU, 0x7b7b7b7bU,
	0x7b7b7b7aU, 0x7a7a7a7aU, 0x7a797979U, 0x79797978U,
	0x78787878U, 0x78777777U, 0x77777676U, 0x76767675U,
	0x75757575U, 0x74747474U, 0x73737373U, 0x72727272U,
	0x72717171U, 0x70707070U, 0x6f6f6f6fU, 0x6f6e6e6eU,
	0x1a1a1a1aU, 0x1b1b1b1cU, 0x1c1c1c1dU, 0x1d1d1d1eU,
	0x1e1e1f1fU, 0x1f1f2020U, 0x20202121U, 0x21222222U,
	0x22232324U, 0x24242425U, 0x25252526U, 0x26272727U,
	0x27282828U, 0x2929292aU, 0x2a2a2a2bU, 0x2b2c2c2cU,
	0x2c2d2d2eU, 0x2e2e2e2fU, 0x2f303030U, 0x30313132U,
	0x32323333U, 0x33343434U, 0x35353636U, 0x36363737U,
	0x38383839U, 0x393a3a3aU, 0x3a3b3b3cU, 0x3c3c3d3dU,
	0x3d3e3e3eU, 0x3f3f4040U, 0x40414141U, 0x42424243U,
	0x43444444U, 0x45454546U, 0x46464747U, 0x48484849U,
	0x49494a4aU, 0x4a4b4b4cU, 0x4c4c4c4dU, 0x4d4e4e4eU,
	0x4f4f5050U, 0x50505151U, 0x52525253U, 0x53535454U,
	0x54555556U, 0x56565657U, 0x57585858U, 0x5959595aU,
	0x5a5a5b5bU, 0x5c5c5c5cU, 0x5d5d5e5eU, 0x5e5e5f5fU,
	0x60606060U, 0x61616162U, 0x62626363U, 0x63646464U,
	0x65656565U, 0x66666767U, 0x67676868U, 0x68686969U,
	0x696a6a6aU, 0x6b6b6b6cU, 0x6c6c6c6dU, 0x6d6d6d6eU,
	0x6e6e6e6fU, 0x6f6f6f6fU, 0x70707071U, 0x71717172U,
	0x72727272U, 0x73737373U, 0x74747474U, 0x74757575U,
	0x75767676U, 0x76767777U, 0x77777778U, 0x78787878U,
	0x78797979U, 0x7979797aU, 0x7a7a7a7aU, 0x7a7b7b7bU,
	0x7b7b7b7bU, 0x7b7c7c7cU, 0x7c7c7c7cU, 0x7d7d7d7dU,
	0x7d7d7d7dU, 0x7d7d7e7eU, 0x7e7e7e7eU, 0x7e7e7e7eU,
	0x7e7e7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f80U,
	0x80807f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7eU,
	0x7e7e7e7eU, 0x7e7e7e7eU, 0x7e7e7e7dU, 0x7d7d7d7dU,
	0x7d7d7d7dU, 0x7d7c7c7cU, 0x7c7c7c7cU, 0x7b7b7b7bU,
	0x7b7b7b7bU, 0x7a7a7a7aU, 0x7a7a7979U, 0x79797979U,
	0x78787878U, 0x78787777U, 0x77777776U, 0x76767676U,
	0x75757575U, 0x74747474U, 0x74737373U, 0x73727272U,
	0x72727171U, 0x71717070U, 0x706f6f6fU, 0x6f6f6e6eU,
	0x1b1b1b1bU, 0x1c1c1c1dU, 0x1d1d1d1eU, 0x1e1e1e1fU,
	0x1f1f2020U, 0x20202121U, 0x21212222U, 0x22222323U,
	0x24242424U, 0x25252526U, 0x26262727U, 0x27272828U,
	0x28292929U, 0x2a2a2a2bU, 0x2b2b2c2cU, 0x2c2c2d2dU,
	0x2e2e2e2eU, 0x2f2f3030U, 0x30303131U, 0x32323233U,
	0x33333434U, 0x34353536U, 0x36363637U, 0x37373838U,
	0x39393a3aU, 0x3a3a3b3bU, 0x3b3c3c3dU, 0x3d3d3d3eU,
	0x3e3f3f3fU, 0x40404141U, 0x41414242U, 0x43434344U,
	0x44454545U, 0x45464647U, 0x47474848U, 0x49494949U,
	0x4a4a4b4bU, 0x4b4c4c4cU, 0x4c4d4d4eU, 0x4e4e4f4fU,
	0x50505050U, 0x51515252U, 0x52535353U, 0x54545455U,
	0x55565656U, 0x56575758U, 0x58585959U, 0x59595a5aU,
	0x5b5b5c5cU, 0x5c5c5d5dU, 0x5d5e5e5eU, 0x5f5f5f60U,
	0x60606161U, 0x61626262U, 0x62636364U, 0x64646465U,
	0x65656666U, 0x66676767U, 0x67686868U, 0x69696969U,
	0x6a6a6b6bU, 0x6b6b6c6cU, 0x6c6c6d6dU, 0x6d6d6e6eU,
	0x6e6e6f6fU, 0x6f6f6f70U, 0x70707171U, 0x71717272U,
	0x72727273U, 0x73737374U, 0x74747474U, 0x75757575U,
	0x75767676U, 0x76777777U, 0x77777878U, 0x78787878U,
	0x78797979U, 0x7979797aU, 0x7a7a7a7aU, 0x7a7b7b7bU,
	0x7b7b7b7bU, 0x7c7c7c7cU, 0x7c7c7c7cU, 0x7d7d7d7dU,
	0x7d7d7d7dU, 0x7d7e7e7eU, 0x7e7e7e7eU, 0x7e7e7e7eU,
	0x7e7e7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f80U,
	0x80807f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7eU,
	0x7e7e7e7eU, 0x7e7e7e7eU, 0x7e7e7e7eU, 0x7d7d7d7dU,
	0x7d7d7d7dU, 0x7d7c7c7cU, 0x7c7c7c7cU, 0x7c7b7b7bU,
	0x7b7b7b7bU, 0x7a7a7a7aU, 0x7a7a7979U, 0x79797979U,
	0x78787878U, 0x78787877U, 0x77777777U, 0x76767676U,
	0x75757575U, 0x75747474U, 0x74747373U, 0x73737272U,
	0x72727271U, 0x71717170U, 0x70706f6fU, 0x6f6f6f6eU,
	0x1c1c1c1cU, 0x1d1d1d1eU, 0x1e1e1e1fU, 0x1f1f1f20U,
	0x20202021U, 0x21212222U, 0x22222323U, 0x23242424U,
	0x25252525U, 0x26262627U, 0x27272828U, 0x28282929U,
	0x2a2a2a2aU, 0x2b2b2b2cU, 0x2c2c2d2dU, 0x2d2e2e2eU,
	0x2e2f2f30U, 0x30303031U, 0x31323232U, 0x33333333U,
	0x34343535U, 0x35363636U, 0x37373738U, 0x38393939U,
	0x3a3a3a3bU, 0x3b3b3c3cU, 0x3d3d3d3dU, 0x3e3e3e3fU,
	0x3f404040U, 0x41414142U, 0x42424343U, 0x44444445U,
	0x45454646U, 0x46474748U, 0x48484949U, 0x49494a4aU,
	0x4b4b4b4cU, 0x4c4c4d4dU, 0x4d4e4e4fU, 0x4f4f5050U,
	0x50505151U, 0x52525253U, 0x53535454U, 0x54555556U,
	0x56565657U, 0x57585858U, 0x59595959U, 0x5a5a5b5bU,
	0x5b5c5c5cU, 0x5d5d5d5eU, 0x5e5e5e5fU, 0x5f606060U,
	0x60616162U, 0x62626263U, 0x63646464U, 0x64656565U,
	0x65666667U, 0x67676768U, 0x68686869U, 0x6969696aU,
	0x6a6b6b6bU, 0x6b6c6c6cU, 0x6c6d6d6dU, 0x6e6e6e6eU,
	0x6e6f6f6fU, 0x6f707070U, 0x70717171U, 0x71727272U,
	0x72727373U, 0x73737474U, 0x74747475U, 0x75757575U,
	0x76767676U, 0x76777777U, 0x77777878U, 0x78787878U,
	0x79797979U, 0x79797a7aU, 0x7a7a7a7aU, 0x7b7b7b7bU,
	0x7b7b7b7bU, 0x7c7c7c7cU, 0x7c7c7c7dU, 0x7d7d7d7dU,
	0x7d7d7d7dU, 0x7d7e7e7eU, 0x7e7e7e7eU, 0x7e7e7e7eU,
	0x7e7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f80U,
	0x80807f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7e7e7e7eU, 0x7e7e7e7eU, 0x7e7e7e7eU, 0x7d7d7d7dU,
	0x7d7d7d7dU, 0x7d7d7c7cU, 0x7c7c7c7cU, 0x7c7b7b7bU,
	0x7b7b7b7bU, 0x7b7a7a7aU, 0x7a7a7a79U, 0x79797979U,
	0x79787878U, 0x78787877U, 0x77777777U, 0x76767676U,
	0x76757575U, 0x75757474U, 0x74747473U, 0x73737372U,
	0x72727272U, 0x71717171U, 0x70707070U, 0x6f6f6f6fU,
	0x1d1d1d1dU, 0x1e1e1e1eU, 0x1f1f1f20U, 0x20202021U,
	0x21212122U, 0x22222223U, 0x23242424U, 0x24252525U,
	0x25262627U, 0x27272728U, 0x28282829U, 0x292a2a2aU,
	0x2a2b2b2cU, 0x2c2c2c2dU, 0x2d2d2e2eU, 0x2e2f2f2fU,
	0x30303030U, 0x31313232U, 0x32333333U, 0x33343435U,
	0x35353636U, 0x36373737U, 0x38383939U, 0x393a3a3aU,
	0x3a3b3b3cU, 0x3c3c3d3dU, 0x3d3e3e3eU, 0x3f3f4040U,
	0x40414141U, 0x41424243U, 0x43434444U, 0x45454545U,
	0x46464647U, 0x47484848U, 0x4949494aU, 0x4a4a4b4bU,
	0x4c4c4c4cU, 0x4d4d4d4eU, 0x4e4f4f4fU, 0x50505051U,
	0x51515252U, 0x53535353U, 0x54545455U, 0x55565656U,
	0x56575758U, 0x58585959U, 0x59595a5aU, 0x5b5b5b5cU,
	0x5c5c5c5dU, 0x5d5e5e5eU, 0x5e5f5f60U, 0x60606061U,
	0x61616262U, 0x62636363U, 0x64646464U, 0x65656566U,
	0x66666767U, 0x67676868U, 0x68696969U, 0x696a6a6aU,
	0x6b6b6b6cU, 0x6c6c6c6dU, 0x6d6d6d6eU, 0x6e6e6e6fU,
	0x6f6f6f6fU, 0x70707070U, 0x71717171U, 0x72727272U,
	0x72737373U, 0x73747474U, 0x74747575U, 0x75757576U,
	0x76767676U, 0x77777777U, 0x77787878U, 0x78787879U,
	0x79797979U, 0x797a7a7aU, 0x7a7a7a7bU, 0x7b7b7b7bU,
	0x7b7b7b7cU, 0x7c7c7c7cU, 0x7c7c7c7dU, 0x7d7d7d7dU,
	0x7d7d7d7dU, 0x7d7e7e7eU, 0x7e7e7e7eU, 0x7e7e7e7eU,
	0x7e7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f80U,
	0x80807f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7e7e7e7eU, 0x7e7e7e7eU, 0x7e7e7e7eU, 0x7d7d7d7dU,
	0x7d7d7d7dU, 0x7d7d7c7cU, 0x7c7c7c7cU, 0x7c7c7b7bU,
	0x7b7b7b7bU, 0x7b7b7a7aU, 0x7a7a7a7aU, 0x79797979U,
	0x79797878U, 0x78787878U, 0x77777777U, 0x77767676U,
	0x76767575U, 0x75757574U, 0x74747474U, 0x73737373U,
	0x72727272U, 0x72717171U, 0x71707070U, 0x706f6f6fU,
	0x1e1e1e1eU, 0x1f1f1f1fU, 0x20202021U, 0x21212122U,
	0x22222223U, 0x23232424U, 0x24252525U, 0x25262626U,
	0x27272728U, 0x28282829U, 0x29292a2aU, 0x2a2a2b2bU,
	0x2c2c2c2cU, 0x2d2d2e2eU, 0x2e2e2f2fU, 0x2f303030U,
	0x30313132U, 0x32323333U, 0x33333434U, 0x35353536U,
	0x36363737U, 0x37383839U, 0x39393a3aU, 0x3a3a3b3bU,
	0x3c3c3c3dU, 0x3d3d3d3eU, 0x3e3f3f3fU, 0x40404141U,
	0x41414242U, 0x42434344U, 0x44444545U, 0x45464646U,
	0x47474748U, 0x48494949U, 0x494a4a4bU, 0x4b4b4c4cU,
	0x4c4c4d4dU, 0x4e4e4e4fU, 0x4f505050U, 0x50515151U,
	0x52525353U, 0x53535454U, 0x54555556U, 0x56565657U,
	0x57585858U, 0x59595959U, 0x5a5a5b5bU, 0x5b5c5c5cU,
	0x5c5d5d5eU, 0x5e5e5e5fU, 0x5f5f6060U, 0x60616161U,
	0x62626262U, 0x63636464U, 0x64646565U, 0x65656666U,
	0x67676767U, 0x68686868U, 0x69696969U, 0x6a6a6b6bU,
	0x6b6b6c6cU, 0x6c6c6d6dU, 0x6d6d6e6eU, 0x6e6f6f6fU,
	0x6f6f6f70U, 0x70707071U, 0x71717172U, 0x72727272U,
	0x73737373U, 0x74747474U, 0x74757575U, 0x75757676U,
	0x76767677U, 0x77777777U, 0x78787878U, 0x78787979U,
	0x79797979U, 0x7a7a7a7aU, 0x7a7a7a7bU, 0x7b7b7b7bU,
	0x7b7b7c7cU, 0x7c7c7c7cU, 0x7c7c7d7dU, 0x7d7d7d7dU,
	0x7d7d7d7dU, 0x7e7e7e7eU, 0x7e7e7e7eU, 0x7e7e7e7eU,
	0x7e7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f80U,
	0x80807f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7e7e7e7eU, 0x7e7e7e7eU, 0x7e7e7e7eU, 0x7e7d7d7dU,
	0x7d7d7d7dU, 0x7d7d7d7cU, 0x7c7c7c7cU, 0x7c7c7c7bU,
	0x7b7b7b7bU, 0x7b7b7a7aU, 0x7a7a7a7aU, 0x7a797979U,
	0x79797978U, 0x78787878U, 0x78777777U, 0x77777676U,
	0x76767675U, 0x75757575U, 0x74747474U, 0x74737373U,
	0x73727272U, 0x72727171U, 0x71717070U, 0x70706f6fU,
	0x1f1f1f1fU, 0x20202020U, 0x21212121U, 0x22222223U,
	0x23232424U, 0x24242525U, 0x25252626U, 0x27272727U,
	0x28282828U, 0x29292a2aU, 0x2a2a2b2bU, 0x2b2c2c2cU,
	0x2c2d2d2eU, 0x2e2e2e2fU, 0x2f2f3030U, 0x30313131U,
	0x32323233U, 0x33333434U, 0x34353535U, 0x36363637U,
	0x37373838U, 0x3939393aU, 0x3a3a3a3bU, 0x3b3c3c3cU,
	0x3d3d3d3dU, 0x3e3e3f3fU, 0x3f404040U, 0x41414142U,
	0x42424343U, 0x44444445U, 0x45454546U, 0x46474747U,
	0x48484849U, 0x49494a4aU, 0x4a4b4b4bU, 0x4c4c4c4dU,
	0x4d4d4e4eU, 0x4f4f4f50U, 0x50505051U, 0x51525252U,
	0x53535353U, 0x54545555U, 0x55565656U, 0x56575758U,
	0x58585959U, 0x59595a5aU, 0x5b5b5b5cU, 0x5c5c5c5dU,
	0x5d5e5e5eU, 0x5e5f5f5fU, 0x60606060U, 0x61616262U,
	0x62626363U, 0x64646464U, 0x65656565U, 0x66666667U,
	0x67676768U, 0x68686969U, 0x69696a6aU, 0x6a6b6b6bU,
	0x6b6c6c6cU, 0x6d6d6d6dU, 0x6e6e6e6eU, 0x6f6f6f6fU,
	0x6f6f7070U, 0x70707171U, 0x71727272U, 0x72727273U,
	0x73737474U, 0x74747474U, 0x75757575U, 0x75767676U,
	0x76767777U, 0x77777778U, 0x78787878U, 0x78797979U,
	0x79797979U, 0x7a7a7a7aU, 0x7a7a7b7bU, 0x7b7b7b7bU,
	0x7b7b7c7cU, 0x7c7c7c7cU, 0x7c7d7d7dU, 0x7d7d7d7dU,
	0x7d7d7d7dU, 0x7e7e7e7eU, 0x7e7e7e7eU, 0x7e7e7e7eU,
	0x7e7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f80U,
	0x80807f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7e7e7e7eU, 0x7e7e7e7eU, 0x7e7e7e7eU, 0x7e7d7d7dU,
	0x7d7d7d7dU, 0x7d7d7d7dU, 0x7c7c7c7cU, 0x7c7c7c7bU,
	0x7b7b7b7bU, 0x7b7b7b7aU, 0x7a7a7a7aU, 0x7a797979U,
	0x79797979U, 0x78787878U, 0x78787777U, 0x77777776U,
	0x76767676U, 0x75757575U, 0x75747474U, 0x74747473U,
	0x73737272U, 0x72727272U, 0x71717170U, 0x7070706fU,
	0x20202020U, 0x21212121U, 0x22222222U, 0x23232424U,
	0x24242525U, 0x25252626U, 0x26272727U, 0x28282828U,
	0x2929292aU, 0x2a2a2a2bU, 0x2b2c2c2cU, 0x2c2d2d2dU,
	0x2e2e2e2eU, 0x2f2f3030U, 0x30303131U, 0x31323233U,
	0x33333334U, 0x34343535U, 0x36363636U, 0x37373738U,
	0x38393939U, 0x3a3a3a3aU, 0x3b3b3b3cU, 0x3c3d3d3dU,
	0x3d3e3e3eU, 0x3f3f4040U, 0x40414141U, 0x41424243U,
	0x43434444U, 0x45454545U, 0x46464647U, 0x47484848U,
	0x49494949U, 0x4a4a4b4bU, 0x4b4c4c4cU, 0x4c4d4d4dU,
	0x4e4e4f4fU, 0x4f505050U, 0x50515152U, 0x52525353U,
	0x53535454U, 0x55555556U, 0x56565657U, 0x57585858U,
	0x59595959U, 0x5a5a5b5bU, 0x5b5c5c5cU, 0x5c5d5d5eU,
	0x5e5e5e5fU, 0x5f5f6060U, 0x60606161U, 0x62626262U,
	0x63636364U, 0x64646465U, 0x65656566U, 0x66676767U,
	0x67686868U, 0x68696969U, 0x696a6a6bU, 0x6b6b6b6cU,
	0x6c6c6c6dU, 0x6d6d6d6eU, 0x6e6e6e6fU, 0x6f6f6f6fU,
	0x6f707070U, 0x71717171U, 0x72727272U, 0x72737373U,
	0x73747474U, 0x74747575U, 0x75757575U, 0x76767676U,
	0x76777777U, 0x77777878U, 0x78787878U, 0x79797979U,
	0x7979797aU, 0x7a7a7a7aU, 0x7a7b7b7bU, 0x7b7b7b7bU,
	0x7b7c7c7cU, 0x7c7c7c7cU, 0x7c7d7d7dU, 0x7d7d7d7dU,
	0x7d7d7d7eU, 0x7e7e7e7eU, 0x7e7e7e7eU, 0x7e7e7e7eU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f80U,
	0x80807f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7e7e7eU, 0x7e7e7e7eU, 0x7e7e7e7eU, 0x7e7e7d7dU,
	0x7d7d7d7dU, 0x7d7d7d7dU, 0x7c7c7c7cU, 0x7c7c7c7cU,
	0x7b7b7b7bU, 0x7b7b7b7bU, 0x7a7a7a7aU, 0x7a7a7979U,
	0x79797979U, 0x79787878U, 0x78787877U, 0x77777777U,
	0x76767676U, 0x76757575U, 0x75757574U, 0x74747474U,
	0x73737373U, 0x72727272U, 0x72717171U, 0x71707070U,
	0x21212121U, 0x22222222U, 0x23232424U, 0x24242525U,
	0x25252626U, 0x26272727U, 0x27282828U, 0x2829292aU,
	0x2a2a2a2bU, 0x2b2b2c2cU, 0x2c2c2d2dU, 0x2e2e2e2eU,
	0x2f2f2f30U, 0x30303031U, 0x31323232U, 0x33333333U,
	0x34343435U, 0x35363636U, 0x36373737U, 0x38383939U,
	0x393a3a3aU, 0x3a3b3b3bU, 0x3c3c3d3dU, 0x3d3d3e3eU,
	0x3e3f3f40U, 0x40404141U, 0x41414242U, 0x43434344U,
	0x44444545U, 0x45454646U, 0x47474748U, 0x48494949U,
	0x494a4a4aU, 0x4b4b4b4cU, 0x4c4c4d4dU, 0x4d4e4e4eU,
	0x4f4f5050U, 0x50505151U, 0x51525253U, 0x53535354U,
	0x54545555U, 0x55565656U, 0x57575758U, 0x58585959U,
	0x59595a5aU, 0x5b5b5b5cU, 0x5c5c5c5dU, 0x5d5e5e5eU,
	0x5e5f5f5fU, 0x60606060U, 0x61616262U, 0x62626363U,
	0x63646464U, 0x64656565U, 0x65666667U, 0x67676768U,
	0x68686869U, 0x6969696aU, 0x6a6a6b6bU, 0x6b6b6c6cU,
	0x6c6c6d6dU, 0x6d6d6e6eU, 0x6e6f6f6fU, 0x6f6f6f70U,
	0x70707071U, 0x71717172U, 0x72727272U, 0x73737373U,
	0x74747474U, 0x74757575U, 0x75757576U, 0x76767676U,
	0x77777777U, 0x77787878U, 0x78787878U, 0x79797979U,
	0x79797a7aU, 0x7a7a7a7aU, 0x7a7b7b7bU, 0x7b7b7b7bU,
	0x7b7c7c7cU, 0x7c7c7c7cU, 0x7d7d7d7dU, 0x7d7d7d7dU,
	0x7d7d7d7eU, 0x7e7e7e7eU, 0x7e7e7e7eU, 0x7e7e7e7eU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f80U,
	0x80807f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7e7e7eU, 0x7e7e7e7eU, 0x7e7e7e7eU, 0x7e7e7d7dU,
	0x7d7d7d7dU, 0x7d7d7d7dU, 0x7d7c7c7cU, 0x7c7c7c7cU,
	0x7b7b7b7bU, 0x7b7b7b7bU, 0x7a7a7a7aU, 0x7a7a7a79U,
	0x79797979U, 0x79787878U, 0x78787878U, 0x77777777U,
	0x77767676U, 0x76767575U, 0x75757575U, 0x74747474U,
	0x74737373U, 0x73727272U, 0x72727171U, 0x71717070U,
	0x22222222U, 0x23232324U, 0x24242425U, 0x25252526U,
	0x26272727U, 0x27282828U, 0x28292929U, 0x2a2a2a2aU,
	0x2b2b2c2cU, 0x2c2c2d2dU, 0x2d2e2e2eU, 0x2e2f2f2fU,
	0x30303031U, 0x31313232U, 0x32333333U, 0x33343435U,
	0x35353636U, 0x36363737U, 0x37383839U, 0x39393a3aU,
	0x3a3a3b3bU, 0x3c3c3c3dU, 0x3d3d3d3eU, 0x3e3e3f3fU,
	0x40404041U, 0x41414142U, 0x42424343U, 0x44444445U,
	0x45454546U, 0x46474747U, 0x48484849U, 0x4949494aU,
	0x4a4b4b4bU, 0x4c4c4c4cU, 0x4d4d4d4eU, 0x4e4f4f4fU,
	0x50505050U, 0x51515252U, 0x52535353U, 0x53545454U,
	0x55555656U, 0x56565757U, 0x57585858U, 0x59595959U,
	0x5a5a5b5bU, 0x5b5c5c5cU, 0x5c5d5d5eU, 0x5e5e5e5fU,
	0x5f5f6060U, 0x60606161U, 0x61626262U, 0x62636364U,
	0x64646465U, 0x65656566U, 0x66666767U, 0x67676868U,
	0x68686969U, 0x69696a6aU, 0x6b6b6b6bU, 0x6c6c6c6cU,
	0x6d6d6d6dU, 0x6e6e6e6eU, 0x6f6f6f6fU, 0x6f707070U,
	0x70707171U, 0x71717272U, 0x72727273U, 0x73737374U,
	0x74747474U, 0x75757575U, 0x75757676U, 0x76767677U,
	0x77777777U, 0x78787878U, 0x78787879U, 0x79797979U,
	0x797a7a7aU, 0x7a7a7a7aU, 0x7b7b7b7bU, 0x7b7b7b7bU,
	0x7c7c7c7cU, 0x7c7c7c7cU, 0x7d7d7d7dU, 0x7d7d7d7dU,
	0x7d7d7e7eU, 0x7e7e7e7eU, 0x7e7e7e7eU, 0x7e7e7e7eU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f80U,
	0x80807f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7e7e7eU, 0x7e7e7e7eU, 0x7e7e7e7eU, 0x7e7e7e7dU,
	0x7d7d7d7dU, 0x7d7d7d7dU, 0x7d7c7c7cU, 0x7c7c7c7cU,
	0x7c7b7b7bU, 0x7b7b7b7bU, 0x7b7a7a7aU, 0x7a7a7a7aU,
	0x79797979U, 0x79797878U, 0x78787878U, 0x78777777U,
	0x77777676U, 0x76767675U, 0x75757575U, 0x75747474U,
	0x74747373U, 0x73737272U, 0x72727271U, 0x71717170U,
	0x23232324U, 0x24242425U, 0x25252526U, 0x26272727U,
	0x27282828U, 0x28292929U, 0x2a2a2a2aU, 0x2b2b2b2cU,
	0x2c2c2c2dU, 0x2d2e2e2eU, 0x2e2f2f2fU, 0x30303030U,
	0x31313132U, 0x32333333U, 0x33343434U, 0x35353536U,
	0x36363637U, 0x37383838U, 0x3939393aU, 0x3a3a3a3bU,
	0x3b3c3c3cU, 0x3d3d3d3dU, 0x3e3e3e3fU, 0x3f404040U,
	0x41414141U, 0x42424243U, 0x43444444U, 0x45454545U,
	0x46464647U, 0x47484848U, 0x49494949U, 0x4a4a4a4bU,
	0x4b4c4c4cU, 0x4c4d4d4dU, 0x4e4e4e4fU, 0x4f505050U,
	0x50515151U, 0x52525253U, 0x53535354U, 0x54555555U,
	0x56565656U, 0x57575758U, 0x58595959U, 0x595a5a5aU,
	0x5b5b5b5cU, 0x5c5c5c5dU, 0x5d5e5e5eU, 0x5e5f5f5fU,
	0x60606060U, 0x61616162U, 0x62626263U, 0x63646464U,
	0x64656565U, 0x65666666U, 0x67676767U, 0x68686868U,
	0x69696969U, 0x6a6a6a6bU, 0x6b6b6b6cU, 0x6c6c6c6dU,
	0x6d6d6d6eU, 0x6e6e6e6fU, 0x6f6f6f6fU, 0x70707070U,
	0x70717171U, 0x71727272U, 0x72727373U, 0x73737474U,
	0x74747475U, 0x75757575U, 0x75767676U, 0x76767777U,
	0x77777778U, 0x78787878U, 0x78787979U, 0x79797979U,
	0x797a7a7aU, 0x7a7a7a7bU, 0x7b7b7b7bU, 0x7b7b7b7cU,
	0x7c7c7c7cU, 0x7c7c7c7dU, 0x7d7d7d7dU, 0x7d7d7d7dU,
	0x7d7d7e7eU, 0x7e7e7e7eU, 0x7e7e7e7eU, 0x7e7e7e7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f80U,
	0x80807f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7e7eU, 0x7e7e7e7eU, 0x7e7e7e7eU, 0x7e7e7e7dU,
	0x7d7d7d7dU, 0x7d7d7d7dU, 0x7d7d7c7cU, 0x7c7c7c7cU,
	0x7c7c7b7bU, 0x7b7b7b7bU, 0x7b7b7a7aU, 0x7a7a7a7aU,
	0x79797979U, 0x79797978U, 0x78787878U, 0x78787777U,
	0x77777776U, 0x76767676U, 0x75757575U, 0x75757474U,
	0x74747473U, 0x73737372U, 0x72727272U, 0x71717171U,
	0x24242425U, 0x25252526U, 0x26272727U, 0x27282828U,
	0x28282929U, 0x2a2a2a2aU, 0x2b2b2b2cU, 0x2c2c2c2dU,
	0x2d2d2e2eU, 0x2e2e2f2fU, 0x30303030U, 0x31313132U,
	0x32323333U, 0x33333434U, 0x34353536U, 0x36363637U,
	0x37373838U, 0x3839393aU, 0x3a3a3a3bU, 0x3b3b3c3cU,
	0x3c3d3d3dU, 0x3d3e3e3eU, 0x3f3f4040U, 0x40414141U,
	0x41424242U, 0x43434444U, 0x44454545U, 0x45464646U,
	0x47474748U, 0x48494949U, 0x494a4a4aU, 0x4b4b4b4cU,
	0x4c4c4c4dU, 0x4d4e4e4eU, 0x4f4f4f50U, 0x50505051U,
	0x51515252U, 0x53535353U, 0x54545455U, 0x55555656U,
	0x56565757U, 0x58585859U, 0x5959595aU, 0x5a5a5b5bU,
	0x5b5c5c5cU, 0x5c5d5d5eU, 0x5e5e5e5fU, 0x5f5f6060U,
	0x60606161U, 0x61626262U, 0x62636364U, 0x64646465U,
	0x65656565U, 0x66666767U, 0x67676868U, 0x68686969U,
	0x69696a6aU, 0x6a6b6b6bU, 0x6b6c6c6cU, 0x6c6d6d6dU,
	0x6d6e6e6eU, 0x6e6f6f6fU, 0x6f6f6f70U, 0x70707071U,
	0x71717172U, 0x72727272U, 0x72737373U, 0x73747474U,
	0x74747575U, 0x75757576U, 0x76767676U, 0x76777777U,
	0x77777878U, 0x78787878U, 0x78797979U, 0x79797979U,
	0x7a7a7a7aU, 0x7a7a7b7bU, 0x7b7b7b7bU, 0x7b7b7c7cU,
	0x7c7c7c7cU, 0x7c7c7c7dU, 0x7d7d7d7dU, 0x7d7d7d7dU,
	0x7d7e7e7eU, 0x7e7e7e7eU, 0x7e7e7e7eU, 0x7e7e7e7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f80U,
	0x80807f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7e7eU, 0x7e7e7e7eU, 0x7e7e7e7eU, 0x7e7e7e7eU,
	0x7d7d7d7dU, 0x7d7d7d7dU, 0x7d7d7c7cU, 0x7c7c7c7cU,
	0x7c7c7c7bU, 0x7b7b7b7bU, 0x7b7b7b7aU, 0x7a7a7a7aU,
	0x7a797979U, 0x79797979U, 0x78787878U, 0x78787877U,
	0x77777777U, 0x76767676U, 0x76767575U, 0x75757574U,
	0x74747474U, 0x73737373U, 0x72727272U, 0x72727171U,
	0x25252526U, 0x26272727U, 0x27272828U, 0x28282929U,
	0x2a2a2a2aU, 0x2b2b2b2cU, 0x2c2c2c2dU, 0x2d2d2e2eU,
	0x2e2e2f2fU, 0x2f303030U, 0x30313131U, 0x32323333U,
	0x33333434U, 0x34353535U, 0x36363636U, 0x37373738U,
	0x38393939U, 0x3a3a3a3aU, 0x3b3b3b3cU, 0x3c3c3d3dU,
	0x3d3d3e3eU, 0x3f3f3f40U, 0x40404141U, 0x41414242U,
	0x42434344U, 0x44444545U, 0x45454646U, 0x46474747U,
	0x48484949U, 0x49494a4aU, 0x4a4b4b4bU, 0x4c4c4c4cU,
	0x4d4d4d4eU, 0x4e4f4f4fU, 0x50505050U, 0x51515152U,
	0x52525353U, 0x53535454U, 0x54555556U, 0x56565657U,
	0x57575858U, 0x58595959U, 0x595a5a5aU, 0x5b5b5c5cU,
	0x5c5c5d5dU, 0x5d5e5e5eU, 0x5e5f5f5fU, 0x60606060U,
	0x61616162U, 0x62626263U, 0x63636464U, 0x64646565U,
	0x65656666U, 0x67676767U, 0x67686868U, 0x68696969U,
	0x696a6a6bU, 0x6b6b6b6cU, 0x6c6c6c6cU, 0x6d6d6d6dU,
	0x6e6e6e6eU, 0x6f6f6f6fU, 0x6f707070U, 0x70717171U,
	0x71717272U, 0x72727273U, 0x73737374U, 0x74747474U,
	0x74757575U, 0x75757676U, 0x76767676U, 0x77777777U,
	0x77787878U, 0x78787878U, 0x79797979U, 0x7979797aU,
	0x7a7a7a7aU, 0x7a7a7b7bU, 0x7b7b7b7bU, 0x7b7b7c7cU,
	0x7c7c7c7cU, 0x7c7c7d7dU, 0x7d7d7d7dU, 0x7d7d7d7dU,
	0x7d7e7e7eU, 0x7e7e7e7eU, 0x7e7e7e7eU, 0x7e7e7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f80U,
	0x80807f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7eU, 0x7e7e7e7eU, 0x7e7e7e7eU, 0x7e7e7e7eU,
	0x7d7d7d7dU, 0x7d7d7d7dU, 0x7d7d7d7cU, 0x7c7c7c7cU,
	0x7c7c7c7bU, 0x7b7b7b7bU, 0x7b7b7b7aU, 0x7a7a7a7aU,
	0x7a7a7979U, 0x79797979U, 0x79787878U, 0x78787878U,
	0x77777777U, 0x77767676U, 0x76767675U, 0x75757575U,
	0x74747474U, 0x74747373U, 0x73737272U, 0x72727271U,
	0x26272727U, 0x27272828U, 0x28282929U, 0x2a2a2a2aU,
	0x2a2b2b2cU, 0x2c2c2c2dU, 0x2d2d2e2eU, 0x2e2e2f2fU,
	0x2f303030U, 0x30313131U, 0x32323233U, 0x33333334U,
	0x34343535U, 0x36363636U, 0x37373738U, 0x38383939U,
	0x393a3a3aU, 0x3a3b3b3bU, 0x3c3c3d3dU, 0x3d3d3e3eU,
	0x3e3f3f3fU, 0x40404041U, 0x41414142U, 0x42424343U,
	0x44444445U, 0x45454546U, 0x46464747U, 0x47484849U,
	0x49494949U, 0x4a4a4b4bU, 0x4b4c4c4cU, 0x4c4d4d4dU,
	0x4e4e4e4fU, 0x4f4f5050U, 0x50505151U, 0x52525253U,
	0x53535354U, 0x54545555U, 0x55565656U, 0x56575757U,
	0x58585959U, 0x5959595aU, 0x5a5b5b5bU, 0x5c5c5c5cU,
	0x5d5d5d5eU, 0x5e5e5e5fU, 0x5f5f6060U, 0x60606161U,
	0x61626262U, 0x62636363U, 0x64646464U, 0x65656565U,
	0x66666667U, 0x67676768U, 0x68686869U, 0x6969696aU,
	0x6a6a6b6bU, 0x6b6b6c6cU, 0x6c6c6d6dU, 0x6d6d6e6eU,
	0x6e6e6f6fU, 0x6f6f6f6fU, 0x70707070U, 0x71717171U,
	0x71727272U, 0x72727373U, 0x73737474U, 0x74747474U,
	0x75757575U, 0x75767676U, 0x76767677U, 0x77777777U,
	0x78787878U, 0x78787879U, 0x79797979U, 0x79797a7aU,
	0x7a7a7a7aU, 0x7a7b7b7bU, 0x7b7b7b7bU, 0x7b7c7c7cU,
	0x7c7c7c7cU, 0x7c7d7d7dU, 0x7d7d7d7dU, 0x7d7d7d7dU,
	0x7e7e7e7eU, 0x7e7e7e7eU, 0x7e7e7e7eU, 0x7e7e7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f80U,
	0x80807f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7eU, 0x7e7e7e7eU, 0x7e7e7e7eU, 0x7e7e7e7eU,
	0x7e7d7d7dU, 0x7d7d7d7dU, 0x7d7d7d7dU, 0x7c7c7c7cU,
	0x7c7c7c7cU, 0x7b7b7b7bU, 0x7b7b7b7bU, 0x7a7a7a7aU,
	0x7a7a7a79U, 0x79797979U, 0x79797878U, 0x78787878U,
	0x78777777U, 0x77777676U, 0x76767676U, 0x75757575U,
	0x75747474U, 0x74747473U, 0x73737372U, 0x72727272U,
	0x27282828U, 0x28282929U, 0x2a2a2a2aU, 0x2a2b2b2cU,
	0x2c2c2c2dU, 0x2d2d2e2eU, 0x2e2e2f2fU, 0x2f303030U,
	0x30313131U, 0x32323233U, 0x33333334U, 0x34343535U,
	0x35363636U, 0x36373737U, 0x38383939U, 0x393a3a3aU,
	0x3a3b3b3bU, 0x3c3c3c3dU, 0x3d3d3d3eU, 0x3e3e3f3fU,
	0x3f404041U, 0x41414141U, 0x42424343U, 0x43444444U,
	0x45454545U, 0x46464647U, 0x47474848U, 0x48494949U,
	0x494a4a4bU, 0x4b4b4c4cU, 0x4c4c4d4dU, 0x4d4e4e4eU,
	0x4f4f4f50U, 0x50505051U, 0x51515252U, 0x52535353U,
	0x53545455U, 0x55555656U, 0x56565757U, 0x57585858U,
	0x59595959U, 0x5a5a5a5bU, 0x5b5b5c5cU, 0x5c5c5d5dU,
	0x5d5e5e5eU, 0x5e5f5f5fU, 0x60606060U, 0x61616162U,
	0x62626263U, 0x63636464U, 0x64646565U, 0x65656666U,
	0x66676767U, 0x67686868U, 0x68696969U, 0x696a6a6aU,
	0x6b6b6b6bU, 0x6c6c6c6cU, 0x6d6d6d6dU, 0x6d6e6e6eU,
	0x6e6f6f6fU, 0x6f6f7070U, 0x70707171U, 0x71717172U,
	0x72727272U, 0x72737373U, 0x73747474U, 0x74747575U,
	0x75757575U, 0x76767676U, 0x76767777U, 0x77777778U,
	0x78787878U, 0x78787979U, 0x79797979U, 0x797a7a7aU,
	0x7a7a7a7aU, 0x7b7b7b7bU, 0x7b7b7b7bU, 0x7c7c7c7cU,
	0x7c7c7c7cU, 0x7c7d7d7dU, 0x7d7d7d7dU, 0x7d7d7d7dU,
	0x7e7e7e7eU, 0x7e7e7e7eU, 0x7e7e7e7eU, 0x7e7e7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f80U,
	0x80807f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7eU, 0x7e7e7e7eU, 0x7e7e7e7eU, 0x7e7e7e7eU,
	0x7e7d7d7dU, 0x7d7d7d7dU, 0x7d7d7d7dU, 0x7c7c7c7cU,
	0x7c7c7c7cU, 0x7c7b7b7bU, 0x7b7b7b7bU, 0x7b7a7a7aU,
	0x7a7a7a7aU, 0x79797979U, 0x79797978U, 0x78787878U,
	0x78787777U, 0x77777776U, 0x76767676U, 0x76757575U,
	0x75757574U, 0x74747474U, 0x73737373U, 0x72727272U,
	0x28292929U, 0x2a2a2a2aU, 0x2b2b2b2cU, 0x2c2c2c2dU,
	0x2d2d2e2eU, 0x2e2e2e2fU, 0x2f303030U, 0x30303131U,
	0x32323233U, 0x33333334U, 0x34343535U, 0x35363636U,
	0x36373737U, 0x38383839U, 0x39393a3aU, 0x3a3a3b3bU,
	0x3b3c3c3cU, 0x3d3d3d3dU, 0x3e3e3e3fU, 0x3f404040U,
	0x41414141U, 0x42424243U, 0x43434444U, 0x44454545U,
	0x45464646U, 0x47474748U, 0x48494949U, 0x49494a4aU,
	0x4a4b4b4cU, 0x4c4c4c4cU, 0x4d4d4e4eU, 0x4e4f4f4fU,
	0x50505050U, 0x51515152U, 0x52525353U, 0x53535454U,
	0x54555555U, 0x56565656U, 0x57575758U, 0x58585959U,
	0x59595a5aU, 0x5a5b5b5cU, 0x5c5c5c5cU, 0x5d5d5e5eU,
	0x5e5e5e5fU, 0x5f606060U, 0x60606161U, 0x62626262U,
	0x62636363U, 0x64646464U, 0x65656565U, 0x66666667U,
	0x67676768U, 0x68686869U, 0x6969696aU, 0x6a6a6b6bU,
	0x6b6b6c6cU, 0x6c6c6c6dU, 0x6d6d6d6eU, 0x6e6e6e6fU,
	0x6f6f6f6fU, 0x6f707070U, 0x70717171U, 0x71727272U,
	0x72727273U, 0x73737373U, 0x74747474U, 0x74757575U,
	0x75757576U, 0x76767676U, 0x77777777U, 0x77777878U,
	0x78787878U, 0x78797979U, 0x79797979U, 0x7a7a7a7aU,
	0x7a7a7a7bU, 0x7b7b7b7bU, 0x7b7b7b7bU, 0x7c7c7c7cU,
	0x7c7c7c7cU, 0x7d7d7d7dU, 0x7d7d7d7dU, 0x7d7d7d7eU,
	0x7e7e7e7eU, 0x7e7e7e7eU, 0x7e7e7e7eU, 0x7e7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f80U,
	0x80807f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7e7e7e7eU, 0x7e7e7e7eU, 0x7e7e7e7eU,
	0x7e7e7d7dU, 0x7d7d7d7dU, 0x7d7d7d7dU, 0x7d7c7c7cU,
	0x7c7c7c7cU, 0x7c7b7b7bU, 0x7b7b7b7bU, 0x7b7b7a7aU,
	0x7a7a7a7aU, 0x7a797979U, 0x79797979U, 0x78787878U,
	0x78787877U, 0x77777777U, 0x77767676U, 0x76767575U,
	0x75757575U, 0x74747474U, 0x74737373U, 0x73737272U,
	0x2a2a2a2aU, 0x2b2b2b2cU, 0x2c2c2c2dU, 0x2d2d2e2eU,
	0x2e2e2f2fU, 0x2f303030U, 0x30303131U, 0x32323233U,
	0x33333333U, 0x34343535U, 0x35363636U, 0x36363737U,
	0x38383839U, 0x39393a3aU, 0x3a3a3b3bU, 0x3b3c3c3cU,
	0x3d3d3d3dU, 0x3e3e3e3fU, 0x3f3f4040U, 0x40414141U,
	0x41424242U, 0x43434344U, 0x44444545U, 0x45454646U,
	0x46474747U, 0x48484949U, 0x4949494aU, 0x4a4a4b4bU,
	0x4c4c4c4cU, 0x4c4d4d4eU, 0x4e4e4f4fU, 0x4f505050U,
	0x50515151U, 0x52525253U, 0x53535354U, 0x54545555U,
	0x55565656U, 0x56575757U, 0x58585859U, 0x5959595aU,
	0x5a5a5b5bU, 0x5b5c5c5cU, 0x5c5d5d5dU, 0x5e5e5e5eU,
	0x5f5f5f60U, 0x60606061U, 0x61616262U, 0x62626263U,
	0x63646464U, 0x64646565U, 0x65656666U, 0x66676767U,
	0x67686868U, 0x68696969U, 0x69696a6aU, 0x6b6b6b6bU,
	0x6b6c6c6cU, 0x6c6d6d6dU, 0x6d6e6e6eU, 0x6e6e6f6fU,
	0x6f6f6f70U, 0x70707071U, 0x71717171U, 0x72727272U,
	0x72727373U, 0x73737474U, 0x74747474U, 0x75757575U,
	0x75757676U, 0x76767677U, 0x77777777U, 0x77787878U,
	0x78787878U, 0x79797979U, 0x7979797aU, 0x7a7a7a7aU,
	0x7a7a7b7bU, 0x7b7b7b7bU, 0x7b7b7b7cU, 0x7c7c7c7cU,
	0x7c7c7c7dU, 0x7d7d7d7dU, 0x7d7d7d7dU, 0x7d7d7d7eU,
	0x7e7e7e7eU, 0x7e7e7e7eU, 0x7e7e7e7eU, 0x7e7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f80U,
	0x80807f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU, 0x7f7f7f7fU,
	0x7f7f7f7fU, 0x7e7e7e7eU, 0x7e7e7e7eU, 0x7e7e7e7eU,
	0x7e7e7d7dU, 0x7d7d7d7dU, 0x7d7d7d7dU, 0x7d7d7c7cU,
	0x7c7c7c7cU, 0x7c7c7b7bU, 0x7b7b7b7bU, 0x7b7b7b7aU,
	0x7a7a7a7aU, 0x7a7a7979U, 0x79797979U, 0x79787878U,
	0x78787878U, 0x77777777U, 0x77777676U, 0x76767675U,
	0x75757575U, 0x75747474U, 0x74747473U, 0x73737372U,
};
#endif /* _LITTLE_ENDIAN */

mlib_u8 *mlib_GraphicsAliasTab_u8 = (mlib_u8 *)mlib_GraphicsAliasTab_u8_xxx;

/* *********************************************************** */

mlib_u8 mlib_GraphicsSqrtTab_u8[129] = {
	0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 4, 4, 4,
	4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8, 8, 8,
	9, 9, 9, 10, 10, 10, 11, 11, 11, 12, 12, 12, 13, 13, 13, 14,
	14, 14, 15, 15, 15, 16, 16, 17, 17, 17, 18, 18, 18, 19, 19, 20,
	20, 20, 21, 21, 21, 22, 22, 23, 23, 23, 24, 24, 25, 25, 25, 26,
	26, 26, 27, 27, 28, 28, 28, 29, 29, 30, 30, 30, 31, 31, 31, 32,
	32, 33, 33, 33, 34, 34, 34, 35, 35, 35, 36, 36, 37, 37, 37, 38,
	38
};

/* *********************************************************** */
