---
stage: Secure
group: Static Analysis
description: Container, dependency, and vulnerability scans.
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# Secure your application

GitLab can check your applications for security vulnerabilities.

| | | |
|--|--|--|
| [**Getting started**](get-started-security.md) **{chevron-right}** | [**Application security**](index.md) **{chevron-right}** | [**Security configuration**](configuration/index.md) **{chevron-right}** |
| [**Container Scanning**](container_scanning/index.md) **{chevron-right}** |  [**Dependency Scanning**](dependency_scanning/index.md) **{chevron-right}** | [**Comparison**](comparison_dependency_and_container_scanning.md) **{chevron-right}** |
| [**Dependency List**](dependency_list/index.md) **{chevron-right}** | [**Continuous Vulnerability Scanning**](continuous_vulnerability_scanning/index.md) **{chevron-right}** |  [**Static Application Security Testing**](sast/index.md) **{chevron-right}** |
| [**Infrastructure as Code (IaC) Scanning**](iac_scanning/index.md) **{chevron-right}** | [**Secret detection**](secret_detection/index.md) **{chevron-right}** | [**Dynamic Application Security Testing (DAST)**](dast/index.md) **{chevron-right}** |
| [**API Security**](api_security/index.md) **{chevron-right}** | [**Web API Fuzz Testing**](api_fuzzing/index.md) **{chevron-right}** | [**Coverage-guided fuzz testing**](coverage_fuzzing/index.md) **{chevron-right}** |
| [**Security Dashboard**](security_dashboard/index.md) **{chevron-right}** | [**Offline environments**](offline_deployments/index.md) **{chevron-right}** | [**Vulnerability Report**](vulnerability_report/index.md) **{chevron-right}** |
| [**Vulnerability Page**](vulnerabilities/index.md) **{chevron-right}** | [**Vulnerability severity levels**](vulnerabilities/severities.md) **{chevron-right}** | [**GitLab Advisory Database**](gitlab_advisory_database/index.md) **{chevron-right}** |
| [**CVE ID requests**](cve_id_request.md) **{chevron-right}** | [**Policies**](policies/index.md) **{chevron-right}** | [**Security scanner integration**](../../development/integrations/secure.md) **{chevron-right}** |
| [**Secure and Govern glossary**](terminology/index.md) **{chevron-right}** |  | |
