# frozen_string_literal: true

class PrepareIndexOnVulnerabilityOccurrencesUuidAsync < Gitlab::Database::Migration[2.1]
  INDEX_NAME = "index_vulnerability_occurrences_on_uuid_1"

  # rubocop:disable Migration/PreventIndexCreation -- Legacy migration
  def up
    prepare_async_index(
      :vulnerability_occurrences,
      :uuid_convert_string_to_uuid,
      unique: true,
      name: INDEX_NAME
    )
  end
  # rubocop:enable Migration/PreventIndexCreation

  def down
    unprepare_async_index(
      :vulnerability_occurrences,
      INDEX_NAME
    )
  end
end
