# frozen_string_literal: true

class ScheduleRemoveTempIndexVulnerabilityOccurrences < Gitlab::Database::Migration[2.1]
  INDEX_NAME = 'tmp_idx_vulnerability_occurrences_on_id_where_report_type_7_99'

  # TODO: Index to be destroyed synchronously in https://gitlab.com/gitlab-org/gitlab/-/issues/417880
  def up
    prepare_async_index_removal :vulnerability_occurrences, :id, where: 'report_type IN (7, 99)', name: INDEX_NAME
  end

  def down
    unprepare_async_index :vulnerability_occurrences, :id, where: 'report_type IN (7, 99)', name: INDEX_NAME
  end
end
