---
stage: Govern
group: Authentication
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# Two-factor authentication

DETAILS:
**Tier:** Free, Premium, Ultimate
**Offering:** GitLab.com, Self-managed

Two-factor authentication (2FA) provides an additional level of security to your GitLab account. For others to access
your account, they would need your username and password _and_ access to your second factor of authentication.

GitLab supports as a second factor of authentication:

- Time-based one-time passwords ([TOTP](https://datatracker.ietf.org/doc/html/rfc6238)). When enabled, GitLab prompts
  you for a code when you sign in. Codes are generated by your one-time password authenticator (for example, a password
  manager on one of your devices).
- WebAuthn devices. You're prompted to activate your WebAuthn device (usually by pressing a button on it) when
  you supply your username and password to sign in. This performs secure authentication on your behalf.

If you set up a device, also set up a TOTP so you can still access your account if you lose the device.

## Use personal access tokens with two-factor authentication

When 2FA is enabled, you can't use your password to authenticate with Git over HTTPS or the [GitLab API](../../../api/rest/index.md).
You can use a [personal access token](../personal_access_tokens.md) instead.

## OAuth credential helpers

The following Git credential helpers authenticate to GitLab using OAuth. This is compatible with two-factor authentication. The first time you authenticate, the helper opens the web browser and GitLab asks you to authorize the app. Subsequent authentication requires no interaction.

### Git Credential Manager

[Git Credential Manager](https://github.com/GitCredentialManager/git-credential-manager) (GCM) authenticates by default using OAuth. GCM supports GitLab.com without any manual configuration. To use GCM with self-managed GitLab, see [GitLab support](https://github.com/GitCredentialManager/git-credential-manager/blob/main/docs/gitlab.md).

So you do not need to re-authenticate on every push, GCM supports caching as well as a variety of platform-specific credential stores that persist between sessions. This feature is useful whether you use personal access tokens or OAuth.

Git for Windows includes Git Credential Manager.

Git Credential Manager is developed primarily by GitHub, Inc. It is an open-source project and is supported by the community.

### git-credential-oauth

[git-credential-oauth](https://github.com/hickford/git-credential-oauth) supports GitLab.com and several popular public hosts without any manual configuration needed. To use with self-managed GitLab, see the [git-credential-oauth custom hosts documentation](https://github.com/hickford/git-credential-oauth#custom-hosts).

Many Linux distributions include git-credential-oauth as a package.

git-credential-oauth is an open-source project supported by the community.

## Enable two-factor authentication

> - Account email confirmation requirement [introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/35102) in GitLab 14.3. [Deployed behind the `ensure_verified_primary_email_for_2fa` flag](../../../administration/feature_flags.md), enabled by default.
> - Account email confirmation requirement generally available and [feature flag `ensure_verified_primary_email_for_2fa` removed](https://gitlab.com/gitlab-org/gitlab/-/issues/340151) in GitLab 14.4.

You can enable 2FA using a:

- One-time password authenticator. After you enable 2FA, back up your [recovery codes](#recovery-codes).
- WebAuthn device.

In GitLab 14.3 and later, your account email must be confirmed to enable 2FA.

### Enable one-time password

To enable 2FA with a one-time password:

<!-- vale gitlab.Substitutions = NO -->

1. **In GitLab:**
   1. Access your [**User settings**](../index.md#access-your-user-settings).
   1. Select **Account**.
   1. Select **Enable Two-factor Authentication**.
1. **On your device (usually your phone):**
   1. Install a compatible application. For example:
      - Cloud-based (recommended because you can restore access if you lose the hardware device):
        - [Authy](https://authy.com/).
        - [Cisco Duo](https://duo.com/).
      - Other (proprietary):
        - [Google Authenticator](https://support.google.com/accounts/answer/1066447?hl=en).
        - [Microsoft Authenticator](https://www.microsoft.com/en-us/security/mobile-authenticator-app).
      - Other (Free Software)
        - [Aegis Authenticator](https://getaegis.app/).
        - [FreeOTP](https://freeotp.github.io/).
   1. In the application, add a new entry in one of two ways:
      - Scan the code displayed by GitLab with your device's camera to add the entry automatically.
      - Enter the details provided to add the entry manually.
1. **In GitLab:**
   1. Enter the six-digit pin number from the entry on your device into **Pin code**.
   1. Enter your current password.
   1. Select **Submit**.

<!-- vale gitlab.Substitutions = YES -->

If you entered the correct pin, GitLab displays a list of [recovery codes](#recovery-codes). Download them and keep them
in a safe place.

### Enable one-time password using FortiAuthenticator

> - [Introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/212312) in GitLab 13.5 [with a flag](../../../administration/feature_flags.md) named `forti_authenticator`. Disabled by default.

FLAG:
On self-managed GitLab, by default this feature is not available. To make it available per user, an administrator can
[enable the feature flag](../../../administration/feature_flags.md) named `forti_authenticator`. On GitLab.com and GitLab Dedicated, this
feature is not available.

You can use FortiAuthenticator as a one-time password (OTP) provider in GitLab. Users must:

- Exist in both FortiAuthenticator and GitLab with the same username.
- Have FortiToken configured in FortiAuthenticator.

You need a username and access token for FortiAuthenticator. The `access_token` shown below is the FortAuthenticator
access key. To get the token, see the REST API Solution Guide at
[Fortinet Document Library](https://docs.fortinet.com/document/fortiauthenticator/6.2.0/rest-api-solution-guide/158294/the-fortiauthenticator-api).
GitLab 13.5 has been tested with FortAuthenticator version 6.2.0.

Configure FortiAuthenticator in GitLab. On your GitLab server:

1. Open the configuration file.

   For Linux package installations:

   ```shell
   sudo editor /etc/gitlab/gitlab.rb
   ```

   For self-compiled installations:

   ```shell
   cd /home/git/gitlab
   sudo -u git -H editor config/gitlab.yml
   ```

1. Add the provider configuration.

   For Linux package installations:

   ```ruby
   gitlab_rails['forti_authenticator_enabled'] = true
   gitlab_rails['forti_authenticator_host'] = 'forti_authenticator.example.com'
   gitlab_rails['forti_authenticator_port'] = 443
   gitlab_rails['forti_authenticator_username'] = '<some_username>'
   gitlab_rails['forti_authenticator_access_token'] = 's3cr3t'
   ```

   For self-compiled installations:

   ```yaml
   forti_authenticator:
     enabled: true
     host: forti_authenticator.example.com
     port: 443
     username: <some_username>
     access_token: s3cr3t
   ```

1. Save the configuration file.
1. [Reconfigure](../../../administration/restart_gitlab.md#reconfigure-a-linux-package-installation)
   (Linux package installations) or [restart](../../../administration/restart_gitlab.md#self-compiled-installations)
   (self-compiled installations).

<!-- vale gitlab.Substitutions = NO -->

### Enable one-time password using Cisco Duo

> - [Introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/15760) in GitLab 15.10.

FLAG:
On self-managed GitLab, by default this feature is available. On GitLab.com this feature is not available.

You can use Cisco Duo as an OTP provider in GitLab.

DUO® is a registered trademark of Cisco Systems, Inc., and/or its affiliates in the United States and certain other countries.

#### Prerequisites

To use Cisco Duo as an OTP provider:

- Your account must exist in both Cisco Duo and GitLab, with the same username in both applications.
- You must have [configured Cisco Duo](https://admin.duosecurity.com/) and have an integration key, secret key, and API hostname.

For more information, see the [Cisco Duo API documentation](https://duo.com/docs/authapi).

GitLab 15.10 has been tested with Cisco Duo version D261.14

#### Configure Cisco Duo in GitLab

<!-- vale gitlab.Substitutions = YES -->

On your GitLab server:

1. Open the configuration file.

   For Linux package installations:

   ```shell
   sudo editor /etc/gitlab/gitlab.rb
   ```

   For self-compiled installations:

   ```shell
   cd /home/git/gitlab
   sudo -u git -H editor config/gitlab.yml
   ```

1. Add the provider configuration.

   For Linux package installations:

   ```ruby
    gitlab_rails['duo_auth_enabled'] = false
    gitlab_rails['duo_auth_integration_key'] = '<duo_integration_key_value>'
    gitlab_rails['duo_auth_secret_key'] = '<duo_secret_key_value>'
    gitlab_rails['duo_auth_hostname'] = '<duo_api_hostname>'
   ```

   For self-compiled installations:

   ```yaml
   duo_auth:
     enabled: true
     hostname: <duo_api_hostname>
     integration_key: <duo_integration_key_value>
     secret_key: <duo_secret_key_value>
   ```

1. Save the configuration file.
1. For Linux package installations, [reconfigure GitLab](../../../administration/restart_gitlab.md#reconfigure-a-linux-package-installation).
   For self-compiled installations, [restart GitLab](../../../administration/restart_gitlab.md#self-compiled-installations).

### Enable one-time password using FortiToken Cloud

DETAILS:
**Offering:** Self-managed

> - [Introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/212313) in GitLab 13.7 [with a flag](../../../administration/feature_flags.md) named `forti_token_cloud`. Disabled by default.

FLAG:
On self-managed GitLab, by default this feature is not available. To make it available per user, an administrator can
[enable the feature flag](../../../administration/feature_flags.md) named `forti_token_cloud`. On GitLab.com and GitLab Dedicated, this
feature is not available. This feature is not ready for production use.

You can use FortiToken Cloud as a one-time password (OTP) provider in GitLab. Users must:

- Exist in both FortiToken Cloud and GitLab with the same username.
- Have FortiToken configured in FortiToken Cloud.

You need a `client_id` and `client_secret` to configure FortiToken Cloud. To get these, see the REST API Guide at
[Fortinet Document Library](https://docs.fortinet.com/document/fortitoken-cloud/latest/rest-api/456035/overview).

Configure FortiToken Cloud in GitLab. On your GitLab server:

1. Open the configuration file.

   For Linux package installations:

   ```shell
   sudo editor /etc/gitlab/gitlab.rb
   ```

   For self-compiled installations:

   ```shell
   cd /home/git/gitlab
   sudo -u git -H editor config/gitlab.yml
   ```

1. Add the provider configuration.

   For Linux package installations:

   ```ruby
   gitlab_rails['forti_token_cloud_enabled'] = true
   gitlab_rails['forti_token_cloud_client_id'] = '<your_fortinet_cloud_client_id>'
   gitlab_rails['forti_token_cloud_client_secret'] = '<your_fortinet_cloud_client_secret>'
   ```

   For self-compiled installations:

   ```yaml
   forti_token_cloud:
     enabled: true
     client_id: YOUR_FORTI_TOKEN_CLOUD_CLIENT_ID
     client_secret: YOUR_FORTI_TOKEN_CLOUD_CLIENT_SECRET
   ```

1. Save the configuration file.
1. [Reconfigure](../../../administration/restart_gitlab.md#reconfigure-a-linux-package-installation) (Linux package installations) or
   [restart](../../../administration/restart_gitlab.md#self-compiled-installations) (self-compiled installations).

### Set up a WebAuthn device

> - WebAuthn devices [introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/22506) in GitLab 13.4 [with a flag](../../../administration/feature_flags.md) named `webauthn`. Disabled by default.
> - WebAuthn devices [enabled on GitLab.com and self-managed](https://gitlab.com/gitlab-org/gitlab/-/issues/232671) in GitLab 14.6.
> - Optional one-time password authentication for WebAuthn devices [introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/378844) in GitLab 15.10 [with a flag](../../../administration/feature_flags.md) named `webauthn_without_topt`. [Enabled on GitLab.com and self-managed by default](https://gitlab.com/gitlab-org/gitlab/-/issues/232671).

FLAG:
On self-managed GitLab, by default, WebAuthn devices are available. To disable the feature, an administrator can
[disable the feature flag](../../../administration/feature_flags.md) named `webauthn`. If you disable the WebAuthn
feature flag after WebAuthn devices have been registered, these devices are not usable until you re-enable this feature.
On GitLab.com, WebAuthn devices are available.

FLAG:
On self-managed GitLab, by default, optional one-time password authentication for WebAuthn devices is not available. To enable the feature, an administrator can [enable the feature flag](../../../administration/feature_flags.md) named `webauthn_without_totp`.
On GitLab.com, this feature is available. On GitLab Dedicated, this feature is not available.

WebAuthn is [supported by](https://caniuse.com/#search=webauthn) the following:

- Desktop browsers:
  - Chrome
  - Edge
  - Firefox
  - Opera
  - Safari
- Mobile browsers:
  - Chrome for Android
  - Firefox for Android
  - iOS Safari (since iOS 13.3)

To set up 2FA with a WebAuthn-compatible device:

1. Optional. [Set up a one-time password](#enable-one-time-password).
1. Access your [**User settings**](../index.md#access-your-user-settings).
1. Select **Account**.
1. Select **Enable Two-Factor Authentication**.
1. Plug in your WebAuthn device.
1. Enter a device name and in GitLab 15.10 and later, your GitLab account password.
   You might not need to enter this password if you have signed in through your
   identity provider.
1. Select **Set up New WebAuthn Device**.
1. Depending on your device, you might have to press a button or touch a sensor.

You should receive a message indicating that you successfully set up your device.

When you set up 2FA with a WebAuthn-compatible device, that device is linked to
a specific browser on a specific computer. Depending on the browser and WebAuthn
device, you might be able to configure settings to use the WebAuthn device on a
different browser or computer.

If this is the first time you have set up 2FA, you
must [download recovery codes](#recovery-codes) so you can recover access to your
account if you lose access.

WARNING:
You can lose access to your account if you clear your browser data.

## Recovery codes

> - [Introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/267730) in GitLab 13.7, **Copy codes** and **Print codes** buttons.

Immediately after successfully enabling 2FA with a one-time password, you're prompted to download
a set of generated recovery codes. If you ever lose access to your one-time password authenticator, you can use one of
these recovery codes to sign in to your account.

WARNING:
Each code can be used only once to sign in to your account.

You should copy and print the codes, or use **Download codes** to download them for storage in a safe
place. If you choose to download them, the file is called `gitlab-recovery-codes.txt`.

NOTE:
Recovery codes are not generated for WebAuthn devices.

If you lose the recovery codes, or want to generate new ones, you can use either:

- The [2FA account settings](#regenerate-two-factor-authentication-recovery-codes) page.
- [SSH](#generate-new-recovery-codes-using-ssh).

### Regenerate two-factor authentication recovery codes

To regenerate 2FA recovery codes, you need access to a desktop browser:

1. Access your [**User settings**](../index.md#access-your-user-settings).
1. Select **Account > Two-Factor Authentication (2FA)**.
1. If you've already configured 2FA, select **Manage two-factor authentication**.
1. In the **Register Two-Factor Authenticator** pane, enter your current password and select **Regenerate recovery codes**.

NOTE:
If you regenerate 2FA recovery codes, save them. You can't use any previously created 2FA codes.

## Sign in with two-factor authentication enabled

Signing in with 2FA enabled is only slightly different than the typical sign-in process. Enter your username and password
and you're presented with a second prompt, depending on which type of 2FA you've enabled.

### Sign in using a one-time password

When asked, enter the pin from your one-time password authenticator's application or a recovery code to sign in.

### Sign in using a WebAuthn device

In supported browsers, you should be automatically prompted to activate your WebAuthn device (for example, by touching
or pressing its button) after entering your credentials.

A message displays indicating that your device responded to the authentication request and you're automatically signed
in.

## Disable two-factor authentication

To disable 2FA:

1. Access your [**User settings**](../index.md#access-your-user-settings).
1. Select **Account**.
1. Select **Manage two-factor authentication**.
1. Under **Register Two-Factor Authenticator**, enter your current password and select **Disable two-factor
   authentication**.

This clears all your 2FA registrations, including mobile applications and WebAuthn devices.

## Recovery options

If you don't have access to your code generation device, you can recover access to your account:

- [Use a saved recovery code](#use-a-saved-recovery-code), if you saved them when you enabled two-factor
  authentication.
- [Generate new recovery codes using SSH](#generate-new-recovery-codes-using-ssh), if you didn't save your original
  recovery codes but have an SSH key.
- [Have 2FA disabled on your account](#have-two-factor-authentication-disabled-on-your-account), if you don't have your
  recovery codes or an SSH key.

### Use a saved recovery code

To use a recovery code:

1. Enter your username or email, and password, on the GitLab sign-in page.
1. When prompted for a two-factor code, enter the recovery code.

After you use a recovery code, you cannot re-use it. You can still use the other recovery codes you saved.

### Generate new recovery codes using SSH

If you forget to save your recovery codes when enabling 2FA, and you added an SSH key to your GitLab account, you can generate a new set of recovery codes with SSH:

1. In a terminal, run:

   ```shell
   ssh git@gitlab.com 2fa_recovery_codes
   ```

   On self-managed instances, replace **`gitlab.com`** in the command above with the GitLab server hostname (`gitlab.example.com`).

1. You are prompted to confirm that you want to generate new codes. This process invalidates previously-saved codes. For
   example:

   ```shell
   Are you sure you want to generate new two-factor recovery codes?
   Any existing recovery codes you saved will be invalidated. (yes/no)

   yes

   Your two-factor authentication recovery codes are:

   119135e5a3ebce8e
   11f6v2a498810dcd
   3924c7ab2089c902
   e79a3398bfe4f224
   34bd7b74adbc8861
   f061691d5107df1a
   169bf32a18e63e7f
   b510e7422e81c947
   20dbed24c5e74663
   df9d3b9403b9c9f0

   During sign in, use one of the codes above when prompted for your
   two-factor code. Then, visit your Profile Settings and add a new device
   so you do not lose access to your account again.
   ```

1. Go to the GitLab sign-in page and enter your username or email, and password. When prompted for a two-factor code,
   enter one of the recovery codes obtained from the command-line output.

After signing in, immediately set up 2FA with a new device.

### Have two-factor authentication disabled on your account

DETAILS:
**Tier:** Premium, Ultimate
**Offering:** GitLab.com

If other methods are unavailable, have a GitLab support contact submit a [support ticket](https://support.gitlab.com) to request
a GitLab global administrator disable 2FA for your account:

- This service is only available for accounts that have a GitLab.com subscription. For more information, see our
  [blog post](https://about.gitlab.com/blog/2020/08/04/gitlab-support-no-longer-processing-mfa-resets-for-free-users/).
- Disabling this setting temporarily leaves your account in a less secure state. You should sign in and re-enable two-factor
  authentication as soon as possible.

## Information for GitLab administrators

DETAILS:
**Tier:** Free, Premium, Ultimate
**Offering:** Self-managed

- Take care that 2FA keeps working after [restoring a GitLab backup](../../../administration/backup_restore/index.md).
- To ensure 2FA authorizes correctly with a time-based one-time password (TOTP) server, synchronize your GitLab
  server's time using a service like NTP. Otherwise, authorization can always fail because of time differences.
- The GitLab WebAuthn implementation does _not_ work when the GitLab instance is accessed from multiple hostnames
  or FQDNs. Each WebAuthn registration is linked to the _current hostname_ at the time of registration, and
  cannot be used for other hostnames or FQDNs.

  For example, if a user is trying to access a GitLab instance from `first.host.xyz` and `second.host.xyz`:

  - The user signs in by using `first.host.xyz` and registers their WebAuthn key.
  - The user signs out and attempts to sign in by using `first.host.xyz` - WebAuthn authentication succeeds.
  - The user signs out and attempts to sign in by using `second.host.xyz` - WebAuthn authentication fails, because
    the WebAuthn key has only been registered on `first.host.xyz`.

- To enforce 2FA at the system or group levels see, [Enforce two-factor authentication](../../../security/two_factor_authentication.md).

## Troubleshooting

### Error: "HTTP Basic: Access denied. The provided password or token ..."

When making a request, you can receive the following error:

```plaintext
HTTP Basic: Access denied. The provided password or token is incorrect or your account has 2FA enabled and you must use a personal
access token instead of a password.
```

This error occurs in the following scenarios:

- You have 2FA enabled and have attempted to authenticate with a username and
  password.
- You do not have 2FA enabled and have sent an incorrect username or password
  with your request.
- You do not have 2FA enabled but an administrator has enabled the
  [enforce 2FA for all users](../../../security/two_factor_authentication.md#enforce-2fa-for-all-users) setting.
- You do not have 2FA enabled, but an administrator has disabled the
  [password authentication enabled for Git over HTTP(S)](../../../administration/settings/sign_in_restrictions.md#password-authentication-enabled)
  setting.

Instead you can authenticate:

- Using a [personal access token](../personal_access_tokens.md) (PAT):
  - For Git requests over HTTP(S), a PAT with `read_repository` or `write_repository` scope is required.
  - For [GitLab container registry](../../packages/container_registry/authenticate_with_container_registry.md) requests, a PAT
    with `read_registry` or `write_registry` scope is required.
  - For [Dependency Proxy](../../packages/dependency_proxy/index.md#authenticate-with-the-dependency-proxy) requests, a PAT with
    `read_registry` and `write_registry` scopes is required.
- If you have configured LDAP, using an [LDAP password](../../../administration/auth/ldap/index.md)
- Using an [OAuth credential helper](#oauth-credential-helpers).

### Error: "invalid pin code"

If you receive an `invalid pin code` error, this can indicate that there is a time sync issue between the authentication
application and the GitLab instance itself. To avoid the time sync issue, enable time synchronization in the device that
generates the codes. For example:

- For Android (Google Authenticator):
  1. Go to the Main Menu in Google Authenticator.
  1. Select Settings.
  1. Select the Time correction for the codes.
  1. Select Sync now.
- For iOS:
  1. Go to Settings.
  1. Select General.
  1. Select Date & Time.
  1. Enable Set Automatically. If it's already enabled, disable it, wait a few seconds, and re-enable.

### Error: "Permission denied (publickey)" when regenerating recovery codes

If you receive a `Permission denied (publickey)` error when attempting to [generate new recovery codes using an SSH key](#generate-new-recovery-codes-using-ssh)
and you are using a non-default SSH key pair file path,
you might need to [manually register your private SSH key](../../ssh.md#configure-ssh-to-point-to-a-different-directory) using `ssh-agent`.
