---
stage: Systems
group: Distribution
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: Read through the GitLab installation methods.
---

# Install GitLab

You can install GitLab on most GNU/Linux distributions, on several
cloud providers, and in Kubernetes clusters.
To get the best experience, you should balance performance, reliability,
ease of administration (backups, upgrades, and troubleshooting) with the cost of hosting.

<!-- markdownlint-disable MD044 -->

| | | |
|--|--|--|
| [**Installation system requirements**](requirements.md) **{chevron-right}**<br><br> Prerequisites for installation. | [**Installation methods**](install_methods.md) **{chevron-right}**<br><br> Linux, Helm, Docker, Operator, source, or scripts. | [**Install GitLab on a cloud provider**](cloud_providers.md) **{chevron-right}**<br><br> AWS, Google Cloud Platform, Azure. |
| [**Offline GitLab**](../topics/offline/index.md) **{chevron-right}**<br><br> Isolated installation. | [**Reference architectures**](../administration/reference_architectures/index.md) **{chevron-right}**<br><br> Recommended deployments at scale. | [**Upgrade GitLab**](../update/index.md) **{chevron-right}**<br><br> Latest version instructions. |
| [**Install GitLab Runner**](https://docs.gitlab.com/runner/install/) **{chevron-right}**<br><br> Software for CI/CD jobs. | [**Configure GitLab Runner**](https://docs.gitlab.com/runner/configuration/) **{chevron-right}**<br><br> Config.toml, certificates, autoscaling, proxy setup. | |

<!-- markdownlint-enable MD044 -->
