#include "fetchmail.h"
#include "sdump.h"

#include <errno.h>
#include <stdio.h>
#include <string.h>

const char *program_name = __FILE__;
volatile int lastsig;

int main(void)
{
	const char *pw = fm_getpassword("TEST MODE - enter password: ");
	if (!pw) {
		fprintf(stderr, "fm_getpassword failed! %s\n", strerror(errno));
		return EXIT_FAILURE;
	} else {
		char *pwdump;

		pwdump = sdump_c(pw);
		printf("password received:       <%zu> \"%s\"\n", strlen(pw), pwdump);
		xzerofree(pwdump);

		fm_clearpassword();
		pwdump = sdump_c(pw);
		printf("cleared password buffer: <%zu> \"%s\"\n", strlen(pw), pwdump);
		xzerofree(pwdump);
		if (strlen(pw)) return EXIT_FAILURE;
	}
	return EXIT_SUCCESS;
}
