##############################################################################
##############################################################################
##
##  ARCHIVE HEADER INFORMATION
##
##  @Make-file{
##      FILENAME    = "ms-bcc.mak",
##      VERSION     = "1.00",
##      DATE        = "",
##      TIME        = "",
##
##      AUTHOR      = "Niel Kempson",
##      ADDRESS     = "25 Whitethorn Drive
##                     Cheltenham
##                     GL52 5LL
##                     England",
##      TELEPHONE   = "+44-242 579105",
##      EMAIL       = "kempson@tex.ac.uk (Internet)",
##
##      SUPPORTED   = "yes",
##      ARCHIVED    = "tex.ac.uk, ftp.tex.ac.uk",
##      KEYWORDS    = "VVcode",
##
##      CODETABLE   = "ISO/ASCII",
##      CHECKSUM    = "51492 1481 5732 57976",
##
##      DOCSTRING   = { This file is part of VVcode.
##                  }
##  }
##
##  MODULE CONTENTS
##
##      [tbs]
##
##  COPYRIGHT
##
##      Written 1991-1992 by Niel Kempson <kempson@tex.ac.uk> who claims
##      no copyright over this program - you are free to use it as you wish.
##
##  CHANGE LOG
##
##############################################################################
##############################################################################

##############################################################################
#
# Local definitions for file types and compilation / linking.
#
# If your MS-DOS compiler is already supported it should not be necessary to 
# modify any part of the Makefile except the local definitions below.	Here 
# are some examples known to work for my MS-DOS C compilers.
#
#   Borland Turbo C v1.5, v2.0
#
#	CC	       = TCC
#	LINK	       = TCC
#	CCMODEL        = -ms
#	CFLAGS	       = $(CCMODEL) -c -w -y -v -O- -G- -N
#	LFLAGS	       = $(CCMODEL) -v -y
#
#   Borland C++ v1.0, v2.0, v3.0
#
#	CC	       = BCC
#	LINK	       = BCC
#	CCMODEL        = -ms
#	CFLAGS	       = $(CCMODEL) -c -w -y -v -O- -G- -N
#	LFLAGS	       = $(CCMODEL) -v -y
#
#   Microsoft C v5.1, v6.0
#
#	CC	       = CL
#	LINK	       = CL
#	CCMODEL        = /AS
#	CFLAGS	       = $(CCMODEL) /c /W3 /Zd /Zi /Od
#	LFLAGS	       = $(CCMODEL) 
#
##############################################################################
# Start of local definitions.
##############################################################################
CC	       = BCC
LINK	       = BCC
CCMODEL        = -ms
CFLAGS	       = $(CCMODEL) -c -w -y -v -O- -G- -N
LFLAGS	       = $(CCMODEL) -v -y
##############################################################################
# End of local definitions.
##############################################################################


##############################################################################
# File types and default rule for compilation
##############################################################################
EXE		= .exe
OBJ		= .obj

.SUFFIXES:      .c .h $(OBJ) $(EXE)

.c.obj:
	$(CC)  $(CFLAGS)  $*.c    	

##############################################################################
# Target Groupings
##############################################################################
HDRFILES	= checkos.h machine.h local.h globals.h specific.h vvutils.h

OBJFILES	= vvencode$(OBJ) vvdecode$(OBJ) vveparse$(OBJ) \
		  vvutils$(OBJ) msdos$(OBJ)

EXEFILES	= vvencode$(EXE) vvdecode$(EXE)

##############################################################################
# Top level targets
##############################################################################
vvcode:		$(EXEFILES)
	@ echo VVcode built

clean:
	- del *$(OBJ)
	- del *$(EXE)

##############################################################################
# Dependencies for executables
##############################################################################
vvencode$(EXE): vvencode$(OBJ) vvutils$(OBJ) msdos$(OBJ)
	$(LINK)  $(LFLAGS) vvencode$(OBJ) vvutils$(OBJ) msdos$(OBJ)

vvdecode$(EXE):	vvdecode$(OBJ) vveparse$(OBJ) vvutils$(OBJ) msdos$(OBJ)
	$(LINK)  $(LFLAGS) vvdecode$(OBJ) vveparse$(OBJ) \
		 vvutils$(OBJ) msdos$(OBJ)

#-----------------------------------------------------------------------------
# Dependencies for object files
#-----------------------------------------------------------------------------
vvencode$(OBJ): vvencode.c $(HDRFILES)

vvdecode$(OBJ): vvdecode.c $(HDRFILES) vveparse.h

vveparse$(OBJ):	vveparse.c $(HDRFILES) vveparse.h

vvutils$(OBJ):	vvutils.c $(HDRFILES)

msdos$(OBJ):	msdos.c $(HDRFILES)
